rule ByteCode_MSIL_Ransomware_Janelle : tc_detection malicious
{
    meta:

        author              = "ReversingLabs"

        source              = "ReversingLabs"
        status              = "RELEASED"
        sharing             = "TLP:WHITE"
        category            = "MALWARE"
        malware             = "JANELLE"
        description         = "Yara rule that detects Janelle ransomware."

        tc_detection_type   = "Ransomware"
        tc_detection_name   = "Janelle"
        tc_detection_factor = 5

    strings:

        $setup_env_p1 = {
            00 02 7B ?? ?? ?? ?? 72 ?? ?? ?? ?? 6F ?? ?? ?? ?? 00 73 ?? ?? ?? ?? 0A 06 02 7D ?? ??
            ?? ?? 00 7E ?? ?? ?? ?? 72 ?? ?? ?? ?? 17 6F ?? ?? ?? ?? 0B 07 72 ?? ?? ?? ?? 28 ?? ??
            ?? ?? 6F ?? ?? ?? ?? 6F ?? ?? ?? ?? 00 00 28 ?? ?? ?? ?? 6F ?? ?? ?? ?? 0C 2B ?? 08 6F
            ?? ?? ?? ?? 74 ?? ?? ?? ?? 0D 00 02 7B ?? ?? ?? ?? 6F ?? ?? ?? ?? 09 6F ?? ?? ?? ?? 6F
            ?? ?? ?? ?? 6F ?? ?? ?? ?? 26 00 08 6F ?? ?? ?? ?? 2D ?? DE ?? 08 75 ?? ?? ?? ?? 13 ??
            11 ?? 2C ?? 11 ?? 6F ?? ?? ?? ?? 00 DC 02 7B ?? ?? ?? ?? 16 6F ?? ?? ?? ?? 00 16 28 ??
            ?? ?? ?? 72 ?? ?? ?? ?? 28 ?? ?? ?? ?? 28 ?? ?? ?? ?? 16 FE 01 13 ?? 11 ?? 2C ?? 00 16
            28 ?? ?? ?? ?? 72 ?? ?? ?? ?? 28 ?? ?? ?? ?? 28 ?? ?? ?? ?? 6F ?? ?? ?? ?? 00 16 28 ??
            ?? ?? ?? 72 ?? ?? ?? ?? 28 ?? ?? ?? ?? 72 ?? ?? ?? ?? 28 ?? ?? ?? ?? 00 00 28 ?? ?? ??
            ?? 6F ?? ?? ?? ?? 13 ?? 11 ?? 2C ?? 00 02 16 28 ?? ?? ?? ?? 00 00 28 ?? ?? ?? ?? 6F ??
            ?? ?? ?? 6F ?? ?? ?? ?? 16 FE 02 16 FE 01 13 ?? 11 ?? 2C ?? 00 28 ?? ?? ?? ?? 28 ?? ??
            ?? ?? 13 ?? 12 ?? 28 ?? ?? ?? ?? 6F ?? ?? ?? ?? 00 28 ?? ?? ?? ?? 28 ?? ?? ?? ?? 13 ??
            12 ?? 23 ?? ?? ?? ?? ?? ?? ?? ?? 28 ?? ?? ?? ?? 13 ?? 12 ?? 28 ?? ?? ?? ?? 6F ?? ?? ??
            ?? 00 28 ?? ?? ?? ?? 28 ?? ?? ?? ?? 13 ?? 12 ?? 23 ?? ?? ?? ?? ?? ?? ?? ?? 28 ?? ?? ??
            ?? 13 ?? 12 ?? 28 ?? ?? ?? ?? 6F ?? ?? ?? ?? 00 28 ?? ?? ?? ?? 6F ?? ?? ?? ?? 00 00 02
        }

        $setup_env_p2 = {
            7B ?? ?? ?? ?? 28 ?? ?? ?? ?? 6F ?? ?? ?? ?? 6F ?? ?? ?? ?? 00 02 7B ?? ?? ?? ?? 28 ??
            ?? ?? ?? 6F ?? ?? ?? ?? 6F ?? ?? ?? ?? 00 16 28 ?? ?? ?? ?? 72 ?? ?? ?? ?? 28 ?? ?? ??
            ?? 28 ?? ?? ?? ?? 13 ?? 11 ?? 2C ?? 00 02 7B ?? ?? ?? ?? 72 ?? ?? ?? ?? 16 28 ?? ?? ??
            ?? 28 ?? ?? ?? ?? 73 ?? ?? ?? ?? 6F ?? ?? ?? ?? 00 00 2B ?? 00 16 28 ?? ?? ?? ?? 72 ??
            ?? ?? ?? 28 ?? ?? ?? ?? 28 ?? ?? ?? ?? 6F ?? ?? ?? ?? 00 16 28 ?? ?? ?? ?? 72 ?? ?? ??
            ?? 28 ?? ?? ?? ?? 72 ?? ?? ?? ?? 28 ?? ?? ?? ?? 00 02 7B ?? ?? ?? ?? 72 ?? ?? ?? ?? 16
            28 ?? ?? ?? ?? 28 ?? ?? ?? ?? 73 ?? ?? ?? ?? 6F ?? ?? ?? ?? 00 00 28 ?? ?? ?? ?? 16 28
            ?? ?? ?? ?? 72 ?? ?? ?? ?? 28 ?? ?? ?? ?? 6F ?? ?? ?? ?? 00 16 28 ?? ?? ?? ?? 72 ?? ??
            ?? ?? 28 ?? ?? ?? ?? 28 ?? ?? ?? ?? 00 28 ?? ?? ?? ?? 6F ?? ?? ?? ?? 72 ?? ?? ?? ?? 28
            ?? ?? ?? ?? 13 ?? 11 ?? 2C ?? 00 28 ?? ?? ?? ?? 02 20 ?? ?? ?? ?? 28 ?? ?? ?? ?? 6F ??
            ?? ?? ?? 00 28 ?? ?? ?? ?? 6F ?? ?? ?? ?? 00 00 16 28 ?? ?? ?? ?? 72 ?? ?? ?? ?? 28 ??
            ?? ?? ?? 28 ?? ?? ?? ?? 00 16 28 ?? ?? ?? ?? 72 ?? ?? ?? ?? 28 ?? ?? ?? ?? 28 ?? ?? ??
            ?? 6F ?? ?? ?? ?? 00 06 28 ?? ?? ?? ?? 6F ?? ?? ?? ?? 7D ?? ?? ?? ?? 16 28 ?? ?? ?? ??
            72 ?? ?? ?? ?? 28 ?? ?? ?? ?? 28 ?? ?? ?? ?? 6F ?? ?? ?? ?? 06 7B ?? ?? ?? ?? 28 ?? ??
            ?? ?? 28 ?? ?? ?? ?? 00 28 ?? ?? ?? ?? 6F ?? ?? ?? ?? 72 ?? ?? ?? ?? 28 ?? ?? ?? ?? 13
            ?? 11 ?? 2C ?? 00 02 17 7D ?? ?? ?? ?? 06 FE 06 ?? ?? ?? ?? 73 ?? ?? ?? ?? 73 ?? ?? ??
            ?? 25 17 6F ?? ?? ?? ?? 00 6F ?? ?? ?? ?? 00 06 7B ?? ?? ?? ?? 28 ?? ?? ?? ?? 00 00 02
            7B ?? ?? ?? ?? 16 28 ?? ?? ?? ?? 72 ?? ?? ?? ?? 28 ?? ?? ?? ?? 28 ?? ?? ?? ?? 6F ?? ??
            ?? ?? 00 00 2A
        }

        $find_files = {
            73 ?? ?? ?? ?? 0A 06 02 7D ?? ?? ?? ?? 06 04 7D ?? ?? ?? ?? 06 05 7D ?? ?? ?? ?? 00 00
            03 28 ?? ?? ?? ?? 0B 00 07 0C 16 0D 2B ?? 08 09 9A 13 ?? 00 02 11 ?? 06 7B ?? ?? ?? ??
            28 ?? ?? ?? ?? 00 00 09 17 58 0D 09 08 8E 69 32 ?? 06 7B ?? ?? ?? ?? 13 ?? 11 ?? 2C ??
            00 00 00 03 28 ?? ?? ?? ?? 13 ?? 16 13 ?? 2B ?? 73 ?? ?? ?? ?? 13 ?? 11 ?? 06 7D ?? ??
            ?? ?? 11 ?? 11 ?? 11 ?? 9A 7D ?? ?? ?? ?? 00 11 ?? FE 06 ?? ?? ?? ?? 73 ?? ?? ?? ?? 73
            ?? ?? ?? ?? 25 17 6F ?? ?? ?? ?? 00 6F ?? ?? ?? ?? 00 00 11 ?? 17 58 13 ?? 11 ?? 11 ??
            8E 69 32 ?? 00 DE ?? 13 ?? 00 72 ?? ?? ?? ?? 03 28 ?? ?? ?? ?? 28 ?? ?? ?? ?? 00 00 DE
            ?? 00 00 DE ?? 26 00 72 ?? ?? ?? ?? 03 28 ?? ?? ?? ?? 28 ?? ?? ?? ?? 00 00 DE ?? 2A
        }

        $encrypt_files = {
            00 28 ?? ?? ?? ?? 0A 03 72 ?? ?? ?? ?? 28 ?? ?? ?? ?? 18 73 ?? ?? ?? ?? 0B 28 ?? ?? ??
            ?? 04 6F ?? ?? ?? ?? 0C 73 ?? ?? ?? ?? 0D 09 20 ?? ?? ?? ?? 6F ?? ?? ?? ?? 00 09 20 ??
            ?? ?? ?? 6F ?? ?? ?? ?? 00 09 18 6F ?? ?? ?? ?? 00 08 06 20 ?? ?? ?? ?? 73 ?? ?? ?? ??
            13 ?? 09 11 ?? 09 6F ?? ?? ?? ?? 1E 5B 6F ?? ?? ?? ?? 6F ?? ?? ?? ?? 00 09 11 ?? 09 6F
            ?? ?? ?? ?? 1E 5B 6F ?? ?? ?? ?? 6F ?? ?? ?? ?? 00 09 1A 6F ?? ?? ?? ?? 00 07 06 16 06
            8E 69 6F ?? ?? ?? ?? 00 07 09 6F ?? ?? ?? ?? 17 73 ?? ?? ?? ?? 13 ?? 03 19 73 ?? ?? ??
            ?? 13 ?? 20 ?? ?? ?? ?? 8D ?? ?? ?? ?? 13 ?? 00 2B ?? 00 28 ?? ?? ?? ?? 00 11 ?? 11 ??
            16 11 ?? 6F ?? ?? ?? ?? 00 00 11 ?? 11 ?? 16 11 ?? 8E 69 6F ?? ?? ?? ?? 25 13 ?? 16 FE
            02 13 ?? 11 ?? 2D ?? 11 ?? 6F ?? ?? ?? ?? 00 00 DE ?? 13 ?? 00 72 ?? ?? ?? ?? 11 ?? 6F
            ?? ?? ?? ?? 28 ?? ?? ?? ?? 28 ?? ?? ?? ?? 00 00 DE ?? DE ?? 00 11 ?? 6F ?? ?? ?? ?? 00
            07 6F ?? ?? ?? ?? 00 00 DC 2A
        }

    condition:
        uint16(0) == 0x5A4D and
        (
            all of ($setup_env_p*)
        ) and
        (
            $find_files
        ) and
        (
            $encrypt_files
        )
}