rule Win32_Ransomware_Blitzkrieg : tc_detection malicious
{
    meta:

        author              = "ReversingLabs"

        source              = "ReversingLabs"
        status              = "RELEASED"
        sharing             = "TLP:WHITE"
        category            = "MALWARE"
        malware             = "BLITZKRIEG"
        description         = "Yara rule that detects Blitzkrieg ransomware."

        tc_detection_type   = "Ransomware"
        tc_detection_name   = "Blitzkrieg"
        tc_detection_factor = 5

    strings:

        $encrypt_files = {
            55 8B EC 83 C4 ?? 53 56 57 33 D2 89 55 ?? 89 55 ?? 89 45 ?? 33 C0 55 68 ?? ?? ?? ?? 
            64 FF 30 64 89 20 B2 ?? A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 ?? 33 C0 55 68 ?? ?? ?? 
            ?? 64 FF 30 64 89 20 8B 45 ?? 8B 40 ?? 8B 10 FF 52 ?? 8B F0 4E 83 FE ?? 0F 8C ?? ?? 
            ?? ?? 8B 45 ?? 8B 48 ?? B2 ?? A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 A0 ?? ?? ?? ?? 88 
            43 ?? C6 43 ?? ?? 8D 4D ?? 8B 45 ?? 8B 40 ?? 8B D6 8B 38 FF 57 ?? 8B 55 ?? 8B C3 E8 
            ?? ?? ?? ?? 8D 43 ?? BA ?? ?? ?? ?? E8 ?? ?? ?? ?? B2 ?? 8B C3 E8 ?? ?? ?? ?? 8B D3 
            8B 45 ?? E8 ?? ?? ?? ?? 8B 45 ?? E8 ?? ?? ?? ?? 40 50 8D 45 ?? B9 ?? ?? ?? ?? 8B 15 
            ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 ?? 8B 45 ?? E8 ?? ?? ?? ?? 8B 55 ?? 8B 4B ?? 89 0C 
            82 4E 83 FE ?? 0F 85 ?? ?? ?? ?? 6A ?? 6A ?? 8B 45 ?? 50 8B 45 ?? E8 ?? ?? ?? ?? 50 
            E8 ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8B 45 ?? E8 ?? ?? ?? ?? E8 ?? 
            ?? ?? ?? 84 C0 74 ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 
        }

        $search_files_p1 = {
            E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 C0 89 45 ?? B2 ?? A1 ?? 
            ?? ?? ?? E8 ?? ?? ?? ?? 89 45 ?? 8B 45 ?? F6 40 ?? ?? 74 ?? FF 45 ?? 8B 45 ?? F6 40 
            ?? ?? 74 ?? 83 45 ?? ?? 8B 45 ?? F6 40 ?? ?? 74 ?? 83 45 ?? ?? 8B 45 ?? F6 40 ?? ?? 
            74 ?? 83 45 ?? ?? 8B 45 ?? F6 40 ?? ?? 74 ?? 83 45 ?? ?? B2 ?? A1 ?? ?? ?? ?? E8 ?? 
            ?? ?? ?? 89 45 ?? 8B 45 ?? 8B 10 FF 52 ?? 8D 45 ?? E8 ?? ?? ?? ?? 8B 45 ?? 8B 40 ?? 
            E8 ?? ?? ?? ?? 85 C0 7E ?? 89 45 ?? C7 45 ?? ?? ?? ?? ?? 8B 45 ?? 8B 55 ?? 8B 52 ?? 
            48 85 D2 74 ?? 3B 42 ?? 72 ?? E8 ?? ?? ?? ?? 40 80 7C 02 ?? ?? 74 ?? 8D 85 ?? ?? ?? 
            ?? 8B 55 ?? 8B 4D ?? 8B 49 ?? 4A 85 C9 74 ?? 3B 51 ?? 72 ?? E8 ?? ?? ?? ?? 42 8A 54 
            11 ?? E8 ?? ?? ?? ?? 8B 95 ?? ?? ?? ?? 8D 45 ?? E8 ?? ?? ?? ?? EB ?? 8B 55 ?? 8B 45 
            ?? 8B 08 FF 51 ?? 8D 45 ?? E8 ?? ?? ?? ?? FF 45 ?? FF 4D ?? 75 ?? 8B 45 ?? 8B 10 FF 
            52 ?? 48 85 C0 0F 8C ?? ?? ?? ?? 40 89 45 ?? C7 45 ?? ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? 
            8B 55 ?? 8B 45 ?? 8B 18 FF 53 ?? 8B 8D ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 8B 55 ?? E8 ?? 
            ?? ?? ?? 8B 85 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? 8B 55 ?? E8 ?? ?? ?? ?? 85 C0 0F 85 ?? 
            ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 8D 45 ?? 8B 8D ?? ?? ?? ?? 8B 55 
            ?? E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? BA ?? ?? ?? ?? B8 ?? ?? ?? ?? E8 
            ?? ?? ?? ?? FF B5 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? BA ?? ?? ?? ?? E8 ?? 
            ?? ?? ?? 8B 85 ?? ?? ?? ?? 8B 55 ?? E8 ?? ?? ?? ?? 85 C0 0F 8F ?? ?? ?? ?? 8B 55 ?? 
            B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 0F 8F ?? ?? ?? ?? 8B 55 ?? 8B 45 ?? E8 ?? ?? ?? 
            ?? 84 C0 0F 85 ?? ?? ?? ?? 8B 45 ?? E8 ?? ?? ?? ?? 84 C0 75 ?? 8B 55 ?? B8 ?? ?? ?? 
            ?? E8 ?? ?? ?? ?? 85 C0 7F ?? 8B 45 ?? 8B 40 ?? 50 8B 4D ?? B2 ?? A1 ?? ?? ?? ?? E8 
            ?? ?? ?? ?? 8B D8 B2 ?? 8B C3 E8 ?? ?? ?? ?? 8B D3 8B 45 ?? E8 ?? ?? ?? ?? 8B 45
        }

        $search_files_p2 = {
            E8 ?? ?? ?? ?? 40 50 8D 45 ?? B9 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 
            ?? 8B 45 ?? E8 ?? ?? ?? ?? 8B 55 ?? 85 D2 74 ?? 3B 42 ?? 72 ?? E8 ?? ?? ?? ?? 8B 4B 
            ?? 89 0C 82 8D 85 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 0F 84 ?? ?? ?? ?? 6A ?? 6A ?? 8B 
            45 ?? 50 8B 45 ?? E8 ?? ?? ?? ?? 85 C0 79 ?? E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 33 C0 
            5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 E9 ?? ?? ?? ?? 
            EB ?? FF 45 ?? FF 4D ?? 0F 85 ?? ?? ?? ?? 8B 45 ?? 80 78 ?? ?? 0F 84 ?? ?? ?? ?? 8D 
            85 ?? ?? ?? ?? B9 ?? ?? ?? ?? 8B 55 ?? E8 ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? 8D 8D ?? ?? 
            ?? ?? BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 0F 85 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 
            64 FF 30 64 89 20 F6 85 ?? ?? ?? ?? ?? 0F 84 ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? BA ?? ?? 
            ?? ?? E8 ?? ?? ?? ?? 0F 84 ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? BA ?? ?? ?? ?? E8 ?? ?? ?? 
            ?? 0F 84 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 8B 8D ?? ?? ?? ?? 8B 55 ?? E8 ?? ?? ?? ?? 8B 
            85 ?? ?? ?? ?? 8D 95 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 95 ?? ?? ?? ?? 8B 45 ?? E8 ?? ?? 
            ?? ?? 8D 85 ?? ?? ?? ?? 8B 8D ?? ?? ?? ?? 8B 55 ?? E8 ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? 
            8D 95 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 8D 85 ?? ?? 
            ?? ?? E8 ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 75 ?? 8D 85 ?? ?? ?? ?? 
            8B 8D ?? ?? ?? ?? 8B 55 ?? E8 ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? 8D 95 ?? ?? ?? ?? E8 ?? 
            ?? ?? ?? 8D 85 ?? ?? ?? ?? BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 95 ?? ?? ?? ?? 8B 45 ?? 
            8B 48 ?? 8B 45 ?? E8 
        }

        $disable_services_p1 = {
            E8 ?? ?? ?? ?? 8B F0 BA ?? ?? ?? ?? 8B C6 8B 08 FF 51 ?? BA ?? ?? ?? ?? 8B C6 8B 08 
            FF 51 ?? BA ?? ?? ?? ?? 8B C6 8B 08 FF 51 ?? BA ?? ?? ?? ?? 8B C6 8B 08 FF 51 ?? BA 
            ?? ?? ?? ?? 8B C6 8B 08 FF 51 ?? BA ?? ?? ?? ?? 8B C6 8B 08 FF 51 ?? BA ?? ?? ?? ?? 
            8B C6 8B 08 FF 51 ?? BA ?? ?? ?? ?? 8B C6 8B 08 FF 51 ?? BA ?? ?? ?? ?? 8B C6 8B 08 
            FF 51 ?? BA ?? ?? ?? ?? 8B C6 8B 08 FF 51 ?? BA ?? ?? ?? ?? 8B C6 8B 08 FF 51 ?? BA 
            ?? ?? ?? ?? 8B C6 8B 08 FF 51 ?? BA ?? ?? ?? ?? 8B C6 8B 08 FF 51 ?? BA ?? ?? ?? ?? 
            8B C6 8B 08 FF 51 ?? BA ?? ?? ?? ?? 8B C6 8B 08 FF 51 ?? BA ?? ?? ?? ?? 8B C6 8B 08 
            FF 51 ?? BA ?? ?? ?? ?? 8B C6 8B 08 FF 51 ?? BA ?? ?? ?? ?? 8B C6 8B 08 FF 51 ?? BA 
            ?? ?? ?? ?? 8B C6 8B 08 FF 51 ?? BA ?? ?? ?? ?? 8B C6 8B 08 FF 51 ?? BA ?? ?? ?? ?? 
            8B C6 8B 08 FF 51 ?? BA ?? ?? ?? ?? 8B C6 8B 08 FF 51 ?? BA ?? ?? ?? ?? 8B C6 8B 08 
            FF 51 ?? BA ?? ?? ?? ?? 8B C6 8B 08 FF 51 ?? BA ?? ?? ?? ?? 8B C6 8B 08 FF 51 ?? BA 
            ?? ?? ?? ?? 8B C6 8B 08 FF 51 ?? BA ?? ?? ?? ?? 8B C6 8B 08 FF 51 ?? BA ?? ?? ?? ?? 
            8B C6 8B 08 FF 51 ?? BA ?? ?? ?? ?? 8B C6 8B 08 FF 51 ?? BA ?? ?? ?? ?? 8B C6 8B 08 
            FF 51 ?? BA ?? ?? ?? ?? 8B C6 8B 08 FF 51 ?? BA ?? ?? ?? ?? 8B C6 8B 08 FF 51 ?? BA 
            ?? ?? ?? ?? 8B C6 8B 08 FF 51 ?? BA ?? ?? ?? ?? 8B C6 8B 08 FF 51 ?? BA 
        }

        $disable_services_p2 = {
            8B C6 8B 08 FF 51 ?? BA ?? ?? ?? ?? 8B C6 8B 08 FF 51 ?? BA ?? ?? ?? ?? 8B C6 8B 08 
            FF 51 ?? BA ?? ?? ?? ?? 8B C6 8B 08 FF 51 ?? BA ?? ?? ?? ?? 8B C6 8B 08 FF 51 ?? BA 
            ?? ?? ?? ?? 8B C6 8B 08 FF 51 ?? BA ?? ?? ?? ?? 8B C6 8B 08 FF 51 ?? BA ?? ?? ?? ?? 
            8B C6 8B 08 FF 51 ?? BA ?? ?? ?? ?? 8B C6 8B 08 FF 51 ?? BA ?? ?? ?? ?? 8B C6 8B 08 
            FF 51 ?? BA ?? ?? ?? ?? 8B C6 8B 08 FF 51 ?? BA ?? ?? ?? ?? 8B C6 8B 08 FF 51 ?? BA 
            ?? ?? ?? ?? 8B C6 8B 08 FF 51 ?? BA ?? ?? ?? ?? 8B C6 8B 08 FF 51 ?? BA ?? ?? ?? ?? 
            8B C6 8B 08 FF 51 ?? BA ?? ?? ?? ?? 8B C6 8B 08 FF 51 ?? BA ?? ?? ?? ?? 8B C6 8B 08 
            FF 51 ?? BA ?? ?? ?? ?? 8B C6 8B 08 FF 51 ?? BA ?? ?? ?? ?? 8B C6 8B 08 FF 51 ?? BA 
            ?? ?? ?? ?? 8B C6 8B 08 FF 51 ?? BA ?? ?? ?? ?? 8B C6 8B 08 FF 51 ?? BA ?? ?? ?? ?? 
            8B C6 8B 08 FF 51 ?? BA ?? ?? ?? ?? 8B C6 8B 08 FF 51 ?? BA ?? ?? ?? ?? 8B C6 8B 08 
            FF 51 ?? BA ?? ?? ?? ?? 8B C6 8B 08 FF 51 ?? BA ?? ?? ?? ?? 8B C6 8B 08 FF 51 ?? BA 
            ?? ?? ?? ?? 8B C6 8B 08 FF 51 ?? 8B 55 ?? 8B C6 8B 08 FF 51 ?? 6A ?? 8B 45 ?? E8 ?? 
            ?? ?? ?? 8B D0 8D 45 ?? E8 ?? ?? ?? ?? 8B 45 ?? 33 C9 33 D2 E8 ?? ?? ?? ?? 33 C0 5A 
            59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 ?? BA ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 
        }

    condition:
        uint16(0) == 0x5A4D and 
        (
            (
                all of ($disable_services_p*)
            ) and 
            (
                all of ($search_files_p*)
            ) and 
            (
                $encrypt_files
            )
        )
}