rule Win32_Ransomware_Crypmic : tc_detection malicious
{
    meta:

        author              = "ReversingLabs"

        source              = "ReversingLabs"
        status              = "RELEASED"
        sharing             = "TLP:WHITE"
        category            = "MALWARE"
        malware             = "CRYPMIC"
        description         = "Yara rule that detects Crypmic ransomware."

        tc_detection_type   = "Ransomware"
        tc_detection_name   = "Crypmic"
        tc_detection_factor = 5

    strings:

        $search_and_encrypt_1 = {
            55 8B EC 81 EC ?? ?? ?? ?? 53 56 B8 ?? ?? ?? ?? 57 8B F9 89 7D ?? C7 45 ?? ?? ?? ?? 
            ?? 89 45 ?? 8D 50 ?? 68 ?? ?? ?? ?? 6A ?? FF 77 ?? 66 89 85 ?? ?? ?? ?? 8B 47 ?? C7 
            85 ?? ?? ?? ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? FF D0 66 8B 95 ?? ?? ?? ?? 33 F6 33 
            C9 89 45 ?? 66 3B F2 74 ?? 0F B7 D2 41 66 89 14 06 8D 34 09 33 DB 0F B7 94 35 ?? ?? 
            ?? ?? 66 3B DA 75 ?? BA ?? ?? ?? ?? 66 89 14 48 8D 1C 48 8D 8D ?? ?? ?? ?? 51 C7 43 
            ?? ?? ?? ?? ?? 50 8B 47 ?? FF D0 8B F0 83 FE ?? 0F 84 ?? ?? ?? ?? F6 85 ?? ?? ?? ?? 
            ?? 74 ?? 66 8B 8D ?? ?? ?? ?? 66 83 F9 ?? 74 ?? 66 83 BD ?? ?? ?? ?? ?? 74 ?? 33 D2 
            33 C0 66 3B D1 74 ?? 0F B7 C9 8B FF 40 66 89 4C 1A ?? 8D 14 00 C7 45 ?? ?? ?? ?? ?? 
            0F B7 8C 15 ?? ?? ?? ?? 66 39 4D ?? 75 ?? 8B 55 ?? 33 C9 66 89 4C 43 ?? 68 ?? ?? ?? 
            ?? 8B CF E8 ?? ?? ?? ?? 83 C4 ?? 01 45 ?? 8D 85 ?? ?? ?? ?? 50 8B 47 ?? 56 FF D0 85 
            C0 75 ?? 8B 47 ?? 56 FF D0 8D 85 ?? ?? ?? ?? 50 FF 75 ?? C7 43 ?? ?? ?? ?? ?? 8B 47
        }

        $search_and_encrypt_2 = { 
            33 F6 89 75 ?? FF D0 89 45 ?? 83 F8 ?? 0F 84 ?? ?? ?? ?? EB ?? 8D 9B ?? ?? ?? ?? 
            F6 85 ?? ?? ?? ?? ?? 75 ?? 66 8B BD ?? ?? ?? ?? 33 F6 8B 8E ?? ?? ?? ?? 8D 95 ?? ?? 
            ?? ?? E8 ?? ?? ?? ?? 85 C0 74 ?? BA ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 66 83 FF ?? 75 ?? 
            EB ?? 8D 9B ?? ?? ?? ?? 66 8B 48 ?? 83 C0 ?? 83 C2 ?? 66 3B 0A 74 ?? 66 83 38 ?? 0F 
            85 ?? ?? ?? ?? 66 83 3A ?? 0F 85 ?? ?? ?? ?? 83 C6 ?? 81 FE ?? ?? ?? ?? 72 ?? 8B 7D 
            ?? 8B 75 ?? 8B 45 ?? 8D 8D ?? ?? ?? ?? 51 50 8B 47 ?? FF D0 85 C0 8B 45 ?? 0F 85 ?? 
            ?? ?? ?? 50 8B 47 ?? FF D0 85 F6 74 ?? 8B 55 ?? 33 C0 8B CF 66 89 43 ?? E8 ?? ?? ?? 
            ?? FF 75 ?? 8B 47 ?? 6A ?? FF 77 ?? FF D0 8B 45 ?? 8B 5D ?? 03 C6 03 D8 8B 45 ?? 40 
            89 5D ?? 89 45 ?? BA ?? ?? ?? ?? 83 F8 ?? 0F 8E ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 85 ?? 
            ?? ?? ?? 50 8B 47 ?? 68 ?? ?? ?? ?? FF D0 68 ?? ?? ?? ?? 8D 95 ?? ?? ?? ?? 8B CF E8 
            ?? ?? ?? ?? 83 C4 ?? 03 C3 5F 5E 5B 8B E5 5D C3 33 C9 33 C0 66 3B CF 74 ?? 0F B7 CF 
            33 D2 8D 9B ?? ?? ?? ?? 40 66 89 4C 1A ?? 8D 14 00 33 F6 0F B7 8C 15 ?? ?? ?? ?? 66 
            3B F1 75 ?? 8B 75 ?? FF 75 ?? 8B 7D ?? 33 C9 46 57 66 89 4C 43 ?? 89 75 ?? E8 ?? ?? 
            ?? ?? E9
        }

    condition:
        uint16(0) == 0x5A4D and
        (
            (all of ($search_and_encrypt_*))
        )
}