rule Win32_Ransomware_ShadowCryptor : tc_detection malicious
{
    meta:

        author              = "ReversingLabs"

        source              = "ReversingLabs"
        status              = "RELEASED"
        sharing             = "TLP:WHITE"
        category            = "MALWARE"
        malware             = "SHADOWCRYPTOR"
        description         = "Yara rule that detects ShadowCryptor ransomware."

        tc_detection_type   = "Ransomware"
        tc_detection_name   = "ShadowCryptor"
        tc_detection_factor = 5

    strings:

        $find_files = {
            55 8B EC 6A ?? 68 ?? ?? ?? ?? 64 A1 ?? ?? ?? ?? 50 81 EC ?? ?? ?? ?? A1 ?? ?? ?? ?? 
            33 C5 89 45 ?? 53 56 57 50 8D 45 ?? 64 A3 ?? ?? ?? ?? 89 8D ?? ?? ?? ?? C7 45 ?? ?? 
            ?? ?? ?? 8D 45 ?? 83 7D ?? ?? 0F 57 C0 66 0F 13 85 ?? ?? ?? ?? 0F 43 45 ?? 50 8D 85 
            ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? 
            ?? 8D 85 ?? ?? ?? ?? 50 8D 85 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 8B B5 ?? ?? ?? ?? 8B 
            BD ?? ?? ?? ?? 89 85 ?? ?? ?? ?? 83 F8 ?? 0F 84 ?? ?? ?? ?? 8B 1D ?? ?? ?? ?? EB ?? 
            8D A4 24 ?? ?? ?? ?? 90 68 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 50 FF D3 85 C0 0F 84 ?? ?? 
            ?? ?? 68 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 50 FF D3 85 C0 0F 84 ?? ?? ?? ?? 33 C0 83 7D 
            ?? ?? 66 89 85 ?? ?? ?? ?? 8D 45 ?? 0F 43 45 ?? 50 8D 85 ?? ?? ?? ?? 50 FF 15 ?? ?? 
            ?? ?? 8D 85 ?? ?? ?? ?? 50 8D 85 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 85 C0 74 ?? 8B 85 
            ?? ?? ?? ?? 83 F8 ?? 74 ?? A8 ?? 74 ?? 50 8D 85 ?? ?? ?? ?? 50 51 8B 8D ?? ?? ?? ?? 
            E8 ?? ?? ?? ?? EB ?? 51 8D 85 ?? ?? ?? ?? 50 8D 85 ?? ?? ?? ?? 50 51 8B 8D ?? ?? ?? 
            ?? E8 ?? ?? ?? ?? 85 C0 74 ?? 83 C7 ?? 83 D6 ?? 8D 85 ?? ?? ?? ?? 50 FF B5 ?? ?? ?? 
            ?? FF 15 ?? ?? ?? ?? 85 C0 0F 85 ?? ?? ?? ?? FF B5 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 83 
            7D ?? ?? 72 ?? FF 75 ?? E8 ?? ?? ?? ?? 83 C4 ?? 8B D6 8B C7 8B 4D ?? 64 89 0D ?? ?? 
            ?? ?? 59 5F 5E 5B 8B 4D ?? 33 CD E8 ?? ?? ?? ?? 8B E5 5D C2
        }

        $encrypt_files = {
            55 8B EC 83 E4 ?? 6A ?? 68 ?? ?? ?? ?? 64 A1 ?? ?? ?? ?? 50 83 EC ?? A1 ?? ?? ?? ?? 
            33 C4 89 44 24 ?? 53 56 57 A1 ?? ?? ?? ?? 33 C4 50 8D 44 24 ?? 64 A3 ?? ?? ?? ?? 8B 
            F1 8D 46 ?? 50 8D 4E ?? E8 ?? ?? ?? ?? 33 C0 C7 44 24 ?? ?? ?? ?? ?? C7 44 24 ?? ?? 
            ?? ?? ?? 66 89 44 24 ?? 89 44 24 ?? 39 46 ?? 0F 84 ?? ?? ?? ?? 8D A4 24 ?? ?? ?? ?? 
            80 7E ?? ?? 0F 85 ?? ?? ?? ?? 51 8D 44 24 ?? 50 8D 44 24 ?? 50 8D 4E ?? E8 ?? ?? ?? 
            ?? 8B C8 E8 ?? ?? ?? ?? 8B D0 8B 02 85 C0 74 ?? 8B 00 8B 48 ?? 8B 40 ?? 49 23 4A ?? 
            8B 04 88 8D 4C 24 ?? 3B C8 74 ?? 6A ?? 6A ?? 50 E8 ?? ?? ?? ?? 8B 46 ?? 8B 4E ?? 48 
            03 C8 8B 46 ?? 48 23 C8 8B 46 ?? 8B 3C 88 83 7F ?? ?? 72 ?? FF 37 E8 ?? ?? ?? ?? 83 
            C4 ?? 33 C0 C7 47 ?? ?? ?? ?? ?? C7 47 ?? ?? ?? ?? ?? 66 89 07 FF 4E ?? 75 ?? 89 46 
            ?? 83 EC ?? 8B CC 6A ?? 89 41 ?? 33 C0 C7 41 ?? ?? ?? ?? ?? 50 66 89 01 8D 44 24 ?? 
            50 E8 ?? ?? ?? ?? 51 8B CE E8 ?? ?? ?? ?? 8B C8 0B CA 74 ?? 01 46 ?? 11 56 ?? 83 7C 
            24 ?? ?? 8D 54 24 ?? 0F 43 54 24 ?? 83 EC ?? 8B FC 33 C0 C7 47 ?? ?? ?? ?? ?? C7 47 
            ?? ?? ?? ?? ?? 66 89 07 66 39 02 74 ?? 8B C2 8D 48 ?? 89 4C 24 ?? 66 8B 08 83 C0 ?? 
            66 85 C9 75 ?? 2B 44 24 ?? D1 F8 50 52 8B CF E8 ?? ?? ?? ?? 8B 4E ?? 83 79 ?? ?? 8D 
            41 ?? 72 ?? 8B 00 8B 91 ?? ?? ?? ?? 81 C1 ?? ?? ?? ?? 83 79 ?? ?? 72 ?? 8B 09 50 E8 
            ?? ?? ?? ?? 83 C4 ?? 83 7E ?? ?? 0F 85 ?? ?? ?? ?? 83 7C 24 ?? ?? 72 ?? FF 74 24 ?? 
            E8 ?? ?? ?? ?? 83 C4 ?? 8B 4C 24 ?? 64 89 0D ?? ?? ?? ?? 59 5F 5E 5B 8B 4C 24 ?? 33 
            CC E8 ?? ?? ?? ?? 8B E5 5D C3
        }

        $terminate_antivirus_processes_p1 = {
            55 8B EC 6A ?? 68 ?? ?? ?? ?? 64 A1 ?? ?? ?? ?? 50 81 EC ?? ?? ?? ?? A1 ?? ?? ?? ?? 
            33 C5 89 45 ?? 53 56 57 50 8D 45 ?? 64 A3 ?? ?? ?? ?? 8B D9 C7 85 ?? ?? ?? ?? ?? ?? 
            ?? ?? 33 C0 C7 43 ?? ?? ?? ?? ?? C7 43 ?? ?? ?? ?? ?? 89 9D ?? ?? ?? ?? 66 89 03 89 
            45 ?? 50 6A ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? C7 85
        }

        $terminate_antivirus_processes_p2 = {
            8D 85 ?? ?? ?? ?? 6A ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? 8D 
            85 ?? ?? ?? ?? 50 56 FF 15 ?? ?? ?? ?? 85 C0 74 ?? 8D 49 ?? 33 F6 8B BC B5 ?? ?? ?? 
            ?? 8D 85 ?? ?? ?? ?? 57 50 FF 15 ?? ?? ?? ?? 85 C0 75 ?? 39 43 ?? 74 ?? 6A ?? 68 ?? 
            ?? ?? ?? 8B CB E8 ?? ?? ?? ?? 66 83 3F ?? 75 ?? 33 C0 EB ?? 8B C7 8D 50 ?? 8D 49 ?? 
            66 8B 08 83 C0 ?? 66 85 C9 75 ?? 2B C2 D1 F8 50 57 8B CB E8 ?? ?? ?? ?? 46 83 FE ?? 
            72 ?? 8B B5 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 50 56 FF 15 ?? ?? ?? ?? 85 C0 75 ?? 56 FF 
            15 ?? ?? ?? ?? 8B C3 8B 4D ?? 64 89 0D ?? ?? ?? ?? 59 5F 5E 5B 8B 4D ?? 33 CD E8 ?? 
            ?? ?? ?? 8B E5 5D C3 
        }

    condition:
        uint16(0) == 0x5A4D and
        (
            all of ($terminate_antivirus_processes_p*)
        ) and
        (
            $find_files
        ) and
        (
            $encrypt_files
        )
}