rule Win32_Ransomware_Thanatos : tc_detection malicious
{
    meta:

        author              = "ReversingLabs"

        source              = "ReversingLabs"
        status              = "RELEASED"
        sharing             = "TLP:WHITE"
        category            = "MALWARE"
        malware             = "THANATOS"
        description         = "Yara rule that detects Thanatos ransomware."

        tc_detection_type   = "Ransomware"
        tc_detection_name   = "Thanatos"
        tc_detection_factor = 5

    strings:

        $find_files = {
            55 8B EC 81 EC ?? ?? ?? ?? A1 ?? ?? ?? ?? 33 C5 89 45 ?? 8B 45 ?? 53 56 57 50 89 85 
            ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 8B 35 ?? ?? ?? ?? 68 ?? ?? ?? ?? 
            8D 8D ?? ?? ?? ?? 51 FF D6 8D 95 ?? ?? ?? ?? 52 8D 85 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? 
            ?? 89 85 ?? ?? ?? ?? EB ?? 8D 49 ?? 6A ?? E8 ?? ?? ?? ?? 8B D8 83 C4 ?? C6 03 ?? FF 
            15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 99 B9 ?? ?? 
            ?? ?? F7 F9 52 53 68 ?? ?? ?? ?? 53 E8 ?? ?? ?? ?? 83 C4 ?? 4F 75 ?? 8B 95 ?? ?? ?? 
            ?? 52 8D 85 ?? ?? ?? ?? 50 C6 43 ?? ?? FF 15 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 8D ?? ?? 
            ?? ?? 51 FF D6 8D 95 ?? ?? ?? ?? 52 8D 85 ?? ?? ?? ?? 50 FF D6 F6 85 ?? ?? ?? ?? ?? 
            74 ?? 8B 3D ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? 51 FF D7 85 C0 0F 84 ?? ?? 
            ?? ?? 68 ?? ?? ?? ?? 8D 95 ?? ?? ?? ?? 52 FF D7 85 C0 0F 84 ?? ?? ?? ?? 8D 85 ?? ?? 
            ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 8D 85 ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? C7 
            85 ?? ?? ?? ?? ?? ?? ?? ?? C6 85 ?? ?? ?? ?? ?? 8D 50 ?? 8A 08 40 84 C9 75 ?? 2B C2 
            50 8D 8D ?? ?? ?? ?? 51 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 95 ?? ?? ?? ?? 52 8D BD 
            ?? ?? ?? ?? C6 85 ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 BD ?? ?? ?? ?? ?? 8B F8 72 ?? 8B 
            85 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 83 FF ?? 74 ?? 53 8D 9D ?? ?? ?? ?? E8 ?? 
            ?? ?? ?? 8B 95 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? 51 52 FF 15 ?? ?? ?? ?? 85 C0 0F 85 ?? 
            ?? ?? ?? 8B 85 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 8B 4D ?? 5F 5E 33 CD 5B E8 ?? ?? ?? 
            ?? 8B E5 5D C3 
        }

        $encrypt_files_p1 = {
            55 8B EC 83 EC ?? 53 56 57 68 ?? ?? ?? ?? 33 DB 6A ?? 53 8B F0 53 8D 45 ?? 33 FF 50 
            89 7D ?? 89 5D ?? 89 5D ?? 89 5D ?? FF 15 ?? ?? ?? ?? 85 C0 0F 84 ?? ?? ?? ?? 8B 55 
            ?? 8D 4D ?? 51 53 53 68 ?? ?? ?? ?? 52 FF 15 ?? ?? ?? ?? 85 C0 0F 84 ?? ?? ?? ?? 8B 
            C6 8D 50 ?? 8A 08 40 84 C9 75 ?? 53 2B C2 50 8B 45 ?? 56 50 FF 15 ?? ?? ?? ?? 85 C0 
            0F 84 ?? ?? ?? ?? 8B 55 ?? 8B 45 ?? 8D 4D ?? 51 6A ?? 52 68 ?? ?? ?? ?? 50 FF 15 ?? 
            ?? ?? ?? 85 C0 0F 84 ?? ?? ?? ?? 8B 45 ?? 8B 55 ?? 50 8D 4D ?? 51 53 53 6A ?? 53 8B 
            1D ?? ?? ?? ?? 52 89 45 ?? FF D3 85 C0 74 ?? 8B 45 ?? 8B 3D ?? ?? ?? ?? 50 6A ?? FF 
            D7 50 FF 15 ?? ?? ?? ?? 8B F0 85 F6 74 ?? 8B 4D ?? 8B 55 ?? 8B 02 51 50 56 E8 ?? ?? 
            ?? ?? 8B 4D ?? 8B 45 ?? 83 C4 ?? 51 8D 55 ?? 52 56 6A ?? 6A ?? 6A ?? 50 FF D3 85 C0 
            74 ?? 8B 5D ?? 8B 0B 51 6A ?? FF D7 50 FF 15 ?? ?? ?? ?? 8B 55 ?? 8B 45 ?? 89 10 89 
            33 C7 45 ?? ?? ?? ?? ?? 8B 4D ?? 51 FF 15 ?? ?? ?? ?? 8B 7D ?? 33 DB 8B 55 ?? 52 FF 
            15 ?? ?? ?? ?? 8B 45 ?? 53 50 FF 15 ?? ?? ?? ?? 8B C7 5F 5E 5B 8B E5 5D C2
        }

        $encrypt_files_p2 = {
            55 8B EC 6A ?? 68 ?? ?? ?? ?? 64 A1 ?? ?? ?? ?? 50 81 EC ?? ?? ?? ?? A1 ?? ?? ?? ?? 
            33 C5 89 45 ?? 56 57 50 8D 45 ?? 64 A3 ?? ?? ?? ?? 8B 45 ?? 33 F6 56 68 ?? ?? ?? ?? 
            6A ?? 56 6A ?? 68 ?? ?? ?? ?? 53 89 85 ?? ?? ?? ?? 89 B5 ?? ?? ?? ?? 89 B5 ?? ?? ?? 
            ?? FF 15 ?? ?? ?? ?? 8B F8 83 FF ?? 0F 84 ?? ?? ?? ?? 56 57 FF 15 ?? ?? ?? ?? 8B F0 
            56 6A ?? FF 15 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 89 85 ?? ?? ?? ?? 85 C0 0F 84 ?? ?? 
            ?? ?? 6A ?? 8D 8D ?? ?? ?? ?? 51 56 50 57 FF 15 ?? ?? ?? ?? 85 C0 0F 84 ?? ?? ?? ?? 
            8B 85 ?? ?? ?? ?? 8D 95 ?? ?? ?? ?? 52 50 8B 85 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? 51 E8 
            ?? ?? ?? ?? 85 C0 0F 84 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 95 ?? ?? ?? ?? 6A ?? 52 E8 ?? 
            ?? ?? ?? 83 C4 ?? 53 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 50 B8 ?? ?? ?? ?? 8D B5 ?? ?? 
            ?? ?? C7 45 ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? BE ?? ?? ?? ?? 83 C4 ?? 39 70 ?? 72 ?? 8B 
            00 50 8D 85 ?? ?? ?? ?? 68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 39 B5 ?? ?? ?? ?? 
            72 ?? 8B 8D ?? ?? ?? ?? 51 E8 ?? ?? ?? ?? 83 C4 ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? C7 
            85 ?? ?? ?? ?? ?? ?? ?? ?? C6 85 ?? ?? ?? ?? ?? 39 B5 ?? ?? ?? ?? 72 ?? 8B 95 ?? ?? 
            ?? ?? 52 E8 ?? ?? ?? ?? 83 C4 ?? 6A ?? 68 ?? ?? ?? ?? 6A ?? 6A ?? 6A ?? 68 ?? ?? ?? 
            ?? 8D 85 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 83 F8 ?? 74 ?? 8B 95 ?? ?? ?? ?? 6A ?? 8D 
            8D ?? ?? ?? ?? 51 8B 8D ?? ?? ?? ?? 52 51 50 FF 15 ?? ?? ?? ?? 57 FF 15 ?? ?? ?? ?? 
            53 FF 15 ?? ?? ?? ?? 8B 4D ?? 64 89 0D ?? ?? ?? ?? 59 5F 5E 8B 4D ?? 33 CD E8 ?? ?? 
            ?? ?? 8B E5 5D C2
        }
        
    condition:
        uint16(0) == 0x5A4D and
        (
            $find_files
        ) and
        (
            all of ($encrypt_files_p*)
        )
}