rule ByteCode_MSIL_Ransomware_TaRRaK : tc_detection malicious
{
    meta:

        author              = "ReversingLabs"

        source              = "ReversingLabs"
        status              = "RELEASED"
        sharing             = "TLP:WHITE"
        category            = "MALWARE"
        malware             = "TARRAK"
        description         = "Yara rule that detects TaRRaK ransomware."

        tc_detection_type   = "Ransomware"
        tc_detection_name   = "TaRRaK"
        tc_detection_factor = 5

    strings:

        $encrypt_files_p1 = {
            03 28 ?? ?? ?? ?? 0A 16 0B 2B ?? 06 07 9A 0C 73 ?? ?? ?? ?? 0D 09 08 28 ?? ?? ?? ?? 7D
            ?? ?? ?? ?? 02 7B ?? ?? ?? ?? 09 FE 06 ?? ?? ?? ?? 73 ?? ?? ?? ?? 28 ?? ?? ?? ?? 2C ??
            02 08 28 ?? ?? ?? ?? 07 17 58 0B 07 06 8E 69 32 ?? DE ?? 26 DE ?? 00 03 28 ?? ?? ?? ??
            0A 16 0B 2B ?? 06 07 9A 13 ?? 11 ?? 72 ?? ?? ?? ?? 6F ?? ?? ?? ?? 2D ?? 11 ?? 72 ?? ??
            ?? ?? 6F ?? ?? ?? ?? 2D ?? 11 ?? 72 ?? ?? ?? ?? 6F ?? ?? ?? ?? 2D ?? 11 ?? 72 ?? ?? ??
            ?? 6F ?? ?? ?? ?? 2D ?? 11 ?? 72 ?? ?? ?? ?? 6F ?? ?? ?? ?? 2D ?? 11 ?? 72 ?? ?? ?? ??
            6F ?? ?? ?? ?? 2D ?? 11 ?? 72 ?? ?? ?? ?? 6F ?? ?? ?? ?? 2D ?? 02 11 ?? 28 ?? ?? ?? ??
            07 17 58 0B 07 06 8E 69 32 ?? DE ?? 26 DE ?? 2A
        }

        $encrypt_files_p2 = {
            03 8E 69 17 59 0A 06 17 2F ?? 03 2A 03 06 95 0B 16 0D 1C 1F ?? 06 17 58 5B 58 13 ?? 2B
            ?? 09 20 ?? ?? ?? ?? 58 0D 09 18 64 19 5F 13 ?? 16 13 ?? 2B ?? 03 11 ?? 17 58 95 0C 03
            11 ?? 8F ?? ?? ?? ?? 25 4B 02 09 08 07 11 ?? 11 ?? 04 28 ?? ?? ?? ?? 58 25 13 ?? 54 11
            ?? 0B 11 ?? 17 58 13 ?? 11 ?? 06 32 ?? 03 16 95 0C 03 06 8F ?? ?? ?? ?? 25 4B 02 09 08
            07 11 ?? 11 ?? 04 28 ?? ?? ?? ?? 58 25 13 ?? 54 11 ?? 0B 16 11 ?? 25 17 59 13 ?? 32 ??
            03 2A
        }

        $encrypt_files_p3 = {
            05 1B 64 04 18 62 61 04 19 64 05 1A 62 61 58 03 04 61 0E ?? 0E ?? 19 5F 6A 0E ?? 6E 61
            D4 95 05 61 58 61 2A
        }

        $encrypt_files_p4 = {
            03 8E 2D ?? 03 2A 02 02 02 03 17 28 ?? ?? ?? ?? 02 02 7B ?? ?? ?? ?? 16 28 ?? ?? ?? ??
            28 ?? ?? ?? ?? 16 28 ?? ?? ?? ?? 2A
        }

        $find_files_p1 = {
            73 ?? ?? ?? ?? 25 02 28 ?? ?? ?? ?? 6F ?? ?? ?? ?? 25 28 ?? ?? ?? ?? 7E ?? ?? ?? ?? 25
            2D ?? 26 7E ?? ?? ?? ?? FE 06 ?? ?? ?? ?? 73 ?? ?? ?? ?? 25 80 ?? ?? ?? ?? 28 ?? ?? ??
            ?? 6F ?? ?? ?? ?? 2A
        }

        $find_files_p2 = {
            73 ?? ?? ?? ?? 25 1F ?? 28 ?? ?? ?? ?? 6F ?? ?? ?? ?? 25 1B 28 ?? ?? ?? ?? 6F ?? ?? ??
            ?? 25 1F ?? 28 ?? ?? ?? ?? 6F ?? ?? ?? ?? 25 1F ?? 28 ?? ?? ?? ?? 6F ?? ?? ?? ?? 25 1F
            ?? 28 ?? ?? ?? ?? 6F ?? ?? ?? ?? 2A
        }

        $change_desktop = {
            1F ?? 28 ?? ?? ?? ?? 02 7B ?? ?? ?? ?? 28 ?? ?? ?? ?? 0A 28 ?? ?? ?? ?? 06 28 ?? ?? ??
            ?? 6F ?? ?? ?? ?? 7E ?? ?? ?? ?? 72 ?? ?? ?? ?? 17 6F ?? ?? ?? ?? 25 72 ?? ?? ?? ?? 17
            8C ?? ?? ?? ?? 6F ?? ?? ?? ?? 72 ?? ?? ?? ?? 16 8C ?? ?? ?? ?? 6F ?? ?? ?? ?? 1F ?? 16
            06 19 28 ?? ?? ?? ?? 26 DE ?? 26 DE ?? 2A
        }

        $drop_ransom_note = {
            02 7B ?? ?? ?? ?? 6F ?? ?? ?? ?? 2D ?? 2A 00 28 ?? ?? ?? ?? 72 ?? ?? ?? ?? 02 7B ?? ??
            ?? ?? 6F ?? ?? ?? ?? 0D 12 ?? 28 ?? ?? ?? ?? 6F ?? ?? ?? ?? 72 ?? ?? ?? ?? 7E ?? ?? ??
            ?? 28 ?? ?? ?? ?? 6F ?? ?? ?? ?? 0A 73 ?? ?? ?? ?? 0B 07 06 6F ?? ?? ?? ?? 26 07 6F ??
            ?? ?? ?? 26 07 72 ?? ?? ?? ?? 6F ?? ?? ?? ?? 26 02 7B ?? ?? ?? ?? 6F ?? ?? ?? ?? 13 ??
            2B ?? 12 ?? 28 ?? ?? ?? ?? 13 ?? 07 11 ?? 6F ?? ?? ?? ?? 26 12 ?? 28 ?? ?? ?? ?? 2D ??
            DE ?? 12 ?? FE 16 ?? ?? ?? ?? 6F ?? ?? ?? ?? DC 07 6F ?? ?? ?? ?? 0C 02 28 ?? ?? ?? ??
            6F ?? ?? ?? ?? 13 ?? 2B ?? 11 ?? 6F ?? ?? ?? ?? 13 ?? 11 ?? 02 7B ?? ?? ?? ?? 28 ?? ??
            ?? ?? 06 28 ?? ?? ?? ?? 11 ?? 02 7B ?? ?? ?? ?? 28 ?? ?? ?? ?? 08 28 ?? ?? ?? ?? DE ??
            26 DE ?? 11 ?? 6F ?? ?? ?? ?? 2D ?? DE ?? 11 ?? 2C ?? 11 ?? 6F ?? ?? ?? ?? DC DE ?? 26
            DE ?? 2A
        }

    condition:
        uint16(0) == 0x5A4D and
        (
            all of ($find_files_p*)
        ) and
        (
            all of ($encrypt_files_p*)
        ) and
        (
            $change_desktop
        ) and
        (
            $drop_ransom_note
        )
}