rule Bytecode_MSIL_Ransomware_CobraLocker : tc_detection malicious
{
    meta:

        author              = "ReversingLabs"

        source              = "ReversingLabs"
        status              = "RELEASED"
        sharing             = "TLP:WHITE"
        category            = "MALWARE"
        malware             = "COBRALOCKER"
        description         = "Yara rule that detects CobraLocker ransomware."

        tc_detection_type   = "Ransomware"
        tc_detection_name   = "CobraLocker"
        tc_detection_factor = 5

    strings:

        $encrypt_files = {
            14 0A 1E 8D ?? ?? ?? ?? 25 D0 ?? ?? ?? ?? 28 ?? ?? ?? ?? 0B 73 ?? ?? ?? ?? 0C 00 73 ?? 
            ?? ?? ?? 0D 00 09 20 ?? ?? ?? ?? 6F ?? ?? ?? ?? 00 09 20 ?? ?? ?? ?? 6F ?? ?? ?? ?? 00 
            03 07 20 ?? ?? ?? ?? 73 ?? ?? ?? ?? 13 ?? 09 11 ?? 09 6F ?? ?? ?? ?? 1E 5B 6F ?? ?? ?? 
            ?? 6F ?? ?? ?? ?? 00 09 11 ?? 09 6F ?? ?? ?? ?? 1E 5B 6F ?? ?? ?? ?? 6F ?? ?? ?? ?? 00 
            09 17 6F ?? ?? ?? ?? 00 08 09 6F ?? ?? ?? ?? 17 73 ?? ?? ?? ?? 13 ?? 00 11 ?? 02 16 02 
            8E 69 6F ?? ?? ?? ?? 00 11 ?? 6F ?? ?? ?? ?? 00 00 DD ?? ?? ?? ?? 11 ?? 38 ?? ?? ?? ?? 
            38 ?? ?? ?? ?? 39 ?? ?? ?? ?? 11 ?? 6F ?? ?? ?? ?? 00 DC 08 6F ?? ?? ?? ?? 0A 00 DD ?? 
            ?? ?? ?? 09 38 ?? ?? ?? ?? 38 ?? ?? ?? ?? 39 ?? ?? ?? ?? 09 6F ?? ?? ?? ?? 00 DC 00 DD 
            ?? ?? ?? ?? 08 38 ?? ?? ?? ?? 38 ?? ?? ?? ?? 39 ?? ?? ?? ?? 08 6F ?? ?? ?? ?? 00 DC 06 
            13 ?? 38 ?? ?? ?? ?? 38 ?? ?? ?? ?? 38 ?? ?? ?? ?? 11 ?? 2A 
        }

        $find_files = {
            16 28 ?? ?? ?? ?? 0A 72 ?? ?? ?? ?? 28 ?? ?? ?? ?? 0B 07 72 ?? ?? ?? ?? 28 ?? ?? ?? ?? 
            0C 07 72 ?? ?? ?? ?? 28 ?? ?? ?? ?? 0D 07 72 ?? ?? ?? ?? 28 ?? ?? ?? ?? 13 ?? 06 72 ?? 
            ?? ?? ?? 28 ?? ?? ?? ?? 72 ?? ?? ?? ?? 17 28 ?? ?? ?? ?? 13 ?? 08 72 ?? ?? ?? ?? 28 ?? 
            ?? ?? ?? 72 ?? ?? ?? ?? 17 28 ?? ?? ?? ?? 13 ?? 09 72 ?? ?? ?? ?? 28 ?? ?? ?? ?? 72 ?? 
            ?? ?? ?? 16 28 ?? ?? ?? ?? 13 ?? 11 ?? 72 ?? ?? ?? ?? 28 ?? ?? ?? ?? 72 ?? ?? ?? ?? 17 
            28 ?? ?? ?? ?? 13 ?? 73 ?? ?? ?? ?? 13 ?? 72 ?? ?? ?? ?? 13 ?? 16 13 ?? 38 ?? ?? ?? ?? 
            00 11 ?? 11 ?? 11 ?? 9A 11 ?? 6F ?? ?? ?? ?? 00 00 11 ?? 17 58 13 ?? 11 ?? 11 ?? 8E 69 
            FE 04 13 ?? 11 ?? 38 ?? ?? ?? ?? 38 ?? ?? ?? ?? 00 11 ?? 11 ?? 11 ?? 9A 11 ?? 6F ?? ?? 
            ?? ?? 00 00 11 ?? 17 58 13 ?? 11 ?? 11 ?? 8E 69 FE 04 13 ?? 11 ?? 38 ?? ?? ?? ?? 38 ?? 
            ?? ?? ?? 00 11 ?? 11 ?? 11 ?? 9A 11 ?? 6F ?? ?? ?? ?? 00 00 11 ?? 17 58 13 ?? 11 ?? 11 
            ?? 8E 69 FE 04 13 ?? 11 ?? 38 ?? ?? ?? ?? 38 ?? ?? ?? ?? 00 11 ?? 11 ?? 11 ?? 9A 11 ?? 
            6F ?? ?? ?? ?? 00 00 11 ?? 17 58 13 ?? 11 ?? 11 ?? 8E 69 FE 04 13 ?? 11 ?? 38 ?? ?? ?? 
            ?? 38 ?? ?? ?? ?? 3A ?? ?? ?? ?? 16 13 ?? 38 ?? ?? ?? ?? 38 ?? ?? ?? ?? 3A ?? ?? ?? ?? 
            16 13 ?? 38 ?? ?? ?? ?? 38 ?? ?? ?? ?? 3A ?? ?? ?? ?? 16 13 ?? 38 ?? ?? ?? ?? 38 ?? ?? 
            ?? ?? 3A ?? ?? ?? ?? 2A 
        }

    condition:
        uint16(0) == 0x5A4D and
        (
            $find_files
        ) and
        (
            $encrypt_files
        )
}