rule Linux_Ransomware_RedAlert : tc_detection malicious
{
    meta:

        author              = "ReversingLabs"

        source              = "ReversingLabs"
        status              = "RELEASED"
        sharing             = "TLP:WHITE"
        category            = "MALWARE"
        malware             = "REDALERT"
        description         = "Yara rule that detects RedAlert ransomware."

        tc_detection_type   = "Ransomware"
        tc_detection_name   = "RedAlert"
        tc_detection_factor = 5

    strings:

        $encrypt_files_p1 = {
            41 57 41 56 41 55 41 54 55 53 48 81 EC ?? ?? ?? ?? 48 89 74 24 ?? BE ?? ?? ?? ?? 48
            89 54 24 ?? 48 89 4C 24 ?? 4C 89 44 24 ?? E8 ?? ?? ?? ?? 48 85 C0 48 89 C5 75 ?? BF
            ?? ?? ?? ?? E8 ?? ?? ?? ?? EB ?? 48 89 C7 E8 ?? ?? ?? ?? 83 F8 ?? 89 C3 75 ?? BF ??
            ?? ?? ?? E8 ?? ?? ?? ?? 48 89 EF E8 ?? ?? ?? ?? 31 C0 E9 ?? ?? ?? ?? 48 8D 54 24 ??
            89 C6 BF ?? ?? ?? ?? E8 ?? ?? ?? ?? FF C0 75 ?? BF ?? ?? ?? ?? EB ?? 4C 8B B4 24 ??
            ?? ?? ?? 4D 85 F6 7F ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 DF E8 ?? ?? ?? ?? EB ?? 49
            81 FE ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? 0F 97 44 24 ?? 49 81 FE ?? ?? ?? ?? 0F 97
            44 24 ?? 80 7C 24 ?? ?? 74 ?? BA ?? ?? ?? ?? 4C 89 F0 C7 44 24 ?? ?? ?? ?? ?? 48 89
            D3 31 D2 48 F7 F3 48 6B C8 ?? 48 89 4C 24 ?? 49 81 FE ?? ?? ?? ?? 77 ?? 4D 89 F4 41
            BD ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? EB ?? 41 BC ?? ?? ?? ?? 45 31 ED C7 44 24 ??
            ?? ?? ?? ?? 4D 63 FD C7 44 24 ?? ?? ?? ?? ?? 4C 0F AF 7C 24 ?? E9 ?? ?? ?? ?? 80 7C
            24 ?? ?? 74 ?? 45 85 ED 74 ?? 80 7C 24 ?? ?? 74 ?? 41 8D 45 ?? 3B 44 24 ?? 4C 89 FE
            75 ?? 49 8D B6 ?? ?? ?? ?? EB ?? 31 F6 31 D2 48 89 EF E8 ?? ?? ?? ?? 48 63 7C 24 ??
            48 89 E9 4C 89 E2 48 03 7C 24 ?? BE ?? ?? ?? ?? E8 ?? ?? ?? ?? 4C 39 E0 74 ?? BF ??
            ?? ?? ?? EB ?? 44 01 64 24 ?? 41 FF C5 44 3B 6C 24 ?? 0F 85 ?? ?? ?? ?? 48 8D 9C 24
            ?? ?? ?? ?? BA ?? ?? ?? ?? BE ?? ?? ?? ?? 48 89 DF E8 ?? ?? ?? ?? 84 C0 74 ?? BF ??
            ?? ?? ?? EB ?? 48 8D BC 24 ?? ?? ?? ?? BA ?? ?? ?? ?? 48 89 DE E8 ?? ?? ?? ?? 85 C0
            74 ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 4C 63 6C 24 ?? 45 89 E7 44 89 64 24 ?? 4C 0F AF
            6C 24 ?? C6 44 24 ?? ?? C7 44 24 ?? ?? ?? ?? ?? E9 ?? ?? ?? ?? 4C 8B 4C 24 ?? 41 B8
            ?? ?? ?? ?? B9 ?? ?? ?? ?? BA ?? ?? ?? ?? BE ?? ?? ?? ?? 48 89 DF E8 ?? ?? ?? ?? 84
        }

        $encrypt_files_p2 = {
            C0 75 ?? 48 8B 54 24 ?? 48 8B 7C 24 ?? 48 89 E9 BE ?? ?? ?? ?? E8 ?? ?? ?? ?? 0F B7
            15 ?? ?? ?? ?? 48 39 D0 75 ?? 48 8B 44 24 ?? 48 89 E9 BE ?? ?? ?? ?? 0F B7 50 ?? 48
            8B 38 E8 ?? ?? ?? ?? 48 8B 4C 24 ?? 0F B7 51 ?? 48 39 D0 74 ?? BF ?? ?? ?? ?? E9 ??
            ?? ?? ?? 48 89 EF E8 ?? ?? ?? ?? 4C 03 7C 24 ?? 44 3B 6C 24 ?? 0F 8C ?? ?? ?? ?? E9
            ?? ?? ?? ?? BF ?? ?? ?? ?? EB ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? E9 ?? ?? ?? ?? 80 7C
            24 ?? ?? 74 ?? 83 7C 24 ?? ?? 74 ?? 80 7C 24 ?? ?? 74 ?? 8B 44 24 ?? 4C 89 EE FF C0
            3B 44 24 ?? 75 ?? 49 8D B6 ?? ?? ?? ?? EB ?? 31 F6 31 D2 48 89 EF E8 ?? ?? ?? ?? 48
            63 44 24 ?? 48 8B 5C 24 ?? 48 8D B4 24 ?? ?? ?? ?? 48 8D BC 24 ?? ?? ?? ?? 31 C9 31
            D2 45 89 E1 C7 44 24 ?? ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? 48 01 C3 48 8D 84 24 ??
            ?? ?? ?? 49 89 D8 48 89 1C 24 48 89 44 24 ?? E8 ?? ?? ?? ?? 85 C0 0F 85 ?? ?? ?? ??
            48 89 E9 4C 89 E2 BE ?? ?? ?? ?? 48 89 DF E8 ?? ?? ?? ?? 4C 39 E0 0F 85 ?? ?? ?? ??
            FF 44 24 ?? 8B 54 24 ?? 8B 4C 24 ?? 01 54 24 ?? 39 4C 24 ?? 75 ?? 31 F6 BA ?? ?? ??
            ?? 48 89 EF E8 ?? ?? ?? ?? 48 8D BC 24 ?? ?? ?? ?? 48 89 E9 BA ?? ?? ?? ?? BE ?? ??
            ?? ?? E8 ?? ?? ?? ?? 8A 5C 24 ?? 48 83 F8 ?? B0 ?? 0F 44 D8 44 3B 7C 24 ?? 88 5C 24
            ?? 74 ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 44 03 7C 24 ?? 4C 03 6C 24 ?? 8B 44 24 ?? 39
            44 24 ?? 0F 8C ?? ?? ?? ?? 48 89 EF E8 ?? ?? ?? ?? 0F B6 44 24 ?? 48 81 C4 ?? ?? ??
            ?? 5B 5D 41 5C 41 5D 41 5E 41 5F C3
        }

        $find_files_p1 = {
            41 57 FC 41 56 41 55 41 54 49 89 FC 55 53 48 83 EC ?? 48 8B 84 24 ?? ?? ?? ?? 48 89
            4C 24 ?? 48 83 C9 ?? 48 89 74 24 ?? 4C 89 44 24 ?? 4C 89 4C 24 ?? 88 54 24 ?? 48 89
            44 24 ?? 48 8B 84 24 ?? ?? ?? ?? 44 8A BC 24 ?? ?? ?? ?? 48 89 44 24 ?? 48 8B 84 24
            ?? ?? ?? ?? 48 89 44 24 ?? 48 8B 84 24 ?? ?? ?? ?? 48 89 44 24 ?? 31 C0 F2 AE 4C 89
            E7 48 F7 D1 4C 8D 71 ?? E8 ?? ?? ?? ?? 48 85 C0 48 89 44 24 ?? 0F 85 ?? ?? ?? ?? E8
            ?? ?? ?? ?? 8B 38 E8 ?? ?? ?? ?? 48 83 C4 ?? 4C 89 E6 48 89 C2 5B 5D 41 5C 41 5D 41
            5E 41 5F BF ?? ?? ?? ?? 31 C0 E9 ?? ?? ?? ?? 45 84 FF 48 8D 6B ?? 74 ?? 0F B6 4B ??
            48 89 EA 4C 89 E6 BF ?? ?? ?? ?? 31 C0 E8 ?? ?? ?? ?? 80 7B ?? ?? 0F 85 ?? ?? ?? ??
            80 7C 24 ?? ?? 0F 84 ?? ?? ?? ?? BE ?? ?? ?? ?? 48 89 EF E8 ?? ?? ?? ?? 85 C0 0F 84
            ?? ?? ?? ?? BE ?? ?? ?? ?? 48 89 EF E8 ?? ?? ?? ?? 85 C0 0F 84 ?? ?? ?? ?? BE ?? ??
            ?? ?? 48 89 EF E8 ?? ?? ?? ?? 85 C0 0F 84 ?? ?? ?? ?? FC 31 C0 48 83 C9 ?? 48 89 EF
            F2 AE 4C 89 F0 48 29 C8 48 3B 44 24 ?? 76 ?? 48 8B 3D ?? ?? ?? ?? 48 89 E9 4C 89 E2
            BE ?? ?? ?? ?? 31 C0 E8 ?? ?? ?? ?? E9 ?? ?? ?? ?? 4B 8D 1C 34 48 89 EE 48 8D 7B ??
            C6 03 ?? E8 ?? ?? ?? ?? 41 0F B6 C7 4C 8B 4C 24 ?? 4C 8B 44 24 ?? 89 44 24 ?? 48 8B
            44 24 ?? BA ?? ?? ?? ?? 48 8B 4C 24 ?? 48 8B 74 24 ?? 4C 89 E7 48 89 44 24 ?? 48 8B
        }

        $find_files_p2 = {
            44 24 ?? 48 89 44 24 ?? 48 8B 44 24 ?? 48 89 44 24 ?? 48 8B 44 24 ?? 48 89 04 24 E8
            ?? ?? ?? ?? E9 ?? ?? ?? ?? 45 84 FF 0F 85 ?? ?? ?? ?? FC 48 83 C9 ?? 48 89 EF 44 88
            F8 F2 AE 48 8B 54 24 ?? 48 89 EF 48 89 CB 48 8B 4C 24 ?? 48 F7 D3 48 89 DE 4C 8D 6B
            ?? E8 ?? ?? ?? ?? 84 C0 74 ?? 48 89 EA 4C 89 E6 BF ?? ?? ?? ?? 31 C0 E8 ?? ?? ?? ??
            E9 ?? ?? ?? ?? 4C 89 EA BE ?? ?? ?? ?? 48 89 EF E8 ?? ?? ?? ?? 85 C0 0F 84 ?? ?? ??
            ?? 48 89 DE 48 89 EF E8 ?? ?? ?? ?? 84 C0 0F 84 ?? ?? ?? ?? 4B 8D 1C 34 48 89 EA 4C
            89 E6 BF ?? ?? ?? ?? 31 C0 E8 ?? ?? ?? ?? 48 8D 7B ?? 48 89 EE C6 03 ?? E8 ?? ?? ??
            ?? 0F B7 0D ?? ?? ?? ?? 4C 89 E7 4C 8B 44 24 ?? 48 8B 54 24 ?? 48 8B 74 24 ?? FF 15
            ?? ?? ?? ?? 84 C0 BF ?? ?? ?? ?? 74 ?? 48 8B 7C 24 ?? B9 ?? ?? ?? ?? 4C 89 E2 BE ??
            ?? ?? ?? 31 C0 E8 ?? ?? ?? ?? 48 8B 74 24 ?? 4C 89 E7 E8 ?? ?? ?? ?? 85 C0 74 ?? BF
            ?? ?? ?? ?? E8 ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 7C 24 ?? 41 8D 56 ??
            4C 89 E6 E8 ?? ?? ?? ?? C6 03 ?? 48 8B 7C 24 ?? E8 ?? ?? ?? ?? 48 85 C0 48 89 C3 0F
            85 ?? ?? ?? ?? 48 8B 7C 24 ?? 48 83 C4 ?? 5B 5D 41 5C 41 5D 41 5E 41 5F E9
        }

        $setup_environment = {
            55 48 89 E5 41 56 49 89 F6 BE ?? ?? ?? ?? 41 55 41 54 53 48 89 FB 48 83 EC ?? E8 ??
            ?? ?? ?? 48 85 C0 49 89 C4 75 ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 7D ?? E8 ?? ??
            ?? ?? 84 C0 BF ?? ?? ?? ?? 74 ?? BE ?? ?? ?? ?? 48 89 DF E8 ?? ?? ?? ?? 48 85 C0 49
            89 C4 74 ?? 0F B7 55 ?? 48 8B 7D ?? 48 89 C1 BE ?? ?? ?? ?? E8 ?? ?? ?? ?? 0F B7 55
            ?? 48 8B 7D ?? 4C 89 E1 BE ?? ?? ?? ?? E8 ?? ?? ?? ?? 0F B7 55 ?? 31 C9 39 C2 0F 85
            ?? ?? ?? ?? E9 ?? ?? ?? ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? E9 ?? ?? ?? ?? BF ?? ?? ??
            ?? 49 89 E5 E8 ?? ?? ?? ?? 66 8B 3D ?? ?? 22 00 66 03 3D ?? ?? 22 00 66 8B 05 ?? ??
            22 00 66 89 7D ?? 0F B7 FF 66 89 45 ?? E8 ?? ?? ?? ?? 0F B7 7D ?? 48 89 45 ?? E8 ??
            ?? ?? ?? 0F B7 55 ?? 48 8B 7D ?? 4C 89 E1 BE ?? ?? ?? ?? 48 89 45 ?? E8 ?? ?? ?? ??
            0F B7 55 ?? 48 8B 7D ?? 4C 89 E1 BE ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B 75 ?? BF ?? ??
            ?? ?? 31 C0 E8 ?? ?? ?? ?? 0F B7 45 ?? 0F B7 35 ?? ?? ?? ?? 31 C9 48 8B 7D ?? 48 83
            C0 ?? 25 ?? ?? ?? ?? 48 29 C4 48 8D 5C 24 ?? 48 83 E3 ?? 48 89 DA E8 ?? ?? ?? ?? 48
            89 DE BF ?? ?? ?? ?? 31 C0 E8 ?? ?? ?? ?? 0F B7 3D ?? ?? ?? ?? BE ?? ?? ?? ?? 48 03
            7D ?? E8 ?? ?? ?? ?? 66 39 05 ?? ?? 22 00 74 ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 4C 89
            EC 31 C9 EB ?? 4C 89 E7 E8 ?? ?? ?? ?? 48 8D 75 ?? B9 ?? ?? ?? ?? 4C 89 F7 FC F3 A5
            B1 ?? EB ?? 4C 89 EC EB ?? 48 8D 65 ?? 89 C8 5B 41 5C 41 5D 41 5E C9 C3
        }

        $make_configuration = {
            41 56 BE ?? ?? ?? ?? 49 89 FE BF ?? ?? ?? ?? 41 55 41 54 55 53 48 83 EC ?? E8 ?? ??
            ?? ?? 84 C0 88 C3 74 ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 31 FF EB ?? BF ?? ?? ?? ?? E8
            ?? ?? ?? ?? BA ?? ?? ?? ?? 0F B7 F0 BF ?? ?? ?? ?? E8 ?? ?? ?? ?? BF ?? ?? ?? ?? E8
            ?? ?? ?? ?? B9 ?? ?? ?? ?? 49 89 C4 48 89 C2 BE ?? ?? ?? ?? BF ?? ?? ?? ?? 66 C7 00
            ?? ?? C6 40 ?? ?? E8 ?? ?? ?? ?? 4C 89 E6 BF ?? ?? ?? ?? 31 C0 E8 ?? ?? ?? ?? 48 89
            E6 4C 89 E7 E8 ?? ?? ?? ?? 84 C0 75 ?? BF ?? ?? ?? ?? E8 ?? ?? ?? ?? BF ?? ?? ?? ??
            E8 ?? ?? ?? ?? FC 88 D8 BF ?? ?? ?? ?? 48 83 C9 ?? F2 AE 48 F7 D1 48 FF C9 8D 59 ??
            83 C1 ?? 48 63 F9 E8 ?? ?? ?? ?? 48 85 C0 48 89 C5 0F 84 ?? ?? ?? ?? 48 8D 78 ?? 48
            63 D3 BE ?? ?? ?? ?? C6 00 ?? E8 ?? ?? ?? ?? 48 89 EF BE ?? ?? ?? ?? E8 ?? ?? ?? ??
            48 85 C0 48 89 C3 BF ?? ?? ?? ?? 74 ?? 0F B7 54 24 ?? 48 8B 7C 24 ?? 48 89 C1 BE ??
            ?? ?? ?? E8 ?? ?? ?? ?? 48 89 DF E8 ?? ?? ?? ?? 48 89 EF E8 ?? ?? ?? ?? BF ?? ?? ??
            ?? E8 ?? ?? ?? ?? 4C 89 E7 E8 ?? ?? ?? ?? 4C 89 F7 48 89 E6 B9 ?? ?? ?? ?? FC F3 A5
            48 83 C4 ?? 5B 5D 41 5C 41 5D 41 5E C3 BF ?? ?? ?? ?? E8 ?? ?? ?? ?? E9
        }

    condition:
        uint32(0) == 0x464C457F and
        (
            $setup_environment
        ) and
        (
            all of ($find_files_p*)
        ) and
        (
            all of ($encrypt_files_p*)
        ) and
        (
            $make_configuration
        )
}