rule Win32_Ransomware_Babuk : tc_detection malicious
{
    meta:

        author              = "ReversingLabs"

        source              = "ReversingLabs"
        status              = "RELEASED"
        sharing             = "TLP:WHITE"
        category            = "MALWARE"
        malware             = "BABUK"
        description         = "Yara rule that detects Babuk ransomware."

        tc_detection_type   = "Ransomware"
        tc_detection_name   = "Babuk"
        tc_detection_factor = 5

    strings:

        $find_files = {
            55 8B EC 81 EC ?? ?? ?? ?? A1 ?? ?? ?? ?? 33 C5 89 45 ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? 
            ?? 83 C4 ?? 89 85 ?? ?? ?? ?? 83 BD ?? ?? ?? ?? ?? 0F 84 ?? ?? ?? ?? 8B 45 ?? 50 8B 
            8D ?? ?? ?? ?? 51 FF 15 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 95 ?? ?? ?? ?? 52 FF 15 ?? ?? 
            ?? ?? 8D 85 ?? ?? ?? ?? 50 8B 8D ?? ?? ?? ?? 51 FF 15 ?? ?? ?? ?? 89 85 ?? ?? ?? ?? 
            83 BD ?? ?? ?? ?? ?? 0F 84 ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? EB ?? 8B 95 ?? 
            ?? ?? ?? 83 C2 ?? 89 95 ?? ?? ?? ?? 83 BD ?? ?? ?? ?? ?? 73 ?? 8B 85 ?? ?? ?? ?? 8B 
            0C 85 ?? ?? ?? ?? 51 8D 95 ?? ?? ?? ?? 52 FF 15 ?? ?? ?? ?? 85 C0 75 ?? E9 ?? ?? ?? 
            ?? E9 ?? ?? ?? ?? EB ?? 8B 45 ?? 50 8B 8D ?? ?? ?? ?? 51 FF 15 ?? ?? ?? ?? 68 ?? ?? 
            ?? ?? 8B 95 ?? ?? ?? ?? 52 FF 15 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 50 8B 8D ?? ?? ?? ?? 
            51 FF 15 ?? ?? ?? ?? 8B 95 ?? ?? ?? ?? 83 E2 ?? 74 ?? 83 7D ?? ?? 77 ?? 8B 45 ?? 83 
            C0 ?? 50 8B 8D ?? ?? ?? ?? 51 E8 ?? ?? ?? ?? 83 C4 ?? E9 ?? ?? ?? ?? 68 ?? ?? ?? ?? 
            8D 95 ?? ?? ?? ?? 52 FF 15 ?? ?? ?? ?? 85 C0 74 ?? 8D 85 ?? ?? ?? ?? 50 FF 15 ?? ?? 
            ?? ?? 89 85 ?? ?? ?? ?? EB ?? 8B 8D ?? ?? ?? ?? 83 E9 ?? 89 8D ?? ?? ?? ?? 83 BD ?? 
            ?? ?? ?? ?? 7C ?? 8B 95 ?? ?? ?? ?? 0F B7 84 55 ?? ?? ?? ?? 83 F8 ?? 75 ?? 68 ?? ?? 
            ?? ?? 8B 8D ?? ?? ?? ?? 8D 94 4D ?? ?? ?? ?? 52 FF 15 ?? ?? ?? ?? 85 C0 75 ?? EB ?? 
            EB ?? EB ?? EB ?? EB ?? 8B 85 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 8D 8D ?? ?? ?? 
            ?? 51 8B 95 ?? ?? ?? ?? 52 FF 15 ?? ?? ?? ?? 85 C0 0F 85 ?? ?? ?? ?? 8B 85 ?? ?? ?? 
            ?? 50 FF 15
        }

        $encrypt_files_p1 = {
            55 8B EC B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 33 C5 89 45 ?? C7 85 ?? ?? ?? 
            ?? ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 45 ?? 50 FF 15 ?? ?? ?? ?? 6A ?? 68 ?? ?? ?? ?? 6A 
            ?? 6A ?? 6A ?? 68 ?? ?? ?? ?? 8B 4D ?? 51 FF 15 ?? ?? ?? ?? 89 85 ?? ?? ?? ?? 83 BD 
            ?? ?? ?? ?? ?? 0F 84 ?? ?? ?? ?? 8D 95 ?? ?? ?? ?? 52 8B 85 ?? ?? ?? ?? 50 FF 15 ?? 
            ?? ?? ?? 6A ?? 6A ?? 6A ?? 6A ?? 6A ?? 8B 8D ?? ?? ?? ?? 51 FF 15 ?? ?? ?? ?? 89 85 
            ?? ?? ?? ?? 83 BD ?? ?? ?? ?? ?? 0F 84 ?? ?? ?? ?? 83 BD ?? ?? ?? ?? ?? 0F 8C ?? ?? 
            ?? ?? 7F ?? 81 BD ?? ?? ?? ?? ?? ?? ?? ?? 0F 86 ?? ?? ?? ?? 6A ?? 68 ?? ?? ?? ?? 8B 
            95 ?? ?? ?? ?? 52 8B 85 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 6A ?? 6A ?? 52 50 E8 ?? ?? ?? 
            ?? 89 85 ?? ?? ?? ?? 89 95 ?? ?? ?? ?? 0F 57 C0 66 0F 13 85 ?? ?? ?? ?? EB ?? 8B 8D 
            ?? ?? ?? ?? 83 C1 ?? 8B 95 ?? ?? ?? ?? 83 D2 ?? 89 8D ?? ?? ?? ?? 89 95 ?? ?? ?? ?? 
            83 BD ?? ?? ?? ?? ?? 0F 8F ?? ?? ?? ?? 7C ?? 83 BD ?? ?? ?? ?? ?? 0F 83 ?? ?? ?? ?? 
            8B 85 ?? ?? ?? ?? 50 8B 8D ?? ?? ?? ?? 51 8B 95 ?? ?? ?? ?? 52 8B 85 ?? ?? ?? ?? 50
        }

        $encrypt_files_p2 = {
            E8 ?? ?? ?? ?? 6A ?? 68 ?? ?? ?? ?? 52 50 E8 ?? ?? ?? ?? 89 85 ?? ?? ?? ?? 89 95 ?? 
            ?? ?? ?? 68 ?? ?? ?? ?? 8B 8D ?? ?? ?? ?? 51 8B 95 ?? ?? ?? ?? 52 68 ?? ?? ?? ?? 8B 
            85 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 89 85 ?? ?? ?? ?? 83 BD ?? ?? ?? ?? ?? 74 ?? 68 
            ?? ?? ?? ?? 8B 8D ?? ?? ?? ?? 51 8B 95 ?? ?? ?? ?? 52 68 ?? ?? ?? ?? 6A ?? 68 ?? ?? 
            ?? ?? E8 ?? ?? ?? ?? 83 C4 ?? 68 ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? 50 8B 8D ?? ?? ?? ?? 
            51 68 ?? ?? ?? ?? 6A ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 ?? 8B 95 ?? ?? ?? ?? 52 
            FF 15 ?? ?? ?? ?? E9 ?? ?? ?? ?? E9 ?? ?? ?? ?? 83 BD ?? ?? ?? ?? ?? 0F 8C ?? ?? ?? 
            ?? 7F ?? 83 BD ?? ?? ?? ?? ?? 0F 86 ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? 50 6A ?? 6A ?? 68 
            ?? ?? ?? ?? 8B 8D ?? ?? ?? ?? 51 FF 15 ?? ?? ?? ?? 89 85 ?? ?? ?? ?? 83 BD ?? ?? ?? 
            ?? ?? 74 ?? 8B 95 ?? ?? ?? ?? 52 8B 85 ?? ?? ?? ?? 50 8B 8D ?? ?? ?? ?? 51 68 ?? ?? 
            ?? ?? 6A ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 ?? 8B 95 ?? ?? ?? ?? 52 8B 85 ?? ?? 
            ?? ?? 50 8B 8D ?? ?? ?? ?? 51 68 ?? ?? ?? ?? 6A ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83
        }

        $encrypt_files_p3 = {
            C4 ?? 8B 95 ?? ?? ?? ?? 52 FF 15 ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 
            8B 8D ?? ?? ?? ?? 51 FF 15 ?? ?? ?? ?? 8B 95 ?? ?? ?? ?? 52 FF 15 ?? ?? ?? ?? 68 ?? 
            ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 ?? 89 85 ?? ?? ?? ?? 83 BD ?? ?? ?? ?? ?? 74 ?? 8B 45 
            ?? 50 8B 8D ?? ?? ?? ?? 51 FF 15 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 95 ?? ?? ?? ?? 52 FF 
            15 ?? ?? ?? ?? 6A ?? 8B 85 ?? ?? ?? ?? 50 8B 4D ?? 51 FF 15 ?? ?? ?? ?? 8B 95 ?? ?? 
            ?? ?? 52 E8 ?? ?? ?? ?? 83 C4 ?? E9 ?? ?? ?? ?? 83 BD ?? ?? ?? ?? ?? 0F 84 ?? ?? ?? 
            ?? 6A ?? 6A ?? 8D 45 ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 8D 4D ?? 51 6A ?? 8D 95 ?? ?? ?? 
            ?? 52 E8 ?? ?? ?? ?? 85 C0 0F 85 ?? ?? ?? ?? 6A ?? 6A ?? 6A ?? 6A ?? 8D 45 ?? 50 6A 
            ?? 8B 8D ?? ?? ?? ?? 51 E8 ?? ?? ?? ?? 85 C0 0F 85 ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? 
            ?? ?? ?? 8D 95 ?? ?? ?? ?? 52 8D 85 ?? ?? ?? ?? 50 8D 8D ?? ?? ?? ?? 51 8D 95 ?? ?? 
            ?? ?? 52 8B 85 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 85 C0 0F 85 ?? ?? ?? ?? C7 85 ?? ?? ?? 
            ?? ?? ?? ?? ?? EB ?? 8B 8D ?? ?? ?? ?? 83 C1 ?? 89 8D ?? ?? ?? ?? 8B 95 ?? ?? ?? ?? 
            3B 95 ?? ?? ?? ?? 0F 83 ?? ?? ?? ?? 69 85 ?? ?? ?? ?? ?? ?? ?? ?? 83 BC 05 ?? ?? ?? 
            ?? ?? 0F 84 ?? ?? ?? ?? 69 8D ?? ?? ?? ?? ?? ?? ?? ?? 81 BC 0D ?? ?? ?? ?? ?? ?? ?? 
            ?? 74 ?? FF 15 ?? ?? ?? ?? 69 95 ?? ?? ?? ?? ?? ?? ?? ?? 3B 84 15 ?? ?? ?? ?? 74 ?? 
            69 85 ?? ?? ?? ?? ?? ?? ?? ?? 8B 8C 05 ?? ?? ?? ?? 51 6A ?? 68 ?? ?? ?? ?? FF 15 ?? 
            ?? ?? ?? 89 85 ?? ?? ?? ?? 83 BD ?? ?? ?? ?? ?? 74 ?? 6A ?? 8B 95 ?? ?? ?? ?? 52 FF 
            15 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 8B 8D ?? ?? ?? 
            ?? 51 FF 15 ?? ?? ?? ?? E9 ?? ?? ?? ?? 8B 95 ?? ?? ?? ?? 52 E8 ?? ?? ?? ?? C7 85 ?? 
            ?? ?? ?? ?? ?? ?? ?? E9 ?? ?? ?? ?? 8B 4D ?? 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 
        }

        $enum_resources = {
            55 8B EC 83 EC ?? A1 ?? ?? ?? ?? 33 C5 89 45 ?? C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? 
            ?? ?? 8D 45 ?? 50 8B 4D ?? 51 6A ?? 6A ?? 6A ?? E8 ?? ?? ?? ?? 85 C0 0F 85 ?? ?? ?? 
            ?? 8B 55 ?? 52 E8 ?? ?? ?? ?? 83 C4 ?? 89 45 ?? 83 7D ?? ?? 0F 84 ?? ?? ?? ?? 8D 45 
            ?? 50 8B 4D ?? 51 8D 55 ?? 52 8B 45 ?? 50 E8 ?? ?? ?? ?? 85 C0 75 ?? C7 45 ?? ?? ?? 
            ?? ?? EB ?? 8B 4D ?? 83 C1 ?? 89 4D ?? 8B 55 ?? 3B 55 ?? 73 ?? 8B 45 ?? C1 E0 ?? 8B 
            4D ?? 8B 54 01 ?? 83 E2 ?? 74 ?? 8B 45 ?? C1 E0 ?? 03 45 ?? 50 E8 ?? ?? ?? ?? 83 C4 
            ?? EB ?? 6A ?? 8B 4D ?? C1 E1 ?? 8B 55 ?? 8B 44 0A ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? EB 
            ?? EB ?? 8B 4D ?? 51 E8 ?? ?? ?? ?? 83 C4 ?? 8B 55 ?? 52 E8 ?? ?? ?? ?? 8B 4D ?? 33 
            CD E8 ?? ?? ?? ?? 8B E5 5D C3 
        }

    condition:
        uint16(0) == 0x5A4D and
        (
            $find_files
        ) and
        (
            all of ($encrypt_files_p*)
        ) and
        (
            $enum_resources
        )
}