rule Win32_Ransomware_ChiChi : tc_detection malicious
{
    meta:

        author              = "ReversingLabs"

        source              = "ReversingLabs"
        status              = "RELEASED"
        sharing             = "TLP:WHITE"
        category            = "MALWARE"
        malware             = "CHICHI"
        description         = "Yara rule that detects ChiChi ransomware."

        tc_detection_type   = "Ransomware"
        tc_detection_name   = "ChiChi"
        tc_detection_factor = 5

    strings:

        $generate_key = {
            55 8B EC 6A ?? 68 ?? ?? ?? ?? 64 A1 ?? ?? ?? ?? 50 83 EC ?? 53 56 57 A1 ?? ?? ?? ??
            33 C5 50 8D 45 ?? 64 A3 ?? ?? ?? ?? 8B D9 8B 7D ?? C7 45 ?? ?? ?? ?? ?? 89 7D ?? 85
            FF 75 ?? 33 F6 EB ?? 57 E8 ?? ?? ?? ?? 83 C4 ?? 8B F0 89 75 ?? 6A ?? 8D 4D ?? C7 45
            ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 4D ?? C7 45 ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? 57 56 8D
            4D ?? C6 45 ?? ?? E8 ?? ?? ?? ?? 8B 45 ?? C6 45 ?? ?? C7 45 ?? ?? ?? ?? ?? 85 C0 74
            ?? 6A ?? 50 FF 15 ?? ?? ?? ?? 8B 03 8B CB 57 56 FF 50 ?? C7 45 ?? ?? ?? ?? ?? 85 F6
            74 ?? 83 FF ?? 8D 45 ?? 8D 4D ?? 8B FE 0F 46 C8 32 C0 56 8B 09 F3 AA E8 ?? ?? ?? ??
            83 C4 ?? 8B 4D ?? 64 89 0D ?? ?? ?? ?? 59 5F 5E 5B 8B E5 5D C2
        }

        $encrypt_files = {
            55 8B EC 51 53 56 57 8B D9 68 ?? ?? ?? ?? 53 89 5D ?? FF 15 ?? ?? ?? ?? 8B 35 ?? ??
            ?? ?? 53 FF D6 68 ?? ?? ?? ?? 8B F8 FF D6 8B 1D ?? ?? ?? ?? 03 F8 03 FF 83 C7 ?? 57
            6A ?? FF 35 ?? ?? ?? ?? FF D3 8B F0 85 F6 74 ?? 8B 7D ?? 57 56 FF 15 ?? ?? ?? ?? 68
            ?? ?? ?? ?? 56 FF 15 ?? ?? ?? ?? 6A ?? 56 57 FF 15 ?? ?? ?? ?? 85 C0 75 ?? 5F 5E 5B
            8B E5 5D C3 6A ?? 68 ?? ?? ?? ?? 6A ?? 6A ?? 6A ?? 68 ?? ?? ?? ?? 56 FF 15 ?? ?? ??
            ?? 56 6A ?? FF 35 ?? ?? ?? ?? 8B F8 FF 15 ?? ?? ?? ?? 83 FF ?? 74 ?? 8B CF E8 ?? ??
            ?? ?? 5F 5E 5B 8B E5 5D C3 5F 5E B8 ?? ?? ?? ?? 5B 8B E5 5D C3
        }

        $find_files = {
            6A ?? 8D 44 24 ?? 50 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 50 68 ?? ?? ?? ?? 56 FF 15 ??
            ?? ?? ?? 56 FF 15 ?? ?? ?? ?? FF 74 24 ?? 53 FF 15 ?? ?? ?? ?? 68 ?? ?? ?? ?? 53 FF
            D7 8D 44 24 ?? 50 53 FF 15 ?? ?? ?? ?? 8B 1D ?? ?? ?? ?? 89 44 24 ?? 83 F8 ?? 0F 84
            ?? ?? ?? ?? 8B 3D ?? ?? ?? ?? 33 F6 FF B6 ?? ?? ?? ?? 8D 44 24 ?? 50 FF 15 ?? ?? ??
            ?? 85 C0 0F 84 ?? ?? ?? ?? 83 C6 ?? 81 FE ?? ?? ?? ?? 72 ?? FF 74 24 ?? 8B 74 24 ??
            56 FF 15 ?? ?? ?? ?? 68 ?? ?? ?? ?? 56 FF 15 ?? ?? ?? ?? 8D 44 24 ?? 50 56 FF 15 ??
            ?? ?? ?? F6 44 24 ?? ?? 0F 85 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 44 24 ?? 50 FF 15 ?? ??
            ?? ?? 85 C0 0F 84 ?? ?? ?? ?? 8D 44 24 ?? 50 FF 15 ?? ?? ?? ?? 83 E8 ?? 78 ?? 66 83
            7C 44 ?? ?? 74 ?? 83 E8 ?? 79 ?? EB ?? 8D 74 24 ?? 8D 34 46 68 ?? ?? ?? ?? 56 FF 15
            ?? ?? ?? ?? 85 C0 0F 84 ?? ?? ?? ?? 68 ?? ?? ?? ?? 56 FF 15 ?? ?? ?? ?? 85 C0 0F 84
            ?? ?? ?? ?? 68 ?? ?? ?? ?? 56 FF 15 ?? ?? ?? ?? 85 C0 0F 84
        }

    condition:
        uint16(0) == 0x5A4D and
        (
            $find_files
        ) and
        (
            $generate_key
        ) and
        (
            $encrypt_files
        )
}