rule Win32_Ransomware_Crysis : tc_detection malicious
{
    meta:

        author              = "ReversingLabs"

        source              = "ReversingLabs"
        status              = "RELEASED"
        sharing             = "TLP:WHITE"
        category            = "MALWARE"
        malware             = "CRYSIS"
        description         = "Yara rule that detects Crysis ransomware."

        tc_detection_type   = "Ransomware"
        tc_detection_name   = "Crysis"
        tc_detection_factor = 5

    strings:

        $remote_connection_1 = {
            55 8B EC 83 EC ?? C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? C6 45 ?? ?? 6A ?? 6A ?? 
            6A ?? FF 15 ?? ?? ?? ?? 89 45 ?? 6A ?? 6A ?? 8D 45 ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? B9 
            ?? ?? ?? ?? 66 89 4D ?? 6A ?? FF 15 ?? ?? ?? ?? 66 89 45 ?? 8B 55 ?? 52 FF 15 ?? ?? 
            ?? ?? 89 45 ?? 83 7D ?? ?? 0F 84 ?? ?? ?? ?? 83 7D ?? ?? 0F 84 ?? ?? ?? ?? C7 45 ?? 
            ?? ?? ?? ?? EB ?? 8B 45 ?? 83 C0 ?? 89 45 ?? 8B 4D ?? 8B 51 ?? 8B 45 ?? 83 3C 82 ?? 
            74 ?? 8B 4D ?? 0F BF 51 ?? 52 8B 45 ?? 8B 48 ?? 8B 55 ?? 8B 04 91 50 8D 4D ?? 51 E8 
            ?? ?? ?? ?? 83 C4 ?? 6A ?? 8D 55 ?? 52 8B 45 ?? 50 FF 15 ?? ?? ?? ?? 85 C0 75 ?? 6A 
            ?? 8B 4D ?? 51 FF 15 ?? ?? ?? ?? 50 8B 55 ?? 52 8B 45 ?? 50 FF 15 ?? ?? ?? ?? 6A ?? 
            6A ?? 8D 4D ?? 51 8B 55 ?? 52 FF 15 ?? ?? ?? ?? 8B 45 ?? 50 FF 15 ?? ?? ?? ?? C7 45 
            ?? ?? ?? ?? ?? EB ?? E9 ?? ?? ?? ?? 8B 45 ?? 8B E5 5D C3 
        }

        $enumerate_files = {
            55 8B EC 83 E4 ?? 81 EC ?? ?? ?? ?? 53 33 DB 81 7D ?? ?? ?? ?? ?? 56 57 89 5C 24 ?? 
            0F 8D ?? ?? ?? ?? 68 ?? ?? ?? ?? 53 FF 15 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 8B 7D ?? 
            57 8B F0 FF 15 ?? ?? ?? ?? 3D ?? ?? ?? ?? 0F 8D ?? ?? ?? ?? 68 ?? ?? ?? ?? 57 6A ?? 
            68 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 83 C4 ?? 85 C0 0F 8E ?? ?? ?? ?? 8D 44 24 ?? 50 56 
            FF 15 ?? ?? ?? ?? 89 44 24 ?? 83 F8 ?? 0F 84 ?? ?? ?? ?? 8B 5D ?? 8D 4C 24 ?? 51 68 
            ?? ?? ?? ?? 57 6A ?? 68 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 83 C4 ?? 85 C0 7E ?? F6 44 24 
            ?? ?? 74 ?? 66 83 7C 24 ?? ?? 74 ?? 53 8D 54 24 ?? 52 8B D6 8B CF FF 55 ?? 85 C0 7E 
            ?? 8B 45 ?? 8B 4D ?? 40 50 53 51 56 E8 ?? ?? ?? ?? 83 C4 ?? EB ?? 53 8D 54 24 ?? 52 
            8B D6 8B CF FF 55 ?? 85 C0 7E ?? FF 44 24 ?? 8B 4C 24 ?? 8D 44 24 ?? 50 51 FF 15 ?? 
            ?? ?? ?? 85 C0 7F ?? 8B 54 24 ?? 52 FF 15 ?? ?? ?? ?? 8B 5C 24 ?? 56 6A ?? FF 15 ?? 
            ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 5F 5E 8B C3 5B 8B E5 5D C3 
        }

        $enumerate_resources = {
            FF 15 ?? ?? ?? ?? 85 C0 0F 85 ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? 
            8D 55 ?? 52 8B 45 ?? 50 8D 4D ?? 51 8B 55 ?? 52 FF 15 ?? ?? ?? ?? 85 C0 0F 85 ?? ?? 
            ?? ?? C7 45 ?? ?? ?? ?? ?? EB ?? 8B 45 ?? 83 C0 ?? 89 45 ?? 8B 4D ?? 3B 4D ?? 0F 83 
            ?? ?? ?? ?? 8B 55 ?? C1 E2 ?? 8B 45 ?? 83 7C 10 ?? ?? 75 ?? 8B 4D ?? 51 FF 15 ?? ?? 
            ?? ?? 8B 55 ?? C1 E2 ?? 8B 4D ?? 8B 75 ?? 8B 54 16 ?? E8 ?? ?? ?? ?? 85 C0 74 ?? 8B 
            45 ?? 50 8B 4D ?? 51 8B 55 ?? C1 E2 ?? 8B 45 ?? 8B 4C 10 ?? 51 E8 ?? ?? ?? ?? 83 C4 
            ?? 8B 55 ?? C1 E2 ?? 8B 45 ?? 8B 4C 10 ?? 83 E1 ?? 74 ?? 8B 55 ?? 52 8B 45 ?? 50 8B 
            4D ?? 51 8B 55 ?? C1 E2 ?? 03 55 ?? 52 E8 ?? ?? ?? ?? 83 C4 ?? E9 ?? ?? ?? ?? C7 45 
            ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? E9 ?? ?? ?? ?? 8B 45 ?? 50 FF 15 ?? ?? ?? ?? 8D 
            4D ?? 51 8B 55 ?? 52 6A ?? 6A ?? 6A ?? FF 15 ?? ?? ?? ?? 85 C0 0F 85 ?? ?? ?? ?? C7 
            45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? 8D 45 ?? 50 8B 4D ?? 51 8D 55 ?? 52 8B 45 ?? 
            50 FF 15 ?? ?? ?? ?? 85 C0 0F 85 ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? EB ?? 8B 4D ?? 83 
            C1 ?? 89 4D ?? 8B 55 ?? 3B 55 ?? 0F 83 ?? ?? ?? ?? 8B 45 ?? C1 E0 ?? 8B 4D ?? 83 7C 
            01 ?? ?? 75 ?? 8B 55 ?? 52 FF 15 ?? ?? ?? ?? 8B 55 ?? C1 E2 ?? 8B 4D ?? 8B 75 ?? 8B 
            54 16 ?? E8 ?? ?? ?? ?? 85 C0 74 ?? 8B 45 ?? 50 8B 4D ?? 51 8B 55 ?? C1 E2 ?? 8B 45 
            ?? 8B 4C 10 ?? 51 E8 ?? ?? ?? ?? 83 C4 ?? 8B 55 ?? C1 E2 ?? 8B 45 ?? 8B 4C 10 ?? 83 
            E1 ?? 74 ?? 8B 55 ?? 52 8B 45 ?? 50 8B 4D ?? 51 8B 55 ?? C1 E2 ?? 03 55 ?? 52 E8 ?? 
            ?? ?? ?? 83 C4 ?? E9 ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? E9 ?? ?? 
            ?? ?? 8B 45 ?? 50 FF 15 ?? ?? ?? ?? 5E 8B E5 5D C3 
        }

        $encrypt_files = {
            55 8B EC 81 EC ?? ?? ?? ?? 53 8B D8 33 C0 56 89 45 ?? 89 45 ?? 89 45 ?? 89 45 ?? 8B 
            45 ?? 6A ?? 50 8D 4D ?? 51 8D 77 ?? C7 45 ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 ?? 8B 
            D3 83 E2 ?? 2B DA 83 EB ?? 83 C4 ?? 89 5D ?? 8B 1D ?? ?? ?? ?? 50 FF D3 89 45 ?? 83 
            F8 ?? 0F 84 ?? ?? ?? ?? 8B 4D ?? 51 FF D3 83 F8 ?? 0F 85 ?? ?? ?? ?? 8B 55 ?? 81 C2 
            ?? ?? ?? ?? 81 FA ?? ?? ?? ?? 0F 83 ?? ?? ?? ?? 8B 45 ?? A8 ?? 74 ?? 83 E0 ?? 50 8B 
            45 ?? 50 FF 15 ?? ?? ?? ?? 8B 4D ?? 6A ?? 6A ?? 6A ?? 6A ?? 6A ?? 68 ?? ?? ?? ?? 51 
            FF 15 ?? ?? ?? ?? 8B D8 89 5D ?? 83 FB ?? 0F 84 ?? ?? ?? ?? 6A ?? 8D 55 ?? 52 33 C0 
            33 C9 51 50 53 89 45 ?? 89 45 ?? FF 15 ?? ?? ?? ?? 85 C0 0F 84 ?? ?? ?? ?? 83 7D ?? 
            ?? 75 ?? 83 7D ?? ?? 0F 84 ?? ?? ?? ?? 33 C9 51 8D 55 ?? 52 33 C0 50 51 53 FF 15 ?? 
            ?? ?? ?? 8B 45 ?? 6A ?? 6A ?? 6A ?? 6A ?? 6A ?? 68 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 
            8B D8 83 FB ?? 0F 84 ?? ?? ?? ?? 8B 55 ?? 8B 4D ?? 8D 85 ?? ?? ?? ?? E8 ?? ?? ?? ?? 
            8B 55 ?? 8B 45 ?? 6A ?? 8D 4D ?? 51 52 57 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 ?? ?? ?? 
            ?? 8B 4D ?? 85 C9 74 ?? 8B 45 ?? 85 C0 75 ?? 3B 4D ?? 73 ?? 8B D1 83 E2 ?? B8 ?? ?? 
            ?? ?? 2B C2 89 45 ?? 57 03 C1 8D 8D ?? ?? ?? ?? 57 51 E8 ?? ?? ?? ?? 8B 4D ?? 03 4D 
            ?? 83 C4 ?? 6A ?? 8D 55 ?? 52 51 57 53 FF 15 ?? ?? ?? ?? 85 C0 0F 84 ?? ?? ?? ?? 8B 
            45 ?? 03 45 ?? 39 45 ?? 0F 85 ?? ?? ?? ?? 8B 55 ?? 8B 45 ?? 6A ?? 8D 4D ?? 51 52 57 
            50 FF 15 ?? ?? ?? ?? 85 C0 75 ?? E9 ?? ?? ?? ?? 6A ?? 6A ?? 57 E8 ?? ?? ?? ?? 8B 45 
            ?? 83 C4 ?? C7 47 ?? ?? ?? ?? ?? C7 47 ?? ?? ?? ?? ?? 85 C0 74 ?? 8B 4D ?? 51 50 56 
            C7 47 ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 ?? 83 C4 ?? 03 F0 01 45 ?? 8B 55 ?? 6A ?? 
            52 56 E8 ?? ?? ?? ?? 8B 45 ?? 6A ?? 50 83 C6 ?? 56 E8 ?? ?? ?? ?? 6A ?? 8D 4D ?? 51 
            83 C6 ?? 56 E8 ?? ?? ?? ?? 6A ?? 8D 55 ?? 52 83 C6 ?? 56 E8 ?? ?? ?? ?? 8B 45 ?? 68 
            ?? ?? ?? ?? 50 83 C6 ?? 56 E8 ?? ?? ?? ?? 6A ?? 8D 4D ?? 51 83 EE ?? 56 E8 ?? ?? ?? 
            ?? 83 C4 ?? 6A ?? 8D 55 ?? 52 83 C6 ?? 2B F7 56 57 53 FF 15 ?? ?? ?? ?? 85 C0 74 ?? 
            39 75 ?? 75 ?? 53 FF 15 ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? 53 FF 15 ?? ?? ?? ?? 83 7D 
            ?? ?? 7E ?? 8B 75 ?? 33 C9 51 8D 55 ?? 52 33 C0 50 51 56 FF 15 ?? ?? ?? ?? 56 FF 15 
            ?? ?? ?? ?? 8B 5D ?? 53 FF 15 ?? ?? ?? ?? 83 7D ?? ?? 7E ?? 8B 45 ?? 8B 4D ?? 50 51 
            FF 15 ?? ?? ?? ?? 8B 55 ?? 52 FF 15 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 6A 
            ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 8B 45 ?? 5E 5B 8B E5 5D C3 
        }

    condition:
        uint16(0) == 0x5A4D and
        (
            $enumerate_resources and
            $enumerate_files and
            $encrypt_files and
            $remote_connection_1
        )
}