rule Win32_Ransomware_DearCry : tc_detection malicious
{
    meta:

        author              = "ReversingLabs"

        source              = "ReversingLabs"
        status              = "RELEASED"
        sharing             = "TLP:WHITE"
        category            = "MALWARE"
        malware             = "DEARCRY"
        description         = "Yara rule that detects DearCry ransomware."

        tc_detection_type   = "Ransomware"
        tc_detection_name   = "DearCry"
        tc_detection_factor = 5

    strings:

        $drop_ransom_note_p1 = {
            55 8B EC 83 E4 ?? 81 EC ?? ?? ?? ?? A1 ?? ?? ?? ?? 33 C4 89 84 24 ?? ?? ?? ?? A1 ?? 
            ?? ?? ?? 53 56 57 33 DB 68 ?? ?? ?? ?? 50 C7 05 ?? ?? ?? ?? ?? ?? ?? ?? 89 1D ?? ?? 
            ?? ?? 89 1D ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? 89 1D ?? ?? ?? ?? FF 15 ?? ?? 
            ?? ?? E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 6A ?? 68 ?? ?? ?? ?? 89 44 24 ?? E8 
            ?? ?? ?? ?? 8B F0 6A ?? 68 ?? ?? ?? ?? 89 74 24 ?? E8 ?? ?? ?? ?? 8B F8 89 7C 24 ?? 
            E8 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 51 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 
            ?? ?? ?? ?? 83 C4 ?? 3B F3 0F 84 ?? ?? ?? ?? 3B FB 0F 84 ?? ?? ?? ?? 68 ?? ?? ?? ?? 
            6A ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 ?? 89 5C 24 ?? B8 ?? ?? ?? ?? 33 F6 8B FF 
            38 18 74 ?? 50 E8 ?? ?? ?? ?? 8D BE ?? ?? ?? ?? 83 C4 ?? 8B D7 8A 08 88 0A 40 42 84 
            C9 75 ?? 8B C7 33 F6 8D 50 ?? 8A 08 40 84 C9 75 ?? 2B C2 74 ?? 0F BE 14 37 52 E8 ?? 
            ?? ?? ?? 88 04 37 8B C7 83 C4 ?? 46 8D 50 ?? 8A 08 40 84 C9 75 ?? 2B C2 3B F0 72 ?? 
            8B 74 24 ?? 46 89 74 24 ?? 69 F6 ?? ?? ?? ?? 8D 86 ?? ?? ?? ?? 3B C3 75 ?? 6A ?? 68 
        }

        $drop_ransom_note_p2 = {
            89 5C 24 ?? E8 ?? ?? ?? ?? 53 8B F0 53 8D 44 24 ?? 50 56 E8 ?? ?? ?? ?? 56 89 44 24 
            ?? E8 ?? ?? ?? ?? 8B 44 24 ?? 83 C4 ?? 8B F8 3B C3 0F 84 ?? ?? ?? ?? FF 15 ?? ?? ?? 
            ?? 85 C0 0F 86 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 4C 24 ?? 53 51 88 5C 24 ?? E8 ?? ?? ?? 
            ?? 83 C4 ?? 8D 54 24 ?? 52 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 85 C0 0F 84 ?? ?? ?? ?? 
            8A 44 1C ?? 3C ?? 7C ?? 3C ?? 7E ?? 3C ?? 0F 8C ?? ?? ?? ?? 3C ?? 0F 8F ?? ?? ?? ?? 
            0F BE C0 50 8D 4C 24 ?? 68 ?? ?? ?? ?? 51 E8 ?? ?? ?? ?? 8B 35 ?? ?? ?? ?? 83 C4 ?? 
            8D 54 24 ?? 52 FF D6 83 F8 ?? 0F 84 ?? ?? ?? ?? 8D 44 24 ?? 50 FF D6 85 C0 74 ?? 8B 
            4C 24 ?? 8B 54 24 ?? 8B 44 24 ?? 51 52 50 6A ?? 8D 4C 24 ?? 51 57 E8 ?? ?? ?? ?? 0F 
            BE 54 1C ?? 68 ?? ?? ?? ?? 52 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 68 ?? ?? 
            ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 83 C4 ?? 85 F6 74 ?? B8 ?? ?? ?? ?? 8D 50 
            ?? 8D 49 ?? 8A 08 40 84 C9 75 ?? 56 2B C2 50 6A ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 56 
            E8 ?? ?? ?? ?? 83 C4 ?? 43 81 FB ?? ?? ?? ?? 0F 8C ?? ?? ?? ?? 33 DB 57
        }

        $find_files_p1 = {
            55 8B EC 6A ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 ?? ?? ?? ?? 50 83 EC ?? B8 ?? ?? 
            ?? ?? E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 31 45 ?? 33 C5 89 45 ?? 53 56 57 50 8D 45 ?? 64 
            A3 ?? ?? ?? ?? 89 65 ?? 8B 45 ?? 89 85 ?? ?? ?? ?? 8B 75 ?? 89 B5 ?? ?? ?? ?? 8B 4D 
            ?? 89 8D ?? ?? ?? ?? 8B 55 ?? 89 95 ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? 68 ?? 
            ?? ?? ?? 6A ?? 8D 85 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? C6 85 ?? ?? ?? ?? ?? 68 
            ?? ?? ?? ?? 6A ?? 8D 8D ?? ?? ?? ?? 51 E8 ?? ?? ?? ?? 83 C4 ?? C6 85 ?? ?? ?? ?? ?? 
            8B C6 8D 50 ?? 8D 49 ?? 8A 08 40 84 C9 75 ?? 2B C2 80 7C 06 ?? ?? 74 ?? 8B C6 8D 50 
            ?? 8A 08 40 84 C9 75 ?? 2B C2 80 7C 06 ?? ?? 74 ?? 68 ?? ?? ?? ?? 56 68 ?? ?? ?? ?? 
            8D 95 ?? ?? ?? ?? 52 EB ?? 68 ?? ?? ?? ?? 56 68 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 50 E8 
            ?? ?? ?? ?? 83 C4 ?? 8D 8D ?? ?? ?? ?? 51 8D 95 ?? ?? ?? ?? 52 FF 15 ?? ?? ?? ?? 89 
            85 ?? ?? ?? ?? 83 F8 ?? 0F 84 ?? ?? ?? ?? F6 85 ?? ?? ?? ?? ?? 0F 85 ?? ?? ?? ?? 6A 
            ?? 8D 85 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 8B D8 85 DB 0F 84 ?? ?? ?? ?? 8B C6 
            8D 50 ?? 8A 08 40 84 C9 75 ?? 2B C2 8B D0 8D 85 ?? ?? ?? ?? 8D 78 ?? 8A 08 40 84 C9 
            75 ?? 2B C7 03 C2 3D ?? ?? ?? ?? 0F 83 ?? ?? ?? ?? 6A ?? 6A ?? 8D 4D ?? 51 E8 ?? ?? 
            ?? ?? 83 C4 ?? 8B C3 8D 50 ?? 8A 08 40 84 C9 75 ?? 2B C2 83 F8 ?? 76 ?? B8 ?? ?? ?? 
            ?? EB ?? 8B C3 8D 50 ?? 8D 64 24 ?? 8A 08 40 84 C9 75 ?? 2B C2 50 53 8D 55 ?? 52 E8
        }

        $find_files_p2 = {
            83 C4 ?? 33 FF 8D 45 ?? 8D 50 ?? 90 8A 08 40 84 C9 75 ?? 2B C2 74 ?? EB ?? 8D 49 ?? 
            0F BE 44 3D ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 88 44 3D ?? 47 8D 45 ?? 8D 50 ?? 8D A4 24 
            ?? ?? ?? ?? 8A 08 40 84 C9 75 ?? 2B C2 3B F8 72 ?? 8D 4D ?? 51 68 ?? ?? ?? ?? E8 ?? 
            ?? ?? ?? 83 C4 ?? 85 C0 0F 84 ?? ?? ?? ?? B9 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 8A 10 3A 
            11 75 ?? 84 D2 74 ?? 8A 50 ?? 3A 51 ?? 75 ?? 83 C0 ?? 83 C1 ?? 84 D2 75 ?? 33 C0 EB 
            ?? 1B C0 83 D8 ?? 85 C0 0F 84 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A ?? 8D 95 ?? ?? ?? ?? 52 
            E8 ?? ?? ?? ?? 83 C4 ?? 8B C6 8D 50 ?? 8D A4 24 ?? ?? ?? ?? 8A 08 40 84 C9 75 ?? 2B 
            C2 80 7C 30 ?? ?? 74 ?? 8B C6 8D 50 ?? 8A 08 40 84 C9 75 ?? 2B C2 80 7C 30 ?? ?? 74 
            ?? 8D 85 ?? ?? ?? ?? 50 56 68 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? 51 EB ?? 8D 95 ?? ?? ?? 
            ?? 52 56 68 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? C7 45 ?? ?? ?? 
            ?? ?? 68 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? 51 E8 ?? ?? ?? ?? 83 C4 ?? 85 C0 74 ?? 50 E8 
            ?? ?? ?? ?? 83 C4 ?? 68 ?? ?? ?? ?? 6A ?? 8B BD ?? ?? ?? ?? 57 E8 ?? ?? ?? ?? 83 C4 
            ?? 68 ?? ?? ?? ?? 6A ?? 8B 9D ?? ?? ?? ?? 53 E8 ?? ?? ?? ?? 83 C4 ?? 53 57 8B 55 ?? 
            52 8D BD ?? ?? ?? ?? 8B 9D ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 ?? C7 45 ?? ?? ?? ?? ?? 
            E9 ?? ?? ?? ?? B8 ?? ?? ?? ?? C3 8B 65 ?? C7 45 ?? ?? ?? ?? ?? 8B B5 ?? ?? ?? ?? E9 
            ?? ?? ?? ?? 80 BD ?? ?? ?? ?? ?? 0F 84 ?? ?? ?? ?? 8B C6 8D 50 ?? 8B FF
        }

    condition:
        uint16(0) == 0x5A4D and
        (
            all of ($drop_ransom_note_p*)
        ) and
        (
            all of ($find_files_p*)
        )
}