rule Win32_Ransomware_FenixLocker : tc_detection malicious
{
    meta:

        author              = "ReversingLabs"

        source              = "ReversingLabs"
        status              = "RELEASED"
        sharing             = "TLP:WHITE"
        category            = "MALWARE"
        malware             = "FENIXLOCKER"
        description         = "Yara rule that detects FenixLocker ransomware."

        tc_detection_type   = "Ransomware"
        tc_detection_name   = "FenixLocker"
        tc_detection_factor = 5

    strings:

        $encrypt_files_1 = {
            55 8B EC B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 33 C5 89 45 ?? 56 68 ?? ?? ?? 
            ?? 8D 85 ?? ?? ?? ?? 89 95 ?? ?? ?? ?? 68 ?? ?? ?? ?? 50 8B F1 E8 ?? ?? ?? ?? 83 C4 
            ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? C7 
            85 ?? ?? ?? ?? ?? ?? ?? ?? 6A ?? 6A ?? 50 8D 85 ?? ?? ?? ?? 50 6A ?? 6A ?? 8D 85 ?? 
            ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 85 C0 75 ?? FF 15 ?? ?? ?? ?? 50 68 ?? ?? ?? ?? 6A ?? 
            E8 ?? ?? ?? ?? 83 C4 ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 33 C0 5E 8B 4D ?? 33 CD E8 ?? ?? 
            ?? ?? 8B E5 5D C3 8D 85 ?? ?? ?? ?? 50 8D 85 ?? ?? ?? ?? 50 6A ?? 68 ?? ?? ?? ?? FF 
            B5 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 50 6A ?? 6A ?? FF 15 ?? ?? ?? ?? 85 C0 75 ?? FF 15 
            ?? ?? ?? ?? 50 68 ?? ?? ?? ?? EB ?? 68 ?? ?? ?? ?? 6A ?? 6A ?? 6A ?? 8D 85 ?? ?? ?? 
            ?? 50 FF 15 ?? ?? ?? ?? 85 C0 75 ?? FF 15 ?? ?? ?? ?? 50 68 ?? ?? ?? ?? E8 ?? ?? ?? 
            ?? 83 C4 ?? 33 C0 5E 8B 4D ?? 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 8D 85 ?? ?? ?? ?? 50 
            FF B5 ?? ?? ?? ?? 6A ?? FF B5 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 85 C0 75 ?? FF 15 ?? ?? 
            ?? ?? 50 68 ?? ?? ?? ?? E9 ?? ?? ?? ?? 8B 46 ?? 50 89 85 ?? ?? ?? ?? 89 85 ?? ?? ?? 
            ?? 8D 85 ?? ?? ?? ?? 50 6A ?? 6A ?? 6A ?? 6A ?? FF B5 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 
            85 C0 0F 84 ?? ?? ?? ?? 57 FF B5 ?? ?? ?? ?? E8 ?? ?? ?? ?? FF B5 ?? ?? ?? ?? 8B F8 
            6A ?? 57 E8 ?? ?? ?? ?? 83 C4 ?? 83 7E ?? ?? 72 ?? 8B 36 FF B5 ?? ?? ?? ?? 56 57 E8 
            ?? ?? ?? ?? 83 C4 ?? 8D 85 ?? ?? ?? ?? FF B5 ?? ?? ?? ?? 50 57 6A ?? 6A ?? 6A ?? FF 
            B5 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 85 C0 75 ?? 5F 5E 8B 4D ?? 33 CD E8 ?? ?? ?? ?? 8B 
            E5 5D C3 8B 8D ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? 89 01 8B C7 8B 4D ?? 5F 33 CD 5E E8 ?? 
            ?? ?? ?? 8B E5 5D C3 
        }

        $encrypt_files_2 = {
            B9 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 8A 10 3A 11 75 ?? 84 D2 74 ?? 8A 50 ?? 3A 51 ?? 75 
            ?? 83 C0 ?? 83 C1 ?? 84 D2 75 ?? 33 C0 EB ?? 1B C0 83 C8 ?? 85 C0 0F 84 ?? ?? ?? ?? 
            F6 85 ?? ?? ?? ?? ?? 8D 55 ?? 68 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? 0F 84 ?? ?? ?? ?? E8 
            ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? C6 45 ?? ?? 51 8B D0 8D 4D ?? E8 ?? ?? ?? ?? 83 C4 ?? 
            8B F8 C6 45 ?? ?? 8B 4D ?? 8B 55 ?? 41 3B D1 77 ?? 51 8D 4D ?? E8 ?? ?? ?? ?? 8B 55 
            ?? 8B 4D ?? 4A 8B 45 ?? 23 CA 03 C1 89 4D ?? 8B 4D ?? 23 D0 83 3C 91 ?? 8D 34 95 ?? 
            ?? ?? ?? 75 ?? 6A ?? E8 ?? ?? ?? ?? 8B 4D ?? 83 C4 ?? 89 04 31 8B 4D ?? 8B 0C 31 85 
            C9 74 ?? 57 E8 ?? ?? ?? ?? FF 45 ?? C6 45 ?? ?? 8B 45 ?? 83 F8 ?? 72 ?? 8B 4D ?? 40 
            3D ?? ?? ?? ?? 72 ?? F6 C1 ?? 0F 85 ?? ?? ?? ?? 8B 41 ?? 3B C1 0F 83 ?? ?? ?? ?? 2B 
            C8 83 F9 ?? 0F 82 ?? ?? ?? ?? 83 F9 ?? 0F 87 ?? ?? ?? ?? 8B C8 51 E8 ?? ?? ?? ?? 83 
            C4 ?? C6 45 ?? ?? 8B 85 ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? C6 45 
            ?? ?? 83 F8 ?? 72 ?? 8B 8D ?? ?? ?? ?? 40 3D ?? ?? ?? ?? 72 ?? F6 C1 ?? 0F 85 ?? ?? 
            ?? ?? 8B 41 ?? 3B C1 0F 83 ?? ?? ?? ?? 2B C8 83 F9 ?? 0F 82 ?? ?? ?? ?? 83 F9 ?? 0F 
            87 ?? ?? ?? ?? 8B C8 51 E8 ?? ?? ?? ?? 83 C4 ?? 8B BD ?? ?? ?? ?? 8B B5 ?? ?? ?? ?? 
            8D 85 ?? ?? ?? ?? 50 57 FF 15 ?? ?? ?? ?? 85 C0 0F 85 ?? ?? ?? ?? 85 F6 0F 8E ?? ?? 
            ?? ?? 68 ?? ?? ?? ?? 50 8D 85 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 55 ?? 
            8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 ?? C6 45 ?? ?? 8D 8D ?? ?? ?? ?? 50 E8 ?? ?? 
            ?? ?? C6 45 ?? ?? 8B 85 ?? ?? ?? ?? 83 F8 ?? 72 ?? 8B 8D ?? ?? ?? ?? 40 3D ?? ?? ?? 
            ?? 72 ?? F6 C1 ?? 0F 85 ?? ?? ?? ?? 8B 41 ?? 3B C1 0F 83 ?? ?? ?? ?? 2B C8 83 F9 ?? 
            0F 82 ?? ?? ?? ?? 83 F9 ?? 0F 87 ?? ?? ?? ?? 8B C8 51 E8 ?? ?? ?? ?? 83 C4 ?? 8B 85 
            ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? C6 85 ?? ?? 
            ?? ?? ?? 8B 40 ?? F6 84 05 ?? ?? ?? ?? ?? 0F 85 ?? ?? ?? ?? 8D 45 ?? 50 E8 ?? ?? ?? 
            ?? 8B D0 C6 45 ?? ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? C6 45 ?? ?? 8B 45 ?? 83 F8 ?? 
            72 ?? 8B 4D ?? 40 3D ?? ?? ?? ?? 72 ?? F6 C1 ?? 0F 85 ?? ?? ?? ?? 8B 41 ?? 3B C1 0F 
            83 ?? ?? ?? ?? 2B C8 83 F9 ?? 0F 82 ?? ?? ?? ?? 83 F9 ?? 0F 87 ?? ?? ?? ?? 8B C8 51 
            E8 ?? ?? ?? ?? 83 C4 ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 75 ?? 8B 85 ?? ?? ?? 
            ?? 8D 8D ?? ?? ?? ?? 6A ?? 8B 40 ?? 03 C8 8B 51 ?? 83 CA ?? 8B C2 83 C8 ?? 83 79 ?? 
            ?? 0F 45 C2 50 E8 ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? 8B 40 ?? C7 84 05 ?? ?? ?? ?? ?? ?? 
            ?? ?? 8B 85 ?? ?? ?? ?? 8B 48 ?? 8D 41 ?? 89 84 0D ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? E8 
            ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? 8B 40 ?? C7 84 05 ?? ?? ?? ?? ?? ?? ?? ?? 8B 85 ?? ?? 
            ?? ?? 8B 48 ?? 8D 41 ?? 89 84 0D ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? C6 45 ?? ?? 50 C7 85 
            ?? ?? ?? ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 ?? C6 45 ?? ?? FF 15 ?? ?? ?? ?? 57 FF 
            15 ?? ?? ?? ?? 83 7D ?? ?? 0F 85 ?? ?? ?? ?? 8D 4D ?? E8 ?? ?? ?? ?? 8D 4D ?? E8 ?? 
            ?? ?? ?? FF 75 ?? E8 ?? ?? ?? ?? 83 C4 ?? C7 45 ?? ?? ?? ?? ?? 8D 4D ?? E8 ?? ?? ?? 
            ?? 8D 4D ?? E8 ?? ?? ?? ?? 8D 4D ?? E8 ?? ?? ?? ?? B0 ?? 8B 4D ?? 64 89 0D ?? ?? ?? 
            ?? 59 5F 5E 8B 4D ?? 33 CD E8 ?? ?? ?? ?? 8B E5 5D C3 
        }

        $encrypt_files_3 = {
            E8 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? C6 45 ?? ?? 51 8B D0 8D 4D ?? E8 ?? ?? ?? ?? 83 C4 
            ?? C6 45 ?? ?? 8B 85 ?? ?? ?? ?? 83 F8 ?? 72 ?? 8B 8D ?? ?? ?? ?? 40 3D ?? ?? ?? ?? 
            72 ?? F6 C1 ?? 0F 85 ?? ?? ?? ?? 8B 41 ?? 3B C1 0F 83 ?? ?? ?? ?? 2B C8 83 F9 ?? 0F 
            82 ?? ?? ?? ?? 83 F9 ?? 0F 87 ?? ?? ?? ?? 8B C8 51 E8 ?? ?? ?? ?? 83 C4 ?? C7 85 ?? 
            ?? ?? ?? ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? C6 85 ?? ?? ?? ?? ?? 83 FE ?? 0F 
            84 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 0F 84 ?? ?? ?? ?? B8 ?? ?? ?? 
            ?? 8D 8D ?? ?? ?? ?? 8A 11 3A 10 75 ?? 84 D2 74 ?? 8A 51 ?? 3A 50 ?? 75 ?? 83 C1 ?? 
            83 C0 ?? 84 D2 75 ?? 33 C0 EB ?? 1B C0 83 C8 ?? 85 C0 0F 84 ?? ?? ?? ?? 6A ?? 6A ?? 
            8D 45 ?? C7 45 ?? ?? ?? ?? ?? 50 8D 4D ?? C7 45 ?? ?? ?? ?? ?? C6 45 ?? ?? E8 ?? ?? 
            ?? ?? 6A ?? 68 ?? ?? ?? ?? 8D 4D ?? C6 45 ?? ?? E8 ?? ?? ?? ?? 83 7D ?? ?? 8D 45 ?? 
            8D 4D ?? 0F 43 4D ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 85 C0 7E ?? 83 7D ?? ?? 8D 4D ?? 8D 
            45 ?? 0F 43 4D ?? 83 7D ?? ?? 51 0F 43 45 ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 85 C0 75 ?? 
            46 EB ?? 85 F6 75 ?? 83 F8 ?? B8 ?? ?? ?? ?? 0F 45 F0 89 B5 ?? ?? ?? ?? 8D 4D ?? E8 
            ?? ?? ?? ?? C6 45 ?? ?? 8B 45 ?? 83 F8 ?? 0F 82 ?? ?? ?? ?? 8B 4D ?? 40 3D ?? ?? ?? 
            ?? 72 ?? F6 C1 ?? 75 ?? 8B 41 ?? 3B C1 73 ?? 2B C8 83 F9 ?? 72 ?? 83 F9 ?? 77 ?? 8B 
            C8 51 E8 ?? ?? ?? ?? 83 C4 ?? E9 ?? ?? ?? ?? E8
        }

        $encrypt_files_4 = {
            8B BD ?? ?? ?? ?? 8B B5 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 50 57 FF 15 ?? ?? ?? ?? 85 C0 
            0F 85 ?? ?? ?? ?? 85 F6 0F 8E ?? ?? ?? ?? 68 ?? ?? ?? ?? 50 8D 85 ?? ?? ?? ?? 50 E8 
            ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 55 ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 ?? C6 45 
            ?? ?? 8D 8D ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? C6 45 ?? ?? 8B 85 ?? ?? ?? ?? 83 F8 ?? 72 
            ?? 40 8D 8D ?? ?? ?? ?? 50 FF B5 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? C7 85 
            ?? ?? ?? ?? ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? C6 85 ?? ?? ?? ?? ?? 8B 40 ?? 
            F6 84 05 ?? ?? ?? ?? ?? 75 ?? 8D 45 ?? 50 E8 ?? ?? ?? ?? 8B D0 C6 45 ?? ?? 8D 8D ?? 
            ?? ?? ?? E8 ?? ?? ?? ?? C6 45 ?? ?? 8B 45 ?? 83 F8 ?? 72 ?? 40 8D 4D ?? 50 FF 75 ?? 
            E8 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 75 ?? 8B 85 ?? ?? ?? ?? 8D 8D 
            ?? ?? ?? ?? 8B 40 ?? 03 C8 8B 41 ?? 83 C8 ?? 83 79 ?? ?? 75 ?? 83 C8 ?? 6A ?? 50 E8 
            ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? 8B 40 ?? C7 84 05 ?? ?? ?? ?? ?? ?? ?? ?? 8B 85 ?? ?? 
            ?? ?? 8B 48 ?? 8D 41 ?? 89 84 0D ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 85 
            ?? ?? ?? ?? 8B 40 ?? C7 84 05 ?? ?? ?? ?? ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? 8B 48 ?? 8D 
            41 ?? 89 84 0D ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? C6 45 ?? ?? 50 C7 85 ?? ?? ?? ?? ?? ?? 
            ?? ?? E8 ?? ?? ?? ?? 83 C4 ?? C6 45 ?? ?? FF 15 ?? ?? ?? ?? 57 FF 15 ?? ?? ?? ?? 83 
            7D ?? ?? 0F 85 ?? ?? ?? ?? 8D 4D ?? E8 ?? ?? ?? ?? 8D 4D ?? E8 ?? ?? ?? ?? FF 75 ?? 
            E8 ?? ?? ?? ?? 8B 45 ?? 83 C4 ?? C7 45 ?? ?? ?? ?? ?? 83 F8 ?? 72 ?? 40 8D 4D ?? 50
        }

        $encrypt_files_5 = {
            FF 75 ?? E8 ?? ?? ?? ?? 8B 45 ?? C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? C6 45 ?? 
            ?? 83 F8 ?? 72 ?? 40 8D 4D ?? 50 FF 75 ?? E8 ?? ?? ?? ?? 8B 45 ?? C7 45 ?? ?? ?? ?? 
            ?? C7 45 ?? ?? ?? ?? ?? C6 45 ?? ?? 83 F8 ?? 72 ?? 40 8D 4D ?? 50 FF 75 ?? E8 ?? ?? 
            ?? ?? B0 ?? 8B 4D ?? 64 89 0D ?? ?? ?? ?? 59 5F 5E 8B 4D ?? 33 CD E8 ?? ?? ?? ?? 8B 
            E5 5D C3 E8 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? C6 45 ?? ?? 51 8B D0 8D 4D ?? E8 ?? ?? ?? 
            ?? 83 C4 ?? C6 45 ?? ?? 8B 85 ?? ?? ?? ?? 83 F8 ?? 72 ?? 40 8D 8D ?? ?? ?? ?? 50 FF 
            B5 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ?? 
            ?? ?? C6 85 ?? ?? ?? ?? ?? 83 FE ?? 0F 84 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? 
            ?? 85 C0 0F 84 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 
            ?? 85 C0 0F 84 ?? ?? ?? ?? 6A ?? 6A ?? 8D 45 ?? C7 45 ?? ?? ?? ?? ?? 50 8D 4D ?? C7 
            45 ?? ?? ?? ?? ?? C6 45 ?? ?? E8 ?? ?? ?? ?? 6A ?? 68 ?? ?? ?? ?? 8D 4D ?? C6 45 ?? 
            ?? E8 ?? ?? ?? ?? 83 7D ?? ?? 8D 45 ?? 8D 4D ?? 0F 43 4D ?? 50 E8 ?? ?? ?? ?? 83 C4 
            ?? 85 C0 7E ?? 83 7D ?? ?? 8D 4D ?? 8D 45 ?? 0F 43 4D ?? 83 7D ?? ?? 51 0F 43 45 ?? 
            50 E8 ?? ?? ?? ?? 83 C4 ?? 85 C0 75 ?? 46 89 B5 ?? ?? ?? ?? 8B 45 ?? 83 F8 ?? 72 ?? 
            40 8D 4D ?? 50 FF 75 ?? E8 ?? ?? ?? ?? C6 45 ?? ?? 8B 45 ?? 83 F8 ?? 0F 82 ?? ?? ?? 
            ?? 40 8D 4D ?? 50 FF 75 ?? E8 ?? ?? ?? ?? E9
        }

    condition:
        uint16(0) == 0x5A4D and ($encrypt_files_1 and $encrypt_files_2 and $encrypt_files_3) or
        ($encrypt_files_1 and $encrypt_files_4 and $encrypt_files_5)
}