rule Win32_Ransomware_GandCrab : tc_detection malicious
{
    meta:

        author              = "ReversingLabs"

        source              = "ReversingLabs"
        status              = "RELEASED"
        sharing             = "TLP:WHITE"
        category            = "MALWARE"
        malware             = "GANDCRAB"
        description         = "Yara rule that detects GandCrab ransomware."

        tc_detection_type   = "Ransomware"
        tc_detection_name   = "GandCrab"
        tc_detection_factor = 5

    strings:

        $remote_connection = {
            55 8B EC 81 EC ?? ?? ?? ?? 53 56 57 8B F9 89 55 ?? 8D 4D ?? E8 ?? ?? ?? ?? 6A ?? 68 
            ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A ?? FF 15 ?? ?? ?? ?? 8B D8 89 5D ?? 85 DB 74 ?? 33 C0 
            83 F8 ?? 75 ?? 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 8B CB E8 ?? ?? ?? ?? 83 F8 ?? 74 ?? 
            57 FF 15 ?? ?? ?? ?? 8D 4D ?? 8D 34 45 ?? ?? ?? ?? 8D 46 ?? 50 E8 ?? ?? ?? ?? 68 ?? 
            ?? ?? ?? 8D 4D ?? E8 ?? ?? ?? ?? 56 8D 4D ?? E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 4D ?? 
            8B D8 E8 ?? ?? ?? ?? 8B 35 ?? ?? ?? ?? 68 ?? ?? ?? ?? 53 89 45 ?? FF D6 57 53 FF D6 
            6A ?? 59 BE ?? ?? ?? ?? 8D BD ?? ?? ?? ?? F3 A5 8B 35 ?? ?? ?? ?? 53 FF D6 33 FF 8D 
            85 ?? ?? ?? ?? 21 BD ?? ?? ?? ?? 68 ?? ?? ?? ?? 57 50 E8 ?? ?? ?? ?? 83 C4 ?? 8D 85 
            ?? ?? ?? ?? 68 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 
            85 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 50 8D 85 ?? ?? ?? ?? 50 68 ?? ?? ?? ?? 83 EC ?? 
            FF 75 ?? 53 FF D6 8B 75 ?? 8D 4D ?? 50 53 8D 85 ?? ?? ?? ?? 50 56 E8 ?? ?? ?? ?? 85 
            C0 74 ?? 47 83 7D ?? ?? 74 ?? 8B 4D ?? 8D 55 ?? 83 65 ?? ?? E8 ?? ?? ?? ?? 85 C0 74 
            ?? 8B 45 ?? 85 C0 74 ?? 8B 4D ?? 89 01 EB ?? 33 FF 68 ?? ?? ?? ?? 6A ?? 56 FF 15 ?? 
            ?? ?? ?? 8D 4D ?? E8 ?? ?? ?? ?? 8D 4D ?? E8 ?? ?? ?? ?? 83 7D ?? ?? 74 ?? FF 75 ?? 
            FF 15 ?? ?? ?? ?? 8B C7 5F 5E 5B 8B E5 5D C3 
        }

        $remote_connection_v2 = {
            55 8B EC 83 EC ?? 53 56 8B D9 89 55 ?? 57 8D 4D ?? 89 5D ?? E8 ?? ?? ?? ?? E8 ?? ?? 
            ?? ?? 53 89 45 ?? FF 15 ?? ?? ?? ?? 8B 35 ?? ?? ?? ?? 6A ?? 68 ?? ?? ?? ?? 8D 3C 45 
            ?? ?? ?? ?? 8D 47 ?? 50 6A ?? FF D6 6A ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A ?? 8B D8 
            FF D6 89 45 ?? 85 DB 74 ?? 8D 47 ?? 3B F8 73 ?? 8B F3 EB ?? 33 F6 FF 75 ?? 56 FF 15 
            ?? ?? ?? ?? F3 0F 6F 05 ?? ?? ?? ?? 56 F3 0F 7F 45 ?? F3 0F 6F 05 ?? ?? ?? ?? F3 0F 
            7F 45 ?? F3 0F 6F 05 ?? ?? ?? ?? F3 0F 7F 45 ?? F3 0F 6F 05 ?? ?? ?? ?? F3 0F 7F 45 
            ?? F3 0F 6F 05 ?? ?? ?? ?? F3 0F 7F 45 ?? F3 0F 6F 05 ?? ?? ?? ?? F3 0F 7F 45 ?? FF 
            15 ?? ?? ?? ?? 8D 45 ?? 33 FF 50 FF 15 ?? ?? ?? ?? 50 8D 45 ?? 50 68 ?? ?? ?? ?? 83 
            EC ?? 68 ?? ?? ?? ?? FF 75 ?? 56 FF 15 ?? ?? ?? ?? 50 56 8B 75 ?? 8D 4D ?? 68 ?? ?? 
            ?? ?? 56 E8 ?? ?? ?? ?? 85 C0 74 ?? 83 7D ?? ?? BF ?? ?? ?? ?? 74 ?? 8B 4D ?? 8D 55 
            ?? C7 45 ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 ?? 8B 45 ?? 85 C0 74 ?? 8B 4D ?? 89 
            01 EB ?? 33 FF 68 ?? ?? ?? ?? 6A ?? 56 8B 35 ?? ?? ?? ?? FF D6 68 ?? ?? ?? ?? 6A ?? 
            FF 75 ?? FF D6 68 ?? ?? ?? ?? 6A ?? 53 FF D6 8B 45 ?? 85 C0 74 ?? 50 FF 15 ?? ?? ?? 
            ?? 8B C7 5F 5E 5B 8B E5 5D C3 
        }

        $crypt_files = {
            55 8B EC 83 E4 ?? 81 EC ?? ?? ?? ?? 53 56 57 51 33 C0 89 4C 24 ?? 40 8B DA 50 51 50 
            83 EC ?? 89 5C 24 ?? 50 51 50 51 50 51 50 51 50 83 EC ?? 50 51 50 8D 8C 24 ?? ?? ?? 
            ?? E8 ?? ?? ?? ?? 8D 4C 24 ?? E8 ?? ?? ?? ?? 8D 4C 24 ?? E8 ?? ?? ?? ?? 8B 75 ?? 8B 
            F8 03 F3 8D 4E ?? 8D 0C CF C1 E1 ?? 51 8D 4C 24 ?? E8 ?? ?? ?? ?? 8D 04 B7 8D 04 C5 
            ?? ?? ?? ?? 50 8D 4C 24 ?? E8 ?? ?? ?? ?? 8B 75 ?? 89 44 24 ?? 8D 0C F5 ?? ?? ?? ?? 
            51 8D 4C 24 ?? E8 ?? ?? ?? ?? 8D 0C DD ?? ?? ?? ?? 8B F8 51 8D 4C 24 ?? E8 ?? ?? ?? 
            ?? 8B D8 89 5C 24 ?? 85 FF 0F 84 ?? ?? ?? ?? 8D 44 24 ?? 50 57 68 ?? ?? ?? ?? 56 FF 
            75 ?? 8D 0C 36 8B 35 ?? ?? ?? ?? 89 4C 24 ?? FF D6 8B 4C 24 ?? 8D 04 09 89 44 24 ?? 
            8D 44 24 ?? 50 53 68 ?? ?? ?? ?? 51 FF 74 24 ?? FF D6 53 8B 1D ?? ?? ?? ?? FF D3 57 
            8B F0 FF D3 83 C0 ?? 8D 4C 24 ?? 03 C6 50 E8 ?? ?? ?? ?? 57 FF D3 40 8D 4C 24 ?? 50 
            E8 ?? ?? ?? ?? FF 74 24 ?? 89 44 24 ?? FF D3 40 8D 4C 24 ?? 50 E8 ?? ?? ?? ?? 33 F6 
            89 44 24 ?? 8B CE 57 89 4C 24 ?? FF D3 85 C0 74 ?? 8B 54 24 ?? 89 54 24 ?? 8B 44 24 
            ?? 8A 0C 38 80 F9 ?? 74 ?? 80 F9 ?? 74 ?? 88 0A 42 89 54 24 ?? 40 57 89 44 24 ?? FF 
            D3 8B 4C 24 ?? 8B 54 24 ?? 3B C8 72 ?? 8B 7C 24 ?? 57 FF D3 85 C0 74 ?? 8B 4C 24 ?? 
            89 4C 24 ?? 8A 04 3E 3C ?? 74 ?? 3C ?? 74 ?? 88 01 41 89 4C 24 ?? 57 46 FF D3 8B 4C 
            24 ?? 3B F0 72 ?? 8B 7C 24 ?? 8B 1D ?? ?? ?? ?? 68 ?? ?? ?? ?? 57 FF D3 8B 35 ?? ?? 
            ?? ?? 57 FF D6 8D 4C 24 ?? 8D 3C 47 57 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 57 FF D3 57 FF 
            D6 FF 74 24 ?? 8D 34 47 FF 15 ?? ?? ?? ?? 50 56 6A ?? FF 74 24 ?? 6A ?? 68 ?? ?? ?? 
            ?? FF 15 ?? ?? ?? ?? 68 ?? ?? ?? ?? 57 FF D3 57 FF 15 ?? ?? ?? ?? FF 74 24 ?? 8D 34 
            47 FF 15 ?? ?? ?? ?? 50 56 6A ?? FF 74 24 ?? 6A ?? 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 
            68 ?? ?? ?? ?? 57 FF D3 8B 74 24 ?? 8B 1D ?? ?? ?? ?? 56 FF D3 C1 E0 ?? 8D 4C 24 ?? 
            83 C0 ?? 50 E8 ?? ?? ?? ?? 56 FF D3 8D 4C 24 ?? 8D 04 C5 ?? ?? ?? ?? 50 E8 ?? ?? ?? 
            ?? 56 89 44 24 ?? FF D3 8B 5C 24 ?? 8B F0 8B CB 8D 3C 36 8B D7 E8 ?? ?? ?? ?? 8D 44 
            24 ?? 8B CE 8B 74 24 ?? 50 56 68 ?? ?? ?? ?? 57 C1 E1 ?? 53 89 4C 24 ?? FF 15 ?? ?? 
            ?? ?? 85 C0 75 ?? FF 15 ?? ?? ?? ?? 8B 1D ?? ?? ?? ?? 56 FF D3 83 C0 ?? 8D 4C 24 ?? 
            50 E8 ?? ?? ?? ?? 56 FF D3 40 8D 4C 24 ?? 50 E8 ?? ?? ?? ?? 89 44 24 ?? 33 F6 8B 44 
            24 ?? 8B FE 50 FF D3 85 C0 74 ?? 8B 54 24 ?? 89 54 24 ?? 8B 44 24 ?? 8A 0C 07 80 F9 
            ?? 74 ?? 80 F9 ?? 74 ?? 88 0A 42 89 54 24 ?? 50 47 FF D3 8B 54 24 ?? 3B F8 72 ?? 8B 
            7C 24 ?? 57 FF D3 50 FF 74 24 ?? 6A ?? 57 56 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 6A ?? 
            8D 54 24 ?? 89 74 24 ?? 8B CF E8 ?? ?? ?? ?? 59 85 C0 75 ?? 8D 4C 24 ?? E8 ?? ?? ?? 
            ?? 8D 4C 24 ?? E8 ?? ?? ?? ?? 8D 4C 24 ?? E8 ?? ?? ?? ?? EB ?? 8B 4C 24 ?? 85 C9 74 
            ?? 8B 45 ?? 89 08 8D 4C 24 ?? E8 ?? ?? ?? ?? 8D 4C 24 ?? E8 ?? ?? ?? ?? 8D 4C 24 ?? 
            E8 ?? ?? ?? ?? 33 F6 46 8D 4C 24 ?? E8 ?? ?? ?? ?? 8D 4C 24 ?? E8 ?? ?? ?? ?? 5F 8B 
            C6 5E 5B 8B E5 5D C3 
        }

        $crypt_files_v2 = {
            8B 55 ?? 8B 1D ?? ?? ?? ?? 8D 04 12 89 44 24 ?? 8D 44 24 ?? 50 51 68 ?? ?? ?? ?? 52 
            FF 75 ?? FF D3 8D 04 36 89 44 24 ?? 8D 44 24 ?? 50 57 68 ?? ?? ?? ?? 56 FF 74 24 ?? 
            FF D3 8B 1D ?? ?? ?? ?? 57 FF D3 FF 74 24 ?? 8B F0 FF D3 6A ?? 83 C0 ?? 68 ?? ?? ?? 
            ?? 03 F0 56 6A ?? FF 15 ?? ?? ?? ?? FF 74 24 ?? 89 44 24 ?? 89 44 24 ?? C7 44 24 ?? 
            ?? ?? ?? ?? FF D3 8B 54 24 ?? 40 85 D2 74 ?? 3B C6 73 ?? 8D 0C 02 89 44 24 ?? 89 4C 
            24 ?? 89 54 24 ?? EB ?? C7 44 24 ?? ?? ?? ?? ?? 57 FF D3 40 83 7C 24 ?? ?? 74 ?? 03 
            44 24 ?? 3B C6 72 ?? C7 44 24 ?? ?? ?? ?? ?? FF 74 24 ?? 33 F6 FF D3 85 C0 74 ?? 8B 
            7C 24 ?? EB ?? 8D 9B ?? ?? ?? ?? 8B 4C 24 ?? 8A 04 0E 3C ?? 74 ?? 3C ?? 74 ?? 88 07 
            47 51 46 FF D3 3B F0 72 ?? 8B 7C 24 ?? 57 33 F6 FF D3 85 C0 74 ?? 8B 4C 24 ?? 89 4C 
            24 ?? 90 8A 04 3E 3C ?? 74 ?? 3C ?? 74 ?? 88 01 41 89 4C 24 ?? 57 46 FF D3 8B 4C 24 
            ?? 3B F0 72 ?? 8B 74 24 ?? 8B 3D ?? ?? ?? ?? 68 ?? ?? ?? ?? 56 FF D7 56 FF 15 ?? ?? 
            ?? ?? 8D 4C 24 ?? 8D 34 46 56 89 74 24 ?? E8 ?? ?? ?? ?? 8D 54 24 ?? C7 44 24 ?? ?? 
            ?? ?? ?? 8D 4C 24 ?? C7 44 24 ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 75 ?? 50 FF 15 ?? 
            ?? ?? ?? 68 ?? ?? ?? ?? 56 FF D7 8B 7C 24 ?? 57 56 FF 15 ?? ?? ?? ?? 68 ?? ?? ?? ?? 
            56 FF 15 ?? ?? ?? ?? 8B 74 24 ?? 56 FF 74 24 ?? FF 15 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 
            ?? 57 8B 3D ?? ?? ?? ?? FF D7 68 ?? ?? ?? ?? 6A ?? 56 FF D7 8B 74 24 ?? 68 ?? ?? ?? 
            ?? 56 FF 15 ?? ?? ?? ?? 8B 3D ?? ?? ?? ?? 56 FF D7 FF 74 24 ?? 8D 34 46 FF D3 50 56 
            6A ?? FF 74 24 ?? 6A ?? 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 8B 74 24 ?? 68 ?? ?? ?? ?? 
            56 FF 15 ?? ?? ?? ?? 56 FF D7 8B 7C 24 ?? 57 8D 34 46 FF D3 50 56 6A ?? 57 6A ?? 68 
            ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 68 ?? ?? ?? ?? FF 74 24 ?? FF 15 ?? ?? ?? ?? FF 74 24 
            ?? 8B 35 ?? ?? ?? ?? FF D6 8B F8 6A ?? C1 E7 ?? 68 ?? ?? ?? ?? 83 C7 ?? 57 6A ?? FF 
            15 ?? ?? ?? ?? FF 74 24 ?? 89 44 24 ?? FF D6 8D 0C C5 ?? ?? ?? ?? 8B 44 24 ?? 85 C0 
            74 ?? 3B CF 73 ?? 8B F8 EB ?? 33 FF FF 74 24 ?? FF D6 8B 0D ?? ?? ?? ?? 89 44 24 ?? 
            85 C9 74 ?? 68 ?? ?? ?? ?? 6A ?? 51 FF 15 ?? ?? ?? ?? 6A ?? 68 ?? ?? ?? ?? 68 ?? ?? 
            ?? ?? FF D6 83 C0 ?? 50 6A ?? FF 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? 85 C0 74 ?? 68 ?? ?? 
            ?? ?? 68 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 83 C4 ?? 8B 44 24 ?? 8B 4C 24 ?? 8D 34 00 
            8B D6 E8 ?? ?? ?? ?? 8B 4C 24 ?? 8D 04 CD ?? ?? ?? ?? 89 44 24 ?? 8D 44 24 ?? 50 57 
            68 ?? ?? ?? ?? 56 FF 74 24 ?? FF 15 ?? ?? ?? ?? 85 C0 75 ?? FF 15 ?? ?? ?? ?? 57 FF 
            D3 6A ?? 68 ?? ?? ?? ?? 8D 70 ?? 56 6A ?? FF 15 ?? ?? ?? ?? 57 89 44 24 ?? FF D3 8D 
            48 ?? 8B 44 24 ?? 85 C0 74 ?? 89 44 24 ?? 3B CE 72 ?? C7 44 24 ?? ?? ?? ?? ?? 57 33 
            F6 FF D3 85 C0 74 ?? 8B 4C 24 ?? 89 4C 24 ?? 8A 04 3E 3C ?? 74 ?? 3C ?? 74 ?? 88 01 
            41 89 4C 24 ?? 57 46 FF D3 8B 4C 24 ?? 3B F0 72 ?? 8B 74 24 ?? 56 FF D3 50 FF 74 24 
            ?? 6A ?? 56 6A ?? 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 6A ?? 51 8D 54 24 ?? C7 44 24 ?? 
            ?? ?? ?? ?? 8B CE E8 ?? ?? ?? ?? 83 C4 ?? 85 C0 75 ?? 8B 1D ?? ?? ?? ?? 68 ?? ?? ?? 
            ?? 50 8B 44 24 ?? 50 FF D3 8B 44 24 ?? 68 ?? ?? ?? ?? 6A ?? 50 FF D3 68 ?? ?? ?? ?? 
            6A ?? FF 74 24 ?? FF D3 68 ?? ?? ?? ?? 6A ?? FF 74 24 ?? FF D3 8D 4C 24 ?? E8 ?? ?? 
            ?? ?? 33 C0 5F 5E 5B 8B E5 5D C3 
        }

        $find_files = {
            55 8B EC 81 EC ?? ?? ?? ?? 53 56 57 89 55 ?? 8B F9 E8 ?? ?? ?? ?? 85 C0 0F 84 ?? ?? 
            ?? ?? 8B CF E8 ?? ?? ?? ?? 85 C0 0F 85 ?? ?? ?? ?? E8 ?? ?? ?? ?? 57 FF 15 ?? ?? ?? 
            ?? 68 ?? ?? ?? ?? 57 8D 1C 47 89 5D ?? FF 15 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 50 57 FF 
            15 ?? ?? ?? ?? 8B F0 33 C0 89 75 ?? 66 89 03 83 FE ?? 75 ?? B8 ?? ?? ?? ?? E9 ?? ?? 
            ?? ?? 8B 5D ?? 68 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 ?? 
            ?? ?? ?? 68 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 85 C0 74 ?? 8D 85 ?? 
            ?? ?? ?? 50 57 FF 15 ?? ?? ?? ?? F6 85 ?? ?? ?? ?? ?? 74 ?? 68 ?? ?? ?? ?? 57 FF 15 
            ?? ?? ?? ?? 8B 55 ?? 8B CF 53 FF 75 ?? FF 75 ?? E8 ?? ?? ?? ?? 83 C4 ?? EB ?? FF 75 
            ?? 8B 03 8D 95 ?? ?? ?? ?? 8B 73 ?? 51 8B CF 89 45 ?? E8 ?? ?? ?? ?? 01 03 59 11 53 
            ?? 59 3B 73 ?? 77 ?? 72 ?? 8B 45 ?? 3B 03 73 ?? 8B 45 ?? FF 00 8B 75 ?? 8B 45 ?? 33 
            C9 66 89 08 8D 85 ?? ?? ?? ?? 50 56 FF 15 ?? ?? ?? ?? 85 C0 0F 85 ?? ?? ?? ?? 56 FF 
            15 ?? ?? ?? ?? 33 C0 5F 5E 5B 8B E5 5D C3 
        }

        $find_files_v2 = {
            55 8B EC 81 EC ?? ?? ?? ?? 53 56 57 89 55 ?? 8B F9 E8 ?? ?? ?? ?? 85 C0 0F 84 ?? ?? 
            ?? ?? 8B CF E8 ?? ?? ?? ?? 85 C0 0F 85 ?? ?? ?? ?? E8 ?? ?? ?? ?? 57 FF 15 ?? ?? ?? 
            ?? 8B 35 ?? ?? ?? ?? 68 ?? ?? ?? ?? 57 8D 1C 47 89 5D ?? FF D6 8D 85 ?? ?? ?? ?? 50 
            57 FF 15 ?? ?? ?? ?? 33 C9 89 45 ?? 66 89 0B 83 F8 ?? 75 ?? B8 ?? ?? ?? ?? 5F 5E 5B 
            8B E5 5D C3 8B 5D ?? EB ?? 8D A4 24 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 50 
            FF 15 ?? ?? ?? ?? 85 C0 0F 84 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 50 FF 15 
            ?? ?? ?? ?? 85 C0 74 ?? 8D 85 ?? ?? ?? ?? 50 57 FF D6 F6 85 ?? ?? ?? ?? ?? 74 ?? 68 
            ?? ?? ?? ?? 57 FF D6 8B 55 ?? 8B CF 53 FF 75 ?? FF 75 ?? E8 ?? ?? ?? ?? 83 C4 ?? EB 
            ?? FF 75 ?? 8B 03 8D 95 ?? ?? ?? ?? 8B 73 ?? 51 8B CF 89 45 ?? E8 ?? ?? ?? ?? 83 C4 
            ?? 01 03 11 53 ?? 3B 73 ?? 77 ?? 72 ?? 8B 45 ?? 3B 03 73 ?? 8B 45 ?? FF 00 8B 35 ?? 
            ?? ?? ?? 8B 45 ?? 33 C9 66 89 08 8D 85 ?? ?? ?? ?? 50 FF 75 ?? FF 15 ?? ?? ?? ?? 85 
            C0 0F 85 ?? ?? ?? ?? FF 75 ?? FF 15 ?? ?? ?? ?? 5F 5E 33 C0 5B 8B E5 5D C3 
        }

        $search_antivirus_processes = {
            55 8B EC 81 EC ?? ?? ?? ?? 53 56 57 B8 ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? 6A 
            ?? 6A ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? 89 85 ?? ?? ?? 
            ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? 
            ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? C7 45 ?? ?? ?? 
            ?? ?? C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? 
            ?? ?? C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? 
            ?? ?? C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? 
            ?? ?? C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? 
            ?? ?? C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? 
            ?? ?? C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? 89 45 ?? C7 45 ?? ?? ?? ?? ?? C7 45 
            ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? C7 45 
            ?? ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 6A ?? 68 ?? ?? ?? ?? BB ?? ?? ?? ?? 8B F8 53 6A ?? 
            89 7D ?? FF 15 ?? ?? ?? ?? 8B F0 85 F6 74 ?? 89 1E 83 FF ?? 74 ?? 56 57 FF 15 ?? ?? 
            ?? ?? 33 DB 8D 7E ?? 57 FF B4 9D ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 85 C0 75 ?? FF 76 ?? 
            50 6A ?? FF 15 ?? ?? ?? ?? 89 45 ?? 85 C0 74 ?? 6A ?? 50 FF 15 ?? ?? ?? ?? FF 75 ?? 
            FF 15 ?? ?? ?? ?? 43 83 FB ?? 72 ?? 8B 7D ?? 56 57 FF 15 ?? ?? ?? ?? 85 C0 75 ?? 85 
            F6 74 ?? 68 ?? ?? ?? ?? 50 56 FF 15 ?? ?? ?? ?? 57 FF 15 ?? ?? ?? ?? 5F 5E 5B 8B E5 
            5D C3 
        }

        $search_antivirus_processes_v2 = {
            C7 44 24 ?? ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? C7 44 24 ?? 
            ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? 
            C7 44 24 ?? ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? C7 44 24 ?? 
            ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? 
            C7 44 24 ?? ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? C7 44 24 ?? 
            ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? 
            C7 44 24 ?? ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? C7 44 24 ?? 
            ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? C7 84 24 ?? ?? ?? ?? ?? ?? ?? ?? C7 84 24 ?? ?? 
            ?? ?? ?? ?? ?? ?? C7 84 24 ?? ?? ?? ?? ?? ?? ?? ?? C7 84 24 ?? ?? ?? ?? ?? ?? ?? ?? 
            C7 84 24 ?? ?? ?? ?? ?? ?? ?? ?? C7 84 24 ?? ?? ?? ?? ?? ?? ?? ?? C7 84 24 ?? ?? ?? 
            ?? ?? ?? ?? ?? C7 84 24 ?? ?? ?? ?? ?? ?? ?? ?? C7 84 24 ?? ?? ?? ?? ?? ?? ?? ?? C7 
            84 24 ?? ?? ?? ?? ?? ?? ?? ?? C7 84 24 ?? ?? ?? ?? ?? ?? ?? ?? C7 84 24 ?? ?? ?? ?? 
            ?? ?? ?? ?? C7 84 24 ?? ?? ?? ?? ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 6A ?? 68 ?? ?? ?? ?? 
            68 ?? ?? ?? ?? 8B F0 6A ?? 89 74 24 ?? FF 15 ?? ?? ?? ?? 8B D8 85 DB 74 ?? C7 03 ?? 
            ?? ?? ?? 83 FE ?? 74 ?? 53 56 FF 15 ?? ?? ?? ?? 8B 3D ?? ?? ?? ?? 8D 4B ?? 33 F6 EB 
            ?? 8D A4 24 ?? ?? ?? ?? 90 51 FF 74 B4 ?? FF 15 ?? ?? ?? ?? 85 C0 75 ?? FF 73 ?? 50 
            6A ?? FF 15 ?? ?? ?? ?? 8B F8 85 FF 74 ?? 6A ?? 57 FF 15 ?? ?? ?? ?? 57 8B 3D ?? ?? 
            ?? ?? FF D7 EB ?? 8B 3D ?? ?? ?? ?? 46 8D 4B ?? 83 FE ?? 72 ?? 8B 74 24 ?? 53 56 FF 
            15 ?? ?? ?? ?? 8D 4B ?? 85 C0 75 ?? 85 DB 74 ?? 68 ?? ?? ?? ?? 6A ?? 53 FF 15 ?? ?? 
            ?? ?? 56 FF D7 5F 5E 5B 8B E5 5D C3 
        }

        $find_files_v2_1 = {
            6A ?? 6A ?? 8D 85 ?? ?? ?? ?? 50 6A ?? FF 15 ?? ?? ?? ?? 8B 1D ?? ?? ?? ?? 85 C0 74 
            ?? 68 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 50 FF D3 8D 85 ?? ?? ?? ?? 50 56 FF 15 ?? ?? ?? 
            ?? F7 D8 1B C0 40 75 ?? BA ?? ?? ?? ?? 8B CE E8 ?? ?? ?? ?? 85 C0 75 ?? 8B CE E8 ?? 
            ?? ?? ?? 56 FF 15 ?? ?? ?? ?? 68 ?? ?? ?? ?? 56 8D 3C 46 89 7D ?? FF D3 8D 85 ?? ?? 
            ?? ?? 50 56 FF 15 ?? ?? ?? ?? 33 C9 89 45 ?? 66 89 0F 83 F8 ?? 75 ?? B8 ?? ?? ?? ?? 
            5F 5E 5B 8B E5 5D C3 8B 7D ?? EB ?? 8D 9B ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 85 ?? ?? ?? 
            ?? 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 50 
            FF 15 ?? ?? ?? ?? 85 C0 0F 84 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 50 56 FF D3 F6 85 ?? ?? 
            ?? ?? ?? 74 ?? 83 7D ?? ?? 74 ?? BA ?? ?? ?? ?? 8B CE E8 ?? ?? ?? ?? 85 C0 0F 84 ?? 
            ?? ?? ?? 68 ?? ?? ?? ?? 56 FF D3 8B 55 ?? 8B CE 6A ?? 57 FF 75 ?? FF 75 ?? E8 ?? ?? 
            ?? ?? 83 C4 ?? E9 ?? ?? ?? ?? 68 ?? ?? ?? ?? 56 FF D3 8B 55 ?? 8B CE 6A ?? 57 FF 75 
            ?? FF 75 ?? E8 ?? ?? ?? ?? 83 C4 ?? E9 ?? ?? ?? ?? 8B 07 6A ?? 68 ?? ?? ?? ?? 68 ?? 
            ?? ?? ?? 89 45 ?? 8B 47 ?? 6A ?? 89 45 ?? FF 15 ?? ?? ?? ?? 56 8B D8 68 ?? ?? ?? ?? 
            53 FF 15 ?? ?? ?? ?? 83 C4 ?? 8B CB E8 ?? ?? ?? ?? 85 C0 74 ?? 68 ?? ?? ?? ?? 6A ?? 
            53 FF 15 ?? ?? ?? ?? 0F 57 C0 66 0F 13 45 ?? 8B 45 ?? 8B 4D ?? EB ?? 83 BD ?? ?? ?? 
            ?? ?? 0F 57 C0 66 0F 13 45 ?? 72 ?? 51 FF 75 ?? 8B CB E8 ?? ?? ?? ?? 83 C4 ?? 89 55 
            ?? EB ?? 8B 45 ?? 89 45 ?? 8B 45 ?? 68 ?? ?? ?? ?? 6A ?? 53 89 45 ?? FF 15 ?? ?? ?? 
            ?? 8B 45 ?? 8B 4D ?? 01 0F 11 47 ?? 8B 45 ?? 3B 47 ?? 77 ?? 72 ?? 8B 45 ?? 3B 07 73 
            ?? 8B 45 ?? FF 00 8B 1D ?? ?? ?? ?? 8B 45 ?? 33 C9 66 89 08 8D 85 ?? ?? ?? ?? 50 FF 
            75 ?? FF 15 ?? ?? ?? ?? 85 C0 0F 85 ?? ?? ?? ?? FF 75 ?? FF 15 ?? ?? ?? ?? 5F 5E 33 
            C0 5B 8B E5 5D C3 
        }

        $crypt_files_v2_1 = {
            FF 15 ?? ?? ?? ?? 33 D2 89 44 24 ?? 89 44 24 ?? 8D 0C B7 8D 0C CD ?? ?? ?? ?? 85 C0 
            74 ?? 3B CB 73 ?? 8D 3C 01 89 44 24 ?? 89 7C 24 ?? 8B D1 EB ?? 89 54 24 ?? 8B F8 8B 
            4D ?? 8D 34 CD ?? ?? ?? ?? 85 C0 74 ?? 8D 0C 32 89 4C 24 ?? 3B CB 73 ?? 8B 54 24 ?? 
            8B CF 89 7C 24 ?? 03 FE 89 7C 24 ?? EB ?? 33 C9 89 4C 24 ?? 8B 74 24 ?? 85 C0 74 ?? 
            8D 04 F5 ?? ?? ?? ?? 03 C2 3B C3 72 ?? 33 FF 89 7C 24 ?? 8B 1D ?? ?? ?? ?? 85 C9 0F 
            84 ?? ?? ?? ?? 8B 55 ?? 8B 1D ?? ?? ?? ?? 8D 04 12 89 44 24 ?? 8D 44 24 ?? 50 51 68 
            ?? ?? ?? ?? 52 FF 75 ?? FF D3 8D 04 36 89 44 24 ?? 8D 44 24 ?? 50 57 68 ?? ?? ?? ?? 
            56 FF 74 24 ?? FF D3 8B 1D ?? ?? ?? ?? 57 FF D3 FF 74 24 ?? 8B F0 FF D3 6A ?? 83 C6 
            ?? 03 C6 68 ?? ?? ?? ?? 50 6A ?? 89 44 24 ?? FF 15 ?? ?? ?? ?? FF 74 24 ?? 8B F0 C7 
            44 24 ?? ?? ?? ?? ?? 89 74 24 ?? 89 74 24 ?? FF D3 40 85 F6 74 ?? 3B 44 24 ?? 73 ?? 
            8D 0C 06 89 44 24 ?? 89 4C 24 ?? 89 74 24 ?? EB ?? C7 44 24 ?? ?? ?? ?? ?? 57 FF D3 
            40 85 F6 74 ?? 03 44 24 ?? 3B 44 24 ?? 72 ?? C7 44 24 ?? ?? ?? ?? ?? FF 74 24 ?? 33 
            F6 FF D3 85 C0 74 ?? 8B 4C 24 ?? 8B 7C 24 ?? 89 4C 24 ?? 8A 04 3E 3C ?? 74 ?? 3C ?? 
            74 ?? 88 01 41 89 4C 24 ?? 57 46 FF D3 8B 4C 24 ?? 3B F0 72 ?? 8B 7C 24 ?? 57 33 F6 
            FF D3 85 C0 74 ?? 8B 4C 24 ?? 89 4C 24 ?? EB ?? 8D 49 ?? 8A 04 3E 3C ?? 74 ?? 3C ?? 
            74 ?? 88 01 41 89 4C 24 ?? 57 46 FF D3 8B 4C 24 ?? 3B F0 72 ?? 8B 74 24 ?? 8B 1D ?? 
            ?? ?? ?? 68 ?? ?? ?? ?? 56 FF D3 56 FF 15 ?? ?? ?? ?? 8D 4C 24 ?? 8D 3C 46 57 E8 ?? 
            ?? ?? ?? 68 ?? ?? ?? ?? 57 FF D3 68 ?? ?? ?? ?? 57 FF D3 68 ?? ?? ?? ?? 57 FF D3 68 
            ?? ?? ?? ?? 57 FF D3 8B 35 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A ?? 68 ?? ?? ?? ?? FF D6 68 
            ?? ?? ?? ?? 6A ?? 68 ?? ?? ?? ?? FF D6 68 ?? ?? ?? ?? 57 FF D3 57 FF 15 ?? ?? ?? ?? 
            FF 74 24 ?? 8D 34 47 FF 15 ?? ?? ?? ?? 50 56 6A ?? FF 74 24 ?? 6A ?? 68 ?? ?? ?? ?? 
            FF 15 ?? ?? ?? ?? 68 ?? ?? ?? ?? 57 FF D3 57 FF 15 ?? ?? ?? ?? FF 74 24 ?? 8D 34 47 
            FF 15 ?? ?? ?? ?? 50 56 6A ?? FF 74 24 ?? 6A ?? 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 33 
            C0 C7 44 24 ?? ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? C7 44 24 
            ?? ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? 
            ?? 66 89 44 24 ?? C7 44 24 ?? ?? ?? ?? ?? 50 FF 74 24 ?? 58 58 8D 44 24 ?? 50 57 FF 
            D3 8B 5C 24 ?? 8B 35 ?? ?? ?? ?? 53 FF D6 6A ?? C1 E0 ?? 83 C0 ?? 68 ?? ?? ?? ?? 50 
            6A ?? 89 44 24 ?? FF 15 ?? ?? ?? ?? 8B F8 53 89 7C 24 ?? FF D6 8D 04 C5 ?? ?? ?? ?? 
            85 FF 74 ?? 3B 44 24 ?? 72 ?? 33 FF 53 FF D6 8B 0D ?? ?? ?? ?? 8B F0 89 74 24 ?? 85 
            C9 74 ?? 68 ?? ?? ?? ?? 6A ?? 51 FF 15 ?? ?? ?? ?? 8B 5C 24 ?? 6A ?? 68 ?? ?? ?? ?? 
            53 FF 15 ?? ?? ?? ?? 83 C0 ?? 50 6A ?? FF 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? 85 C0 74 ?? 
            53 68 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 83 C4 ?? 8B 5C 24 ?? 03 F6 8B D6 8B CB E8 ?? 
            ?? ?? ?? 8B 4C 24 ?? 8D 04 CD ?? ?? ?? ?? 89 44 24 ?? 8D 44 24 ?? 50 57 68 ?? ?? ?? 
            ?? 56 53 FF 15 ?? ?? ?? ?? 85 C0 75 ?? FF 15 ?? ?? ?? ?? 8B 1D ?? ?? ?? ?? 57 FF D3 
            6A ?? 68 ?? ?? ?? ?? 8D 70 ?? 56 6A ?? FF 15 ?? ?? ?? ?? 57 89 44 24 ?? FF D3 8D 48 
            ?? 8B 44 24 ?? 85 C0 74 ?? 89 44 24 ?? 3B CE 72 ?? C7 44 24 ?? ?? ?? ?? ?? 57 33 F6 
            FF D3 85 C0 74 ?? 8B 4C 24 ?? 89 4C 24 ?? 8A 04 3E 3C ?? 74 ?? 3C ?? 74 ?? 88 01 41 
            89 4C 24 ?? 57 46 FF D3 8B 4C 24 ?? 3B F0 72 ?? 8B 74 24 ?? 56 FF D3 50 FF 74 24 ?? 
            6A ?? 56 6A ?? 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 8B 7C 24 ?? 8D 54 24 ?? 6A ?? 57 8B 
            CE C7 44 24 ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 ?? 85 C0 75 ?? 8B 1D ?? ?? ?? ?? 68 
            ?? ?? ?? ?? 50 8B 44 24 ?? 50 FF D3 68 ?? ?? ?? ?? 6A ?? FF 74 24 ?? FF D3 68 ?? ?? 
            ?? ?? 6A ?? FF 74 24 ?? FF D3 33 F6 EB ?? 8B 4C 24 ?? 85 C9 74 ?? 8B 45 ?? 89 08 8B 
            44 24 ?? 8B 1D ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A ?? 50 FF D3 68 ?? ?? ?? ?? 6A ?? FF 74 
            24 ?? FF D3 68 ?? ?? ?? ?? 6A ?? FF 74 24 ?? FF D3 EB ?? 8B 7C 24 ?? 83 7C 24 ?? ?? 
            75 ?? 68 ?? ?? ?? ?? 6A ?? 57 FF D3 BE ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A ?? FF 74 24 ?? 
            FF D3 8D 4C 24 ?? E8 ?? ?? ?? ?? 5F 8B C6 5E 5B 8B E5 5D C3 
        }

        $remote_connection_v2_1 = {
            53 89 45 ?? FF 15 ?? ?? ?? ?? 8B 35 ?? ?? ?? ?? 6A ?? 68 ?? ?? ?? ?? 8D 3C 45 ?? ?? 
            ?? ?? 8D 47 ?? 50 6A ?? FF D6 6A ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A ?? 8B D8 FF D6 
            89 45 ?? 85 DB 74 ?? 8D 47 ?? 3B F8 73 ?? 8B F3 EB ?? 33 F6 FF 75 ?? 56 FF 15 ?? ?? 
            ?? ?? F3 0F 6F 05 ?? ?? ?? ?? 56 F3 0F 7F 45 ?? F3 0F 6F 05 ?? ?? ?? ?? F3 0F 7F 45 
            ?? F3 0F 6F 05 ?? ?? ?? ?? F3 0F 7F 45 ?? F3 0F 6F 05 ?? ?? ?? ?? F3 0F 7F 45 ?? F3 
            0F 6F 05 ?? ?? ?? ?? F3 0F 7F 45 ?? F3 0F 6F 05 ?? ?? ?? ?? F3 0F 7F 45 ?? FF 15 ?? 
            ?? ?? ?? 8D 45 ?? 33 FF 50 FF 15 ?? ?? ?? ?? 50 8D 45 ?? 50 68 ?? ?? ?? ?? 83 EC ?? 
            68 ?? ?? ?? ?? FF 75 ?? 56 FF 15 ?? ?? ?? ?? 50 56 FF 75 ?? 8B 75 ?? 8D 4D ?? 56 E8 
            ?? ?? ?? ?? 85 C0 74 ?? 83 7D ?? ?? BF ?? ?? ?? ?? 74 ?? 8B 4D ?? 8D 55 ?? C7 45 ?? 
            ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 ?? 8B 45 ?? 85 C0 74 ?? 8B 4D ?? 89 01 EB ?? 33 
            FF 68 ?? ?? ?? ?? 6A ?? 56 8B 35 ?? ?? ?? ?? FF D6 68 ?? ?? ?? ?? 6A ?? FF 75 ?? FF 
            D6 68 ?? ?? ?? ?? 6A ?? 53 FF D6 8B 45 ?? 85 C0 74 ?? 50 FF 15 ?? ?? ?? ?? 8B C7 5F 
            5E 5B 8B E5 5D C3 
        }

        $search_antivirus_processes_v4_1_2 = {
            C7 85 ?? ?? ?? ?? ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ?? 
            ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? C7 85 ?? ?? ?? ?? 
            ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? C7 85 ?? ?? 
            ?? ?? ?? ?? ?? ?? 89 45 ?? C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? 
            ?? ?? C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? 
            ?? ?? C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? 
            ?? ?? C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? 
            ?? ?? C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? 
            ?? ?? C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? 89 45 ?? C7 45 ?? ?? ?? ?? ?? C7 45 
            ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? C7 45 
            ?? ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 6A ?? 68 ?? ?? ?? ?? BB ?? ?? ?? ?? 8B F8 53 6A ?? 
            89 7D ?? FF 15 ?? ?? ?? ?? 8B F0 85 F6 74 ?? 89 1E 83 FF ?? 74 ?? 56 57 FF 15 ?? ?? 
            ?? ?? 33 DB 8D 7E ?? 57 FF B4 9D ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 85 C0 75 ?? FF 76 ?? 
            50 6A ?? FF 15 ?? ?? ?? ?? 89 45 ?? 85 C0 74 ?? 6A ?? 50 FF 15 ?? ?? ?? ?? FF 75 ?? 
            FF 15 ?? ?? ?? ?? 43 83 FB ?? 72 ?? 8B 7D ?? 56 57 FF 15 ?? ?? ?? ?? 85 C0 75 ?? 85 
            F6 74 ?? 68 ?? ?? ?? ?? 50 56 FF 15 ?? ?? ?? ?? 57 FF 15 ?? ?? ?? ?? 5F 5E 5B 8B E5 
            5D C3 
        }

        $find_files_v4_1_2 = {
            55 8B EC 83 E4 ?? 81 EC ?? ?? ?? ?? 53 56 57 33 FF 89 54 24 ?? 8B F1 89 7C 24 ?? 39 
            7D ?? 75 ?? 8D 54 24 ?? E8 ?? ?? ?? ?? 8B 5C 24 ?? 85 C0 75 ?? 85 DB 75 ?? 33 C0 E9 
            ?? ?? ?? ?? 33 DB 43 8B CE E8 ?? ?? ?? ?? 85 C0 75 ?? 66 83 3E ?? 74 ?? 8D 54 24 ?? 
            89 7C 24 ?? 8B CE E8 ?? ?? ?? ?? 89 44 24 ?? 39 7C 24 ?? 75 ?? 56 FF 15 ?? ?? ?? ?? 
            68 ?? ?? ?? ?? 56 8D 04 46 89 44 24 ?? FF 15 ?? ?? ?? ?? 8D 44 24 ?? 50 56 FF 15 ?? 
            ?? ?? ?? 8B 4C 24 ?? 33 D2 89 44 24 ?? 66 89 11 83 F8 ?? 75 ?? BF ?? ?? ?? ?? E9 ?? 
            ?? ?? ?? 68 ?? ?? ?? ?? 8D 44 24 ?? 50 FF 15 ?? ?? ?? ?? 85 C0 74 ?? 68 ?? ?? ?? ?? 
            8D 44 24 ?? 50 FF 15 ?? ?? ?? ?? 85 C0 74 ?? 8D 44 24 ?? 50 56 FF 15 ?? ?? ?? ?? F6 
            44 24 ?? ?? 74 ?? 85 DB 74 ?? BA ?? ?? ?? ?? 8B CE E8 ?? ?? ?? ?? 85 C0 74 ?? 68 ?? 
            ?? ?? ?? 56 FF 15 ?? ?? ?? ?? 6A ?? 8B 54 24 ?? 8B CE E8 ?? ?? ?? ?? EB ?? 68 ?? ?? 
            ?? ?? 56 FF 15 ?? ?? ?? ?? 57 EB ?? FF 74 24 ?? 8D 54 24 ?? 8B CE E8 ?? ?? ?? ?? 59 
            8B 44 24 ?? 33 C9 66 89 08 8D 44 24 ?? 50 FF 74 24 ?? FF 15 ?? ?? ?? ?? 85 C0 0F 85 
            ?? ?? ?? ?? FF 74 24 ?? FF 15 ?? ?? ?? ?? FF 74 24 ?? FF 15 ?? ?? ?? ?? 8B C7 5F 5E 
            5B 8B E5 5D C3 
        }

        $crypt_files_v4_1_2 = {
            55 8B EC 81 EC ?? ?? ?? ?? 53 56 89 4D ?? 33 DB 57 B9 ?? ?? ?? ?? 89 5D ?? 8B F2 E8 
            ?? ?? ?? ?? 8B F8 8D 55 ?? 56 57 8D 4D ?? 89 7D ?? E8 ?? ?? ?? ?? 59 59 85 C0 0F 84 
            ?? ?? ?? ?? 53 53 6A ?? 53 53 68 ?? ?? ?? ?? FF 75 ?? FF 15 ?? ?? ?? ?? 8B F0 83 FE 
            ?? 0F 84 ?? ?? ?? ?? 6A ?? 58 88 5D ?? 48 75 ?? 51 51 8D 55 ?? 8D 8D ?? ?? ?? ?? E8 
            ?? ?? ?? ?? 8B 45 ?? 83 C4 ?? 89 45 ?? B9 ?? ?? ?? ?? 8B 45 ?? 89 45 ?? 89 5D ?? 89 
            5D ?? E8 ?? ?? ?? ?? B9 ?? ?? ?? ?? 89 45 ?? E8 ?? ?? ?? ?? 89 45 ?? 89 5D ?? 53 8D 
            45 ?? 50 68 ?? ?? ?? ?? FF 75 ?? 56 FF 15 ?? ?? ?? ?? 85 C0 0F 84 ?? ?? ?? ?? 8B 4D 
            ?? 85 C9 0F 84 ?? ?? ?? ?? 8B 45 ?? 81 F9 ?? ?? ?? ?? 6A ?? 5A 0F 42 C2 01 8F ?? ?? 
            ?? ?? 8B 55 ?? 8D 8D ?? ?? ?? ?? 11 9F ?? ?? ?? ?? 89 45 ?? 8B 45 ?? 50 FF 75 ?? 89 
            45 ?? E8 ?? ?? ?? ?? 8B 45 ?? 59 59 33 C9 F7 D8 41 99 51 53 52 50 56 FF 15 ?? ?? ?? 
            ?? 85 C0 75 ?? FF 15 ?? ?? ?? ?? 53 8D 45 ?? 50 FF 75 ?? FF 75 ?? 56 FF 15 ?? ?? ?? 
            ?? 85 C0 75 ?? 8B 7D ?? 6A ?? FF 15 ?? ?? ?? ?? 53 8D 45 ?? 50 FF 75 ?? 57 56 FF 15 
            ?? ?? ?? ?? 85 C0 74 ?? 8B 7D ?? 8B 4D ?? 85 C9 0F 84 ?? ?? ?? ?? 53 8D 45 ?? 50 68 
            ?? ?? ?? ?? 57 56 FF 15 ?? ?? ?? ?? 8B 4D ?? 8B D8 E8 ?? ?? ?? ?? 8B 4D ?? E8 ?? ?? 
            ?? ?? 56 FF 15 ?? ?? ?? ?? 8B CF E8 ?? ?? ?? ?? 5F 5E 8B C3 5B 8B E5 5D C3 33 C0 8D 
            48 ?? 89 4D ?? EB
        }

        $remote_connection_v4_1_2 = {
            55 8B EC 83 EC ?? 53 8B 1D ?? ?? ?? ?? 56 8B F1 57 83 7E ?? ?? 74 ?? FF 76 ?? FF D3 
            8B CE E8 ?? ?? ?? ?? 33 FF 57 57 6A ?? 57 57 FF 75 ?? FF 75 ?? FF 76 ?? FF 15 ?? ?? 
            ?? ?? 89 45 ?? 85 C0 0F 84 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 4D ?? E8 ?? ?? ?? ?? 68 ?? 
            ?? ?? ?? 8D 4D ?? E8 ?? ?? ?? ?? FF 75 ?? 8B F0 68 ?? ?? ?? ?? 56 FF 15 ?? ?? ?? ?? 
            83 C4 ?? B8 ?? ?? ?? ?? 81 7D ?? ?? ?? ?? ?? B9 ?? ?? ?? ?? 0F 44 C8 57 51 57 57 68 
            ?? ?? ?? ?? 56 8B 75 ?? 68 ?? ?? ?? ?? 56 FF 15 ?? ?? ?? ?? 89 45 ?? 85 C0 74 ?? FF 
            75 ?? FF 75 ?? FF 75 ?? FF 75 ?? 50 FF 15 ?? ?? ?? ?? 85 C0 74 ?? 33 FF 47 EB ?? FF 
            15 ?? ?? ?? ?? 8B 45 ?? 50 FF D3 56 FF D3 8D 4D ?? E8 ?? ?? ?? ?? 8B C7 5F 5E 5B 8B 
            E5 5D C2
        }

        $url_parameters_setup_v4_1_2 = {
            55 8B EC 81 EC ?? ?? ?? ?? 53 56 57 FF 15 ?? ?? ?? ?? 33 FF 57 57 57 FF 15 ?? ?? ?? 
            ?? FF 15 ?? ?? ?? ?? 83 F8 ?? 74 ?? 57 FF 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 0F 85 
            ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 0F 85 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 ?? E8 ?? 
            ?? ?? ?? 83 EC ?? 33 DB 43 53 83 EC ?? 53 51 53 51 53 51 53 51 53 83 EC ?? 53 51 53 
            8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? 
            E8 ?? ?? ?? ?? 8D 0C 45 ?? ?? ?? ?? E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? 85 C0 74 ?? 50 8D 
            8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 35 ?? ?? ?? ?? 68 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? FF 
            D6 68 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? FF D6 68 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? FF D6 68 
            ?? ?? ?? ?? FF 35 ?? ?? ?? ?? FF D6 68 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? FF D6 68 ?? ?? 
            ?? ?? FF 35 ?? ?? ?? ?? FF D6 68 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? FF D6 FF 35 ?? ?? ?? 
            ?? 8B 35 ?? ?? ?? ?? FF D6 FF 35 ?? ?? ?? ?? 03 C0 A3 ?? ?? ?? ?? FF D6 03 C0 8B D0 
            E8 ?? ?? ?? ?? 53 FF 15 ?? ?? ?? ?? 57 57 57 68 ?? ?? ?? ?? 57 57 FF 15 ?? ?? ?? ?? 
            8B 35 ?? ?? ?? ?? 8B F8 68 ?? ?? ?? ?? FF D6 68 ?? ?? ?? ?? FF D6 BB ?? ?? ?? ?? 53 
            FF D6 E8 ?? ?? ?? ?? 8B 35 ?? ?? ?? ?? 53 FF D6 68 ?? ?? ?? ?? FF D6 68 ?? ?? ?? ?? 
            FF D6 E8 ?? ?? ?? ?? 85 FF 74 ?? 6A ?? 57 FF 15 ?? ?? ?? ?? E8 
        }

        $url_parameters_setup_v4 = {
            55 8B EC 81 EC ?? ?? ?? ?? 56 FF 15 ?? ?? ?? ?? 6A ?? 6A ?? 6A ?? FF 15 ?? ?? ?? ?? 
            FF 15 ?? ?? ?? ?? 83 F8 ?? 74 ?? 6A ?? FF 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 0F 85 
            ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 0F 85 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 75 ?? 50 FF 
            15 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ?? 
            ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? C7 45 
            ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? C7 45 
            ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? C7 45 
            ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? C7 45 
            ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? C7 45 
            ?? ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? 89 45 ?? E8 ?? ?? ?? ?? 8D 8D ?? 
            ?? ?? ?? E8 ?? ?? ?? ?? 6A ?? 68 ?? ?? ?? ?? 8D 04 45 ?? ?? ?? ?? 50 6A ?? FF 15 ?? 
            ?? ?? ?? A3 ?? ?? ?? ?? 85 C0 75 ?? 50 FF 15 ?? ?? ?? ?? 50 8D 8D ?? ?? ?? ?? E8 ?? 
            ?? ?? ?? 8B 35 ?? ?? ?? ?? 68 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? FF D6 68 ?? ?? ?? ?? FF 
            35 ?? ?? ?? ?? FF D6 68 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? FF D6 68 ?? ?? ?? ?? FF 35 ?? 
            ?? ?? ?? FF D6 68 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? FF D6 68 ?? ?? ?? ?? FF 35 ?? ?? ?? 
            ?? FF D6 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 03 C0 8B D0 E8 ?? ?? ?? ?? 6A ?? FF 15 
            ?? ?? ?? ?? 8B 35 ?? ?? ?? ?? 68 ?? ?? ?? ?? FF D6 68 ?? ?? ?? ?? FF D6 68 ?? ?? ?? 
            ?? FF D6 E8 ?? ?? ?? ?? 8B 35 ?? ?? ?? ?? 68 ?? ?? ?? ?? FF D6 68 ?? ?? ?? ?? FF D6 
            68 ?? ?? ?? ?? FF D6 E8 ?? ?? ?? ?? E8
        }

        $search_antivirus_processes_v4 = {
            55 8B EC 83 EC ?? 53 56 8B 35 ?? ?? ?? ?? 57 6A ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A 
            ?? FF D6 8B 5D ?? 6A ?? 68 ?? ?? ?? ?? 6A ?? 6A ?? 89 03 C7 45 ?? ?? ?? ?? ?? C7 45 
            ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? C7 45 
            ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? C7 45 
            ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? C7 45 
            ?? ?? ?? ?? ?? FF D6 8B F8 89 7D ?? 85 FF 74 ?? 6A ?? 6A ?? C7 07 ?? ?? ?? ?? FF 15 
            ?? ?? ?? ?? 89 45 ?? 83 F8 ?? 75 ?? 68 ?? ?? ?? ?? 6A ?? 57 FF 15 ?? ?? ?? ?? 5F 5E 
            33 C0 5B 8B E5 5D C2 ?? ?? 33 C9 33 F6 57 50 89 4D ?? 89 4D ?? 89 4D ?? 89 75 ?? FF 
            15 ?? ?? ?? ?? 85 C0 0F 84 ?? ?? ?? ?? 8D 49 ?? 85 F6 0F 85 ?? ?? ?? ?? 83 C7 ?? EB 
            ?? 8D 49 ?? 57 FF 74 B5 ?? FF 15 ?? ?? ?? ?? 85 C0 74 ?? 46 83 FE ?? 72 ?? 8B 75 ?? 
            EB ?? 83 7D ?? ?? 57 FF 33 C7 45 ?? ?? ?? ?? ?? 75 ?? FF 15 ?? ?? ?? ?? 68 ?? ?? ?? 
            ?? FF 33 FF 15 ?? ?? ?? ?? EB ?? 8B 35 ?? ?? ?? ?? FF D6 68 ?? ?? ?? ?? FF 33 FF D6 
            FF 45 ?? 57 FF 15 ?? ?? ?? ?? 8B 4D ?? 8B 75 ?? 8D 0C 41 B8 ?? ?? ?? ?? 81 F9 ?? ?? 
            ?? ?? 89 4D ?? 0F 47 F0 89 75 ?? 8B 7D ?? 57 FF 75 ?? FF 15 ?? ?? ?? ?? 85 C0 74 ?? 
            FF 15 ?? ?? ?? ?? 83 F8 ?? 0F 85 ?? ?? ?? ?? 83 7D ?? ?? 74 ?? 8B 03 66 83 38 ?? 74 
            ?? 50 FF 15 ?? ?? ?? ?? 8B 0B 33 D2 66 89 54 41 ?? 8B 45 ?? 8B 4D ?? 89 08 8B 35 ?? 
            ?? ?? ?? 68 ?? ?? ?? ?? 6A ?? 57 FF D6 FF 75 ?? FF 15 ?? ?? ?? ?? 8B 7D ?? 85 FF 75 
            ?? 68 ?? ?? ?? ?? 57 FF 33 FF D6 8B C7 5F 5E 5B 8B E5 5D C2
        }

        $find_files_v4 = {
            C7 44 24 ?? ?? ?? ?? ?? 8B CE E8 ?? ?? ?? ?? 85 C0 75 ?? 66 83 3E ?? 0F 84 ?? ?? ?? 
            ?? 8D 54 24 ?? C7 44 24 ?? ?? ?? ?? ?? 8B CE E8 ?? ?? ?? ?? 83 7C 24 ?? ?? 89 44 24 
            ?? 0F 85 ?? ?? ?? ?? 56 FF 15 ?? ?? ?? ?? 8B 3D ?? ?? ?? ?? 68 ?? ?? ?? ?? 56 8D 04 
            46 89 44 24 ?? FF D7 8D 44 24 ?? 50 56 FF 15 ?? ?? ?? ?? 8B 4C 24 ?? 33 D2 89 44 24 
            ?? 66 89 11 83 F8 ?? 75 ?? FF 74 24 ?? FF 15 ?? ?? ?? ?? B8 ?? ?? ?? ?? 5F 5E 5B 8B 
            E5 5D C3 68 ?? ?? ?? ?? 8D 44 24 ?? 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 ?? ?? ?? ?? 68 
            ?? ?? ?? ?? 8D 44 24 ?? 50 FF 15 ?? ?? ?? ?? 85 C0 74 ?? 8D 44 24 ?? 50 56 FF D7 F6 
            44 24 ?? ?? 74 ?? 83 7C 24 ?? ?? 74 ?? BA ?? ?? ?? ?? 8B CE E8 ?? ?? ?? ?? 85 C0 74 
            ?? 68 ?? ?? ?? ?? 56 FF D7 6A ?? 8B D3 8B CE E8 ?? ?? ?? ?? EB ?? 68 ?? ?? ?? ?? 56 
            FF D7 6A ?? 8B D3 8B CE E8 ?? ?? ?? ?? EB ?? 53 8D 54 24 ?? 8B CE E8 ?? ?? ?? ?? 83 
            C4 ?? 8B 44 24 ?? 33 C9 66 89 08 8D 44 24 ?? 50 FF 74 24 ?? FF 15 ?? ?? ?? ?? 85 C0 
            0F 85 ?? ?? ?? ?? FF 74 24 ?? FF 15 ?? ?? ?? ?? FF 74 24 ?? FF 15 ?? ?? ?? ?? 5F 5E 
            33 C0 5B 8B E5 5D C3 
        }

        $crypt_files_v4 = {
            55 8B EC 81 EC ?? ?? ?? ?? 53 56 57 6A ?? 68 ?? ?? ?? ?? 33 DB 89 4D ?? 68 ?? ?? ?? 
            ?? 53 8B F2 89 5D ?? FF 15 ?? ?? ?? ?? 8B F8 8D 55 ?? 56 57 8D 4D ?? 89 7D ?? E8 ?? 
            ?? ?? ?? 83 C4 ?? 85 C0 75 ?? 68 ?? ?? ?? ?? 50 57 FF 15 ?? ?? ?? ?? 33 C0 5F 5E 5B 
            8B E5 5D C3 6A ?? 6A ?? 6A ?? 6A ?? 6A ?? 68 ?? ?? ?? ?? FF 75 ?? FF 15 ?? ?? ?? ?? 
            8B F0 83 FE ?? 0F 84 ?? ?? ?? ?? B8 ?? ?? ?? ?? 88 5D ?? 48 75 ?? 8B 45 ?? 89 85 ?? 
            ?? ?? ?? 8B 45 ?? 89 45 ?? 8B 45 ?? 89 45 ?? 8B 45 ?? 89 45 ?? 8B 45 ?? 89 45 ?? 8B 
            45 ?? 89 45 ?? 8B 45 ?? 6A ?? 89 45 ?? 8B 45 ?? 68 ?? ?? ?? ?? 89 45 ?? 8B 45 ?? 68 
            ?? ?? ?? ?? 89 45 ?? 8B 45 ?? 89 5D ?? 89 5D ?? 8B 1D ?? ?? ?? ?? 6A ?? C7 05 ?? ?? 
            ?? ?? ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? 
            ?? ?? C7 45 ?? ?? ?? ?? ?? 89 45 ?? FF D3 6A ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A ?? 
            89 45 ?? FF D3 33 C9 8B D8 89 4D ?? 6A ?? 8D 45 ?? 50 68 ?? ?? ?? ?? FF 75 ?? 56 FF 
            15 ?? ?? ?? ?? 85 C0 0F 84 ?? ?? ?? ?? 8B 45 ?? 85 C0 0F 84 ?? ?? ?? ?? 8B 4D ?? 3D 
            ?? ?? ?? ?? BA ?? ?? ?? ?? 0F 42 CA 01 87 ?? ?? ?? ?? 8B 55 ?? 83 97 ?? ?? ?? ?? ?? 
            8B 7D ?? 89 4D ?? 8D 8D ?? ?? ?? ?? 57 53 E8 ?? ?? ?? ?? 83 C4 ?? 8B C7 F7 D8 99 6A 
            ?? 6A ?? 52 50 56 FF 15 ?? ?? ?? ?? 85 C0 75 ?? FF 15 ?? ?? ?? ?? 6A ?? 8D 45 ?? 50 
            57 53 56 FF 15 ?? ?? ?? ?? 85 C0 75 ?? 6A ?? FF 15 ?? ?? ?? ?? 6A ?? 8D 45 ?? 50 57 
            53 56 FF 15 ?? ?? ?? ?? 85 C0 74 ?? 8B 4D ?? 8B 7D ?? 85 C9 0F 84 ?? ?? ?? ?? 6A ?? 
            8D 45 ?? 50 68 ?? ?? ?? ?? 57 56 FF 15 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A ?? FF 75 ?? 89 
            45 ?? FF 15 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A ?? 53 FF 15 ?? ?? ?? ?? 56 FF 15 ?? ?? ?? 
            ?? 8B 5D ?? 68 ?? ?? ?? ?? 6A ?? 57 FF 15 ?? ?? ?? ?? 5F 5E 8B C3 5B 8B E5 5D C3 
        }

        $crypt_files_v3 = {
            55 8B EC 81 EC ?? ?? ?? ?? 53 56 57 8D 45 ?? C7 45 ?? ?? ?? ?? ?? 50 8D 45 ?? C7 45 
            ?? ?? ?? ?? ?? 50 6A ?? 8B D9 8B CA 6A ?? E8 ?? ?? ?? ?? 8B 35 ?? ?? ?? ?? 6A ?? 68 
            ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A ?? FF D6 8B F8 C7 45 ?? ?? ?? ?? ?? 53 57 89 7D ?? C7 
            45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 8D 45 ?? 50 57 FF 15 ?? ?? 
            ?? ?? 66 0F 6F 05 ?? ?? ?? ?? BA ?? ?? ?? ?? F3 0F 7F 85 ?? ?? ?? ?? 51 66 0F 6F 05 
            ?? ?? ?? ?? 8D 4D ?? F3 0F 7F 45 ?? C6 45 ?? ?? 66 0F 6F 05 ?? ?? ?? ?? F3 0F 7F 45 
            ?? E8 ?? ?? ?? ?? BA ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 ?? 6A ?? 68 
            ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A ?? FF D6 F3 0F 6F 85 ?? ?? ?? ?? 8B F8 6A ?? 68 ?? ?? 
            ?? ?? 68 ?? ?? ?? ?? F3 0F 7F 07 6A ?? F3 0F 6F 45 ?? 89 7D ?? F3 0F 7F 47 ?? FF D6 
            F3 0F 6F 45 ?? 68 ?? ?? ?? ?? 89 45 ?? F3 0F 7F 00 8D 45 ?? C7 45 ?? ?? ?? ?? ?? 50 
            57 FF 75 ?? C7 45 ?? ?? ?? ?? ?? FF 75 ?? E8 ?? ?? ?? ?? 8B 3D ?? ?? ?? ?? 83 C4 ?? 
            85 C0 75 ?? 6A ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A ?? FF 15 ?? ?? ?? ?? EB ?? 68 ?? 
            ?? ?? ?? 8D 45 ?? 50 FF 75 ?? FF 75 ?? FF 75 ?? E8 ?? ?? ?? ?? 83 C4 ?? 85 C0 75 ?? 
            FF 15 ?? ?? ?? ?? 0F 57 C0 66 0F 13 45 ?? 8B 75 ?? 8B 5D ?? E9 ?? ?? ?? ?? 8D 85 ?? 
            ?? ?? ?? 50 8D 85 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 6A ?? 68 ?? ?? ?? ?? 6A ?? 
            6A ?? 6A ?? 68 ?? ?? ?? ?? 53 FF 15 ?? ?? ?? ?? 89 45 ?? 83 F8 ?? 75 ?? 68 ?? ?? ?? 
            ?? 6A ?? FF 75 ?? FF D7 68 ?? ?? ?? ?? 6A ?? FF 75 ?? FF D7 0F 57 C0 66 0F 13 45 ?? 
            8B 75 ?? 8B 5D ?? E9 ?? ?? ?? ?? 6A ?? 68 ?? ?? ?? ?? 6A ?? 6A ?? FF D6 6A ?? 8B D8 
            68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A ?? C7 03 ?? ?? ?? ?? C7 43 ?? ?? ?? ?? ?? FF D6 8B 
            3D ?? ?? ?? ?? 33 F6 33 C9 89 45 ?? 89 4D ?? EB ?? 8B 45 ?? 6A ?? 8D 4D ?? 51 68 ?? 
            ?? ?? ?? 50 FF 75 ?? FF 15 ?? ?? ?? ?? 85 C0 0F 84 ?? ?? ?? ?? 8B 45 ?? 85 C0 0F 84 
            ?? ?? ?? ?? 3D ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? B9 ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? 
            0F 42 F1 01 03 83 53 ?? ?? 8B 45 ?? 89 45 ?? 89 45 ?? A8 ?? 74 ?? 8B FF 40 A8 ?? 75 
            ?? 89 45 ?? 6A ?? 68 ?? ?? ?? ?? 50 6A ?? FF 15 ?? ?? ?? ?? FF 75 ?? 89 45 ?? FF 75 
            ?? 50 E8 ?? ?? ?? ?? 8B 45 ?? 83 C4 ?? 89 45 ?? 6A ?? 68 ?? ?? ?? ?? 50 6A ?? FF 15 
            ?? ?? ?? ?? 85 C0 74 ?? 8B 55 ?? 8B 4D ?? 50 8D 45 ?? 50 8D 85 ?? ?? ?? ?? 50 8D 45 
            ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 68 ?? ?? ?? ?? 6A ?? FF 75 ?? FF D7 8B 4D ?? 8B 45 ?? 
            F7 D9 6A ?? 83 D0 ?? 6A ?? F7 D8 50 51 FF 75 ?? FF 15 ?? ?? ?? ?? 85 C0 75 ?? FF 15 
            ?? ?? ?? ?? 6A ?? 8D 45 ?? 50 FF 75 ?? FF 75 ?? FF 75 ?? FF 15 ?? ?? ?? ?? 85 C0 75 
            ?? BE ?? ?? ?? ?? 89 75 ?? 68 ?? ?? ?? ?? 6A ?? FF 75 ?? FF D7 85 F6 0F 84 ?? ?? ?? 
            ?? 68 ?? ?? ?? ?? 6A ?? FF 75 ?? FF D7 8B 4D ?? 8B 75 ?? 85 C9 75 ?? 51 8D 45 ?? 50 
            68 ?? ?? ?? ?? FF 75 ?? 56 FF 15 ?? ?? ?? ?? 6A ?? 8D 45 ?? 50 68 ?? ?? ?? ?? FF 75 
            ?? 56 FF 15 ?? ?? ?? ?? 6A ?? 8D 45 ?? 50 6A ?? 53 56 FF 15 ?? ?? ?? ?? 56 FF 15 ?? 
            ?? ?? ?? 8B 03 8B 73 ?? 68 ?? ?? ?? ?? 6A ?? 53 89 45 ?? FF D7 68 ?? ?? ?? ?? 6A ?? 
            FF 75 ?? FF D7 68 ?? ?? ?? ?? 6A ?? FF 75 ?? FF D7 8B 5D ?? 68 ?? ?? ?? ?? 6A ?? FF 
            75 ?? FF D7 5F 8B D6 8B C3 5E 5B 8B E5 5D C3 
        }

        $search_antivirus_processes_v5 = {
            8B 7D ?? 6A ?? 53 6A ?? 33 DB 89 07 53 C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? C7 
            45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? C7 
            45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? C7 
            45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? FF 
            D6 8B F0 85 F6 75 ?? 33 C0 E9 ?? ?? ?? ?? 53 6A ?? C7 06 ?? ?? ?? ?? FF 15 ?? ?? ?? 
            ?? 89 45 ?? 83 F8 ?? 75 ?? 68 ?? ?? ?? ?? 53 56 FF 15 ?? ?? ?? ?? EB ?? 56 33 C9 89 
            5D ?? 50 89 5D ?? 89 4D ?? FF 15 ?? ?? ?? ?? 85 C0 0F 84 ?? ?? ?? ?? 83 7D ?? ?? 0F 
            85 ?? ?? ?? ?? 33 C0 8D 4E ?? 89 45 ?? 51 FF 74 85 ?? FF 15 ?? ?? ?? ?? 85 C0 74 ?? 
            8B 45 ?? 8D 4E ?? 40 89 45 ?? 83 F8 ?? 72 ?? EB ?? 33 C0 39 45 ?? 8D 58 ?? 8D 46 ?? 
            50 FF 37 75 ?? FF 15 ?? ?? ?? ?? EB ?? FF 15 ?? ?? ?? ?? 68 ?? ?? ?? ?? FF 37 FF 15 
            ?? ?? ?? ?? FF 45 ?? 8D 46 ?? 50 FF 15 ?? ?? ?? ?? 8B 4D ?? 6A ?? 8D 0C 41 8B 45 ?? 
            81 F9 ?? ?? ?? ?? 89 4D ?? 59 0F 47 C1 89 45 ?? 56 FF 75 ?? FF 15 ?? ?? ?? ?? 85 C0 
            74 ?? FF 15 ?? ?? ?? ?? 83 F8 ?? 0F 85 ?? ?? ?? ?? 85 DB 74 ?? 8B 07 33 C9 66 39 08 
            74 ?? 50 FF 15 ?? ?? ?? ?? 8B 0F 33 D2 66 89 54 41 ?? 8B 45 ?? 8B 4D ?? 89 08 68 ?? 
            ?? ?? ?? 33 C0 50 56 8B 35 ?? ?? ?? ?? FF D6 FF 75 ?? FF 15 ?? ?? ?? ?? 85 DB 75 ?? 
            68 ?? ?? ?? ?? 33 C0 50 FF 37 FF D6 8B C3 5F 5E 5B 8B E5 5D C2 
        }

        $find_files_v5 = {
            55 8B EC 83 E4 ?? 81 EC ?? ?? ?? ?? 53 56 57 33 FF 89 54 24 ?? 8B F1 89 7C 24 ?? 39 
            7D ?? 75 ?? 8D 54 24 ?? E8 ?? ?? ?? ?? 8B 5C 24 ?? 85 C0 75 ?? 85 DB 75 ?? 33 C0 E9 
            ?? ?? ?? ?? 33 DB 43 8B CE E8 ?? ?? ?? ?? 85 C0 75 ?? 66 83 3E ?? 74 ?? 8D 54 24 ?? 
            89 7C 24 ?? 8B CE E8 ?? ?? ?? ?? 89 44 24 ?? 39 7C 24 ?? 75 ?? 56 FF 15 ?? ?? ?? ?? 
            68 ?? ?? ?? ?? 56 8D 04 46 89 44 24 ?? FF 15 ?? ?? ?? ?? 6A ?? 57 57 8D 44 24 ?? 50 
            6A ?? 56 FF 15 ?? ?? ?? ?? 8B 4C 24 ?? 33 D2 89 44 24 ?? 66 89 11 83 F8 ?? 75 ?? BF 
            ?? ?? ?? ?? E9 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 44 24 ?? 50 FF 15 ?? ?? ?? ?? 85 C0 74 
            ?? 68 ?? ?? ?? ?? 8D 44 24 ?? 50 FF 15 ?? ?? ?? ?? 85 C0 74 ?? 8D 44 24 ?? 50 56 FF 
            15 ?? ?? ?? ?? F6 44 24 ?? ?? 74 ?? 85 DB 74 ?? BA ?? ?? ?? ?? 8B CE E8 ?? ?? ?? ?? 
            85 C0 74 ?? 68 ?? ?? ?? ?? 56 FF 15 ?? ?? ?? ?? 6A ?? 8B 54 24 ?? 8B CE E8 ?? ?? ?? 
            ?? EB ?? 68 ?? ?? ?? ?? 56 FF 15 ?? ?? ?? ?? 57 EB ?? FF 74 24 ?? 8D 54 24 ?? 8B CE 
            E8 ?? ?? ?? ?? 59 8B 44 24 ?? 33 C9 66 89 08 8D 44 24 ?? 50 FF 74 24 ?? FF 15 ?? ?? 
            ?? ?? 85 C0 0F 85 ?? ?? ?? ?? FF 74 24 ?? FF 15 ?? ?? ?? ?? FF 74 24 ?? FF 15 ?? ?? 
            ?? ?? 8B C7 5F 5E 5B 8B E5 5D C3 
        }

        $crypt_files_v5 = {
            55 8B EC 81 EC ?? ?? ?? ?? 53 56 57 8B D9 89 55 ?? 33 FF 89 5D ?? 21 7D ?? B9 ?? ?? 
            ?? ?? 89 7D ?? E8 ?? ?? ?? ?? 8B F0 89 75 ?? 85 F6 75 ?? 33 C0 E9 ?? ?? ?? ?? FF 75 
            ?? 8D 55 ?? 56 8D 4D ?? E8 ?? ?? ?? ?? 59 59 85 C0 75 ?? 8B CE E8 ?? ?? ?? ?? EB ?? 
            33 C0 50 68 ?? ?? ?? ?? 6A ?? 50 50 68 ?? ?? ?? ?? 53 FF 15 ?? ?? ?? ?? 8B D8 83 FB 
            ?? 75 ?? 33 C0 50 68 ?? ?? ?? ?? 6A ?? 50 50 68 ?? ?? ?? ?? FF 75 ?? FF 15 ?? ?? ?? 
            ?? 8B D8 83 FB ?? 0F 84 ?? ?? ?? ?? 8B 45 ?? FF 70 ?? FF 70 ?? 6A ?? 6A ?? 53 FF 15 
            ?? ?? ?? ?? 6A ?? 58 C6 45 ?? ?? 48 75 ?? 51 68 ?? ?? ?? ?? 8D 55 ?? 8D 8D ?? ?? ?? 
            ?? E8 ?? ?? ?? ?? 8B 45 ?? 83 C4 ?? 8B 8E ?? ?? ?? ?? 21 7D ?? 21 7D ?? 41 89 45 ?? 
            8B 45 ?? 89 45 ?? E8 ?? ?? ?? ?? 8B 8E ?? ?? ?? ?? 83 C1 ?? 89 45 ?? E8 ?? ?? ?? ?? 
            89 45 ?? 33 FF 6A ?? 8D 45 ?? 50 FF B6 ?? ?? ?? ?? FF 75 ?? 53 FF 15 ?? ?? ?? ?? 85 
            C0 0F 84 ?? ?? ?? ?? 8B 45 ?? 85 C0 0F 84 ?? ?? ?? ?? 3B 86 ?? ?? ?? ?? 8B 55 ?? 6A 
            ?? 59 0F 42 F9 83 7D ?? ?? 8D 8D ?? ?? ?? ?? 0F 45 7D ?? 01 86 ?? ?? ?? ?? 89 7D ?? 
            83 96 ?? ?? ?? ?? ?? 8B 45 ?? 50 FF 75 ?? 89 45 ?? E8 ?? ?? ?? ?? 8B 45 ?? 59 59 33 
            C9 F7 D8 41 99 51 6A ?? 52 50 53 FF 15 ?? ?? ?? ?? 6A ?? 8D 45 ?? 50 FF 75 ?? FF 75 
            ?? 53 FF 15 ?? ?? ?? ?? 85 C0 75 ?? 8B 75 ?? 8B 7D ?? 6A ?? FF 15 ?? ?? ?? ?? 6A ?? 
            8D 45 ?? 50 57 56 53 FF 15 ?? ?? ?? ?? 85 C0 74 ?? 8B 75 ?? 8B 7D ?? 33 C0 40 01 86 
            ?? ?? ?? ?? 83 96 ?? ?? ?? ?? ?? EB ?? 33 C0 8D 78 ?? 85 FF 0F 84 ?? ?? ?? ?? 83 7D 
            ?? ?? 74 ?? 6A ?? 6A ?? 0F 57 C0 66 0F 13 45 ?? FF 75 ?? FF 75 ?? 53 FF 15 ?? ?? ?? 
            ?? 6A ?? 8D 45 ?? 50 68 ?? ?? ?? ?? 56 53 FF 15 ?? ?? ?? ?? 8B 4D ?? 8B F8 89 7D ?? 
            E8 ?? ?? ?? ?? 8B 4D ?? E8 ?? ?? ?? ?? 8B CE E8 ?? ?? ?? ?? 85 DB 0F 84 ?? ?? ?? ?? 
            85 FF 0F 84 ?? ?? ?? ?? 83 7D ?? ?? 74 ?? FF 75 ?? 83 65 ?? ?? 83 65 ?? ?? 8B 35 ?? 
            ?? ?? ?? FF D6 8D 0C 45 ?? ?? ?? ?? E8 ?? ?? ?? ?? FF 75 ?? 8B F8 33 C0 40 83 67 ?? 
            ?? 88 07 FF D6 FF 75 ?? 03 C0 89 47 ?? FF D6 8D 04 45 ?? ?? ?? ?? 50 FF 75 ?? 8D 47 
            ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 6A ?? FF 75 ?? FF D6 8D 04 45 ?? ?? ?? ?? 50 57 8D 45 
            ?? 50 53 FF 15 ?? ?? ?? ?? 8B 4D ?? 89 01 8B CF E8 ?? ?? ?? ?? 8B 7D ?? 8B 45 ?? FF 
            70 ?? FF 70 ?? 6A ?? 6A ?? 53 FF 15 ?? ?? ?? ?? 53 FF 15 ?? ?? ?? ?? 8B C7 5F 5E 5B 
            8B E5 5D C3 
        }

        $remote_connection_v5 = {
            55 8B EC 83 EC ?? 53 8B 1D ?? ?? ?? ?? 56 8B F1 57 83 7E ?? ?? 74 ?? FF 76 ?? FF D3 
            8B CE E8 ?? ?? ?? ?? 33 FF 57 57 6A ?? 57 57 FF 75 ?? FF 75 ?? FF 76 ?? FF 15 ?? ?? 
            ?? ?? 89 45 ?? 85 C0 0F 84 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 4D ?? E8 ?? ?? ?? ?? 68 ?? 
            ?? ?? ?? 8D 4D ?? E8 ?? ?? ?? ?? FF 75 ?? 8B F0 68 ?? ?? ?? ?? 56 FF 15 ?? ?? ?? ?? 
            83 C4 ?? B8 ?? ?? ?? ?? 81 7D ?? ?? ?? ?? ?? B9 ?? ?? ?? ?? 0F 44 C8 57 51 57 57 68 
            ?? ?? ?? ?? 56 8B 75 ?? 68 ?? ?? ?? ?? 56 FF 15 ?? ?? ?? ?? 89 45 ?? 85 C0 74 ?? FF 
            75 ?? FF 75 ?? FF 75 ?? FF 75 ?? 50 FF 15 ?? ?? ?? ?? 85 C0 74 ?? 33 FF 47 EB ?? FF 
            15 ?? ?? ?? ?? 8B 45 ?? 50 FF D3 56 FF D3 8D 4D ?? E8 ?? ?? ?? ?? 8B C7 5F 5E 5B 8B 
            E5 5D C2 
        }

        $remote_connection_v5_0_1 = {
            55 8B EC 83 EC ?? 53 8B 1D ?? ?? ?? ?? 56 8B F1 57 83 7E ?? ?? 74 ?? FF 76 ?? FF D3 
            8B CE E8 ?? ?? ?? ?? 33 FF 57 57 6A ?? 57 57 FF 75 ?? FF 75 ?? FF 76 ?? FF 15 ?? ?? 
            ?? ?? 89 45 ?? 85 C0 0F 84 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 4D ?? E8 ?? ?? ?? ?? 68 ?? 
            ?? ?? ?? 8D 4D ?? E8 ?? ?? ?? ?? FF 75 ?? 8B F0 68 ?? ?? ?? ?? 56 FF 15 ?? ?? ?? ?? 
            83 C4 ?? B8 ?? ?? ?? ?? 81 7D ?? ?? ?? ?? ?? B9 ?? ?? ?? ?? 0F 44 C8 57 51 57 57 68 
            ?? ?? ?? ?? 56 8B 75 ?? 68 ?? ?? ?? ?? 56 FF 15 ?? ?? ?? ?? 89 45 ?? 85 C0 74 ?? FF 
            75 ?? FF 75 ?? FF 75 ?? FF 75 ?? 50 FF 15 ?? ?? ?? ?? 33 C9 41 85 C0 8B 45 ?? 0F 45 
            F9 50 FF D3 56 FF D3 8D 4D ?? E8 ?? ?? ?? ?? 8B C7 5F 5E 5B 8B E5 5D C2 
        }

        $url_parameters_setup_v5 = {
            68 ?? ?? ?? ?? 6A ?? 68 ?? ?? ?? ?? 6A ?? 68 ?? ?? ?? ?? 6A ?? 68 ?? ?? ?? ?? 6A ?? 
            68 ?? ?? ?? ?? 6A ?? 68 ?? ?? ?? ?? 6A ?? 68 ?? ?? ?? ?? 6A ?? 68 ?? ?? ?? ?? 6A ?? 
            68 ?? ?? ?? ?? 6A ?? 68 ?? ?? ?? ?? 6A ?? 68 ?? ?? ?? ?? 6A ?? 8D 8D ?? ?? ?? ?? E8 
            ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 
            ?? 8B 45 ?? 8D 8C 00 ?? ?? ?? ?? E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? ?? 
            75 ?? 6A ?? FF 15 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 68 
            ?? ?? ?? ?? FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 68 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? FF 
            15 ?? ?? ?? ?? 68 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 68 ?? ?? ?? ?? FF 
            35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? 8D 45 ?? 68 ?? ?? ?? ?? FF 35 
            ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 68 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 68 
            ?? ?? ?? ?? FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 
            D1 E0 A3 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? D1 E0 8B D0 8B 0D ?? ?? ?? 
            ?? E8 ?? ?? ?? ?? 6A ?? FF 15 ?? ?? ?? ?? 6A ?? 6A ?? 6A ?? 68 ?? ?? ?? ?? 6A ?? 6A 
            ?? FF 15 ?? ?? ?? ?? 89 45 ?? 83 7D ?? ?? 75 ?? 6A ?? FF 75 ?? FF 15 ?? ?? ?? ?? 68 
            ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 68 ?? ?? ?? ?? FF 15 
            ?? ?? ?? ?? E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 68 ?? ?? ?? ?? FF 15 ?? 
            ?? ?? ?? 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 3D ?? ?? ?? 
            ?? 73 ?? 83 65 ?? ?? 68 ?? ?? ?? ?? 8D 45 ?? 50 E8 ?? ?? ?? ?? 59 59 85 C0 74 ?? 6A 
            ?? FF 75 ?? 6A ?? 6A ?? FF 15 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A ?? FF 75 ?? FF 15 ?? ?? 
            ?? ?? 83 7D ?? ?? 74 ?? 6A ?? FF 75 ?? FF 15 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? 
            ?? ?? 8B E5 5D C3 
        }

        $url_parameters_setup_v5_0_1 = {
            68 ?? ?? ?? ?? 6A ?? 68 ?? ?? ?? ?? 6A ?? 68 ?? ?? ?? ?? 6A ?? 68 ?? ?? ?? ?? 6A ?? 
            68 ?? ?? ?? ?? 6A ?? 68 ?? ?? ?? ?? 6A ?? 68 ?? ?? ?? ?? 6A ?? 68 ?? ?? ?? ?? 6A ?? 
            68 ?? ?? ?? ?? 6A ?? 68 ?? ?? ?? ?? 6A ?? 68 ?? ?? ?? ?? 6A ?? 8D 8D ?? ?? ?? ?? E8 
            ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 
            ?? 8B 45 ?? 8D 8C 00 ?? ?? ?? ?? E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? ?? 
            75 ?? 6A ?? FF 15 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 68 
            ?? ?? ?? ?? FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 68 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? FF 
            15 ?? ?? ?? ?? 68 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 68 ?? ?? ?? ?? FF 
            35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? 8D 45 ?? 68 ?? ?? ?? ?? FF 35 
            ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 68 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 68 
            ?? ?? ?? ?? FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 
            D1 E0 A3 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? D1 E0 8B D0 8B 0D ?? ?? ?? 
            ?? E8 ?? ?? ?? ?? 6A ?? FF 15 ?? ?? ?? ?? 6A ?? 6A ?? 6A ?? 68 ?? ?? ?? ?? 6A ?? 6A 
            ?? FF 15 ?? ?? ?? ?? 89 45 ?? 83 7D ?? ?? 75 ?? 6A ?? FF 75 ?? FF 15 ?? ?? ?? ?? 68 
            ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 68 ?? ?? ?? ?? FF 15 
            ?? ?? ?? ?? E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 68 ?? ?? ?? ?? FF 15 ?? 
            ?? ?? ?? 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 3D ?? ?? ?? 
            ?? 73 ?? 83 65 ?? ?? 68 ?? ?? ?? ?? 8D 45 ?? 50 E8 ?? ?? ?? ?? 59 59 85 C0 74 ?? 6A 
            ?? FF 75 ?? 6A ?? 6A ?? FF 15 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A ?? FF 75 ?? FF 15 ?? ?? 
            ?? ?? 83 7D ?? ?? 74 ?? 6A ?? FF 75 ?? FF 15 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? 
            ?? ?? 8B E5 5D C3 
        }

        $crypt_files_v5_0_1 = {
            55 8B EC 81 EC ?? ?? ?? ?? 53 56 57 8B D9 89 55 ?? 33 FF 89 5D ?? 21 7D ?? B9 ?? ?? 
            ?? ?? 89 7D ?? E8 ?? ?? ?? ?? 8B F0 33 C0 89 75 ?? 85 F6 0F 84 ?? ?? ?? ?? 50 68 ?? 
            ?? ?? ?? 6A ?? 50 50 68 ?? ?? ?? ?? 53 FF 15 ?? ?? ?? ?? 8B D8 83 FB ?? 75 ?? 33 C0 
            50 68 ?? ?? ?? ?? 6A ?? 50 50 68 ?? ?? ?? ?? FF 75 ?? FF 15 ?? ?? ?? ?? 8B D8 83 FB 
            ?? 0F 84 ?? ?? ?? ?? 8B 7D ?? FF 77 ?? FF 77 ?? 6A ?? 6A ?? 53 FF 15 ?? ?? ?? ?? 6A 
            ?? 6A ?? 6A ?? 68 ?? ?? ?? ?? 53 FF 15 ?? ?? ?? ?? 85 C0 74 ?? 6A ?? 8D 45 ?? 50 68 
            ?? ?? ?? ?? 56 53 FF 15 ?? ?? ?? ?? 85 C0 74 ?? 81 BE ?? ?? ?? ?? ?? ?? ?? ?? 75 ?? 
            81 BE ?? ?? ?? ?? ?? ?? ?? ?? 75 ?? FF 77 ?? FF 77 ?? 6A ?? 6A ?? 53 FF 15 ?? ?? ?? 
            ?? 53 FF 15 ?? ?? ?? ?? 8B CE E8 ?? ?? ?? ?? 33 C0 E9 ?? ?? ?? ?? 6A ?? 6A ?? 0F 57 
            C0 66 0F 13 45 ?? FF 75 ?? FF 75 ?? 53 FF 15 ?? ?? ?? ?? FF 75 ?? 83 65 ?? ?? 8D 55 
            ?? 56 8D 4D ?? E8 ?? ?? ?? ?? 59 59 85 C0 74 ?? 6A ?? 58 C6 45 ?? ?? 48 75 ?? 51 68 
            ?? ?? ?? ?? 8D 55 ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 ?? 83 C4 ?? 8B 8E ?? ?? 
            ?? ?? 83 65 ?? ?? 83 65 ?? ?? 41 89 45 ?? 8B 45 ?? 89 45 ?? E8 ?? ?? ?? ?? 8B 8E ?? 
            ?? ?? ?? 83 C1 ?? 89 45 ?? E8 ?? ?? ?? ?? 89 45 ?? 33 FF 6A ?? 8D 45 ?? 50 FF B6 ?? 
            ?? ?? ?? FF 75 ?? 53 FF 15 ?? ?? ?? ?? 85 C0 0F 84 ?? ?? ?? ?? 8B 45 ?? 85 C0 0F 84 
            ?? ?? ?? ?? 3B 86 ?? ?? ?? ?? 8B 55 ?? 6A ?? 59 0F 42 F9 83 7D ?? ?? 8D 8D ?? ?? ?? 
            ?? 0F 45 7D ?? 01 86 ?? ?? ?? ?? 89 7D ?? 83 96 ?? ?? ?? ?? ?? 8B 45 ?? 50 FF 75 ?? 
            89 45 ?? E8 ?? ?? ?? ?? 8B 45 ?? 59 59 33 C9 F7 D8 41 99 51 6A ?? 52 50 53 FF 15 ?? 
            ?? ?? ?? 6A ?? 8D 45 ?? 50 FF 75 ?? FF 75 ?? 53 FF 15 ?? ?? ?? ?? 85 C0 75 ?? 8B 75 
            ?? 8B 7D ?? 6A ?? FF 15 ?? ?? ?? ?? 6A ?? 8D 45 ?? 50 57 56 53 FF 15 ?? ?? ?? ?? 85 
            C0 74 ?? 8B 75 ?? 8B 7D ?? 33 C0 40 01 86 ?? ?? ?? ?? 83 96 ?? ?? ?? ?? ?? EB ?? 33 
            C0 8D 78 ?? 85 FF 0F 84 ?? ?? ?? ?? 83 7D ?? ?? 74 ?? 6A ?? 6A ?? 0F 57 C0 66 0F 13 
            45 ?? FF 75 ?? FF 75 ?? 53 FF 15 ?? ?? ?? ?? 6A ?? 8D 45 ?? 50 68 ?? ?? ?? ?? 56 53 
            FF 15 ?? ?? ?? ?? 8B 4D ?? 8B F8 89 7D ?? E8 ?? ?? ?? ?? 8B 4D ?? E8 ?? ?? ?? ?? 8B 
            CE E8 ?? ?? ?? ?? 85 DB 0F 84 ?? ?? ?? ?? 85 FF 0F 84 ?? ?? ?? ?? 83 7D ?? ?? 74 ?? 
            FF 75 ?? 83 65 ?? ?? 83 65 ?? ?? 8B 35 ?? ?? ?? ?? FF D6 8D 0C 45 ?? ?? ?? ?? E8 ?? 
            ?? ?? ?? FF 75 ?? 8B F8 33 C0 40 83 67 ?? ?? 88 07 FF D6 FF 75 ?? 03 C0 89 47 ?? FF 
            D6 8D 04 45 ?? ?? ?? ?? 50 FF 75 ?? 8D 47 ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 6A ?? FF 75 
            ?? FF D6 8D 04 45 ?? ?? ?? ?? 50 57 8D 45 ?? 50 53 FF 15 ?? ?? ?? ?? 8B 4D ?? 89 01 
            8B CF E8 ?? ?? ?? ?? 8B 7D ?? 8B 45 ?? FF 70 ?? FF 70 ?? 6A ?? 6A ?? 53 FF 15 ?? ?? 
            ?? ?? 53 FF 15 ?? ?? ?? ?? 8B C7 5F 5E 5B 8B E5 5D C3 
        }

        $find_files_v5_0_1 = {
            55 8B EC 83 E4 ?? 81 EC ?? ?? ?? ?? 53 56 57 33 FF 89 54 24 ?? 8B F1 89 7C 24 ?? 39 
            7D ?? 75 ?? 8D 54 24 ?? E8 ?? ?? ?? ?? 8B 5C 24 ?? 85 C0 75 ?? 85 DB 75 ?? 33 C0 E9 
            ?? ?? ?? ?? 33 DB 43 8B CE E8 ?? ?? ?? ?? 85 C0 75 ?? 66 83 3E ?? 74 ?? 8D 54 24 ?? 
            89 7C 24 ?? 8B CE E8 ?? ?? ?? ?? 89 44 24 ?? 39 7C 24 ?? 75 ?? 56 FF 15 ?? ?? ?? ?? 
            68 ?? ?? ?? ?? 56 8D 04 46 89 44 24 ?? FF 15 ?? ?? ?? ?? 6A ?? 57 57 8D 44 24 ?? 50 
            6A ?? 56 FF 15 ?? ?? ?? ?? 8B 4C 24 ?? 33 D2 89 44 24 ?? 66 89 11 83 F8 ?? 75 ?? BF 
            ?? ?? ?? ?? E9 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 44 24 ?? 50 FF 15 ?? ?? ?? ?? 85 C0 74 
            ?? 68 ?? ?? ?? ?? 8D 44 24 ?? 50 FF 15 ?? ?? ?? ?? 85 C0 74 ?? 8D 44 24 ?? 50 56 FF 
            15 ?? ?? ?? ?? F6 44 24 ?? ?? 74 ?? 85 DB 74 ?? BA ?? ?? ?? ?? 8B CE E8 ?? ?? ?? ?? 
            85 C0 74 ?? 68 ?? ?? ?? ?? 56 FF 15 ?? ?? ?? ?? 6A ?? 8B 54 24 ?? 8B CE E8 ?? ?? ?? 
            ?? EB ?? 68 ?? ?? ?? ?? 56 FF 15 ?? ?? ?? ?? 57 EB ?? FF 74 24 ?? 8D 54 24 ?? 8B CE 
            E8 ?? ?? ?? ?? 59 8B 44 24 ?? 33 C9 66 89 08 8D 44 24 ?? 50 FF 74 24 ?? FF 15 ?? ?? 
            ?? ?? 85 C0 0F 85 ?? ?? ?? ?? FF 74 24 ?? FF 15 ?? ?? ?? ?? FF 74 24 ?? FF 15 ?? ?? 
            ?? ?? 8B C7 5F 5E 5B 8B E5 5D C3 
        }

        $search_antivirus_processes_v5_0_1 = {
            55 8B EC 83 EC ?? 53 56 8B 35 ?? ?? ?? ?? BB ?? ?? ?? ?? 57 6A ?? 53 68 ?? ?? ?? ?? 
            33 C0 50 FF D6 8B 7D ?? 6A ?? 53 6A ?? 33 DB 89 07 53 C7 45 ?? ?? ?? ?? ?? C7 45 ?? 
            ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? C7 45 ?? 
            ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? C7 45 ?? 
            ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? C7 45 ?? 
            ?? ?? ?? ?? FF D6 8B F0 85 F6 75 ?? 33 C0 E9 ?? ?? ?? ?? 53 6A ?? C7 06 ?? ?? ?? ?? 
            FF 15 ?? ?? ?? ?? 89 45 ?? 83 F8 ?? 75 ?? 68 ?? ?? ?? ?? 53 56 FF 15 ?? ?? ?? ?? EB 
            ?? 56 33 C9 89 5D ?? 50 89 5D ?? 89 4D ?? FF 15 ?? ?? ?? ?? 85 C0 0F 84 ?? ?? ?? ?? 
            83 7D ?? ?? 0F 85 ?? ?? ?? ?? 33 C0 8D 4E ?? 89 45 ?? 51 FF 74 85 ?? FF 15 ?? ?? ?? 
            ?? 85 C0 74 ?? 8B 45 ?? 8D 4E ?? 40 89 45 ?? 83 F8 ?? 72 ?? EB ?? 33 C0 39 45 ?? 8D 
            58 ?? 8D 46 ?? 50 FF 37 75 ?? FF 15 ?? ?? ?? ?? EB ?? FF 15 ?? ?? ?? ?? 68 ?? ?? ?? 
            ?? FF 37 FF 15 ?? ?? ?? ?? FF 45 ?? 8D 46 ?? 50 FF 15 ?? ?? ?? ?? 8B 4D ?? 6A ?? 8D 
            0C 41 8B 45 ?? 81 F9 ?? ?? ?? ?? 89 4D ?? 59 0F 47 C1 89 45 ?? 56 FF 75 ?? FF 15 ?? 
            ?? ?? ?? 85 C0 74 ?? FF 15 ?? ?? ?? ?? 83 F8 ?? 0F 85 ?? ?? ?? ?? 85 DB 74 ?? 8B 07 
            33 C9 66 39 08 74 ?? 50 FF 15 ?? ?? ?? ?? 8B 0F 33 D2 66 89 54 41 ?? 8B 45 ?? 8B 4D 
            ?? 89 08 68 ?? ?? ?? ?? 33 C0 50 56 8B 35 ?? ?? ?? ?? FF D6 FF 75 ?? FF 15 ?? ?? ?? 
            ?? 85 DB 75 ?? 68 ?? ?? ?? ?? 33 C0 50 FF 37 FF D6 8B C3 5F 5E 5B 8B E5 5D C2 
        }

        $set_url_parameters_v5_0_2 = {
            68 ?? ?? ?? ?? 6A ?? 68 ?? ?? ?? ?? 6A ?? 68 ?? ?? ?? ?? 6A ?? 68 ?? ?? ?? ?? 6A ?? 
            68 ?? ?? ?? ?? 6A ?? 68 ?? ?? ?? ?? 6A ?? 68 ?? ?? ?? ?? 6A ?? 68 ?? ?? ?? ?? 6A ?? 
            68 ?? ?? ?? ?? 6A ?? 68 ?? ?? ?? ?? 6A ?? 68 ?? ?? ?? ?? 6A ?? 8D 8D ?? ?? ?? ?? E8 
            ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 
            ?? 8B 45 ?? 8D 8C 00 ?? ?? ?? ?? E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? ?? 
            75 ?? 6A ?? FF 15 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 68 
            ?? ?? ?? ?? FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 68 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? FF 
            15 ?? ?? ?? ?? 68 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 68 ?? ?? ?? ?? FF 
            35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? 8D 45 ?? 68 ?? ?? ?? ?? FF 35 
            ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 68 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 68 
            ?? ?? ?? ?? FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 
            D1 E0 A3 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? D1 E0 8B D0 8B 0D ?? ?? ?? 
            ?? E8 ?? ?? ?? ?? 6A ?? FF 15 ?? ?? ?? ?? 6A ?? 6A ?? 6A ?? 68 ?? ?? ?? ?? 6A ?? 6A 
            ?? FF 15 ?? ?? ?? ?? 89 45 ?? 83 7D ?? ?? 75 ?? 6A ?? FF 75 ?? FF 15 ?? ?? ?? ?? 68 
            ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 68 ?? ?? ?? ?? FF 15 
            ?? ?? ?? ?? E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 68 ?? ?? ?? ?? FF 15 ?? 
            ?? ?? ?? 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 3D ?? ?? ?? 
            ?? 73 ?? 83 65 ?? ?? 68 ?? ?? ?? ?? 8D 45 ?? 50 E8 ?? ?? ?? ?? 59 59 85 C0 74 ?? 6A 
            ?? FF 75 ?? 6A ?? 6A ?? FF 15 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A ?? FF 75 ?? FF 15 ?? ?? 
            ?? ?? 83 7D ?? ?? 74 ?? 6A ?? FF 75 ?? FF 15 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? 
            ?? ?? 8B E5 5D C3 
        }

        $set_url_parameters_v5_0_3 = {
            68 ?? ?? ?? ?? 6A ?? 68 ?? ?? ?? ?? 6A ?? 68 ?? ?? ?? ?? 6A ?? 68 ?? ?? ?? ?? 6A ?? 
            68 ?? ?? ?? ?? 6A ?? 68 ?? ?? ?? ?? 6A ?? 68 ?? ?? ?? ?? 6A ?? 68 ?? ?? ?? ?? 6A ?? 
            68 ?? ?? ?? ?? 6A ?? 68 ?? ?? ?? ?? 6A ?? 68 ?? ?? ?? ?? 6A ?? 8D 8D ?? ?? ?? ?? E8 
            ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 
            ?? 8B 45 ?? 8D 8C 00 ?? ?? ?? ?? E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? ?? 
            75 ?? 6A ?? FF 15 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 68 
            ?? ?? ?? ?? FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 68 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? FF 
            15 ?? ?? ?? ?? 68 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 68 ?? ?? ?? ?? FF 
            35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? 8D 45 ?? 68 ?? ?? ?? ?? FF 35 
            ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 68 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 68 
            ?? ?? ?? ?? FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 
            D1 E0 A3 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? D1 E0 8B D0 8B 0D ?? ?? ?? 
            ?? E8 ?? ?? ?? ?? 6A ?? FF 15 ?? ?? ?? ?? 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 68 ?? ?? 
            ?? ?? FF 15 ?? ?? ?? ?? 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 68 ?? ?? ?? 
            ?? FF 15 ?? ?? ?? ?? 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 68 ?? ?? ?? ?? FF 15 ?? ?? ?? 
            ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 3D ?? ?? ?? ?? 73 ?? 83 65 ?? ?? 68 ?? ?? ?? ?? 8D 
            45 ?? 50 E8 ?? ?? ?? ?? 59 59 85 C0 74 ?? 6A ?? FF 75 ?? 6A ?? 6A ?? FF 15 ?? ?? ?? 
            ?? 68 ?? ?? ?? ?? 6A ?? FF 75 ?? FF 15 ?? ?? ?? ?? 6A ?? 6A ?? 6A ?? 68 ?? ?? ?? ?? 
            6A ?? 6A ?? FF 15 ?? ?? ?? ?? 89 45 ?? 83 7D ?? ?? 75 ?? 6A ?? FF 75 ?? FF 15 ?? ?? 
            ?? ?? 83 7D ?? ?? 74 ?? 6A ?? FF 75 ?? FF 15 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? 
            ?? ?? 8B E5 5D C3 
        }

        $search_antivirus_processes_v5_0_2 = {
            55 8B EC 83 EC ?? 53 56 8B 35 ?? ?? ?? ?? BB ?? ?? ?? ?? 57 6A ?? 53 68 ?? ?? ?? ?? 
            33 C0 50 FF D6 8B 7D ?? 6A ?? 53 6A ?? 33 DB 89 07 53 C7 45 ?? ?? ?? ?? ?? C7 45 ?? 
            ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? C7 45 ?? 
            ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? C7 45 ?? 
            ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? C7 45 ?? 
            ?? ?? ?? ?? FF D6 8B F0 85 F6 75 ?? 33 C0 E9 ?? ?? ?? ?? 53 6A ?? C7 06 ?? ?? ?? ?? 
            FF 15 ?? ?? ?? ?? 89 45 ?? 83 F8 ?? 75 ?? 68 ?? ?? ?? ?? 53 56 FF 15 ?? ?? ?? ?? EB 
            ?? 56 33 C9 89 5D ?? 50 89 5D ?? 89 4D ?? FF 15 ?? ?? ?? ?? 85 C0 0F 84 ?? ?? ?? ?? 
            83 7D ?? ?? 0F 85 ?? ?? ?? ?? 33 C0 8D 4E ?? 89 45 ?? 51 FF 74 85 ?? FF 15 ?? ?? ?? 
            ?? 85 C0 74 ?? 8B 45 ?? 8D 4E ?? 40 89 45 ?? 83 F8 ?? 72 ?? EB ?? 33 C0 39 45 ?? 8D 
            58 ?? 8D 46 ?? 50 FF 37 75 ?? FF 15 ?? ?? ?? ?? EB ?? FF 15 ?? ?? ?? ?? 68 ?? ?? ?? 
            ?? FF 37 FF 15 ?? ?? ?? ?? FF 45 ?? 8D 46 ?? 50 FF 15 ?? ?? ?? ?? 8B 4D ?? 6A ?? 8D 
            0C 41 8B 45 ?? 81 F9 ?? ?? ?? ?? 89 4D ?? 59 0F 47 C1 89 45 ?? 56 FF 75 ?? FF 15 ?? 
            ?? ?? ?? 85 C0 74 ?? FF 15 ?? ?? ?? ?? 83 F8 ?? 0F 85 ?? ?? ?? ?? 85 DB 74 ?? 8B 07 
            33 C9 66 39 08 74 ?? 50 FF 15 ?? ?? ?? ?? 8B 0F 33 D2 66 89 54 41 ?? 8B 45 ?? 8B 4D 
            ?? 89 08 68 ?? ?? ?? ?? 33 C0 50 56 8B 35 ?? ?? ?? ?? FF D6 FF 75 ?? FF 15 ?? ?? ?? 
            ?? 85 DB 75 ?? 68 ?? ?? ?? ?? 33 C0 50 FF 37 FF D6 8B C3 5F 5E 5B 8B E5 5D C2 
        }

        $find_files_v5_0_2 = {
            55 8B EC 83 E4 ?? 81 EC ?? ?? ?? ?? 53 56 57 33 FF 89 54 24 ?? 8B F1 89 7C 24 ?? 39 
            7D ?? 75 ?? 8D 54 24 ?? E8 ?? ?? ?? ?? 8B 5C 24 ?? 85 C0 75 ?? 85 DB 75 ?? 33 C0 E9 
            ?? ?? ?? ?? 33 DB 43 8B CE E8 ?? ?? ?? ?? 85 C0 75 ?? 66 83 3E ?? 74 ?? 8D 54 24 ?? 
            89 7C 24 ?? 8B CE E8 ?? ?? ?? ?? 89 44 24 ?? 39 7C 24 ?? 75 ?? 56 FF 15 ?? ?? ?? ?? 
            68 ?? ?? ?? ?? 56 8D 04 46 89 44 24 ?? FF 15 ?? ?? ?? ?? 6A ?? 57 57 8D 44 24 ?? 50 
            6A ?? 56 FF 15 ?? ?? ?? ?? 89 44 24 ?? 83 F8 ?? 75 ?? 8D 44 24 ?? 50 56 FF 15 ?? ?? 
            ?? ?? 89 44 24 ?? 8B 4C 24 ?? 33 D2 66 89 11 83 F8 ?? 75 ?? BF ?? ?? ?? ?? E9 ?? ?? 
            ?? ?? 68 ?? ?? ?? ?? 8D 44 24 ?? 50 FF 15 ?? ?? ?? ?? 85 C0 74 ?? 68 ?? ?? ?? ?? 8D 
            44 24 ?? 50 FF 15 ?? ?? ?? ?? 85 C0 74 ?? 8D 44 24 ?? 50 56 FF 15 ?? ?? ?? ?? F6 44 
            24 ?? ?? 74 ?? 85 DB 74 ?? BA ?? ?? ?? ?? 8B CE E8 ?? ?? ?? ?? 85 C0 74 ?? 68 ?? ?? 
            ?? ?? 56 FF 15 ?? ?? ?? ?? 6A ?? 8B 54 24 ?? 8B CE E8 ?? ?? ?? ?? EB ?? 68 ?? ?? ?? 
            ?? 56 FF 15 ?? ?? ?? ?? 57 EB ?? FF 74 24 ?? 8D 54 24 ?? 8B CE E8 ?? ?? ?? ?? 59 8B 
            44 24 ?? 33 C9 66 89 08 8D 44 24 ?? 50 FF 74 24 ?? FF 15 ?? ?? ?? ?? 85 C0 0F 85 ?? 
            ?? ?? ?? FF 74 24 ?? FF 15 ?? ?? ?? ?? FF 74 24 ?? FF 15 ?? ?? ?? ?? 8B C7 5F 5E 5B 
            8B E5 5D C3 
        }

        $crypt_files_v5_0_2 = {
            55 8B EC 81 EC ?? ?? ?? ?? 53 56 57 8B D9 89 55 ?? 33 FF 89 5D ?? 21 7D ?? B9 ?? ?? 
            ?? ?? 89 7D ?? E8 ?? ?? ?? ?? 8B F0 33 C0 89 75 ?? 85 F6 0F 84 ?? ?? ?? ?? 50 68 ?? 
            ?? ?? ?? 6A ?? 50 50 68 ?? ?? ?? ?? 53 FF 15 ?? ?? ?? ?? 8B D8 83 FB ?? 75 ?? 33 C0 
            50 68 ?? ?? ?? ?? 6A ?? 50 50 68 ?? ?? ?? ?? FF 75 ?? FF 15 ?? ?? ?? ?? 8B D8 83 FB 
            ?? 0F 84 ?? ?? ?? ?? 8B 7D ?? FF 77 ?? FF 77 ?? 6A ?? 6A ?? 53 FF 15 ?? ?? ?? ?? 6A 
            ?? 6A ?? 6A ?? 68 ?? ?? ?? ?? 53 FF 15 ?? ?? ?? ?? 85 C0 74 ?? 6A ?? 8D 45 ?? 50 68 
            ?? ?? ?? ?? 56 53 FF 15 ?? ?? ?? ?? 85 C0 74 ?? 81 BE ?? ?? ?? ?? ?? ?? ?? ?? 75 ?? 
            81 BE ?? ?? ?? ?? ?? ?? ?? ?? 75 ?? FF 77 ?? FF 77 ?? 6A ?? 6A ?? 53 FF 15 ?? ?? ?? 
            ?? 53 FF 15 ?? ?? ?? ?? 8B CE E8 ?? ?? ?? ?? 33 C0 E9 ?? ?? ?? ?? 6A ?? 6A ?? 0F 57 
            C0 66 0F 13 45 ?? FF 75 ?? FF 75 ?? 53 FF 15 ?? ?? ?? ?? FF 75 ?? 83 65 ?? ?? 8D 55 
            ?? 56 8D 4D ?? E8 ?? ?? ?? ?? 59 59 85 C0 74 ?? 6A ?? 58 C6 45 ?? ?? 48 75 ?? 51 68 
            ?? ?? ?? ?? 8D 55 ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 ?? 83 C4 ?? 8B 8E ?? ?? 
            ?? ?? 83 65 ?? ?? 83 65 ?? ?? 41 89 45 ?? 8B 45 ?? 89 45 ?? E8 ?? ?? ?? ?? 8B 8E ?? 
            ?? ?? ?? 83 C1 ?? 89 45 ?? E8 ?? ?? ?? ?? 89 45 ?? 33 FF 6A ?? 8D 45 ?? 50 FF B6 ?? 
            ?? ?? ?? FF 75 ?? 53 FF 15 ?? ?? ?? ?? 85 C0 0F 84 ?? ?? ?? ?? 8B 45 ?? 85 C0 0F 84 
            ?? ?? ?? ?? 3B 86 ?? ?? ?? ?? 8B 55 ?? 6A ?? 59 0F 42 F9 83 7D ?? ?? 8D 8D ?? ?? ?? 
            ?? 0F 45 7D ?? 01 86 ?? ?? ?? ?? 89 7D ?? 83 96 ?? ?? ?? ?? ?? 8B 45 ?? 50 FF 75 ?? 
            89 45 ?? E8 ?? ?? ?? ?? 8B 45 ?? 59 59 33 C9 F7 D8 41 99 51 6A ?? 52 50 53 FF 15 ?? 
            ?? ?? ?? 6A ?? 8D 45 ?? 50 FF 75 ?? FF 75 ?? 53 FF 15 ?? ?? ?? ?? 85 C0 75 ?? 8B 75 
            ?? 8B 7D ?? 6A ?? FF 15 ?? ?? ?? ?? 6A ?? 8D 45 ?? 50 57 56 53 FF 15 ?? ?? ?? ?? 85 
            C0 74 ?? 8B 75 ?? 8B 7D ?? 33 C0 40 01 86 ?? ?? ?? ?? 83 96 ?? ?? ?? ?? ?? EB ?? 33 
            C0 8D 78 ?? 85 FF 0F 84 ?? ?? ?? ?? 83 7D ?? ?? 74 ?? 6A ?? 6A ?? 0F 57 C0 66 0F 13 
            45 ?? FF 75 ?? FF 75 ?? 53 FF 15 ?? ?? ?? ?? 6A ?? 8D 45 ?? 50 68 ?? ?? ?? ?? 56 53 
            FF 15 ?? ?? ?? ?? 8B 4D ?? 8B F8 89 7D ?? E8 ?? ?? ?? ?? 8B 4D ?? E8 ?? ?? ?? ?? 8B 
            CE E8 ?? ?? ?? ?? 85 DB 0F 84 ?? ?? ?? ?? 85 FF 0F 84 ?? ?? ?? ?? 83 7D ?? ?? 74 ?? 
            FF 75 ?? 83 65 ?? ?? 83 65 ?? ?? 8B 35 ?? ?? ?? ?? FF D6 8D 0C 45 ?? ?? ?? ?? E8 ?? 
            ?? ?? ?? FF 75 ?? 8B F8 33 C0 40 83 67 ?? ?? 88 07 FF D6 FF 75 ?? 03 C0 89 47 ?? FF 
            D6 8D 04 45 ?? ?? ?? ?? 50 FF 75 ?? 8D 47 ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 6A ?? FF 75 
            ?? FF D6 8D 04 45 ?? ?? ?? ?? 50 57 8D 45 ?? 50 53 FF 15 ?? ?? ?? ?? 8B 4D ?? 89 01 
            8B CF E8 ?? ?? ?? ?? 8B 7D ?? 8B 45 ?? FF 70 ?? FF 70 ?? 6A ?? 6A ?? 53 FF 15 ?? ?? 
            ?? ?? 53 FF 15 ?? ?? ?? ?? 8B C7 5F 5E 5B 8B E5 5D C3 
        }

        $remote_connection_v5_0_2 = {
            55 8B EC 83 EC ?? 53 8B 1D ?? ?? ?? ?? 56 8B F1 57 83 7E ?? ?? 74 ?? FF 76 ?? FF D3 
            8B CE E8 ?? ?? ?? ?? 33 FF 57 57 6A ?? 57 57 FF 75 ?? FF 75 ?? FF 76 ?? FF 15 ?? ?? 
            ?? ?? 89 45 ?? 85 C0 0F 84 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 4D ?? E8 ?? ?? ?? ?? 68 ?? 
            ?? ?? ?? 8D 4D ?? E8 ?? ?? ?? ?? FF 75 ?? 8B F0 68 ?? ?? ?? ?? 56 FF 15 ?? ?? ?? ?? 
            83 C4 ?? B8 ?? ?? ?? ?? 81 7D ?? ?? ?? ?? ?? B9 ?? ?? ?? ?? 0F 44 C8 57 51 57 57 68 
            ?? ?? ?? ?? 56 8B 75 ?? 68 ?? ?? ?? ?? 56 FF 15 ?? ?? ?? ?? 89 45 ?? 85 C0 74 ?? FF 
            75 ?? FF 75 ?? FF 75 ?? FF 75 ?? 50 FF 15 ?? ?? ?? ?? 33 C9 41 85 C0 8B 45 ?? 0F 45 
            F9 50 FF D3 56 FF D3 8D 4D ?? E8 ?? ?? ?? ?? 8B C7 5F 5E 5B 8B E5 5D C2 
        }

        $crypt_files_v5_0_3 = {
            55 8B EC 81 EC ?? ?? ?? ?? 53 56 57 8B F9 89 55 ?? 33 DB B9 ?? ?? ?? ?? 89 5D ?? E8 
            ?? ?? ?? ?? 8B F0 89 75 ?? 85 F6 75 ?? 33 C0 E9 ?? ?? ?? ?? 53 68 ?? ?? ?? ?? 6A ?? 
            53 53 68 ?? ?? ?? ?? 57 FF 15 ?? ?? ?? ?? 8B F8 83 FF ?? 0F 84 ?? ?? ?? ?? 6A ?? 53 
            6A ?? 68 ?? ?? ?? ?? 57 FF 15 ?? ?? ?? ?? 85 C0 74 ?? 53 8D 45 ?? 50 68 ?? ?? ?? ?? 
            56 57 FF 15 ?? ?? ?? ?? 85 C0 74 ?? 81 BE ?? ?? ?? ?? ?? ?? ?? ?? 75 ?? 81 BE ?? ?? 
            ?? ?? ?? ?? ?? ?? 75 ?? 8B 45 ?? FF 70 ?? FF 70 ?? 53 53 57 FF 15 ?? ?? ?? ?? 57 FF 
            15 ?? ?? ?? ?? 8B CE E8 ?? ?? ?? ?? E9 ?? ?? ?? ?? 53 53 0F 57 C0 66 0F 13 45 ?? FF 
            75 ?? FF 75 ?? 57 FF 15 ?? ?? ?? ?? FF 75 ?? 8D 55 ?? 89 5D ?? 56 8D 4D ?? E8 ?? ?? 
            ?? ?? 59 59 85 C0 74 ?? 6A ?? 58 88 5D ?? 48 75 ?? 51 68 ?? ?? ?? ?? 8D 55 ?? 8D 8D 
            ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 ?? 83 C4 ?? 8B 8E ?? ?? ?? ?? 89 85 ?? ?? ?? ?? 41 
            8B 45 ?? 89 85 ?? ?? ?? ?? 89 5D ?? 89 5D ?? E8 ?? ?? ?? ?? 8B 8E ?? ?? ?? ?? 83 C1 
            ?? 89 45 ?? E8 ?? ?? ?? ?? 89 45 ?? 89 5D ?? 53 8D 45 ?? 50 FF B6 ?? ?? ?? ?? FF 75 
            ?? 57 FF 15 ?? ?? ?? ?? 85 C0 0F 84 ?? ?? ?? ?? 8B 4D ?? 85 C9 0F 84 ?? ?? ?? ?? 3B 
            8E ?? ?? ?? ?? 8B 45 ?? 6A ?? 5A 0F 42 C2 39 5D ?? 8B 55 ?? 0F 45 45 ?? 01 8E ?? ?? 
            ?? ?? 8D 8D ?? ?? ?? ?? 89 45 ?? 11 9E ?? ?? ?? ?? 8B 45 ?? 8B 75 ?? 50 56 89 45 ?? 
            E8 ?? ?? ?? ?? 8B 45 ?? 59 59 33 C9 F7 D8 41 99 51 53 52 50 57 FF 15 ?? ?? ?? ?? 8B 
            C3 89 5D ?? 83 F8 ?? 7D ?? 53 8D 45 ?? 50 FF 75 ?? 56 57 FF 15 ?? ?? ?? ?? 85 C0 75 
            ?? 6A ?? FF 15 ?? ?? ?? ?? 8B 45 ?? 40 89 45 ?? EB ?? 8B 75 ?? 33 C0 8B 4D ?? 40 01 
            86 ?? ?? ?? ?? 11 9E ?? ?? ?? ?? EB ?? 33 C0 8D 48 ?? 89 4D ?? 85 C9 0F 84 ?? ?? ?? 
            ?? 39 5D ?? 74 ?? 6A ?? 53 0F 57 C0 66 0F 13 45 ?? FF 75 ?? FF 75 ?? 57 FF 15 ?? ?? 
            ?? ?? 53 8D 45 ?? 50 68 ?? ?? ?? ?? 56 57 FF 15 ?? ?? ?? ?? 8B 4D ?? 8B D8 E8 ?? ?? 
            ?? ?? 8B 4D ?? E8 ?? ?? ?? ?? 8B CE E8 ?? ?? ?? ?? 83 FF ?? 74 ?? 8B 45 ?? 57 83 08 
            ?? FF 15 ?? ?? ?? ?? 8B C3 5F 5E 5B 8B E5 5D C3 
        }

        $remote_connection_v5_0_3 = {
            55 8B EC 81 EC ?? ?? ?? ?? 53 56 57 68 ?? ?? ?? ?? 33 DB 8D 85 ?? ?? ?? ?? 8B F1 53 
            50 89 75 ?? E8 ?? ?? ?? ?? 83 C4 ?? 8B FB 0F B7 04 5E 66 85 C0 74 ?? 83 F8 ?? 75 ?? 
            83 C3 ?? 56 89 5D ?? FF 15 ?? ?? ?? ?? 3B D8 73 ?? 8D 14 1B 0F B7 04 32 EB ?? 66 83 
            F8 ?? 74 ?? 43 0F B7 04 5E 66 85 C0 75 ?? EB ?? 8B CB 2B 4D ?? 74 ?? 03 F2 8D BD ?? 
            ?? ?? ?? D1 E9 F3 A5 13 C9 66 F3 A5 8B 75 ?? 8D 43 ?? 8D 04 46 50 8D 85 ?? ?? ?? ?? 
            50 FF 15 ?? ?? ?? ?? 33 FF 47 43 85 FF 74 ?? 8D 4D ?? E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? 
            ?? 8D 7D ?? 6A ?? 59 BE ?? ?? ?? ?? F3 A5 8B 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F8 85 
            FF 74 ?? 51 8D 45 ?? 50 FF 15 ?? ?? ?? ?? 50 8D 45 ?? 50 83 EC ?? 57 FF 15 ?? ?? ?? 
            ?? 50 57 8D 85 ?? ?? ?? ?? 50 8D 85 ?? ?? ?? ?? 50 8D 4D ?? E8 ?? ?? ?? ?? 8B CF 8B 
            F0 E8 ?? ?? ?? ?? EB ?? 33 F6 83 7D ?? ?? 74 ?? FF 75 ?? FF 15 ?? ?? ?? ?? 5F 8B C6 
            5E 5B 8B E5 5D C3 
        }

    condition:
        uint16(0) == 0x5A4D and (($search_antivirus_processes and $find_files and $crypt_files and $remote_connection) or
        ($find_files_v2 and $crypt_files_v2 and $search_antivirus_processes_v2 and $remote_connection_v2) or
        ($search_antivirus_processes_v2 and $find_files_v2_1 and $crypt_files_v2_1 and $remote_connection_v2_1) or
        ($search_antivirus_processes_v4_1_2 and $find_files_v4_1_2 and $crypt_files_v4_1_2 and $remote_connection_v4_1_2 and $url_parameters_setup_v4_1_2) or
        ($search_antivirus_processes_v4 and $find_files_v4 and $crypt_files_v4 and $url_parameters_setup_v4) or
        ($search_antivirus_processes_v2 and $find_files_v2_1 and $remote_connection_v2_1 and $crypt_files_v3) or
        ($search_antivirus_processes_v5 and $find_files_v5 and $crypt_files_v5 and $remote_connection_v5 and $url_parameters_setup_v5) or
        ($search_antivirus_processes_v5_0_1 and $find_files_v5_0_1 and $crypt_files_v5_0_1 and $url_parameters_setup_v5_0_1 and $remote_connection_v5_0_1) or
        ($search_antivirus_processes_v5_0_2 and $find_files_v5_0_2 and $crypt_files_v5_0_2 and $set_url_parameters_v5_0_2 and $remote_connection_v5_0_2) or 
        ($search_antivirus_processes_v5_0_2 and $find_files_v5_0_2 and $crypt_files_v5_0_3 and $set_url_parameters_v5_0_3 and $remote_connection_v5_0_3))
}