rule Win32_Ransomware_Hermes : tc_detection malicious
{
    meta:

        author              = "ReversingLabs"

        source              = "ReversingLabs"
        status              = "RELEASED"
        sharing             = "TLP:WHITE"
        category            = "MALWARE"
        malware             = "HERMES"
        description         = "Yara rule that detects Hermes ransomware."

        tc_detection_type   = "Ransomware"
        tc_detection_name   = "Hermes"
        tc_detection_factor = 5

    strings:

        $hermes_find_files_v1_p1 = {
            A5 A5 A5 8D BD ?? ?? ?? ?? 66 AB BE ?? ?? ?? ?? 8D BD ?? ?? ?? ?? A5 A5 66 A5 68 ?? 
            ?? ?? ?? 8D BD ?? ?? ?? ?? 50 AB 8D 85 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 83 65 
            ?? ?? 8B 5D ?? 8B FB 4F 4F 8D 47 ?? 66 8B 4F ?? 47 47 66 85 C9 75 ?? BE ?? ?? ?? ?? 
            A5 A5 8D 8D ?? ?? ?? ?? 51 50 66 A5 FF 15 ?? ?? ?? ?? 68 ?? ?? ?? ?? 53 89 45 ?? E8 
            ?? ?? ?? ?? 59 59 8B C8 E8 ?? ?? ?? ?? 8B CB 8B D0 E8 ?? ?? ?? ?? 2B C2 33 C9 83 7D 
            ?? ?? 66 89 0C 43 0F 84 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 F8 ?? 75 ?? 
            8B C1 6A ?? 50 E8 ?? ?? ?? ?? 59 59 85 C0 74 ?? 8D 85 ?? ?? ?? ?? 50 FF 75 ?? FF 15 
            ?? ?? ?? ?? 85 C0 0F 84 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 F8 ?? 75 ?? 
            8B C1 68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 59 85 C0 74 ?? 8D 85 ?? ?? ?? ?? 50 FF 75 
            ?? FF 15 ?? ?? ?? ?? 85 C0 0F 84 ?? ?? ?? ?? BE ?? ?? ?? ?? 8D 7D ?? A5 A5 A5 A5 33
        }

        $hermes_find_files_v1_p2 = {
            C0 6A ?? 59 6A ?? 8D 7D ?? 66 AB BE ?? ?? ?? ?? 8D BD ?? ?? ?? ?? F3 A5 59 BE ?? ?? 
            ?? ?? 8D BD ?? ?? ?? ?? F3 A5 BE ?? ?? ?? ?? 8D 7D ?? A5 A5 A5 A5 6A ?? 59 8D 7D ?? 
            AB BE ?? ?? ?? ?? 8D BD ?? ?? ?? ?? F3 A5 8D BD ?? ?? ?? ?? AB AB 66 AB BE ?? ?? ?? 
            ?? 8D 7D ?? A5 A5 A5 A5 33 C0 6A ?? 8D 7D ?? AB 59 BE ?? ?? ?? ?? 8D BD ?? ?? ?? ?? 
            F3 A5 66 A5 8D BD ?? ?? ?? ?? AB BE ?? ?? ?? ?? 8D BD ?? ?? ?? ?? A5 A5 A5 A5 8D BD 
            ?? ?? ?? ?? AB AB AB 66 AB 8D 45 ?? 50 8D 85 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 59 85 
            C0 0F 85 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 50 8D 85 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 59 
            85 C0 0F 85 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 50 8D 85 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 
            59 85 C0 75 ?? 8D 45 ?? 50 8D 85 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 59 85 C0 75 ?? 8D 
            85 ?? ?? ?? ?? 50 8D 85 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 59 85 C0 75 ?? 8D 45 ?? 50 
            8D 85 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 59 85 C0 75 ?? 8D 85 ?? ?? ?? ?? 50 8D 85 ?? 
            ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 59 85 C0 75 ?? 8D 85 ?? ?? ?? ?? E9 ?? ?? ?? ?? 8D 85 
            ?? ?? ?? ?? 50 FF 75 ?? FF 15 ?? ?? ?? ?? 85 C0 8D 45 ?? 50 8D 85 ?? ?? ?? ?? 50 0F
        }

        $hermes_find_files_v1_p3 = {
            84 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 59 85 C0 75 ?? 8D 85 ?? ?? ?? ?? 50 8D 85 ?? ?? ?? 
            ?? 50 E8 ?? ?? ?? ?? 59 59 85 C0 75 ?? 8D 85 ?? ?? ?? ?? 50 8D 85 ?? ?? ?? ?? 50 E8 
            ?? ?? ?? ?? 59 59 85 C0 75 ?? 8D 45 ?? 50 8D 85 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 59 
            85 C0 75 ?? 8D 85 ?? ?? ?? ?? 50 8D 85 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 59 85 C0 0F 
            85 ?? ?? ?? ?? 8D 45 ?? 50 8D 85 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 59 85 C0 0F 85 ?? 
            ?? ?? ?? 8D 85 ?? ?? ?? ?? 50 8D 85 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 59 85 C0 0F 85 
            ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 50 8D 85 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 59 85 C0 0F 
            85 ?? ?? ?? ?? E9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 59 85 C0 0F 85 ?? ?? ?? ?? 8D 85 ?? 
            ?? ?? ?? 50 8D 85 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 59 85 C0 0F 85 ?? ?? ?? ?? 8D 85 
            ?? ?? ?? ?? 50 8D 85 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 59 85 C0 0F 85 ?? ?? ?? ?? 8D
        }

        $hermes_find_files_v1_p4 = {
            45 ?? 50 8D 85 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 59 85 C0 0F 85 ?? ?? ?? ?? 8D 85 ?? 
            ?? ?? ?? 50 8D 85 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 59 85 C0 0F 85 ?? ?? ?? ?? 8D 45 
            ?? 50 8D 85 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 59 85 C0 0F 85 ?? ?? ?? ?? 8D 85 ?? ?? 
            ?? ?? 50 8D 85 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 59 85 C0 0F 85 ?? ?? ?? ?? 8D 85 ?? 
            ?? ?? ?? 50 8D 85 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 59 85 C0 0F 85 ?? ?? ?? ?? F6 85 
            ?? ?? ?? ?? ?? 0F 84 ?? ?? ?? ?? F6 85 ?? ?? ?? ?? ?? 0F 85 ?? ?? ?? ?? 68 ?? ?? ?? 
            ?? 53 E8 ?? ?? ?? ?? 59 59 85 C0 74 ?? 8B C8 E8 ?? ?? ?? ?? 83 F8 ?? 7E ?? 53 FF 75 
            ?? FF 75 ?? E8
        }

        $hermes_encrypt_files_v1_p1 = {
            55 8B EC 83 EC ?? 53 56 57 FF 75 ?? FF 15 ?? ?? ?? ?? BB ?? ?? ?? ?? 3B C3 74 ?? 53 
            FF 75 ?? FF 15 ?? ?? ?? ?? 33 F6 56 53 6A ?? 56 56 68 ?? ?? ?? ?? FF 75 ?? FF 15 ?? 
            ?? ?? ?? 89 45 ?? 3B C6 0F 84 ?? ?? ?? ?? 8D 4D ?? 51 50 FF 15 ?? ?? ?? ?? 89 45 ?? 
            83 F8 ?? 0F 84 ?? ?? ?? ?? 83 F8 ?? 0F 82 ?? ?? ?? ?? 56 89 45 ?? 8D 45 ?? 50 56 56 
            6A ?? 56 FF 75 ?? FF 15 ?? ?? ?? ?? 85 C0 74 ?? 6A ?? BF ?? ?? ?? ?? 57 FF 75 ?? 56 
            FF 15 ?? ?? ?? ?? 89 45 ?? 3B C6 74 ?? 56 8D 4D ?? 51 FF 75 ?? 89 75 ?? 50 FF 75 ?? 
            FF 15 ?? ?? ?? ?? 85 C0 74 ?? 8B 45 ?? 8B 4D ?? 8D 44 08 ?? 80 38 ?? 75 ?? 80 78 ?? 
            ?? 75 ?? 80 78 ?? ?? 75 ?? 80 78 ?? ?? 75 ?? 80 78 ?? ?? 75 ?? 80 78 ?? ?? 75 ?? FF 
            75 ?? FF 15 ?? ?? ?? ?? 68 ?? ?? ?? ?? 56 FF 75 ?? FF 15 ?? ?? ?? ?? 33 C0 5F 5E 5B 
        }

        $hermes_encrypt_files_v1_p2 = {
            C9 C3 FF 75 ?? 8D 45 ?? 50 51 56 6A ?? 56 FF 75 ?? FF 15 ?? ?? ?? ?? 85 C0 74 ?? 56 
            56 56 FF 75 ?? FF 15 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 E8 ?? ?? ?? 
            ?? 6A ?? 57 FF 75 ?? 88 45 ?? 56 FF 15 ?? ?? ?? ?? 8B F8 89 7D ?? 3B FE 74 ?? FF 75 
            ?? 0F BE 45 ?? 50 57 E8 ?? ?? ?? ?? 83 C4 ?? 56 8D 45 ?? 50 FF 75 ?? 89 75 ?? 57 FF 
            75 ?? FF 15 ?? ?? ?? ?? 85 C0 0F 84 ?? ?? ?? ?? BF ?? ?? ?? ?? 57 56 FF 75 ?? FF 15 
            ?? ?? ?? ?? FF 75 ?? FF 15 ?? ?? ?? ?? 56 53 6A ?? 56 56 68 ?? ?? ?? ?? FF 75 ?? FF 
            15 ?? ?? ?? ?? 8B D8 3B DE 0F 84 ?? ?? ?? ?? 56 8D 45 ?? 50 FF 75 ?? 89 75 ?? FF 75 
            ?? 53 FF 15 ?? ?? ?? ?? 85 C0 0F 84 ?? ?? ?? ?? 56 8D 45 ?? 50 6A ?? 68 ?? ?? ?? ?? 
            53 89 75 ?? FF 15 ?? ?? ?? ?? 85 C0 0F 84 ?? ?? ?? ?? 53 FF 15 ?? ?? ?? ?? 57 56 FF 
            75 ?? FF 15 ?? ?? ?? ?? 33 C0 40 E9 
        }

        $hermes_enum_resources_v1 = {
            55 8B EC 83 EC ?? 53 56 57 8D 45 ?? 50 FF 75 ?? C7 45 ?? ?? ?? ?? ?? 6A ?? 6A ?? 6A 
            ?? C7 45 ?? ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 85 C0 0F 85 ?? ?? ?? ?? FF 75 ?? 6A ?? FF 
            15 ?? ?? ?? ?? 8B D8 85 DB 0F 84 ?? ?? ?? ?? FF 75 ?? 6A ?? 53 E8 ?? ?? ?? ?? 83 C4 
            ?? 8D 45 ?? 50 53 8D 45 ?? 50 FF 75 ?? FF 15 ?? ?? ?? ?? 85 C0 0F 85 ?? ?? ?? ?? 8B 
            43 ?? 66 83 38 ?? 8D 48 ?? 75 ?? 66 83 78 ?? ?? 75 ?? 6A ?? 51 E8 ?? ?? ?? ?? 59 59 
            85 C0 74 ?? 8B 43 ?? 8B D0 66 8B 08 40 40 66 85 C9 75 ?? 8B 7D ?? 2B C2 4F 4F 66 8B 
            4F ?? 47 47 66 85 C9 75 ?? 8B C8 C1 E9 ?? 8B F2 F3 A5 8B C8 83 E1 ?? F3 A4 8B 7D ?? 
            4F 4F 66 8B 47 ?? 47 47 66 85 C0 75 ?? BE ?? ?? ?? ?? A5 8B 43 ?? 83 E0 ?? 3C ?? 0F 
            85 ?? ?? ?? ?? FF 75 ?? 53 E8 ?? ?? ?? ?? 59 59 85 C0 0F 85 ?? ?? ?? ?? 33 C0 5F 5E 
            5B C9 C3 33 C0 40 EB
        }

        $hermes_encrypt_files_v2_p1 = {
            55 8B EC 81 EC ?? ?? ?? ?? 53 56 57 33 C0 8D BD ?? ?? ?? ?? AB 33 DB 89 5D ?? AB AB 
            AB 8B 7D ?? 57 FF 15 ?? ?? ?? ?? BE ?? ?? ?? ?? 56 57 FF 15 ?? ?? ?? ?? 53 56 6A ?? 
            53 53 68 ?? ?? ?? ?? 57 FF 15 ?? ?? ?? ?? 8B F0 85 F6 75 ?? 53 FF 15 ?? ?? ?? ?? 33 
            C0 E9 ?? ?? ?? ?? 33 DB 33 C0 89 5D ?? 0F 57 C0 89 45 ?? 66 0F 13 45 ?? 83 FE ?? 74 
            ?? 8D 45 ?? 50 56 FF 15 ?? ?? ?? ?? 8D 45 ?? 50 56 FF 15 ?? ?? ?? ?? 8B 5D ?? 8B 45 
            ?? 83 FB ?? 75 ?? 85 C0 75 ?? 33 FF 47 E9 ?? ?? ?? ?? 83 65 ?? ?? 83 7D ?? ?? 77 ?? 
            81 7D ?? ?? ?? ?? ?? 0F 86 ?? ?? ?? ?? 6A ?? 6A ?? FF 75 ?? FF 75 ?? E8 ?? ?? ?? ?? 
            6A ?? 6A ?? 52 50 E8 ?? ?? ?? ?? 6A ?? 68 ?? ?? ?? ?? 52 50 E8 ?? ?? ?? ?? 8B 4D ?? 
            89 45 ?? 83 F9 ?? 72 ?? 77 ?? 81 7D ?? ?? ?? ?? ?? 76 ?? 6A ?? 6A ?? 51 FF 75 ?? E8 
            ?? ?? ?? ?? 6A ?? 68 ?? ?? ?? ?? 52 50 E8 ?? ?? ?? ?? 89 45 ?? 3D ?? ?? ?? ?? 76 ?? 
            C7 45 ?? ?? ?? ?? ?? EB ?? 8B 55 ?? 8B C1 81 C2 ?? ?? ?? ?? 83 D0 ?? 83 F8 ?? 77 ?? 
            72 ?? 81 FA ?? ?? ?? ?? 77 ?? 6A ?? 6A ?? 51 FF 75 ?? E8 ?? ?? ?? ?? 6A ?? 6A ?? 52 
            50 E8 ?? ?? ?? ?? 6A ?? 68 ?? ?? ?? ?? 52 50 E8 ?? ?? ?? ?? 89 45 ?? EB ?? 83 F9
        }

        $hermes_encrypt_files_v2_p2 = {
            77 ?? 72 ?? 81 7D ?? ?? ?? ?? ?? 73 ?? 8B 45 ?? EB ?? 8B 45 ?? 3D ?? ?? ?? ?? 0F 87 
            ?? ?? ?? ?? 85 C0 0F 84 ?? ?? ?? ?? 83 7D ?? ?? 77 ?? 0F 82 ?? ?? ?? ?? 83 7D ?? ?? 
            0F 82 ?? ?? ?? ?? 83 7D ?? ?? 0F 84 ?? ?? ?? ?? 83 7D ?? ?? B8 ?? ?? ?? ?? 77 ?? 39 
            45 ?? 0F 86 ?? ?? ?? ?? 6A ?? 6A ?? FF 75 ?? 2B D8 53 56 89 5D ?? FF 15 ?? ?? ?? ?? 
            83 F8 ?? 75 ?? 6A ?? 58 E9 ?? ?? ?? ?? 33 DB 8D 45 ?? 53 50 6A ?? 8D 85 ?? ?? ?? ?? 
            89 5D ?? 50 56 FF 15 ?? ?? ?? ?? 85 C0 75 ?? 6A ?? EB ?? 8B C3 80 BC 05 ?? ?? ?? ?? 
            ?? 75 ?? 80 BC 05 ?? ?? ?? ?? ?? 75 ?? 80 BC 05 ?? ?? ?? ?? ?? 75 ?? 80 BC 05 ?? ?? 
            ?? ?? ?? 75 ?? 80 BC 05 ?? ?? ?? ?? ?? 75 ?? 80 BC 05 ?? ?? ?? ?? ?? 74 ?? 40 83 F8 
            ?? 72 ?? 53 53 53 56 FF 15 ?? ?? ?? ?? 83 F8 ?? 0F 85 ?? ?? ?? ?? 6A ?? E9 ?? ?? ?? 
            ?? 56 FF 15 ?? ?? ?? ?? 6A ?? 58 6A ?? 66 89 45 ?? 58 66 89 45 ?? 6A ?? 58 66 89 45 
            ?? 33 C0 66 89 45 ?? 8D 45 ?? 50 57 E8 ?? ?? ?? ?? 59 59 85 C0 75 ?? 6A ?? 68 ?? ?? 
            ?? ?? 68 ?? ?? ?? ?? 53 FF 15 ?? ?? ?? ?? 8B F0 85 F6 74 ?? 57 56 89 1E E8 ?? ?? ?? 
            ?? 57 56 E8 ?? ?? ?? ?? 8D 45 ?? 50 56 E8 ?? ?? ?? ?? 83 C4 ?? 6A ?? 56 57 FF 15 ?? 
            ?? ?? ?? 68 ?? ?? ?? ?? 53 56 FF 15 ?? ?? ?? ?? 6A ?? E9 ?? ?? ?? ?? 33 DB 8D 45
        }

        $hermes_encrypt_files_v2_p3 = {
            50 6A ?? 68 ?? ?? ?? ?? FF 75 ?? FF 15 ?? ?? ?? ?? 85 C0 75 ?? 6A ?? E9 ?? ?? ?? ?? 
            39 5D ?? 77 ?? 81 7D ?? ?? ?? ?? ?? 77 ?? 53 53 68 ?? ?? ?? ?? FF 75 ?? FF 75 ?? E8 
            ?? ?? ?? ?? 89 5D ?? 5B 6A ?? 89 4D ?? 33 DB 89 45 ?? 89 55 ?? 5F EB ?? 8B 45 ?? 89 
            45 ?? 53 69 C0 ?? ?? ?? ?? 53 50 56 FF 15 ?? ?? ?? ?? 83 F8 ?? 75 ?? 6A ?? E9 ?? ?? 
            ?? ?? 53 8D 45 ?? 89 5D ?? 50 6A ?? 5F 57 8D 85 ?? ?? ?? ?? 50 56 FF 15 ?? ?? ?? ?? 
            85 C0 75 ?? 6A ?? E9 ?? ?? ?? ?? 53 53 53 56 FF 15 ?? ?? ?? ?? 83 F8 ?? 75 ?? 6A ?? 
            E9 ?? ?? ?? ?? 89 5D ?? 6A ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 53 FF 15 ?? ?? ?? ?? 8B 
            D8 85 DB 75 ?? 6A ?? E9 ?? ?? ?? ?? 8B 55 ?? 33 C9 33 C0 C7 45 ?? ?? ?? ?? ?? 89 4D 
            ?? 89 45 ?? 83 65 ?? ?? C7 45 ?? ?? ?? ?? ?? 3B CA 75 ?? 8B 4D ?? 89 4D ?? C7 45 ?? 
            ?? ?? ?? ?? 33 C9 51 51 50 56 89 4D ?? FF 15 ?? ?? ?? ?? 83 F8 ?? 0F 84 ?? ?? ?? ?? 
            6A ?? 8D 45 ?? 50 FF 75 ?? 53 56 FF 15 ?? ?? ?? ?? 85 C0 0F 84 ?? ?? ?? ?? 33 C9 C7 
        }

        $hermes_encrypt_files_v2_p4 = {
            45 ?? ?? ?? ?? ?? 51 8D 45 ?? 50 51 51 FF 75 ?? 51 FF 75 ?? FF 15 ?? ?? ?? ?? 85 C0 
            0F 84 ?? ?? ?? ?? FF 75 ?? 8D 45 ?? 50 53 6A ?? FF 75 ?? 6A ?? FF 75 ?? FF 15 ?? ?? 
            ?? ?? 85 C0 0F 84 ?? ?? ?? ?? 6A ?? 6A ?? FF 75 ?? 56 FF 15 ?? ?? ?? ?? 83 F8 ?? 0F 
            84 ?? ?? ?? ?? 83 65 ?? ?? 8D 45 ?? 6A ?? 50 FF 75 ?? 53 56 FF 15 ?? ?? ?? ?? 85 C0 
            0F 84 ?? ?? ?? ?? 8B 4D ?? 8B 45 ?? 41 8B 55 ?? 05 ?? ?? ?? ?? 89 4D ?? 89 45 ?? 3B 
            CA 0F 86 ?? ?? ?? ?? 33 C0 C7 45 ?? ?? ?? ?? ?? 8D 7D ?? 66 C7 45 ?? ?? ?? AB AB AB 
            AB 66 AB 33 C0 88 45 ?? 39 45 ?? 77 ?? 81 7D ?? ?? ?? ?? ?? 77 ?? 8D 45 ?? 50 8D 45 
            ?? 50 E8 ?? ?? ?? ?? 59 59 EB ?? 6A ?? 50 50 50 56 FF 15 ?? ?? ?? ?? 33 C0 8D 7D ?? 
            AB 6A ?? AB 66 AB 8D 45 ?? 50 8B 45 ?? 50 E8 ?? ?? ?? ?? 8D 45 ?? 68 ?? ?? ?? ?? 50 
            E8 ?? ?? ?? ?? 8D 45 ?? 50 8D 45 ?? 50 E8 ?? ?? ?? ?? 8D 45 ?? 68 ?? ?? ?? ?? 50 E8 
            ?? ?? ?? ?? 8D 45 ?? 50 8D 45 ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 33 FF 8D 45 ?? 57 50 8D 
            45 ?? 89 7D ?? 50 E8 ?? ?? ?? ?? 59 50 8D 45 ?? 50 56 FF 15 ?? ?? ?? ?? 85 C0 75 ?? 
            68 ?? ?? ?? ?? 57 53 FF 15 ?? ?? ?? ?? 6A ?? E9 ?? ?? ?? ?? 8D 45 ?? 50 57 57 6A
        }

        $hermes_encrypt_files_v2_p5 = {
            FF 75 ?? FF 75 ?? FF 15 ?? ?? ?? ?? 85 C0 75 ?? 68 ?? ?? ?? ?? 57 53 FF 15 ?? ?? ?? 
            ?? 6A ?? E9 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 57 50 E8 ?? ?? ?? ?? 83 C4 
            ?? 8D 45 ?? 50 8D 85 ?? ?? ?? ?? 50 57 6A ?? FF 75 ?? FF 75 ?? FF 15 ?? ?? ?? ?? 85 
            C0 75 ?? 68 ?? ?? ?? ?? 57 53 FF 15 ?? ?? ?? ?? 6A ?? E9 ?? ?? ?? ?? 57 8D 45 ?? 89 
            7D ?? 50 FF 75 ?? 8D 85 ?? ?? ?? ?? 50 56 FF 15 ?? ?? ?? ?? 85 C0 75 ?? 68 ?? ?? ?? 
            ?? 57 53 FF 15 ?? ?? ?? ?? 6A ?? E9 ?? ?? ?? ?? 39 7D ?? 77 ?? 81 7D ?? ?? ?? ?? ?? 
            76 ?? 6A ?? 57 0F 57 C0 66 0F 13 45 ?? FF 75 ?? FF 75 ?? 56 FF 15 ?? ?? ?? ?? 83 F8 
            ?? 75 ?? 68 ?? ?? ?? ?? 57 53 FF 15 ?? ?? ?? ?? 6A ?? EB ?? 57 8D 45 ?? 89 7D ?? 50 
            6A ?? 8D 85 ?? ?? ?? ?? 50 56 FF 15 ?? ?? ?? ?? 85 C0 75 ?? 68 ?? ?? ?? ?? 57 53 FF 
            15 ?? ?? ?? ?? 6A ?? EB ?? 56 FF 15 ?? ?? ?? ?? 68 ?? ?? ?? ?? 57 53 E8 ?? ?? ?? ?? 
            83 C4 ?? 68 ?? ?? ?? ?? 57 53 FF 15 ?? ?? ?? ?? 6A ?? 5B EB ?? 68 ?? ?? ?? ?? 6A ?? 
            53 FF 15 ?? ?? ?? ?? 6A ?? 5B 56 FF 15 ?? ?? ?? ?? FF 75 ?? FF 15 ?? ?? ?? ?? 8B C3 
            EB ?? FF 75 ?? FF 15 ?? ?? ?? ?? 56 FF 15 ?? ?? ?? ?? 6A ?? EB ?? FF 75 ?? FF 15 ?? 
            ?? ?? ?? 56 FF 15 ?? ?? ?? ?? 6A ?? EB ?? FF 75 ?? FF 15 ?? ?? ?? ?? 56 FF 15 ?? ?? 
            ?? ?? 6A ?? 5F EB ?? 6A ?? 5F 56 FF 15 ?? ?? ?? ?? FF 75 ?? FF 15 ?? ?? ?? ?? 68 ?? 
            ?? ?? ?? 6A ?? 53 FF 15 ?? ?? ?? ?? EB ?? 6A ?? E9 ?? ?? ?? ?? 6A ?? 5F 56 FF 15 ?? 
            ?? ?? ?? 8B C7 5F 5E 5B 8B E5 5D C3 
        }

        $hermes_find_files_v2_p1 = {
            55 8B EC 81 EC ?? ?? ?? ?? 53 8B 5D ?? 8D 85 ?? ?? ?? ?? 56 57 50 68 ?? ?? ?? ?? 53 
            E8 ?? ?? ?? ?? 59 59 50 FF 15 ?? ?? ?? ?? 8B F8 68 ?? ?? ?? ?? 53 89 7D ?? E8 ?? ?? 
            ?? ?? 50 E8 ?? ?? ?? ?? 53 8B F0 E8 ?? ?? ?? ?? 2B C6 33 C9 83 C4 ?? 66 89 0C 43 83 
            FF ?? 0F 84 ?? ?? ?? ?? 33 F6 8D 85 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 83 F8 ?? 75 ?? 
            8D 85 ?? ?? ?? ?? 6A ?? 50 E8 ?? ?? ?? ?? 59 59 85 C0 74 ?? 8D 85 ?? ?? ?? ?? 50 57 
            FF 15 ?? ?? ?? ?? 85 C0 0F 84 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 83 
            F8 ?? 75 ?? 8D 85 ?? ?? ?? ?? 68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 59 85 C0 74 ?? 8D 
            85 ?? ?? ?? ?? 50 57 FF 15 ?? ?? ?? ?? 85 C0 0F 84 ?? ?? ?? ?? 6A ?? 58 6A ?? 5F 6A 
            ?? 5A 6A ?? 66 89 45 ?? 58 6A ?? 59 6A ?? 66 89 45 ?? 58 6A ?? 66 89 45 ?? 58 6A ?? 
            66 89 45 ?? 33 C0 89 45 ?? 58 6A ?? 66 89 45 ?? 58 6A ?? 66 89 45 ?? 58 6A ?? 66 89
        }

        $hermes_find_files_v2_p2 = {
            45 ?? 58 6A ?? 66 89 45 ?? 58 6A ?? 66 89 45 ?? 33 C0 66 89 45 ?? 58 6A ?? 66 89 45 
            ?? 58 6A ?? 66 89 45 ?? 58 6A ?? 66 89 45 ?? 58 6A ?? 66 89 45 ?? 33 C0 66 89 55 ?? 
            66 89 55 ?? 5A 6A ?? 66 89 45 ?? 58 6A ?? 66 89 85 ?? ?? ?? ?? 58 6A ?? 66 89 4D ?? 
            66 89 4D ?? 66 89 8D ?? ?? ?? ?? 59 66 89 85 ?? ?? ?? ?? 6A ?? 58 66 89 85 ?? ?? ?? 
            ?? 33 C0 66 89 7D ?? 66 89 BD ?? ?? ?? ?? 8D 7D ?? 89 75 ?? 66 89 75 ?? 66 89 55 ?? 
            89 75 ?? 66 89 75 ?? 66 89 8D ?? ?? ?? ?? 66 89 8D ?? ?? ?? ?? 66 89 85 ?? ?? ?? ?? 
            AB 6A ?? 66 89 4D ?? 66 89 55 ?? AB 66 89 55 ?? 89 75 ?? AB 66 AB 58 6A ?? 66 89 45 
            ?? 58 6A ?? 5F 6A ?? 66 89 45 ?? 58 6A ?? 66 89 45 ?? 58 6A ?? 66 89 45 ?? 58 6A ?? 
            66 89 45 ?? 58 6A ?? 66 89 45 ?? 58 6A ?? 59 66 89 45 ?? 33 C0 66 89 45 ?? 6A ?? 58 
            66 89 85 ?? ?? ?? ?? 6A ?? 58 66 89 85 ?? ?? ?? ?? 6A ?? 58 66 89 85 ?? ?? ?? ?? 6A 
            ?? 58 66 89 85 ?? ?? ?? ?? 6A ?? 58 66 89 85 ?? ?? ?? ?? 33 C0 66 89 7D ?? 66 89 7D 
            ?? 8D BD ?? ?? ?? ?? 66 89 85 ?? ?? ?? ?? 66 89 8D ?? ?? ?? ?? 66 89 8D
        }

        $hermes_find_files_v2_p3 = {
            AB AB AB 66 AB 8D 45 ?? 50 8D 85 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 59 85 C0 75 ?? 8D 
            45 ?? 50 8D 85 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 59 85 C0 75 ?? 8D 45 ?? 50 8D 85 ?? 
            ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 59 85 C0 75 ?? 8D 85 ?? ?? ?? ?? 50 8D 85 ?? ?? ?? ?? 
            50 E8 ?? ?? ?? ?? 59 59 85 C0 75 ?? 8D 45 ?? 50 8D 85 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 
            59 59 85 C0 75 ?? 8D 85 ?? ?? ?? ?? 50 8D 85 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 59 85 
            C0 0F 84 ?? ?? ?? ?? 8B 7D ?? E9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 59 85 C0 75 ?? 8D 45 
            ?? 50 8D 85 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 59 85 C0 75 ?? 8D 45 ?? 50 8D 85 ?? ?? 
            ?? ?? 50 E8 ?? ?? ?? ?? 59 59 85 C0 75 ?? 8D 85 ?? ?? ?? ?? 50 8D 85 ?? ?? ?? ?? 50 
            E8 ?? ?? ?? ?? 59 59 85 C0 75 ?? 8D 45 ?? 50 8D 85 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 
            59 85 C0 75 ?? 8D 85 ?? ?? ?? ?? 50 8D 85 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 59 85 C0 
        }

        $hermes_find_files_v2_p4 = {
            0F 84 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 50 57 FF 15 ?? ?? ?? ?? 85 C0 8D 45 ?? 50 8D 85 
            ?? ?? ?? ?? 50 0F 85 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 59 85 C0 0F 85 ?? ?? ?? ?? 8D 45 
            ?? 50 8D 85 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 59 85 C0 0F 85 ?? ?? ?? ?? 8D 45 ?? 50 
            8D 85 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 59 85 C0 0F 85 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 
            50 8D 85 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 59 85 C0 0F 85 ?? ?? ?? ?? 8D 45 ?? 50 8D 
            85 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 59 85 C0 0F 85 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 50 
            8D 85 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 59 85 C0 75 ?? EB ?? 8B 7D ?? F6 85 ?? ?? ?? 
            ?? ?? 74 ?? 53 E8 ?? ?? ?? ?? 59 FF 75 ?? 8D 85 ?? ?? ?? ?? FF 75 ?? FF 75 ?? 50 53 
            E8 ?? ?? ?? ?? 59 59 50 E8 ?? ?? ?? ?? 53 E8 ?? ?? ?? ?? 53 E8 ?? ?? ?? ?? 8B F0 8D 
            85 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 2B F0 83 C4 ?? 33 C0 66 89 44 73 ?? 33 F6 8D 85 ?? 
            ?? ?? ?? 50 57 FF 15 ?? ?? ?? ?? 85 C0 0F 85 ?? ?? ?? ?? 57 FF 15 ?? ?? ?? ?? 5F 5E 
            5B 8B E5 5D C3 
        }

        $hermes_enum_resources_v2 = {
            55 8B EC 83 EC ?? 53 56 57 8D 45 ?? C7 45 ?? ?? ?? ?? ?? 50 FF 75 ?? 33 DB C7 45 ?? 
            ?? ?? ?? ?? 53 53 6A ?? 89 5D ?? FF 15 ?? ?? ?? ?? 85 C0 0F 85 ?? ?? ?? ?? FF 75 ?? 
            6A ?? FF 15 ?? ?? ?? ?? 8B F0 85 F6 74 ?? FF 75 ?? 53 56 E8 ?? ?? ?? ?? 83 C4 ?? 8D 
            45 ?? 50 56 8D 45 ?? 50 FF 75 ?? FF 15 ?? ?? ?? ?? 85 C0 75 ?? 8B 7E ?? 6A ?? 58 66 
            39 07 75 ?? 66 39 47 ?? 75 ?? 50 8D 47 ?? 50 E8 ?? ?? ?? ?? 59 59 85 C0 74 ?? 57 FF 
            75 ?? E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? FF 75 ?? E8 ?? ?? ?? ?? 83 C4 ?? F7 46 ?? ?? ?? 
            ?? ?? 74 ?? FF 75 ?? 56 E8 ?? ?? ?? ?? 59 59 85 C0 75 ?? 33 C0 5F 5E 5B 8B E5 5D C3 
            33 C0 40 EB
        }

    condition:
        uint16(0) == 0x5A4D and
        (
            (
                (
                    all of ($hermes_find_files_v1_p*)
                ) and
                (
                    all of ($hermes_encrypt_files_v1_p*)
                ) 
            ) or
            (
                (
                    all of ($hermes_find_files_v2_p*)
                ) and
                (
                    all of ($hermes_encrypt_files_v2_p*)
                ) 
            )
        ) and
        (
                any of ($hermes_enum_resources_v*)
        )
}