rule Win32_Ransomware_JuicyLemon : tc_detection malicious
{
    meta:

        author              = "ReversingLabs"

        source              = "ReversingLabs"
        status              = "RELEASED"
        sharing             = "TLP:WHITE"
        category            = "MALWARE"
        malware             = "JUICYLEMON"
        description         = "Yara rule that detects JuicyLemon ransomware."

        tc_detection_type   = "Ransomware"
        tc_detection_name   = "JuicyLemon"
        tc_detection_factor = 5

    strings:

        $remote_connection_1 = {
            55 8B EC 83 C4 ?? 53 56 57 89 4D ?? 8B FA 8B F0 C6 45 ?? ?? 6A ?? 6A ?? 6A ?? 6A ?? 
            6A ?? FF 15 ?? ?? ?? ?? 8B D8 6A ?? 6A ?? 6A ?? 6A ?? 6A ?? 57 56 53 FF 15 ?? ?? ?? 
            ?? 8B F0 6A ?? 68 ?? ?? ?? ?? 6A ?? 6A ?? 6A ?? 8B 45 ?? 50 68 ?? ?? ?? ?? 56 FF 15 
            ?? ?? ?? ?? 8B F8 8B 45 ?? E8 ?? ?? ?? ?? 50 8B 45 ?? 50 6A ?? 68 ?? ?? ?? ?? 57 FF 
            15 ?? ?? ?? ?? 85 C0 74 ?? C6 45 ?? ?? 57 FF 15 ?? ?? ?? ?? 56 FF 15 ?? ?? ?? ?? 53 
            FF 15 ?? ?? ?? ?? 8A 45 ?? 5F 5E 5B 59 59 5D C2 
        }

        $remote_connection_2 = {
            55 8B EC 33 C9 51 51 51 51 51 51 51 53 56 89 55 ?? 89 45 ?? 8B 45 ?? E8 ?? ?? ?? ?? 
            8B 45 ?? E8 ?? ?? ?? ?? 33 C0 55 68 ?? ?? ?? ?? 64 FF 30 64 89 20 33 DB 8D 55 ?? 8B 
            45 ?? E8 ?? ?? ?? ?? 8D 55 ?? 8B 45 ?? E8 ?? ?? ?? ?? 8D 55 ?? 8B 45 ?? E8 ?? ?? ?? 
            ?? 66 BE ?? ?? 8B 45 ?? BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 75 ?? 66 BE ?? ?? 8D 45 ?? E8 
            ?? ?? ?? ?? 50 8D 45 ?? B9 ?? ?? ?? ?? 8B 55 ?? E8 ?? ?? ?? ?? 8B 45 ?? E8 ?? ?? ?? 
            ?? 50 8D 45 ?? B9 ?? ?? ?? ?? 8B 55 ?? E8 ?? ?? ?? ?? 8B 45 ?? E8 ?? ?? ?? ?? 8B D6 
            59 E8 ?? ?? ?? ?? 84 C0 74 ?? B3 ?? 33 C0 5A 59 59 64 89 10 68 ?? ?? ?? ?? 8D 45 ?? 
            BA ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 
        }

        $find_files_and_encrypt = {
            E8 ?? ?? ?? ?? EB ?? 8D 85 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 8B 14 B2 E8 ?? ?? ?? ?? 8B 
            85 ?? ?? ?? ?? 8B 55 ?? E8 ?? ?? ?? ?? 88 45 ?? 46 4B 75 ?? A1 ?? ?? ?? ?? BA ?? ?? 
            ?? ?? E8 ?? ?? ?? ?? 75 ?? 80 7D ?? ?? 75 ?? 8B 5D ?? 4B 85 DB 7C ?? 43 33 F6 8D 85 
            ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 8B 14 B2 E8 ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? 8B 55 ?? E8 
            ?? ?? ?? ?? 46 4B 75 ?? A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 50 B8 ?? ?? ?? ?? E8 ?? ?? ?? 
            ?? 8D 8D ?? ?? ?? ?? 5A E8 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 8D 95 ?? ?? ?? ?? E8 ?? ?? 
            ?? ?? 8B 95 ?? ?? ?? ?? B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? BA ?? ?? ?? ?? 
            E8 ?? ?? ?? ?? 75 ?? B8 ?? ?? ?? ?? B9 ?? ?? ?? ?? BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 57 
            A1 ?? ?? ?? ?? 8B 00 FF D0 8B 1D ?? ?? ?? ?? 57 A1 ?? ?? ?? ?? 8B 00 FF D0 85 DB 74 
            ?? 6A ?? A1 ?? ?? ?? ?? 8B 00 FF D0 EB ?? B3 ?? 8D 85 ?? ?? ?? ?? 8B D3 80 C2 ?? E8 
            ?? ?? ?? ?? FF B5 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? BA ?? 
            ?? ?? ?? E8 ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? E8 ?? ?? ?? ?? 50 A1 ?? ?? ?? ?? 8B 00 FF 
            D0 83 F8 ?? 76 ?? 83 F8 ?? 74 ?? B2 ?? A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 8D 85 ?? 
            ?? ?? ?? 8B D3 80 C2 ?? E8 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? BA ?? ?? ?? ?? E8 ?? ?? ?? 
            ?? 8B 95 ?? ?? ?? ?? 8D 46 ?? E8 ?? ?? ?? ?? 57 A1 ?? ?? ?? ?? 8B 00 FF D0 FF 05 ?? 
            ?? ?? ?? 57 A1 ?? ?? ?? ?? 8B 00 FF D0 8D 46 ?? 50 6A ?? 56 68 ?? ?? ?? ?? 68 ?? ?? 
            ?? ?? 6A ?? A1 ?? ?? ?? ?? 8B 00 FF D0 4B 80 FB ?? 0F 85 ?? ?? ?? ?? 57 A1 ?? ?? ?? 
            ?? 8B 00 FF D0 8B 1D ?? ?? ?? ?? 57 A1 ?? ?? ?? ?? 8B 00 FF D0 85 DB 74 ?? 6A ?? A1 
            ?? ?? ?? ?? 8B 00 FF D0 EB ?? B2 ?? A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 8D 46 ?? BA 
            ?? ?? ?? ?? E8 ?? ?? ?? ?? 57 A1 ?? ?? ?? ?? 8B 00 FF D0 FF 05 ?? ?? ?? ?? 57 A1 ?? 
            ?? ?? ?? 8B 00 FF D0 8D 46 ?? 50 6A ?? 56 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A ?? A1 ?? 
            ?? ?? ?? 8B 00 FF D0 57 A1 ?? ?? ?? ?? 8B 00 FF D0 8B 1D ?? ?? ?? ?? 57 A1 ?? ?? ?? 
            ?? 8B 00 FF D0 85 DB 74 ?? 6A ?? A1 ?? ?? ?? ?? 8B 00 FF D0 EB ?? A1 ?? ?? ?? ?? BA 
            ?? ?? ?? ?? E8 ?? ?? ?? ?? 0F 85 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? 68 ?? ?? ?? ?? FF 35 
            ?? ?? ?? ?? FF 35 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? E8 ?? ?? ?? ?? FF B5 ?? ?? ?? ?? 68 
            ?? ?? ?? ?? 6A ?? 68 ?? ?? ?? ?? 8B 05 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 
            52 50 8D 85 ?? ?? ?? ?? E8 ?? ?? ?? ?? FF B5 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 ?? BA 
            ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 ?? E8 ?? ?? ?? ?? 50 8D 45 ?? E8 ?? ?? ?? ?? 50 B8 
            ?? ?? ?? ?? E8 ?? ?? ?? ?? 5A 59 E8 ?? ?? ?? ?? 8D 95 ?? ?? ?? ?? 8B 45 ?? E8 ?? ?? 
            ?? ?? 8B 8D ?? ?? ?? ?? 8D 45 ?? BA ?? ?? ?? ?? E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? E8 ?? 
            ?? ?? ?? 89 45 ?? C6 45 ?? ?? A1 ?? ?? ?? ?? BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 75 ?? 8B 
            5D ?? 4B 85 DB 7C ?? 43 33 F6 80 7D ?? ?? 74 ?? 8D 85 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 
            8B 14 B2 E8 ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? 8B 55 ?? E8 ?? ?? ?? ?? EB ?? 8D 85 ?? ?? 
            ?? ?? 8B 15 ?? ?? ?? ?? 8B 14 B2 E8 ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? 8B 55 ?? E8 ?? ?? 
            ?? ?? 88 45 ?? 46 4B 75 ?? A1 ?? ?? ?? ?? BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 75 ?? 80 7D 
            ?? ?? 75 ?? 8B 5D ?? 4B 85 DB 7C ?? 43 33 F6 8D 85 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 8B 
            14 B2 E8 ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? 8B 55 ?? E8 ?? ?? ?? ?? 46 4B 75 ?? BA ?? ?? 
            ?? ?? A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 8D 85 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 85 ?? 
            ?? ?? ?? E8 ?? ?? ?? ?? 50 8D 85 ?? ?? ?? ?? B9 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? E8 ?? 
            ?? ?? ?? 8B 95 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? E8 ?? 
            ?? ?? ?? 8B C8 B8 ?? ?? ?? ?? 5A E8 ?? ?? ?? ?? BA ?? ?? ?? ?? A1 ?? ?? ?? ?? E8 ?? 
            ?? ?? ?? 8B D0 8D 85 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? E8 ?? ?? ?? ?? 50 
            8D 85 ?? ?? ?? ?? B9 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 95 ?? ?? ?? ?? 
            8D 85 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B C8 B8 ?? ?? ?? 
            ?? 5A E8 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 85 ?? ?? ?? 
            ?? BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 95 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? E8 ?? ?? ?? ?? 
            8B 85 ?? ?? ?? ?? E8 ?? ?? ?? ?? 50 8D 85 ?? ?? ?? ?? 8B 55 ?? E8 ?? ?? ?? ?? 8B 85 
            ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 8B D3 B8 ?? ?? ?? ?? 59 E8 ?? ?? ?? ?? FF 35 ?? ?? 
            ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 
            8B 95 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? E8 ?? ?? ?? ?? 
            50 8B D3 B8 ?? ?? ?? ?? 59 E8 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? BA ?? ?? ?? ?? E8 ?? ?? 
            ?? ?? 8B 85 ?? ?? ?? ?? 50 FF 35 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 85 ?? 
            ?? ?? ?? BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 95 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? E8 ?? ?? 
            ?? ?? 8B 85 ?? ?? ?? ?? E8 ?? ?? ?? ?? 50 8B D3 B8 ?? ?? ?? ?? 59 E8 ?? ?? ?? ?? A1 
            ?? ?? ?? ?? BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 75 ?? A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? B2 ?? 
            E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 75 ?? A1 ?? ?? ?? ?? E8 
            ?? ?? ?? ?? B2 ?? E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 75 ?? 
            A1 ?? ?? ?? ?? E8 ?? ?? ?? ?? B2 ?? E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? BA ?? ?? ?? ?? E8 
            ?? ?? ?? ?? 75 ?? E8 ?? ?? ?? ?? C6 05 ?? ?? ?? ?? ?? 33 C0 5A 59 59 64 89 10 68 ?? 
            ?? ?? ?? 8D 85 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? BA ?? ?? ?? ?? E8 ?? ?? 
            ?? ?? 8D 85 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? BA ?? ?? ?? ?? E8 ?? ?? ?? 
            ?? 8D 85 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 85 ?? ?? ?? 
            ?? E8 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 
            E8 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? BA 
            ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 85 ?? 
            ?? ?? ?? BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 85 ?? ?? 
            ?? ?? E8 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? BA ?? ?? ?? 
            ?? E8 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? E8 ?? ?? ?? ?? 
            8D 85 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 
            85 ?? ?? ?? ?? BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 85 
            ?? ?? ?? ?? BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 45 ?? BA ?? ?? ?? ?? E8 ?? ?? ?? ?? C3 
        }

    condition:
        uint16(0) == 0x5A4D and $find_files_and_encrypt and $remote_connection_1 and $remote_connection_2
}