rule Win32_Ransomware_LockBit : tc_detection malicious
{
    meta:

        author              = "ReversingLabs"

        source              = "ReversingLabs"
        status              = "RELEASED"
        sharing             = "TLP:WHITE"
        category            = "MALWARE"
        malware             = "LOCKBIT"
        description         = "Yara rule that detects LockBit ransomware."

        tc_detection_type   = "Ransomware"
        tc_detection_name   = "LockBit"
        tc_detection_factor = 5

    strings:

        $enum_resources_v1 = {
            55 8B EC 83 EC ?? 57 8D 45 ?? C7 45 ?? ?? ?? ?? ?? 50 51 6A ?? 6A ?? 6A ?? C7 45 ??
            ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 85 C0 0F 85 ?? ?? ?? ?? FF 75 ?? 6A ?? FF 15 ?? ?? ??
            ?? 8B F8 89 7D ?? 85 FF 0F 84 ?? ?? ?? ?? 53 56 FF 75 ?? 6A ?? 57 E8 ?? ?? ?? ?? 83
            C4 ?? 8D 45 ?? 50 57 8D 45 ?? 50 FF 75 ?? FF 15 ?? ?? ?? ?? 85 C0 0F 85 ?? ?? ?? ??
            33 DB 39 5D ?? 76 ?? 8B F7 0F 1F 80 ?? ?? ?? ?? F7 46 ?? ?? ?? ?? ?? 74 ?? 8B CE E8
            ?? ?? ?? ?? 83 7F ?? ?? 74 ?? 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 8B F8 83 C4 ?? 8B 45
            ?? FF 70 ?? FF 15 ?? ?? ?? ?? 8D 04 45 ?? ?? ?? ?? 50 8B 45 ?? FF 70 ?? 57 E8 ?? ??
            ?? ?? 83 C4 ?? 8D 45 ?? 50 6A ?? 57 68 ?? ?? ?? ?? 6A ?? 6A ?? FF 15 ?? ?? ?? ?? 8B
            0D ?? ?? ?? ?? 89 04 8D ?? ?? ?? ?? F0 FF 05 ?? ?? ?? ?? 8B 7D ?? 43 83 C6 ?? 3B 5D
            ?? 72 ?? E9 ?? ?? ?? ?? 57 FF 15 ?? ?? ?? ?? FF 75 ?? FF 15 ?? ?? ?? ?? 5E 5B 85 C0
            75 ?? B8 ?? ?? ?? ?? 5F 8B E5 5D C3 33 C0 5F 8B E5 5D C3
        }

        $find_files_v1_1 = {
            55 8B EC 81 EC ?? ?? ?? ?? 53 56 8B C1 C7 45 ?? ?? ?? ?? ?? 57 50 89 45 ?? 33 C9 8D
            45 ?? C7 45 ?? ?? ?? ?? ?? 50 8D 85 ?? ?? ?? ?? 66 89 4D ?? 50 FF 15 ?? ?? ?? ?? 83
            C4 ?? 8D 85 ?? ?? ?? ?? 6A ?? 6A ?? 6A ?? 50 6A ?? 8D 85 ?? ?? ?? ?? 50 FF 15 ?? ??
            ?? ?? 8B F8 89 7D ?? 83 FF ?? 0F 84 ?? ?? ?? ?? 8B 1D ?? ?? ?? ?? 33 C0 8B 35 ?? ??
            ?? ?? C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? 66 89 45 ?? C7 45 ?? ?? ?? ?? ?? C7
            45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? 0F 1F 80 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 50 8D
            45 ?? 50 FF D3 85 C0 0F 84 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 50 8D 45 ?? 50 FF D3 85 C0
            0F 84 ?? ?? ?? ?? F6 85 ?? ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 0F 84 ?? ?? ?? ?? 68 ?? ??
            ?? ?? 50 FF D3 85 C0 0F 84 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 50 FF D3 85
            C0 0F 84
        }

        $find_files_v1_2 = {
            45 ?? 50 8D 85 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 83 C4 ?? 8D 8D ?? ?? ?? ?? E8 ?? ??
            ?? ?? E9 ?? ?? ?? ?? 33 C9 66 39 8D ?? ?? ?? ?? 74 ?? 8D 40 ?? 41 66 83 38 ?? 75 ??
            83 F9 ?? 0F 8E ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 8B F0 56 68 ?? ??
            ?? ?? FF D3 85 C0 0F 84 ?? ?? ?? ?? 56 68 ?? ?? ?? ?? FF D3 85 C0 0F 84 ?? ?? ?? ??
            56 68 ?? ?? ?? ?? FF D3 85 C0 0F 84 ?? ?? ?? ?? 56 68 ?? ?? ?? ?? FF D3 85 C0 0F 84
        }

        $find_files_v1_3 = {
            85 C0 0F 84 ?? ?? ?? ?? 56 68 ?? ?? ?? ?? FF D3 85 C0 0F 84 ?? ?? ?? ?? 56 68 ?? ??
            ?? ?? FF D3 85 C0 0F 84 ?? ?? ?? ?? 56 68 ?? ?? ?? ?? FF D3 85 C0 0F 84 ?? ?? ?? ??
            56 68 ?? ?? ?? ?? FF D3 85 C0 0F 84 ?? ?? ?? ?? 56 68 ?? ?? ?? ?? FF D3 85 C0 0F 84
            ?? ?? ?? ?? 0F 28 05 ?? ?? ?? ?? 33 C9 0F 11 45 ?? C7 45 ?? ?? ?? ?? ?? 66 C7 45 ??
            ?? ?? 66 90 8A 45 ?? 30 44 0D ?? 41 83 F9 ?? 72 ?? 33 C0 C6 45 ?? ?? 66 89 45 ?? 8D
            45 ?? 50 8D 45 ?? C7 45 ?? ?? ?? ?? ?? 50 8D 85 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 83
            C4 ?? 8D 85 ?? ?? ?? ?? 50 8D 85 ?? ?? ?? ?? 50 FF D3 85 C0 0F 84 ?? ?? ?? ?? 8D 85
            ?? ?? ?? ?? 50 68 ?? ?? ?? ?? FF D3 85 C0 0F 84 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 50 68
            ?? ?? ?? ?? FF D3 85 C0 0F 84 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 50 68 ?? ?? ?? ?? FF D3
            85 C0 0F 84 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 50 68 ?? ?? ?? ?? FF D3 85 C0 0F 84 ?? ??
            ?? ?? 8B 4D ?? 8D 95 ?? ?? ?? ?? 2B D1 0F B7 01 8D 49 ?? 66 89 44 11 ?? 66 85 C0 75
            ?? 8D 85 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 8D 95 ?? ?? ?? ?? 8B F2 66 8B 02 83 C2 ??
            66 85 C0 75 ?? 8D BD ?? ?? ?? ?? 2B D6 83 C7 ?? 0F 1F 40 ?? 66 8B 47 ?? 83 C7 ?? 66
            85 C0 75 ?? 8B 85 ?? ?? ?? ?? 8B CA C1 E9 ?? F3 A5 8B CA 83 E1 ?? F3 A4 A8 ?? 75 ??
            A8 ?? 74 ?? 68 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 85 C0 74 ?? 8D 8D
            ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 7D ?? 8B 35 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 50 57 FF D6
            83 F8 ?? 0F 84 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 83 F8 ?? 75 ?? 57 FF 15 ?? ?? ?? ?? 5F
            5E 5B 8B E5 5D C3
        }

        $encrypt_files_v1_1 = {
            55 8B EC 81 EC ?? ?? ?? ?? 33 C0 C7 45 ?? ?? ?? ?? ?? 53 56 57 8B F9 C7 45 ?? ?? ??
            ?? ?? 89 7D ?? 66 89 45 ?? C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? 66 89 45 ?? C7
            45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? 66
            89 45 ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? C7 85
        }

        $encrypt_files_v1_2 = {
            C7 85 ?? ?? ?? ?? ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? 89 85 ?? ?? ?? ?? C7 85
            ?? ?? ?? ?? ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 8B F8 33 DB 89 7D ?? 33 F6 0F 1F 00 8B 84
            B5 ?? ?? ?? ?? 85 C0 74 ?? 57 50 FF 15 ?? ?? ?? ?? 85 C0 B8 ?? ?? ?? ?? 0F 44 D8 46
            81 FE ?? ?? ?? ?? 7C ?? 8B 7D ?? 33 C0 66 89 85 ?? ?? ?? ?? 66 89 85 ?? ?? ?? ?? 8D
            85 ?? ?? ?? ?? 57 50 8D 85 ?? ?? ?? ?? 89 5D ?? 50 C7 85 ?? ?? ?? ?? ?? ?? ?? ?? C7
            85 ?? ?? ?? ?? ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ??
            ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ??
            ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? FF 15 ?? ?? ??
            ?? 8B 1D ?? ?? ?? ?? 83 C4 ?? 33 F6 8D 85 ?? ?? ?? ?? 50 FF 75 ?? FF 15 ?? ?? ?? ??
            85 C0 74 ?? 8D 85 ?? ?? ?? ?? 50 57 FF 15 ?? ?? ?? ?? 85 C0 75 ?? FF D3 83 F8 ?? 75
            ?? 8B CF E8 ?? ?? ?? ?? 83 F8 ?? 74 ?? 8B
        }

        $encrypt_files_v1_3 = {
            CF E8 ?? ?? ?? ?? 83 F8 ?? 75 ?? 83 FE ?? 7D ?? 46 EB ?? 6A ?? 68 ?? ?? ?? ?? 6A ??
            6A ?? 6A ?? 68 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 8B D8 89 5D ?? 83
            FB ?? 75 ?? 8B 1D ?? ?? ?? ?? EB ?? FF 35 ?? ?? ?? ?? 6A ?? FF 35 ?? ?? ?? ?? 53 FF
            15 ?? ?? ?? ?? A3 ?? ?? ?? ?? 83 F8 ?? 75 ?? 53 FF 15 ?? ?? ?? ?? 33 C0 5F 5E 5B 8B
            E5 5D C3 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 8B D8 83 C4 ?? 85 DB 75 ?? FF 75 ?? FF 15
            ?? ?? ?? ?? 33 C0 5F 5E 5B 8B E5 5D C3 8B 45 ?? 8B 75 ?? 89 43 ?? 8D 43 ?? 50 56 C7
            43 ?? ?? ?? ?? ?? C7 43 ?? ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 85 C0 75 ?? 53 FF 15 ?? ??
            ?? ?? 83 C4 ?? 56 FF 15 ?? ?? ?? ?? 33 C0 5F 5E 5B 8B E5 5D C3 8B 4B ?? 8B 43 ?? 85
            C9 7F ?? 7C ?? 83 F8 ?? 72 ?? 83 E8 ?? C7 43 ?? ?? ?? ?? ?? 89 43 ?? 8B 43 ?? 83 D9
            ?? 89 43 ?? 8B 43 ?? 89 43 ?? 8D 83 ?? ?? ?? ?? 6A ?? 50 89 4B ?? C7 43 ?? ?? ?? ??
            ?? 89 73 ?? E8 ?? ?? ?? ?? 6A ?? 8D 83 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 53 6A ?? 6A ??
            8D 73 ?? 56 FF 73 ?? FF 15 ?? ?? ?? ?? 89 45 ?? 85 C0 75 ?? FF 15 ?? ?? ?? ?? 3D ??
            ?? ?? ?? 74 ?? 56 8B 35 ?? ?? ?? ?? FF D6 83 C4 ?? 53 FF D6 83 C4 ?? FF 75 ?? FF 15
            ?? ?? ?? ?? 8B 45 ?? 5F 5E 5B 8B E5 5D C3 F0 FF 05 ?? ?? ?? ?? 8B CF E8 ?? ?? ?? ??
            B8 ?? ?? ?? ?? F0 0F C1 05 ?? ?? ?? ?? 40 3D ?? ?? ?? ?? 7E ?? 8B 35 ?? ?? ?? ?? 6A
            ?? FF D6 83 3D ?? ?? ?? ?? ?? 7D ?? 5F 5E B8 ?? ?? ?? ?? 5B 8B E5 5D C3
        }

        $check_blacklisted_languages_v2 = {
            FF D0 0F B7 C0 B9 2C 08 ?? ?? 66 3B C1 0F 84 ?? ?? ?? ?? B9 2C 04 ?? ?? 66 3B C1 74
            ?? B9 2B 04 ?? ?? 66 3B C1 74 ?? B9 23 04 ?? ?? 66 3B C1 74 ?? B9 37 04 ?? ?? 66 3B
            C1 74 ?? B9 3F 04 ?? ?? 66 3B C1 74 ?? B9 40 04 ?? ?? 66 3B C1 74 ?? B9 19 08 ?? ??
            66 3B C1 74 ?? B9 19 04 ?? ?? 66 3B C1 74 ?? B9 28 04 ?? ?? 66 3B C1 74 ?? B9 42 04
            ?? ?? 66 3B C1 74 ?? B9 43 08 ?? ?? 66 3B C1 74 ?? B9 43 04 ?? ?? 66 3B C1 74 ?? B9
            22 04 ?? ?? 66 3B C1 0F 85 ?? ?? ?? ?? 8B 1D ?? ?? ?? ?? 85 DB 0F 85 ?? ?? ?? ?? 64
            A1 ?? ?? ?? ?? 8B 40 ?? 8B 40 ?? 8B 00 8B C8 89 45 ?? 8B D0 89 4D ?? 0F B7 59 ?? 33
            FF 8B 71 ?? D1 EB C7 45 ?? ?? ?? ?? ?? 8D 04 5E 3B F0 0F 47 DF 85 DB 74 ?? 8A 0E 8D
            76 ?? 0F BE D1 80 E9 ?? 8B C2 83 C8 ?? 80 F9 ?? 0F 47 C2 47 33 45 ?? 69 C0 ?? ?? ??
            ?? 89 45 ?? 3B FB 75 ?? 3D ?? ?? ?? ?? 0F 84 ?? ?? ?? ?? 8B 4D ?? 8B 55 ?? 8B 01 8B
            C8 89 4D ?? 3B C2 74 ?? 83 79 ?? ?? 75 ?? 33 DB 89 1D ?? ?? ?? ?? A1 ?? ?? ?? ?? 85
            C0 0F 85 ?? ?? ?? ?? 85 DB 0F 84 ?? ?? ?? ?? 8B 43 ?? 8B 4C 18 ?? 8D 04 19 89 45 ??
            3B C3 74 ?? 33 C9 89 4D ?? 39 48 ?? 74 ?? 8B 40 ?? 8B 55 ?? 03 C3 89 45 ?? 0F 1F 40
            ?? 8B 30 BF ?? ?? ?? ?? 8A 04 1E 03 F3 46 84 C0 74 ?? 0F BE D0 8D 76 ?? 2C ?? 8B CA
            83 C9 ?? 3C ?? 8A 46 ?? 0F 47 CA 33 CF 69 F9 ?? ?? ?? ?? 84 C0 75 ?? 8B 4D ?? 8B 55
            ?? 81 FF ?? ?? ?? ?? 0F 84 ?? ?? ?? ?? 8B 45 ?? 41 83 C0 ?? 89 4D ?? 89 45 ?? 3B 4A
            ?? 75 ?? 33 C0 A3 ?? ?? ?? ?? 6A ?? FF D0 5F 5E 5B 8B E5 5D C3
        }

        $create_net_host_trav_threads_v2 = {
            55 8B EC 83 E4 ?? 81 EC ?? ?? ?? ?? 53 56 57 6A ?? 6A ?? 68 ?? ?? ?? ?? E8 ?? ?? ??
            ?? 64 A1 ?? ?? ?? ?? 83 C4 ?? 8B 40 ?? 50 6A ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? A3 ??
            ?? ?? ?? E8 ?? ?? ?? ?? FF D0 85 C0 78 ?? A1 ?? ?? ?? ?? 8D 0C 85 ?? ?? ?? ?? E8 ??
            ?? ?? ?? A3 ?? ?? ?? ?? 85 C0 0F 85 ?? ?? ?? ?? E8 ?? ?? ?? ?? F0 FF 0D ?? ?? ?? ??
            E8 ?? ?? ?? ?? 8B 35
        }

        $fnv1a_hashing_v2 = {
            55 8B EC 83 EC ?? 64 A1 ?? ?? ?? ?? 8B 40 ?? 8B 40 ?? 8B 00 8B 50 ?? A1 ?? ?? ?? ??
            89 55 ?? 85 C0 0F 85 ?? ?? ?? ?? 85 D2 75 ?? 33 C0 A3 ?? ?? ?? ?? 8B E5 5D C3 8B 42
            ?? 8B 4C 10 ?? 8B 44 10 ?? 89 45 ?? 8D 04 11 89 45 ?? 3B C2 74 ?? 53 33 C9 56 57 89
            4D ?? 39 48 ?? 74 ?? 8B 78 ?? 03 FA 8B 07 BE
        }

        $decrypt_configuration_v2_1 = {
            55 8B EC 51 53 56 57 B9 ?? ?? ?? ?? BA ?? ?? ?? ?? 03 C9 83 EA ?? 75 ?? 68 ?? ?? ??
            ?? 68 ?? ?? ?? ?? BA 25 1B 00 00 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ??
            ?? ?? ?? BA 78 0C 00 00 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ??
            BA 39 28 00 00 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? BA F1 40
            00 00 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? BA BF 11 00 00 B9
            ?? ?? ?? ?? E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? BA 28 02 00 00 B9 ?? ?? ??
            ?? E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? BA 3B 07 00 00 B9 ?? ?? ?? ?? E8 ??
            ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? BA A5 04 00 00 B9 ?? ?? ?? ?? E8 ?? ?? ?? ??
            83 C4 ?? BA 0F 03 00 00 B9 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ??
            83 C4 ?? E8 ?? ?? ?? ?? 8B 3D ?? ?? ?? ?? 33 C9 BE ?? ?? ?? ?? 85 FF 74 ?? 8B 15 ??
            ?? ?? ?? 0F 1F 44 00 ?? 80 3C 0A ?? 8D 46 ?? 0F 45 C6 41 8B F0 3B CF 72 ?? 8D 0C B5
            ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D8 89 1D ?? ?? ?? ?? 85 DB 74 ?? 33 FF 85 F6 74 ?? 90
            B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 1D ?? ?? ?? ?? 89 04 BB 47 3B FE 72 ?? 8B 0D ?? ??
            ?? ?? 33 F6 E8 ?? ?? ?? ?? 85 C0 74 ?? 0F 1F 80 ?? ?? ?? ?? 8B 14 B3 8A 08 8D 40 ??
            88 0A 8D 52 ?? 84 C9 75 ?? 33 C9 E8 ?? ?? ?? ?? 46 85 C0 75 ?? C7 04 B3 ?? ?? ?? ??
            5F 5E 5B 8B E5 5D C3
        }

        $decrypt_configuration_v2_2 = {
            55 8B EC 51 53 56 57 8B F2 8B F9 6B CE ?? E8 ?? ?? ?? ?? 8B C8 33 C0 89 4D ?? 85 C9
            0F 84 ?? ?? ?? ?? 85 F6 74 ?? 83 FE ?? 72 ?? 0F 28 0D ?? ?? ?? ?? 8B CE 83 E1 ?? 66
            0F 1F 84 00 ?? ?? ?? ?? 0F 10 04 07 66 0F EF C1 0F 11 04 07 0F 10 44 07 ?? 66 0F EF
            C1 0F 11 44 07 ?? 0F 10 44 07 ?? 66 0F EF C1 0F 11 44 07 ?? 0F 10 44 07 ?? 66 0F EF
            C1 0F 11 44 07 ?? 83 C0 ?? 3B C1 72 ?? 8B 4D ?? 3B C6 73 ?? 80 34 38 5F 40 3B C6 72
            ?? 8B 5D ?? 8B D6 51 53 51 8B CF E8 ?? ?? ?? ?? 83 C4 ?? 85 C0 75 ?? 8B 0B E8 ?? ??
            ?? ?? 8B F8 8B 45 ?? 89 38 8B 45 ?? 85 FF 74 ?? 8B 0B 8B F0 F3 A4 8B C8 BE ?? ?? ??
            ?? E8 ?? ?? ?? ?? 8B C6 5F 5E 5B 8B E5 5D C3
        }

        $encrypt_files_v2_p1 = {
            55 8B EC 83 E4 ?? 81 EC ?? ?? ?? ?? 56 57 66 90 64 A1 ?? ?? ?? ?? 0F 57 C0 C7 44 24
            ?? ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? 66 0F 13 44 24 ?? 8B 40 ?? 8B 40 ?? 8B 00 8B
            50 ?? A1 ?? ?? ?? ?? 89 54 24 ?? 85 C0 0F 85 ?? ?? ?? ?? 85 D2 0F 84 ?? ?? ?? ?? 8B
            42 ?? 8B 4C 10 ?? 8D 04 11 89 44 24 ?? 3B C2 74 ?? 33 C9 89 4C 24 ?? 39 48 ?? 74 ??
            8B 40 ?? 03 C2 89 44 24 ?? 0F 1F 80 ?? ?? ?? ?? 8B 30 BF C5 9D 1C 81 8A 04 16 03 F2
            46 84 C0 74 ?? 0F BE D0 8D 76 ?? 2C ?? 8B CA 83 C9 ?? 3C ?? 8A 46 ?? 0F 47 CA 33 CF
            69 F9 93 01 00 01 84 C0 75 ?? 8B 54 24 ?? 8B 4C 24 ?? 81 FF ?? ?? ?? ?? 74 ?? 8B 74
            24 ?? 41 8B 44 24 ?? 83 C0 ?? 89 4C 24 ?? 89 44 24 ?? 3B 4E ?? 75 ?? 33 C0 A3 ?? ??
            ?? ?? 6A ?? 8D 4C 24 ?? 51 8D 4C 24 ?? 51 8D 4C 24 ?? 51 FF 35 ?? ?? ?? ?? FF D0 85
            C0 0F 88 ?? ?? ?? ?? 8B 74 24 ?? 85 F6 0F 84 ?? ?? ?? ?? 8B 7C 24 ?? 8B 07 48 83 F8
            ?? 0F 87 ?? ?? ?? ?? FF 24 85 ?? ?? ?? ?? 8B 74 24 ?? 8B 46 ?? 8D 04 48 0F B7 0C 10
            8B 46 ?? 8D 04 88 8B 04 10 03 C2 EB ?? 83 7F ?? ?? 0F 85 ?? ?? ?? ?? 83 7F ?? ?? 0F
            85 ?? ?? ?? ?? C7 07 ?? ?? ?? ?? 8B 4C 24 ?? 8B 54 24 ?? 68 ?? ?? ?? ?? 6A ?? 8B 41
            ?? 89 42 ?? 8B 41 ?? 89 42 ?? 8B 44 24 ?? 6A ?? 8B 40 ?? 8D 88 ?? ?? ?? ?? F7 D8 23
            C8 8B 44 24 ?? 89 48 ?? 8D 4C 24 ?? 8B 54 24 ?? 8B 74 24 ?? E8 ?? ?? ?? ?? 83 C4 ??
            8D 84 24 ?? ?? ?? ?? 6A ?? FF 35 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 8D 84 24 ??
            ?? ?? ?? 6A ?? 68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 8D 84 24 ?? ?? ?? ?? 6A ??
            68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? FF 76 ?? FF 76 ?? FF 15 ?? ?? ?? ?? 8B 4E
            ?? 8D 44 24 ?? 68 ?? ?? ?? ?? 50 8B 46 ?? 81 C1 ?? ?? ?? ?? 03 C1 50 E8 ?? ?? ?? ??
            8B 4C 24 ?? 83 C4 ?? 8B 74 24 ?? 89 74 24 ?? 6A ?? 8D 41 ?? 50 FF 71 ?? 8D 41 ?? FF
        }

        $encrypt_files_v2_p2 = {
            71 ?? 50 51 6A ?? 6A ?? FF 76 ?? E8 ?? ?? ?? ?? FF D0 85 C0 0F 89 ?? ?? ?? ?? 83 C8
            ?? F0 0F C1 46 ?? 0F 85 ?? ?? ?? ?? 6A ?? 6A ?? 56 E8 ?? ?? ?? ?? 8B 46 ?? 83 C4 ??
            33 FF 85 C0 0F 84 ?? ?? ?? ?? 83 C6 ?? 8B 0E E8 ?? ?? ?? ?? 8B 44 24 ?? 8D 76 ?? 47
            8B 40 ?? 3B F8 72 ?? 8B 74 24 ?? 85 C0 E9 ?? ?? ?? ?? B9 ?? ?? ?? ?? 8D 56 ?? 8B C1
            F0 0F B1 0A 83 F8 ?? 75 ?? 8B 46 ?? 89 44 24 ?? 0F B7 46 ?? 83 C0 ?? 8B C8 89 44 24
            ?? E8 ?? ?? ?? ?? 8B F8 85 FF 74 ?? 0F B7 4E ?? 51 FF 76 ?? 8D 4F ?? 51 E8 ?? ?? ??
            ?? 0F B7 46 ?? 83 C4 ?? 89 47 ?? 0F 57 C0 8D 44 24 ?? C6 07 ?? C7 47 ?? ?? ?? ?? ??
            6A ?? FF 74 24 ?? 66 0F 13 44 24 ?? 57 50 FF 74 24 ?? E8 ?? ?? ?? ?? FF D0 8B CF E8
            ?? ?? ?? ?? 8D 56 ?? 85 F6 0F 84 ?? ?? ?? ?? 83 C8 ?? F0 0F C1 02 0F 85 ?? ?? ?? ??
            6A ?? 6A ?? 56 E8 ?? ?? ?? ?? 8B 4E ?? 83 C4 ?? C7 44 24 ?? ?? ?? ?? ?? 85 C9 0F 84
            ?? ?? ?? ?? 8D 7E ?? 90 8B 0F E8 ?? ?? ?? ?? 8B 44 24 ?? 8D 7F ?? 8B 4E ?? 40 89 44
            24 ?? 3B C1 72 ?? E9 ?? ?? ?? ?? 80 3D ?? ?? ?? ?? ?? 8D 56 ?? 74 ?? 8D 8C 24 ?? ??
            ?? ?? E8 ?? ?? ?? ?? 8B 47 ?? 8B 57 ?? 50 50 8D 47 ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 8B
            C1 6A ?? EB ?? 8D 8C 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 47 ?? 8D 8C 24 ?? ?? ?? ?? 8B
            57 ?? 50 50 8D 47 ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 8D 84 24 ?? ?? ?? ?? 68 ?? ?? ?? ??
            68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 8B 54 24 ?? 83 C4 ?? 83 7A ?? ?? 8B 42 ?? 0F 8F ??
            ?? ?? ?? 7C ?? 39 42 ?? 0F 87 ?? ?? ?? ?? 8B 74 24 ?? 8D 8C 24 ?? ?? ?? ?? 68 ?? ??
            ?? ?? 6A ?? 6A ?? E8 ?? ?? ?? ?? 83 C4 ?? 8D 84 24 ?? ?? ?? ?? 6A ?? FF 35 ?? ?? ??
            ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 8D 84 24 ?? ?? ?? ?? 6A ?? 68 ?? ?? ?? ?? 50 E8 ?? ??
            ?? ?? 83 C4 ?? 8D 84 24 ?? ?? ?? ?? 6A ?? 68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 8B 4E
        }

        $encrypt_files_v2_p3 = {
            8D 84 24 ?? ?? ?? ?? 83 C4 ?? 81 C1 ?? ?? ?? ?? 68 ?? ?? ?? ?? 50 8B 46 ?? 03 C1 50
            E8 ?? ?? ?? ?? 8B 44 24 ?? 83 C4 ?? C7 00 ?? ?? ?? ?? EB ?? 8B 44 24 ?? C7 00 ?? ??
            ?? ?? 8B 4C 24 ?? 8B 74 24 ?? 6A ?? 89 74 24 ?? 8D 41 ?? 50 FF 71 ?? 8D 41 ?? FF 71
            ?? 50 51 6A ?? 6A ?? FF 76 ?? E8 ?? ?? ?? ?? FF D0 85 C0 0F 89 ?? ?? ?? ?? 83 C8 ??
            F0 0F C1 46 ?? 0F 85 ?? ?? ?? ?? 6A ?? 6A ?? 56 E8 ?? ?? ?? ?? 8B 46 ?? 83 C4 ?? 33
            FF 85 C0 0F 84 ?? ?? ?? ?? 83 C6 ?? 8B 0E E8 ?? ?? ?? ?? 8B 44 24 ?? 8D 76 ?? 47 8B
            40 ?? 3B F8 72 ?? 8B 74 24 ?? 85 C0 E9 ?? ?? ?? ?? 83 C8 ?? F0 0F C1 46 ?? 0F 85 ??
            ?? ?? ?? 6A ?? 6A ?? 56 E8 ?? ?? ?? ?? 8B 4E ?? 83 C4 ?? C7 44 24 ?? ?? ?? ?? ?? 85
            C9 0F 84 ?? ?? ?? ?? 8D 7E ?? 66 0F 1F 44 00 ?? 8B 0F E8 ?? ?? ?? ?? 8B 44 24 ?? 8D
            7F ?? 8B 4E ?? 40 89 44 24 ?? 3B C1 72 ?? E9 ?? ?? ?? ?? B9 ?? ?? ?? ?? 8D 56 ?? 8B
            C1 F0 0F B1 0A 83 F8 ?? 75 ?? 8B 46 ?? 89 44 24 ?? 0F B7 46 ?? 83 C0 ?? 8B C8 89 44
            24 ?? E8 ?? ?? ?? ?? 8B F8 85 FF 74 ?? 0F B7 4E ?? 51 FF 76 ?? 8D 4F ?? 51 E8 ?? ??
            ?? ?? 0F B7 46 ?? 83 C4 ?? 89 47 ?? 0F 57 C0 8D 44 24 ?? C6 07 ?? C7 47 ?? ?? ?? ??
            ?? 6A ?? FF 74 24 ?? 66 0F 13 44 24 ?? 57 50 FF 74 24 ?? E8 ?? ?? ?? ?? FF D0 8B CF
            E8 ?? ?? ?? ?? 8D 56 ?? 85 F6 0F 84 ?? ?? ?? ?? 83 C8 ?? F0 0F C1 02 0F 85 ?? ?? ??
            ?? 6A ?? 6A ?? 56 E8 ?? ?? ?? ?? 8B 4E ?? 83 C4 ?? C7 44 24 ?? ?? ?? ?? ?? 85 C9 74
            ?? 8D 7E ?? 8B 0F E8 ?? ?? ?? ?? 8B 44 24 ?? 8D 7F ?? 8B 4E ?? 40 89 44 24 ?? 3B C1
            72 ?? 85 C9 74 ?? F0 FF 05 ?? ?? ?? ?? F0 FF 0D ?? ?? ?? ?? 8B 46 ?? 85 C0 74 ?? 50
            E8 ?? ?? ?? ?? FF D0 8D 46 ?? 50 E8 ?? ?? ?? ?? FF D0 8B CE E8 ?? ?? ?? ?? E9 ?? ??
            ?? ?? 5F 33 C0 5E 8B E5 5D C2
        }

    condition:
        uint16(0) == 0x5A4D and
        (
            (
                (
                    $enum_resources_v1
                ) and
                (
                    all of ($find_files_v1_*)
                ) and
                (
                    all of ($encrypt_files_v1_*)
                )
            ) or
            (
                (
                    $check_blacklisted_languages_v2
                ) and
                (
                    $fnv1a_hashing_v2
                ) and
                (
                    $create_net_host_trav_threads_v2
                ) and
                (
                    all of ($decrypt_configuration_v2_*)
                ) and
                (
                    all of ($encrypt_files_v2_p*)
                )
            )
        )
}