rule Win32_Ransomware_Paradise : tc_detection malicious
{
    meta:

        author              = "ReversingLabs"

        source              = "ReversingLabs"
        status              = "RELEASED"
        sharing             = "TLP:WHITE"
        category            = "MALWARE"
        malware             = "PARADISE"
        description         = "Yara rule that detects Paradise ransomware."

        tc_detection_type   = "Ransomware"
        tc_detection_name   = "Paradise"
        tc_detection_factor = 5

    strings:

        $search_files = {
            53 56 57 68 ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? 
            ?? C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 59 89 75 ?? 85 F6 
            0F 84 ?? ?? ?? ?? FF 75 ?? 8B 3D ?? ?? ?? ?? 68 ?? ?? ?? ?? BB ?? ?? ?? ?? 53 56 FF 
            D7 83 C4 ?? 8D 85 ?? ?? ?? ?? 50 56 FF 15 ?? ?? ?? ?? 89 45 ?? 83 F8 ?? 0F 84 ?? ?? 
            ?? ?? 83 65 ?? ?? 8B 45 ?? 8B 74 85 ?? 8D 95 ?? ?? ?? ?? 85 F6 74 ?? 0F B7 02 83 F8 
            ?? 72 ?? 8D 48 ?? 83 F8 ?? 76 ?? 8B C8 0F B7 06 83 F8 ?? 72 ?? 83 F8 ?? 77 ?? 83 C0 
            ?? 3B C8 0F B7 02 75 ?? 66 85 C0 74 ?? 83 C2 ?? 83 C6 ?? EB ?? 0F B7 02 EB ?? 66 3B 
            06 1B C0 83 E0 ?? 40 EB ?? 33 C0 85 C0 0F 84 ?? ?? ?? ?? FF 45 ?? 83 7D ?? ?? 72 ?? 
            8B 75 ?? 8D 85 ?? ?? ?? ?? 50 FF 75 ?? 68 ?? ?? ?? ?? 53 56 FF D7 83 C4 ?? F6 85 ?? 
            ?? ?? ?? ?? 74 ?? BA ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 ?? BA ?? 
            ?? ?? ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 ?? 80 3D ?? ?? ?? ?? ?? 74 ?? BA 
            ?? ?? ?? ?? 8B CE E8 ?? ?? ?? ?? 85 C0 74 ?? 56 E8 ?? ?? ?? ?? EB ?? F6 85 ?? ?? ?? 
            ?? ?? 74 ?? A1 ?? ?? ?? ?? 05 ?? ?? ?? ?? 50 8D 85 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 
            85 C0 75 ?? BA ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 ?? BA ?? ?? ?? 
            ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 ?? 56 E8 ?? ?? ?? ?? 59 8D 85 ?? ?? ?? 
            ?? 50 FF 75 ?? FF 15 ?? ?? ?? ?? 85 C0 0F 85 ?? ?? ?? ?? 68 ?? ?? ?? ?? FF 75 ?? 68 
            ?? ?? ?? ?? 53 FF 75 ?? FF D7 83 C4 ?? FF 75 ?? E8 ?? ?? ?? ?? 59 FF 75 ?? FF 15 ?? 
            ?? ?? ?? FF 75 ?? E8 ?? ?? ?? ?? 59 5F 5E 5B C9 C3 
        }

        $encrypt_files_p1 = {
            56 57 6A ?? BE ?? ?? ?? ?? 5F E8 ?? ?? ?? ?? 89 45 ?? 6A ?? 8D 45 ?? 50 56 E8 ?? ?? 
            ?? ?? 83 C4 ?? 83 C6 ?? 4F 75 ?? 33 F6 39 75 ?? 74 ?? 8D 45 ?? 50 A1 ?? ?? ?? ?? 0F 
            B7 88 ?? ?? ?? ?? 56 56 51 50 FF 75 ?? FF 15 ?? ?? ?? ?? 85 C0 74 ?? 6A ?? 59 89 4D 
            ?? 33 C0 8A 90 ?? ?? ?? ?? 88 90 ?? ?? ?? ?? 3B C6 75 ?? 33 C0 40 3B C1 72 ?? 68 ?? 
            ?? ?? ?? 8D 45 ?? 50 68 ?? ?? ?? ?? 56 6A ?? 56 FF 75 ?? FF 15 ?? ?? ?? ?? FF 75 ?? 
            FF 15 ?? ?? ?? ?? 5F 5E C9 C3 56 FF 75 ?? FF 15 ?? ?? ?? ?? 56 FF 15 
        }

        $encrypt_files_p2 = {
            53 56 57 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 35 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A ?? 33 DB 
            53 53 8D 44 24 ?? 50 89 5C 24 ?? FF D6 85 C0 75 ?? 68 ?? ?? ?? ?? 6A ?? 53 53 8D 44 
            24 ?? 50 FF D6 85 C0 75 ?? 89 5C 24 ?? 39 5C 24 ?? 75 ?? 53 FF 15 ?? ?? ?? ?? A1 ?? 
            ?? ?? ?? 0F B6 80 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? FF 
            74 24 ?? E8 ?? ?? ?? ?? 59 53 FF 74 24 ?? FF 15 ?? ?? ?? ?? BE ?? ?? ?? ?? 56 53 53 
            53 53 C6 05 ?? ?? ?? ?? ?? FF 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 56 88 1D ?? ?? ?? ?? E8 
            ?? ?? ?? ?? 59 33 C0 88 98 ?? ?? ?? ?? 3B C3 75 ?? 33 C0 40 83 F8 ?? 72 ?? 6A ?? 5E 
            68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 44 24 ?? 68 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 83 C4 
            ?? 6A ?? 53 53 8D 44 24 ?? 50 68 ?? ?? ?? ?? 53 FF 15 ?? ?? ?? ?? 4E 75 ?? 8B 3D ?? 
            ?? ?? ?? 81 C7 ?? ?? ?? ?? 6A ?? BB ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 85 C0 75 ?? 57 E8 
            ?? ?? ?? ?? 59 5F 5E 5B 8B E5 5D C3 
        }

        $http_remote_connection = {
            53 56 57 FF 75 ?? 33 FF 8D 75 ?? 89 7D ?? E8 ?? ?? ?? ?? 59 89 7D ?? 57 57 57 FF 75 
            ?? 57 FF 15 ?? ?? ?? ?? 89 45 ?? 3B C7 0F 84 ?? ?? ?? ?? 57 57 6A ?? 57 57 FF 75 ?? 
            FF 75 ?? 50 FF 15 ?? ?? ?? ?? 89 45 ?? 3B C7 0F 84 ?? ?? ?? ?? 33 C9 80 7D ?? ?? 57 
            0F 95 C1 B8 ?? ?? ?? ?? 49 23 C8 03 C8 51 57 57 57 FF 75 ?? 68 ?? ?? ?? ?? FF 75 ?? 
            FF 15 ?? ?? ?? ?? 8B D8 3B DF 74 ?? 57 57 57 57 53 FF 15 ?? ?? ?? ?? 85 C0 74 ?? 33 
            F6 57 57 8D 45 ?? 50 53 89 7D ?? FF 15 ?? ?? ?? ?? 85 C0 74 ?? 8B 45 ?? 03 C6 3B C7 
            75 ?? 89 7D ?? EB ?? 50 39 7D ?? 75 ?? E8 ?? ?? ?? ?? 59 EB ?? FF 75 ?? 6A ?? FF 15 
            ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 89 45 ?? 8D 45 ?? 50 FF 75 ?? 8B 45 ?? 03 C6 50 53 
            FF 15 ?? ?? ?? ?? 03 75 ?? 39 7D ?? 75 ?? 53 FF 15 ?? ?? ?? ?? FF 75 ?? FF 15 ?? ?? 
            ?? ?? FF 75 ?? FF 15 ?? ?? ?? ?? 39 7D ?? 75 ?? 33 C0 40 39 45 ?? 74 ?? 89 45 ?? E9 
            ?? ?? ?? ?? FF 75 ?? E8 ?? ?? ?? ?? FF 75 ?? E8 ?? ?? ?? ?? 8B 45 ?? 59 59 5F 5E 5B 
            C9 C3 
        }

    condition:
        uint16(0) == 0x5A4D and $search_files and $http_remote_connection and (all of ($encrypt_files_p*))
}