rule Win32_Ransomware_Ransomexx : tc_detection malicious
{
    meta:

        author              = "ReversingLabs"

        source              = "ReversingLabs"
        status              = "RELEASED"
        sharing             = "TLP:WHITE"
        category            = "MALWARE"
        malware             = "RANSOMEXX"
        description         = "Yara rule that detects Ransomexx ransomware."

        tc_detection_type   = "Ransomware"
        tc_detection_name   = "Ransomexx"
        tc_detection_factor = 5

    strings:

        $find_files_p1 = {
            55 8B EC 81 EC ?? ?? ?? ?? 53 56 57 8B 7D ?? 85 FF 0F 84 ?? ?? ?? ?? B8 ?? ?? ?? ?? 
            E8 ?? ?? ?? ?? 8B F4 B3 ?? 85 F6 74 ?? C6 46 ?? ?? B0 ?? 66 C7 06 ?? ?? 88 5E ?? 88 
            46 ?? 8B C7 8D 50 ?? 90 8A 08 40 84 C9 75 ?? 2B C2 8B D0 8B C6 8D 78 ?? 8A 08 40 84 
            C9 75 ?? 2B C7 8D 84 10 ?? ?? ?? ?? 50 6A ?? FF 15 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 
            89 45 ?? 85 C0 0F 84 ?? ?? ?? ?? 8B 7D ?? 68 ?? ?? ?? ?? 57 50 FF 15 ?? ?? ?? ?? 68 
            ?? ?? ?? ?? 56 8B 75 ?? 56 FF 15 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? 51 56 FF 15 ?? ?? ?? 
            ?? 8B F0 89 75 ?? 83 FE ?? 75 ?? FF 15 ?? ?? ?? ?? 8D A5 ?? ?? ?? ?? 5F 5E 5B 8B E5 
            5D C3 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B C4 89 45 ?? 85 C0 74 ?? C6 40 ?? ?? 88 18 88 
            58 ?? B9 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 8D 49 ?? 8A 10 3A 11 75 ?? 84 D2 74 ?? 8A 50 
            ?? 3A 51 ?? 75 ?? 83 C0 ?? 83 C1 ?? 84 D2 75 ?? 33 C0 EB ?? 1B C0 83 D8 ?? 85 C0 0F 
            84 ?? ?? ?? ?? 8B 4D ?? 8D 85 ?? ?? ?? ?? 8A 10 3A 11 75 ?? 84 D2 74 ?? 8A 50 ?? 3A
        }

        $find_files_p2 = { 
            51 ?? 75 ?? 83 C0 ?? 83 C1 ?? 84 D2 75 ?? 33 C0 EB ?? 1B C0 83 D8 ?? 85 C0 0F 84 ?? 
            ?? ?? ?? 8B C7 8D 50 ?? 8A 08 40 84 C9 75 ?? 2B C2 8B D0 8D 85 ?? ?? ?? ?? 8D 70 ?? 
            8D 64 24 ?? 8A 08 40 84 C9 75 ?? 8B 1D ?? ?? ?? ?? 2B C6 8D 94 10 ?? ?? ?? ?? 52 6A 
            ?? FF D3 50 FF 15 ?? ?? ?? ?? 8B F0 85 F6 0F 84 ?? ?? ?? ?? 68 ?? ?? ?? ?? 57 56 FF 
            15 ?? ?? ?? ?? 56 FF 15 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 50 56 FF 15 ?? 
            ?? ?? ?? F6 85 ?? ?? ?? ?? ?? 74 ?? 56 E8 ?? ?? ?? ?? 83 C4 ?? EB ?? 6A ?? 56 FF 15 
            ?? ?? ?? ?? 68 ?? ?? ?? ?? 56 FF 15 ?? ?? ?? ?? 85 C0 74 ?? 56 FF 15 ?? ?? ?? ?? 85 
            C0 75 ?? 56 FF 15 ?? ?? ?? ?? 85 C0 75 ?? 6A ?? 6A ?? 56 FF 15 ?? ?? ?? ?? 56 6A ?? 
            FF D3 50 FF 15 ?? ?? ?? ?? 8B 75 ?? 8D 8D ?? ?? ?? ?? 51 56 FF 15 ?? ?? ?? ?? 85 C0 
            0F 85 ?? ?? ?? ?? 56 FF 15 ?? ?? ?? ?? 8B 55 ?? 52 6A ?? FF 15 ?? ?? ?? ?? 50 FF 15 
            ?? ?? ?? ?? 6A ?? 57 FF 15 ?? ?? ?? ?? 57 FF 15 ?? ?? ?? ?? 8D A5 ?? ?? ?? ?? 5F 5E 
            5B 8B E5 5D C3 
        }

        $find_files_p3 = {
            55 8B EC 83 E4 ?? 81 EC ?? ?? ?? ?? 53 56 57 8B 7D ?? 85 FF 0F 84 ?? ?? ?? ?? 8B C7 
            8D 50 ?? 90 66 8B 08 83 C0 ?? 66 85 C9 75 ?? 2B C2 D1 F8 8D B4 00 ?? ?? ?? ?? 8D 86 
            ?? ?? ?? ?? 50 6A ?? FF 15 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 8B D8 85 DB 0F 84 ?? ?? 
            ?? ?? 56 57 53 FF 15 ?? ?? ?? ?? 56 68 ?? ?? ?? ?? 53 FF 15 ?? ?? ?? ?? 8D 4C 24 ?? 
            51 53 FF 15 ?? ?? ?? ?? 89 44 24 ?? 83 F8 ?? 75 ?? 8B 3D ?? ?? ?? ?? FF D7 83 F8 ?? 
            0F 84 ?? ?? ?? ?? FF D7 E9 ?? ?? ?? ?? 8D A4 24 ?? ?? ?? ?? 8B 3D ?? ?? ?? ?? 68 ?? 
            ?? ?? ?? 8D 94 24 ?? ?? ?? ?? 52 FF D7 85 C0 0F 84 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 84 
            24 ?? ?? ?? ?? 50 FF D7 85 C0 0F 84 ?? ?? ?? ?? F6 44 24 ?? ?? 0F 85 ?? ?? ?? ?? 8B 
            4D ?? 56 51 53 FF 15 ?? ?? ?? ?? 56 68 ?? ?? ?? ?? 53 FF 15 ?? ?? ?? ?? 56 8D 94 24 
            ?? ?? ?? ?? 52 53 FF 15 ?? ?? ?? ?? F6 44 24 ?? ?? 74 ?? E8 ?? ?? ?? ?? 85 C0 0F 85 
            ?? ?? ?? ?? 53 E8 ?? ?? ?? ?? E9 ?? ?? ?? ?? 8D 44 24 ?? 50 FF 15 ?? ?? ?? ?? 85 C0 
            74 ?? 66 83 38 ?? 74 ?? 68 ?? ?? ?? ?? 50 FF D7 85 C0 75 ?? FF 05 ?? ?? ?? ?? E9 ?? 
            ?? ?? ?? 8D 7C 24 ?? E8 ?? ?? ?? ?? 85 C0 0F 85 ?? ?? ?? ?? 39 05 ?? ?? ?? ?? 0F 84 
            ?? ?? ?? ?? 8B 3D ?? ?? ?? ?? 8D 4C 24 ?? 51 8D 54 24 ?? 52 FF D7 85 C0 74 ?? 8D 44
        }

        $find_files_p4 = { 
            24 ?? 50 8D 4C 24 ?? 51 6A ?? FF 15 ?? ?? ?? ?? 85 C0 74 ?? 0F B7 44 24 ?? 8B 0D ?? 
            ?? ?? ?? 3B C1 74 ?? 49 3B C1 74 ?? 8D 54 24 ?? 52 8D 44 24 ?? 50 FF D7 85 C0 74 ?? 
            8D 4C 24 ?? 51 8D 54 24 ?? 52 6A ?? FF 15 ?? ?? ?? ?? 85 C0 74 ?? 0F B7 44 24 ?? 8B 
            0D ?? ?? ?? ?? 3B C1 74 ?? 49 3B C1 74 ?? 8D 4C 24 ?? E8 ?? ?? ?? ?? 85 C0 0F 85 ?? 
            ?? ?? ?? 8B 44 24 ?? 0B 44 24 ?? 0F 84 ?? ?? ?? ?? 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 
            A1 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 6A ?? 6A ?? 50 51 FF 15 ?? ?? ?? ?? 83 F8 ?? 74 ?? 
            80 3B ?? 75 ?? 80 7B ?? ?? 75 ?? 8B 15 ?? ?? ?? ?? 8D 3C 85 ?? ?? ?? ?? 8B 04 17 53 
            50 FF 15 ?? ?? ?? ?? EB ?? 8B 0D ?? ?? ?? ?? 8D 3C 85 ?? ?? ?? ?? 8B 14 0F 68 ?? ?? 
            ?? ?? 52 FF 15 ?? ?? ?? ?? A1 ?? ?? ?? ?? 8B 0C 07 68 ?? ?? ?? ?? 53 51 FF 15 ?? ?? 
            ?? ?? 8B 15 ?? ?? ?? ?? 8B 04 17 50 FF 15 ?? ?? ?? ?? 68 ?? ?? ?? ?? FF 15 ?? ?? ?? 
            ?? 8B 54 24 ?? 8D 4C 24 ?? 51 52 FF 15 ?? ?? ?? ?? 85 C0 0F 85 ?? ?? ?? ?? 8B 44 24 
            ?? 50 FF 15 ?? ?? ?? ?? 53 6A ?? FF 15 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 5F 5E 33 C0 
            5B 8B E5 5D C2
        }

        $enum_network_resources = {
            55 8B EC 8B 4D ?? 83 EC ?? 8D 45 ?? 50 51 6A ?? 6A ?? 6A ?? FF 15 ?? ?? ?? ?? 85 C0 
            0F 85 ?? ?? ?? ?? 53 8B 1D ?? ?? ?? ?? 56 68 ?? ?? ?? ?? 6A ?? C7 45 ?? ?? ?? ?? ?? 
            FF D3 50 FF 15 ?? ?? ?? ?? 8B F0 89 75 ?? 85 F6 0F 84 ?? ?? ?? ?? 57 90 8B 4D ?? 8D 
            55 ?? 52 56 8D 45 ?? 50 51 C7 45 ?? ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 85 C0 0F 85 ?? ?? 
            ?? ?? 33 FF 39 7D ?? 76 ?? 83 C6 ?? 8D 64 24 ?? F6 46 ?? ?? 74 ?? F6 46 ?? ?? 74 ?? 
            8B 06 8D 50 ?? 66 8B 08 83 C0 ?? 66 85 C9 75 ?? 2B C2 D1 F8 8D 94 00 ?? ?? ?? ?? 52 
            6A ?? FF D3 50 FF 15 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 89 04 8D ?? ?? ?? ?? 85 C0 74 ?? 
            8B 16 0F B7 0A 66 89 08 83 C2 ?? 83 C0 ?? 66 85 C9 75 ?? FF 05 ?? ?? ?? ?? 8B 56 ?? 
            83 E2 ?? 80 FA ?? 75 ?? 8D 46 ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 47 83 C6 ?? 3B 7D ?? 72 
            ?? 8B 75 ?? E9 ?? ?? ?? ?? 56 6A ?? FF D3 50 FF 15 ?? ?? ?? ?? 5F 8B 4D ?? 51 FF 15 
            ?? ?? ?? ?? 5E 5B 8B E5 5D C3 
        }

        $encrypt_files_p1 = {
            55 8B EC 83 EC ?? 53 56 57 E8 ?? ?? ?? ?? 85 C0 0F 85 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 
            89 45 ?? 8D 45 ?? 50 FF 15 ?? ?? ?? ?? 8B 4D ?? B8 ?? ?? ?? ?? 89 4D ?? E8 ?? ?? ?? 
            ?? 8B F4 85 F6 0F 84 ?? ?? ?? ?? 8B D6 81 EA ?? ?? ?? ?? 83 C2 ?? 89 55 ?? 8B D6 81 
            EA ?? ?? ?? ?? 83 C2 ?? 89 55 ?? 8B D6 8B CE 8B FE 81 EA ?? ?? ?? ?? 33 C0 81 E9 ?? 
            ?? ?? ?? 81 EF ?? ?? ?? ?? 83 C2 ?? C6 46 ?? ?? 89 55 ?? 8B 5D ?? 8A D0 80 E2 ?? 02 
            90 ?? ?? ?? ?? 32 90 ?? ?? ?? ?? 88 94 01 ?? ?? ?? ?? 8D 50 ?? 80 E2 ?? 02 90 ?? ?? 
            ?? ?? 32 90 ?? ?? ?? ?? 88 94 07 ?? ?? ?? ?? 8D 50 ?? 80 E2 ?? 02 90 ?? ?? ?? ?? 32 
            90 ?? ?? ?? ?? 88 94 03 ?? ?? ?? ?? 8B 5D ?? 8D 50 ?? 80 E2 ?? 02 90 ?? ?? ?? ?? 32 
            90 ?? ?? ?? ?? 88 94 03 ?? ?? ?? ?? 8B 5D ?? 8D 50 ?? 80 E2 ?? 02 90 ?? ?? ?? ?? 32 
            90 ?? ?? ?? ?? 88 94 03 ?? ?? ?? ?? 8D 50 ?? 80 E2 ?? 02 90 ?? ?? ?? ?? 83 C0 ?? 32 
            90 ?? ?? ?? ?? 88 54 06 ?? 83 F8 ?? 0F 8C ?? ?? ?? ?? A1 ?? ?? ?? ?? 8B 4D ?? 50 51 
            FF 15 ?? ?? ?? ?? 50 56 E8 ?? ?? ?? ?? 83 C4 ?? 6A ?? FF 15 ?? ?? ?? ?? 50 FF 15 ?? 
            ?? ?? ?? 8B 35 ?? ?? ?? ?? 8D 55 ?? 52 6A ?? 6A ?? 68 ?? ?? ?? ?? 6A ?? 6A ?? C7 45 
            ?? ?? ?? ?? ?? FF D6 85 C0 75 ?? 8B 3D ?? ?? ?? ?? 8D 49 ?? 68 ?? ?? ?? ?? FF D7 8D 
            45 ?? 50 6A ?? 6A ?? 68 ?? ?? ?? ?? 6A ?? 6A ?? FF D6 85 C0 74 ?? 50 FF 15 ?? ?? ?? 
            ?? B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B FC 85 FF 0F 84 ?? ?? ?? ?? 8B D7 81 EA ?? ?? ?? 
            ?? 83 C2 ?? 89 55 ?? 8B D7 81 EA ?? ?? ?? ?? 83 C2 ?? 89 55 ?? 8B D7 8B CF 8B F7 81
        }

        $encrypt_files_p2 = {
            EA ?? ?? ?? ?? 33 C0 81 E9 ?? ?? ?? ?? 81 EE ?? ?? ?? ?? 83 C2 ?? C6 47 ?? ?? 89 55 
            ?? 8B 5D ?? 8A D0 80 E2 ?? 02 90 ?? ?? ?? ?? 32 90 ?? ?? ?? ?? 88 94 08 ?? ?? ?? ?? 
            8D 50 ?? 80 E2 ?? 02 90 ?? ?? ?? ?? 32 90 ?? ?? ?? ?? 88 94 30 ?? ?? ?? ?? 8D 50 ?? 
            80 E2 ?? 02 90 ?? ?? ?? ?? 32 90 ?? ?? ?? ?? 88 94 18 ?? ?? ?? ?? 8B 5D ?? 8D 50 ?? 
            80 E2 ?? 02 90 ?? ?? ?? ?? 32 90 ?? ?? ?? ?? 88 94 18 ?? ?? ?? ?? 8B 5D ?? 8D 50 ?? 
            80 E2 ?? 02 90 ?? ?? ?? ?? 32 90 ?? ?? ?? ?? 88 94 18 ?? ?? ?? ?? 8D 50 ?? 80 E2 ?? 
            02 90 ?? ?? ?? ?? 83 C0 ?? 32 90 ?? ?? ?? ?? 88 54 07 ?? 83 F8 ?? 0F 8C ?? ?? ?? ?? 
            E8 ?? ?? ?? ?? 8B D8 C7 05 ?? ?? ?? ?? ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 8B C8 2B 4D ?? 
            B8 ?? ?? ?? ?? F7 E1 8B CA C1 E9 ?? B8 ?? ?? ?? ?? F7 E1 C1 EA ?? 8B C2 C1 E0 ?? 2B 
            C2 03 C0 03 C0 2B C8 8B F2 B8 ?? ?? ?? ?? F7 E6 A1 ?? ?? ?? ?? 51 C1 EA ?? 8B CA C1 
            E1 ?? 2B CA 03 C9 03 C9 2B F1 56 52 8B 15 ?? ?? ?? ?? 52 50 53 57 E8 ?? ?? ?? ?? 83 
            C4 ?? 85 DB 0F 84 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? 
            ?? ?? E8 ?? ?? ?? ?? 8B D8 C7 05 ?? ?? ?? ?? ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 8B C8 2B 
            4D ?? B8 ?? ?? ?? ?? F7 E1 8B CA C1 E9 ?? B8 ?? ?? ?? ?? F7 E1 C1 EA ?? 8B C2 C1 E0 
            ?? 2B C2 03 C0 03 C0 2B C8 8B F2 B8 ?? ?? ?? ?? F7 E6 A1 ?? ?? ?? ?? 51 C1 EA ?? 8B 
            CA C1 E1 ?? 2B CA 03 C9 03 C9 2B F1 56 52 8B 15 ?? ?? ?? ?? 52 50 53 57 E8 ?? ?? ?? 
            ?? 83 C4 ?? 85 DB 0F 85 ?? ?? ?? ?? 8D 65 ?? 5F 5E 5B 8B E5 5D C3 
        }

    condition:
        uint16(0) == 0x5A4D and
        (
            $enum_network_resources
        ) and
        (
            all of ($find_files_p*)
        ) and
        (
            all of ($encrypt_files_p*)
        )
}