rule Win32_Ransomware_Sepsis : tc_detection malicious
{
    meta:

        author              = "ReversingLabs"

        source              = "ReversingLabs"
        status              = "RELEASED"
        sharing             = "TLP:WHITE"
        category            = "MALWARE"
        malware             = "SEPSIS"
        description         = "Yara rule that detects Sepsis ransomware."

        tc_detection_type   = "Ransomware"
        tc_detection_name   = "Sepsis"
        tc_detection_factor = 5

    strings:

        $search_files_1 = {
            55 8B EC 83 E4 ?? 81 EC ?? ?? ?? ?? 53 8B 5D ?? 8D 84 24 ?? ?? ?? ?? 56 57 8B 3D ?? 
            ?? ?? ?? 68 ?? ?? ?? ?? 53 50 FF D7 8D 44 24 ?? 50 8D 84 24 ?? ?? ?? ?? 50 FF 15 ?? 
            ?? ?? ?? 8D 4C 24 ?? 89 44 24 ?? 51 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84
        }

        $search_files_2 = {
            68 ?? ?? ?? ?? 8D 44 24 ?? 50 FF D6 85 C0 0F 84 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 44 24 
            ?? 50 FF D6 85 C0 0F 84 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 44 24 ?? 50 FF D6 85 C0 0F 84 
            ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 44 24 ?? 50 FF D6 85 C0 0F 84 ?? ?? ?? ?? 68 ?? ?? ?? 
            ?? 8D 44 24 ?? 50 FF D6 85 C0 0F 84 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 44 24 ?? 50 FF D6 
            85 C0 0F 84 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 44 24 ?? 50 FF D6 85 C0 0F 84 ?? ?? ?? ?? 
            68 ?? ?? ?? ?? 8D 44 24 ?? 50 FF D6 85 C0 0F 84 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 44 24 
            ?? 50 FF D6 85 C0 0F 84 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 44 24 ?? 50 FF D6 85 C0 0F 84 
            ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 44 24 ?? 50 FF D6 85 C0 0F 84 ?? ?? ?? ?? 68 ?? ?? ?? 
            ?? 8D 44 24 ?? 50 FF D6 85 C0 0F 84 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 44 24 ?? 50 FF D6 
            85 C0 0F 84 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 44 24 ?? 50 FF D6 85 C0 74 ?? 68 ?? ?? ?? 
            ?? 8D 44 24 ?? 50 FF D6 85 C0 74 ?? F6 44 24 ?? ?? 8D 44 24 ?? 50 53 8D 84 24 ?? ?? 
            ?? ?? 50 74 ?? FF D7 8D 84 24 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? EB ?? FF D7 8D 44 24 ?? 
            50 FF 15 ?? ?? ?? ?? 8B D0 8D 7A
        }

        $search_files_3 = {
            66 8B 0A 83 C2 ?? 66 85 C9 75 ?? 2B D7 D1 FA 83 FA ?? 75 ?? 66 83 78 ?? ?? 74 ?? 8D 
            8C 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 3D ?? ?? ?? ?? 8D 44 24 ?? 50 FF 74 24 ?? FF 15 
            ?? ?? ?? ?? 85 C0 0F 85 ?? ?? ?? ?? FF 74 24 ?? FF 15 ?? ?? ?? ?? 5F 5E 33 C0 5B 8B 
            E5 5D C2
        }

        $search_files_4 = {
            68 ?? ?? ?? ?? 8D 44 24 ?? 50 FF D6 85 C0 0F 84 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 44 24 
            ?? 50 FF D6 85 C0 0F 84 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 44 24 ?? 50 FF D6 85 C0 0F 84 
            ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 44 24 ?? 50 FF D6 85 C0 0F 84 ?? ?? ?? ?? 68 ?? ?? ?? 
            ?? 8D 44 24 ?? 50 FF D6 85 C0 0F 84 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 44 24 ?? 50 FF D6 
            85 C0 0F 84 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 44 24 ?? 50 FF D6 85 C0 0F 84 ?? ?? ?? ?? 
            68 ?? ?? ?? ?? 8D 44 24 ?? 50 FF D6 85 C0 0F 84 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 44 24 
            ?? 50 FF D6 85 C0 0F 84 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 44 24 ?? 50 FF D6 85 C0 0F 84 
            ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 44 24 ?? 50 FF D6 85 C0 0F 84 ?? ?? ?? ?? 68 ?? ?? ?? 
            ?? 8D 44 24 ?? 50 FF D6 85 C0 0F 84 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 44 24 ?? 50 FF D6 
            85 C0 0F 84 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 44 24 ?? 50 FF D6 85 C0 0F 84 ?? ?? ?? ?? 
            68 ?? ?? ?? ?? 8D 44 24 ?? 50 FF D6 85 C0 0F 84 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 44 24 
            ?? 50 FF D6 85 C0 74 ?? 68 ?? ?? ?? ?? 8D 44 24 ?? 50 FF D6 85 C0 74 ?? F6 44 24 ?? 
            ?? 8D 44 24 ?? 50 53 8D 84 24 ?? ?? ?? ?? 50 74 ?? FF D7 8D 84 24 ?? ?? ?? ?? 50 E8 
            ?? ?? ?? ?? EB ?? FF D7 8D 44 24 ?? 50 FF 15 ?? ?? ?? ?? 8B D0 8D 7A ?? 66 8B 0A 83 
            C2 ?? 66 85 C9 75 ?? 2B D7 D1 FA 83 FA ?? 75 ?? 66 83 78 ?? ?? 74 ?? 8D 8C 24 ?? ?? 
            ?? ?? E8 ?? ?? ?? ?? 8B 3D ?? ?? ?? ?? 8D 44 24 ?? 50 FF 74 24 ?? FF 15 ?? ?? ?? ?? 
            85 C0 0F 85 ?? ?? ?? ?? FF 74 24 ?? FF 15 ?? ?? ?? ?? 5F 5E 33 C0 5B 8B E5 5D C2
        }

        $encrypt_files_1 = {
            BA ?? ?? ?? ?? B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? BA ?? ?? ?? ?? B9 ?? ?? ?? ?? E8 ?? ?? 
            ?? ?? 6A ?? FF D6 0F 10 05 ?? ?? ?? ?? 8B F8 8D 85 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? 
            ?? ?? ?? 50 0F 11 07 89 3D ?? ?? ?? ?? 0F 10 05 ?? ?? ?? ?? 0F 11 47 ?? 0F 10 05 ?? 
            ?? ?? ?? 0F 11 47 ?? E8 ?? ?? ?? ?? 83 C4 ?? C7 45 ?? ?? ?? ?? ?? 8D 45 ?? C7 45 ?? 
            ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? 6A ?? 6A ?? 50 8D 85 ?? ?? ?? ?? 50 6A ?? 6A ?? 8D 
            85 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 85 C0 75 ?? 33 FF E9 ?? ?? ?? ?? 8D 45 ?? 50 8D 
            45 ?? 50 6A ?? 68 ?? ?? ?? ?? FF 75 ?? 8D 85 ?? ?? ?? ?? 50 6A ?? 6A ?? FF 15 ?? ?? 
            ?? ?? 85 C0 75 ?? 33 FF E9 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A ?? 6A ?? 6A ?? 8D 45 ?? 50 
            FF 15 ?? ?? ?? ?? 85 C0 75 ?? 33 FF E9 ?? ?? ?? ?? 8D 45 ?? 50 FF 75 ?? 6A ?? FF 75 
            ?? FF 15 ?? ?? ?? ?? 85 C0 75 ?? 33 FF EB ?? FF 75 ?? FF 15 ?? ?? ?? ?? 8B CF 8D 51
        }

        $encrypt_files_2 = {
            8A 01 41 84 C0 75 ?? 2B CA 8D 45 ?? 51 50 6A ?? 6A ?? 6A ?? 6A ?? FF 75 ?? 89 4D ?? 
            89 4D ?? FF D3 85 C0 75 ?? 33 FF EB ?? FF 75 ?? FF D6 FF 75 ?? 8B F0 6A ?? 56 E8 ?? 
            ?? ?? ?? FF 75 ?? 57 56 E8 ?? ?? ?? ?? 83 C4 ?? 8D 45 ?? FF 75 ?? 50 56 6A ?? 6A ?? 
            6A ?? FF 75 ?? FF D3 8B F8 F7 DF 1B FF 23 FE 8B 35 ?? ?? ?? ?? 8B D7 8D 4A ?? 66 90 
            8A 02 42 84 C0 75 ?? 2B D1 8B CF E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? 8D 50 ?? 8A 08 40 84 
            C9 75 ?? 2B C2 57 A3 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 83 C4 ?? 81 3D ?? ?? ?? ?? ?? ?? 
            ?? ?? 0F 82 ?? ?? ?? ?? 5F 5E 5B 8B E5 5D C3
        }

        $encrypt_files_3 = {
            55 8B EC 83 EC ?? 57 6A ?? 68 ?? ?? ?? ?? 6A ?? 6A ?? 6A ?? 8B C1 68 ?? ?? ?? ?? 50 
            89 45 ?? FF 15 ?? ?? ?? ?? 8B F8 83 FF ?? 75 ?? 0B C0 5F 8B E5 5D C3 53 6A ?? 57 FF 
            15 ?? ?? ?? ?? 8B D8 83 FB ?? 75 ?? FF 75 ?? 57 FF 15 ?? ?? ?? ?? 8B D8 56 B8 ?? ?? 
            ?? ?? 6A ?? 3B D8 0F 47 D8 53 6A ?? 6A ?? 6A ?? 57 FF 15 ?? ?? ?? ?? 8B F0 83 FE ?? 
            75 ?? 5E 5B 0B C0 5F 8B E5 5D C3 6A ?? 6A ?? 6A ?? 6A ?? 56 FF 15 ?? ?? ?? ?? 56 8B 
            35 ?? ?? ?? ?? 89 45 ?? FF D6 57 FF D6 E8 ?? ?? ?? ?? 0F 10 05 ?? ?? ?? ?? 0F 11 05 
            ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 ?? 8B F8 BE ?? ?? ?? ?? 0F 10 05 ?? ?? ?? ?? 0F 11 
            05 ?? ?? ?? ?? 85 DB 74
        }

        $encrypt_files_4 = {
            8A 0C 06 8D 40 ?? 30 48 ?? 83 EA ?? 75 ?? 8B CF E8 ?? ?? ?? ?? 8B F7 83 C7 ?? 83 EB 
            ?? 75 ?? 8B 45 ?? 0F 10 06 50 0F 11 05 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 68 ?? ?? ?? ?? 
            6A ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 55 ?? 83 C4 ?? 8B F2
        }

        $encrypt_files_5 = {
            66 8B 02 83 C2 ?? 66 85 C0 75 ?? BB ?? ?? ?? ?? 2B D6 8D 7B ?? 66 8B 47 ?? 83 C7 ?? 
            66 85 C0 75 ?? 8B CA C1 E9 ?? F3 A5 8B CA 83 E1 ?? 83 C3 ?? F3 A4 66 8B 43 ?? 83 C3 
            ?? 66 85 C0 75 ?? 8B FB B9 ?? ?? ?? ?? 8B 5D ?? BE ?? ?? ?? ?? 68 ?? ?? ?? ?? F3 A5 
            53 FF 15 ?? ?? ?? ?? 6A ?? 8B F0 6A ?? 56 FF 15 ?? ?? ?? ?? 56 FF 35 ?? ?? ?? ?? 6A 
            ?? FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 56 FF 15 ?? ?? ?? ?? 83 C4 ?? 68 ?? ?? ?? ?? 
            53 FF 15 ?? ?? ?? ?? 5E 5B 33 C0 5F 8B E5 5D C3
        }

    condition:
        uint16(0) == 0x5A4D and 
        (   
            all of ($search_files_*)
        ) and  
        (
            all of ($encrypt_files_*)
        )
}