rule Win32_Ransomware_WaspLocker : tc_detection malicious
{
    meta:

        author              = "ReversingLabs"

        source              = "ReversingLabs"
        status              = "RELEASED"
        sharing             = "TLP:WHITE"
        category            = "MALWARE"
        malware             = "WASPLOCKER"
        description         = "Yara rule that detects WaspLocker ransomware."

        tc_detection_type   = "Ransomware"
        tc_detection_name   = "WaspLocker"
        tc_detection_factor = 5

    strings:

        $find_files = {
            50 50 8D 8D ?? ?? ?? ?? 51 8D 8D ?? ?? ?? ?? 51 50 50 50 56 FF 15 ?? ?? ?? ?? 85 C0
            75 ?? 57 53 E8 ?? ?? ?? ?? 8D 4E ?? E8 ?? ?? ?? ?? E9 ?? ?? ?? ?? 8B 85 ?? ?? ?? ??
            A8 ?? 75 ?? FF B5 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? A8 ?? 0F 85 ?? ??
            ?? ?? 8D 85 ?? ?? ?? ?? 50 57 FF 15 ?? ?? ?? ?? 83 F8 ?? 0F 84 ?? ?? ?? ?? 50 FF 15
            ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? 85 C0 74 ?? 3B 85 ?? ?? ?? ?? 76 ?? 8D 85 ?? ?? ?? ??
            50 E8 ?? ?? ?? ?? 8B 95 ?? ?? ?? ?? 2B 95 ?? ?? ?? ?? 59 03 C2 B9 ?? ?? ?? ?? 3B C1
            7D ?? 8D 85 ?? ?? ?? ?? 2B CA 50 51 FF B5 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 ?? 85 C0
            74 ?? 83 F8 ?? 74 ?? 83 F8 ?? 74 ?? 83 F8 ?? 74 ?? 83 F8 ?? 75 ?? EB ?? 85 DB 0F 84
            ?? ?? ?? ?? C7 43 ?? ?? ?? ?? ?? 85 FF 75 ?? 33 C0 EB ?? 57 E8 ?? ?? ?? ?? 59 50 57
            8D 4B ?? E8 ?? ?? ?? ?? E9 ?? ?? ?? ?? 8D 4E ?? E8 ?? ?? ?? ?? 33 C0 40 E8 ?? ?? ??
            ?? C2 ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? CC 6A ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33
            F6 89 75 ?? 33 FF 89 7D ?? 21 75 ?? 21 75 ?? 39 3D ?? ?? ?? ?? 75 ?? 8D 45 ?? 50 E8
            ?? ?? ?? ?? 8B F8 89 7D ?? 85 FF 74 ?? FF 75 ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ??
            ?? ?? ?? 8B F0 89 75 ?? C7 45 ?? ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? C2
        }

        $drop_aux_files = {
            A1 ?? ?? ?? ?? 89 01 A1 ?? ?? ?? ?? 68 ?? ?? ?? ?? 89 41 ?? 66 A1 ?? ?? ?? ?? 68 ??
            ?? ?? ?? 6A ?? 66 89 41 ?? FF 15 ?? ?? ?? ?? 8B F0 85 F6 74 ?? 56 6A ?? FF 15 ?? ??
            ?? ?? 89 85 ?? ?? ?? ?? 85 C0 74 ?? 56 6A ?? FF 15 ?? ?? ?? ?? 85 C0 74 ?? 50 FF 15
            ?? ?? ?? ?? 8B F8 85 FF 74 ?? 8D 85 ?? ?? ?? ?? 68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 8B
            F0 83 C4 ?? 85 F6 74 ?? 56 FF B5 ?? ?? ?? ?? 6A ?? 57 E8 ?? ?? ?? ?? 6A ?? 6A ?? 56
            E8 ?? ?? ?? ?? 83 C4 ?? 56 E8 ?? ?? ?? ?? 83 C4 ?? 6A ?? 8D 85 ?? ?? ?? ?? 50 FF 15
            ?? ?? ?? ?? 8B B5 ?? ?? ?? ?? 81 C6 ?? ?? ?? ?? 56 FF 15 ?? ?? ?? ?? 85 C0 75 ?? 68
            ?? ?? ?? ?? BA ?? ?? ?? ?? 8B CE E8 ?? ?? ?? ?? 83 C4 ?? 6A ?? 6A ?? 6A ?? 68 ?? ??
            ?? ?? 6A ?? 6A ?? FF 15 ?? ?? ?? ?? 6A ?? 68 ?? ?? ?? ?? 6A ?? 6A ?? 6A ?? 68 ?? ??
            ?? ?? 56 C7 85 ?? ?? ?? ?? ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 8B F0 6A ?? 56 FF 15 ?? ??
            ?? ?? 50 89 85 ?? ?? ?? ?? E8
        }

        $drop_ransom_notes = {
            89 85 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? C6 45 ?? ?? E8 ?? ?? ?? ?? 84 C0
            75 ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? C6 45 ?? ?? E8
            ?? ?? ?? ?? 8B C8 85 C9 0F 84 ?? ?? ?? ?? 8B 01 8B 40 ?? FF D0 83 C0 ?? 89 85 ?? ??
            ?? ?? 68 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? C6 45 ?? ?? E8 ?? ?? ?? ?? 84 C0 75 ?? 68 ??
            ?? ?? ?? 68 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? C6 45 ?? ?? E8 ?? ?? ?? ??
            8B C8 85 C9 0F 84 ?? ?? ?? ?? 8B 01 8B 40 ?? FF D0 83 C0 ?? 89 85 ?? ?? ?? ?? 68 ??
            ?? ?? ?? 8D 8D ?? ?? ?? ?? C6 45 ?? ?? E8 ?? ?? ?? ?? 84 C0 75 ?? B9 ?? ?? ?? ?? 8D
            51 ?? 90 8A 01 41 84 C0 75 ?? 2B CA 51 68 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ??
            ?? C6 45 ?? ?? E8 ?? ?? ?? ?? 8B C8 85 C9 0F 84 ?? ?? ?? ?? 8B 01 8B 40 ?? FF D0 83
            C0 ?? 89 85 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? C6 45 ?? ?? E8 ?? ?? ?? ??
            84 C0 75
        }

    condition:
        uint16(0) == 0x5A4D and
        (
            $find_files
        ) and
        (
            $drop_aux_files
        ) and
        (
            $drop_ransom_notes
        )
}