rule Win32_Ransomware_Zhen : tc_detection malicious
{
    meta:

        author              = "ReversingLabs"

        source              = "ReversingLabs"
        status              = "RELEASED"
        sharing             = "TLP:WHITE"
        category            = "MALWARE"
        malware             = "ZHEN"
        description         = "Yara rule that detects Zhen ransomware."

        tc_detection_type   = "Ransomware"
        tc_detection_name   = "Zhen"
        tc_detection_factor = 5

    strings:

        $find_files_p1 = {
            FF 15 ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? 8D 95 
            ?? ?? ?? ?? 8B 4D ?? B8 ?? ?? ?? ?? 2B 41 ?? C1 E0 ?? 8B 4D ?? 8B 49 ?? 03 C8 FF 15 
            ?? ?? ?? ?? 8D 55 ?? 52 8D 45 ?? 50 FF 15 ?? ?? ?? ?? 8D 4D ?? 51 6A ?? FF 15 ?? ?? 
            ?? ?? 8D 55 ?? 8B 4D ?? 83 C1 ?? FF 15 ?? ?? ?? ?? 8D 4D ?? FF 15 ?? ?? ?? ?? C7 45 
            ?? ?? ?? ?? ?? 8D 55 ?? 52 E8 ?? ?? ?? ?? 8D 4D ?? FF 15 ?? ?? ?? ?? C7 45 ?? ?? ?? 
            ?? ?? 8D 45 ?? 50 E8 ?? ?? ?? ?? 8D 4D ?? FF 15 ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? 8D 
            4D ?? 51 E8 ?? ?? ?? ?? 8D 4D ?? FF 15 ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? 8D 55 ?? 52 
            E8 ?? ?? ?? ?? 8D 4D ?? FF 15 ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? 8D 45 ?? 50 8B 4D
        }

        $find_files_p2 = {
            8B 11 8B 45 ?? 50 FF 92 ?? ?? ?? ?? 89 85 ?? ?? ?? ?? 83 BD ?? ?? ?? ?? ?? 7D ?? 68 
            ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 4D ?? 51 8B 95 ?? ?? ?? ?? 52 FF 15 ?? ?? ?? ?? 89 85 
            ?? ?? ?? ?? EB ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? 8D 4D ?? FF 15 ?? ?? ?? ?? C7 45 ?? 
            ?? ?? ?? ?? 8D 45 ?? 50 E8 ?? ?? ?? ?? 8D 4D ?? FF 15 ?? ?? ?? ?? C7 45 ?? ?? ?? ?? 
            ?? 8D 4D ?? 51 E8 ?? ?? ?? ?? 8D 4D ?? FF 15 ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? 8D 55 
            ?? 52 E8 ?? ?? ?? ?? 8D 4D ?? FF 15 ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? 8D 45 ?? 50 E8 
            ?? ?? ?? ?? 8D 4D ?? FF 15 ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? 83 3D ?? ?? ?? ?? ?? 75 
            ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? EB 
            ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? 8B 8D ?? ?? ?? ?? 8B 11 89 95 ?? ?? ?? ?? C7 45 ?? 
            ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? B8 ?? ?? 
            ?? ?? E8 ?? ?? ?? ?? 8B C4 8B 4D ?? 89 08 8B 55 ?? 89 50 ?? 8B 4D ?? 89 48 ?? 8B 55 
            ?? 89 50 ?? B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B C4 8B 4D ?? 89 08 8B 55 ?? 89 50 ?? 8B 
            4D ?? 89 48 ?? 8B 55 ?? 89 50 ?? 8B 85 ?? ?? ?? ?? 8B 08 8B 95 ?? ?? ?? ?? 52 FF 91 
            ?? ?? ?? ?? DB E2 89 85 ?? ?? ?? ?? 83 BD ?? ?? ?? ?? ?? 7D ?? 68 ?? ?? ?? ?? 68 ?? 
            ?? ?? ?? 8B 85 ?? ?? ?? ?? 50 8B 8D ?? ?? ?? ?? 51 FF 15 ?? ?? ?? ?? 89 85 ?? ?? ?? 
            ?? EB ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? 68 ?? ?? ?? ?? EB ?? 8D 
            4D ?? FF 15 ?? ?? ?? ?? 8D 4D ?? FF 15 ?? ?? ?? ?? 8D 55 ?? 52 6A ?? FF 15 ?? ?? ?? 
            ?? C3 C3 8B 45 ?? 8B 08 8B 55 ?? 52 FF 51 ?? 8B 45 ?? 8B 4D ?? 64 89 0D ?? ?? ?? ?? 
            5F 5E 5B 8B E5 5D C2
        }

        $encrypt_files_p1 = {
            55 8B EC 83 EC ?? 68 ?? ?? ?? ?? 64 A1 ?? ?? ?? ?? 50 64 89 25 ?? ?? ?? ?? B8 ?? ?? 
            ?? ?? E8 ?? ?? ?? ?? 53 56 57 89 65 ?? C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? C7 
            45 ?? ?? ?? ?? ?? 8B 45 ?? 8B 08 8B 55 ?? 52 FF 51 ?? C7 45 ?? ?? ?? ?? ?? C7 45 ?? 
            ?? ?? ?? ?? 6A ?? FF 15 ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? C7 45 
            ?? ?? ?? ?? ?? 8D 45 ?? 50 FF 15 ?? ?? ?? ?? 66 89 45 ?? 8D 4D ?? FF 15 ?? ?? ?? ?? 
            C7 45 ?? ?? ?? ?? ?? 8B 4D ?? 8B 11 52 66 8B 45 ?? 50 6A ?? 6A ?? FF 15 ?? ?? ?? ?? 
            C7 45 ?? ?? ?? ?? ?? 6A ?? 66 8B 4D ?? 51 FF 15 ?? ?? ?? ?? 83 E8 ?? 50 6A ?? 6A ?? 
            8D 55 ?? 52 6A ?? 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 83 C4 ?? C7 45 ?? ?? ?? ?? ?? 66 
            8B 45 ?? 50 8D 4D ?? 51 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? 66 8B 
            55 ?? 52 FF 15 ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? 8B 45 ?? 50 8D 4D ?? 51 8B 55 ?? 8B 
            02 8B 4D ?? 51 FF 50 ?? 89 45 ?? 83 7D ?? ?? 7D ?? 6A ?? 68 ?? ?? ?? ?? 8B 55 ?? 52 
            8B 45 ?? 50 FF 15 ?? ?? ?? ?? 89 45 ?? EB ?? C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? 
            ?? C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? 8D 4D ?? 51 FF 15 ?? ?? ?? ?? 66 89 45 
            ?? 8D 4D ?? FF 15 ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? 8B 55 ?? 8B 02 50 66 8B 4D ?? 51
        }

        $encrypt_files_p2 = { 
            6A ?? 6A ?? FF 15 ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? BA ?? ?? ?? ?? 8D 4D ?? FF 15 ?? 
            ?? ?? ?? 8D 55 ?? 52 8D 45 ?? 50 8B 4D ?? 8B 11 8B 45 ?? 50 FF 52 ?? 89 45 ?? 83 7D 
            ?? ?? 7D ?? 6A ?? 68 ?? ?? ?? ?? 8B 4D ?? 51 8B 55 ?? 52 FF 15 ?? ?? ?? ?? 89 45 ?? 
            EB ?? C7 45 ?? ?? ?? ?? ?? 66 8B 45 ?? 50 8D 4D ?? 51 68 ?? ?? ?? ?? FF 15 ?? ?? ?? 
            ?? 8D 4D ?? FF 15 ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? 66 8B 55 ?? 52 8D 45 ?? 50 68 ?? 
            ?? ?? ?? FF 15 ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? 66 8B 4D ?? 51 FF 15 ?? ?? ?? ?? C7 
            45 ?? ?? ?? ?? ?? 66 C7 45 ?? ?? ?? E9 ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? 6A ?? FF 15 
            ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? 66 8B 55 ?? 52 FF 15 ?? ?? ?? ?? C7 45 ?? ?? ?? ?? 
            ?? 8B 45 ?? 8B 08 51 8D 55 ?? 52 FF 15 ?? ?? ?? ?? 50 8B 45 ?? 8B 08 51 8D 55 ?? 52 
            FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 8B 45 ?? 50 8B 4D ?? 51 FF 15 
            ?? ?? ?? ?? 8B 55 ?? 52 8B 45 ?? 50 FF 15 ?? ?? ?? ?? 8D 4D ?? 51 8D 55 ?? 52 6A ?? 
            FF 15 ?? ?? ?? ?? 83 C4 ?? C7 45 ?? ?? ?? ?? ?? 66 C7 45 ?? ?? ?? FF 15 ?? ?? ?? ?? 
            68 ?? ?? ?? ?? EB ?? 8D 45 ?? 50 8D 4D ?? 51 6A ?? FF 15 ?? ?? ?? ?? 83 C4 ?? 8D 4D 
            ?? FF 15 ?? ?? ?? ?? C3 8D 55 ?? 52 6A ?? FF 15 ?? ?? ?? ?? 8D 45 ?? 50 6A ?? FF 15 
            ?? ?? ?? ?? C3 8B 4D ?? 8B 11 8B 45 ?? 50 FF 52 ?? 8B 4D ?? 66 8B 55 ?? 66 89 11 8B 
            45 ?? 8B 4D ?? 64 89 0D ?? ?? ?? ?? 5F 5E 5B 8B E5 5D C2
        }

        $scan_network_p1 = {
            55 8B EC 83 EC ?? 68 ?? ?? ?? ?? 64 A1 ?? ?? ?? ?? 50 64 89 25 ?? ?? ?? ?? B8 ?? ?? 
            ?? ?? E8 ?? ?? ?? ?? 53 56 57 89 65 ?? C7 45 ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? C7 
            45 ?? ?? ?? ?? ?? 8B 45 ?? 8B 08 8B 55 ?? 52 FF 51 ?? C7 45 ?? ?? ?? ?? ?? C7 45 ?? 
            ?? ?? ?? ?? 6A ?? FF 15 ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? 8B 45 ?? 8B 08 8B 55 ?? 52 
            FF 91 ?? ?? ?? ?? 50 8D 45 ?? 50 FF 15 ?? ?? ?? ?? 89 85 ?? ?? ?? ?? 8D 4D ?? 51 8B 
            95 ?? ?? ?? ?? 8B 02 8B 8D ?? ?? ?? ?? 51 FF 90 ?? ?? ?? ?? DB E2 89 85 ?? ?? ?? ?? 
            83 BD ?? ?? ?? ?? ?? 7D ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 95 ?? ?? ?? ?? 52 8B 85 
            ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 89 85 ?? ?? ?? ?? EB ?? C7 85 ?? ?? ?? ?? ?? ?? ?? 
            ?? C7 45 ?? ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? 8D 95 ?? ?? ?? ?? 8D 4D ?? FF 
            15 ?? ?? ?? ?? 6A ?? 6A ?? 8D 4D ?? 51 8B 55 ?? 52 8D 45 ?? 50 FF 15 ?? ?? ?? ?? 8D 
            4D ?? 51 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 89 85 ?? ?? ?? ?? 8D 95 ?? ?? ?? ?? 52 8D 
            45 ?? 50 FF 15 ?? ?? ?? ?? 8D 4D ?? FF 15 ?? ?? ?? ?? 8D 4D ?? FF 15 ?? ?? ?? ?? 8D 
            4D ?? 51 8D 55 ?? 52 6A ?? FF 15 ?? ?? ?? ?? 83 C4 ?? C7 45 ?? ?? ?? ?? ?? 8B 45 ?? 
            8B 08 8B 55 ?? 52 FF 91 ?? ?? ?? ?? 50 8D 45 ?? 50 FF 15 ?? ?? ?? ?? 89 85 ?? ?? ?? 
            ?? 8D 4D ?? 51 8B 95 ?? ?? ?? ?? 8B 02 8B 8D ?? ?? ?? ?? 51 FF 90 ?? ?? ?? ?? DB E2 
            89 85 ?? ?? ?? ?? 83 BD ?? ?? ?? ?? ?? 7D ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 95 ?? 
            ?? ?? ?? 52 8B 85 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 89 85 ?? ?? ?? ?? EB ?? C7 85 ?? 
            ?? ?? ?? ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? 8D 95 ?? ?? 
            ?? ?? 8D 4D ?? FF 15 ?? ?? ?? ?? 6A ?? 6A ?? 8D 4D ?? 51 8B 55 ?? 52 8D 45 ?? 50 FF
        }

        $scan_network_p2 = {
            15 ?? ?? ?? ?? 8D 4D ?? 51 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 89 85 ?? ?? ?? ?? 8D 95 
            ?? ?? ?? ?? 52 8D 45 ?? 50 FF 15 ?? ?? ?? ?? 8D 4D ?? FF 15 ?? ?? ?? ?? 8D 4D ?? FF 
            15 ?? ?? ?? ?? 8D 4D ?? 51 8D 55 ?? 52 6A ?? FF 15 ?? ?? ?? ?? 83 C4 ?? C7 45 ?? ?? 
            ?? ?? ?? 8B 45 ?? B9 ?? ?? ?? ?? 2B 48 ?? 8B 55 ?? 8B 42 ?? 8B 0C 88 51 FF 15 ?? ?? 
            ?? ?? DD 9D ?? ?? ?? ?? 8B 55 ?? B8 ?? ?? ?? ?? 2B 42 ?? 8B 4D ?? 8B 51 ?? 8B 04 82 
            50 FF 15 ?? ?? ?? ?? DC AD ?? ?? ?? ?? DD 9D ?? ?? ?? ?? 8B 4D ?? BA ?? ?? ?? ?? 2B 
            51 ?? 8B 45 ?? 8B 48 ?? 8B 14 91 52 FF 15 ?? ?? ?? ?? DD 9D ?? ?? ?? ?? 8B 45 ?? B9 
            ?? ?? ?? ?? 2B 48 ?? 8B 55 ?? 8B 42 ?? 8B 0C 88 51 FF 15 ?? ?? ?? ?? DC AD ?? ?? ?? 
            ?? DC 0D ?? ?? ?? ?? DC 85 ?? ?? ?? ?? DD 9D ?? ?? ?? ?? 8B 55 ?? B8 ?? ?? ?? ?? 2B 
            42 ?? 8B 4D ?? 8B 51 ?? 8B 04 82 50 FF 15 ?? ?? ?? ?? DD 9D ?? ?? ?? ?? 8B 4D ?? BA 
            ?? ?? ?? ?? 2B 51 ?? 8B 45 ?? 8B 48 ?? 8B 14 91 52 FF 15 ?? ?? ?? ?? DC AD ?? ?? ?? 
            ?? DC 0D ?? ?? ?? ?? DC 0D ?? ?? ?? ?? DC 85 ?? ?? ?? ?? DD 9D ?? ?? ?? ?? 8B 45 ?? 
            33 C9 2B 48 ?? 8B 55 ?? 8B 42 ?? 8B 0C 88 51 FF 15 ?? ?? ?? ?? DD 9D ?? ?? ?? ?? 8B 
            55 ?? 33 C0 2B 42 ?? 8B 4D ?? 8B 51 ?? 8B 04 82 50 FF 15 ?? ?? ?? ?? DC AD ?? ?? ?? 
            ?? DC 0D ?? ?? ?? ?? DC 0D ?? ?? ?? ?? DC 0D ?? ?? ?? ?? DC 85 ?? ?? ?? ?? DD 5D ?? 
            C7 45 ?? ?? ?? ?? ?? DD 45 ?? FF 15 ?? ?? ?? ?? 8B 4D ?? 89 41 ?? C7 45 ?? ?? ?? ?? 
            ?? C7 45 ?? ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? C7 85
        }

        $scan_network_p3 = {
            C7 85 ?? ?? ?? ?? ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ?? 
            ?? ?? 8D 95 ?? ?? ?? ?? 52 8D 85 ?? ?? ?? ?? 50 8D 8D ?? ?? ?? ?? 51 8D 95 ?? ?? ?? 
            ?? 52 8D 85 ?? ?? ?? ?? 50 8D 4D ?? 51 FF 15 ?? ?? ?? ?? 89 85 ?? ?? ?? ?? E9 ?? ?? 
            ?? ?? C7 45 ?? ?? ?? ?? ?? 83 3D ?? ?? ?? ?? ?? 75 ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 
            FF 15 ?? ?? ?? ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? EB ?? C7 85 ?? ?? ?? ?? ?? ?? ?? ?? 
            8B 95 ?? ?? ?? ?? 8B 02 89 85 ?? ?? ?? ?? 8B 4D ?? 8B 11 8B 45 ?? 50 FF 92 ?? ?? ?? 
            ?? 50 8D 4D ?? 51 FF 15 ?? ?? ?? ?? 89 85 ?? ?? ?? ?? 8D 55 ?? 52 8D 45 ?? 50 FF 15 
            ?? ?? ?? ?? 50 8B 8D ?? ?? ?? ?? 8B 11 8B 85 ?? ?? ?? ?? 50 FF 52 ?? DB E2 89 85 ?? 
            ?? ?? ?? 83 BD ?? ?? ?? ?? ?? 7D ?? 6A ?? 68 ?? ?? ?? ?? 8B 8D ?? ?? ?? ?? 51 8B 95 
            ?? ?? ?? ?? 52 FF 15 ?? ?? ?? ?? 89 85 ?? ?? ?? ?? EB ?? C7 85 ?? ?? ?? ?? ?? ?? ?? 
            ?? 8B 45 ?? 89 85 ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? 8B 8D ?? ?? ?? ?? 51 8D 55 ?? 52 
            FF 15 ?? ?? ?? ?? 50 8B 85 ?? ?? ?? ?? 8B 08 8B 95 ?? ?? ?? ?? 52 FF 51 ?? DB E2 89 
            85 ?? ?? ?? ?? 83 BD ?? ?? ?? ?? ?? 7D ?? 6A ?? 68 ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? 50
        }

        $scan_network_p4 = { 
            8B 8D ?? ?? ?? ?? 51 FF 15 ?? ?? ?? ?? 89 85 ?? ?? ?? ?? EB ?? C7 85 ?? ?? ?? ?? ?? 
            ?? ?? ?? 8D 55 ?? 52 8D 45 ?? 50 6A ?? FF 15 ?? ?? ?? ?? 83 C4 ?? C7 45 ?? ?? ?? ?? 
            ?? FF 15 ?? ?? ?? ?? C7 45 ?? ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? 51 8D 95 ?? ?? ?? ?? 52 
            8D 45 ?? 50 FF 15 ?? ?? ?? ?? 89 85 ?? ?? ?? ?? 83 BD ?? ?? ?? ?? ?? 0F 85 ?? ?? ?? 
            ?? C7 45 ?? ?? ?? ?? ?? 8B 4D ?? 8B 11 8B 45 ?? 50 FF 92 ?? ?? ?? ?? 50 8D 4D ?? 51 
            FF 15 ?? ?? ?? ?? 89 85 ?? ?? ?? ?? 6A ?? 8B 95 ?? ?? ?? ?? 8B 02 8B 8D ?? ?? ?? ?? 
            51 FF 50 ?? DB E2 89 85 ?? ?? ?? ?? 83 BD ?? ?? ?? ?? ?? 7D ?? 6A ?? 68 ?? ?? ?? ?? 
            8B 95 ?? ?? ?? ?? 52 8B 85 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 89 85 ?? ?? ?? ?? EB ?? 
            C7 85 ?? ?? ?? ?? ?? ?? ?? ?? 8D 4D ?? FF 15 ?? ?? ?? ?? 9B 68 ?? ?? ?? ?? EB ?? 8D 
            4D ?? FF 15 ?? ?? ?? ?? 8D 4D ?? 51 8D 55 ?? 52 8D 45 ?? 50 6A ?? FF 15 ?? ?? ?? ?? 
            83 C4 ?? 8D 4D ?? 51 8D 55 ?? 52 6A ?? FF 15 ?? ?? ?? ?? 83 C4 ?? C3 8D 85 ?? ?? ?? 
            ?? 50 8D 8D ?? ?? ?? ?? 51 6A ?? FF 15 ?? ?? ?? ?? 83 C4 ?? 8D 4D ?? FF 15 ?? ?? ?? 
            ?? 8D 55 ?? 52 6A ?? FF 15 ?? ?? ?? ?? 8D 45 ?? 50 6A ?? FF 15 ?? ?? ?? ?? C3 8B 4D 
            ?? 8B 11 8B 45 ?? 50 FF 52 ?? 8B 4D ?? 66 8B 55 ?? 66 89 11 8B 45 ?? 8B 4D ?? 64 89 
            0D ?? ?? ?? ?? 5F 5E 5B 8B E5 5D C2
        }

    condition:
        uint16(0) == 0x5A4D and
        (
            all of ($scan_network_p*)
        ) and
        (
            all of ($find_files_p*)
        ) and
        (
            all of ($encrypt_files_p*)
        )
}