rule Win64_Ransomware_AwesomeScott : tc_detection malicious
{
    meta:

        author              = "ReversingLabs"

        source              = "ReversingLabs"
        status              = "RELEASED"
        sharing             = "TLP:WHITE"
        category            = "MALWARE"
        malware             = "AWESOMESCOTT"
        description         = "Yara rule that detects AwesomeScott ransomware."

        tc_detection_type   = "Ransomware"
        tc_detection_name   = "AwesomeScott"
        tc_detection_factor = 5

    strings:

      $encrypt_files_p1 = {
            48 8B C4 48 89 58 ?? 48 89 68 ?? 48 89 70 ?? 57 41 54 41 55 41 56 41 57 48 83 EC ?? 
            45 33 FF 4C 8B F2 49 8B D8 4C 89 78 ?? C7 40 ?? ?? ?? ?? ?? C7 40 ?? ?? ?? ?? ?? 4C 
            89 78 ?? 4C 89 78 ?? 4C 89 78 ?? 4C 89 78 ?? B8 ?? ?? ?? ?? 48 8B F1 45 33 C9 44 8B 
            C0 8B D0 49 8B CE 45 32 ED 48 83 CD ?? 49 8B FF FF 15 ?? ?? ?? ?? 4C 8B E0 48 3B C5 
            75 ?? FF 15 ?? ?? ?? ?? 8B D8 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 48 ?? E8 ?? 
            ?? ?? ?? E8 ?? ?? ?? ?? 4C 8D 05 ?? ?? ?? ?? 48 8D 48 ?? 48 8D 15 ?? ?? ?? ?? E8 ?? 
            ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 83 C0 ?? 44 8B C3 48 8B C8 E8 ?? ?? 
            ?? ?? E9 ?? ?? ?? ?? 45 33 C9 4C 89 7C 24 ?? 48 8B CB 41 8D 51 ?? 45 8D 41 ?? C7 44 
            24 ?? ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 8B E8 48 83 F8 ?? 75 
            ?? FF 15 ?? ?? ?? ?? 8B D8 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 48 ?? E8 ?? ?? 
            ?? ?? E8 ?? ?? ?? ?? 4C 8D 05 ?? ?? ?? ?? 48 8D 48 ?? 48 8D 15 ?? ?? ?? ?? E8 ?? ?? 
            ?? ?? E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 83 C0 ?? 44 8B C3 48 8B C8 E8 ?? ?? ?? 
            ?? E9 ?? ?? ?? ?? BB ?? ?? ?? ?? 4C 8D 05 ?? ?? ?? ?? 48 8D 4C 24 ?? 33 D2 44 8B CB
      }

      $encrypt_files_p2 = {
            44 89 7C 24 ?? FF 15 ?? ?? ?? ?? 85 C0 75 ?? FF 15 ?? ?? ?? ?? 3D ?? ?? ?? ?? 75 ?? 
            4C 8D 05 ?? ?? ?? ?? 48 8D 4C 24 ?? 44 8B CB 33 D2 C7 44 24 ?? ?? ?? ?? ?? FF 15 ?? 
            ?? ?? ?? 85 C0 75 ?? FF 15 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? E9 ?? ?? ?? ?? 48 8B 4C 
            24 ?? 48 8D 44 24 ?? 45 33 C9 45 33 C0 BA ?? ?? ?? ?? 48 89 44 24 ?? FF 15 ?? ?? ?? 
            ?? 85 C0 75 ?? FF 15 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? E9 ?? ?? ?? ?? 48 8D 0D ?? ?? 
            ?? ?? FF 15 ?? ?? ?? ?? 48 8B 4C 24 ?? 48 8D 15 ?? ?? ?? ?? 44 8B C0 45 33 C9 FF 15 
            ?? ?? ?? ?? 85 C0 75 ?? FF 15 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? E9 ?? ?? ?? ?? 4C 8B 
            44 24 ?? 48 8B 4C 24 ?? 48 8D 44 24 ?? 41 B9 ?? ?? ?? ?? BA ?? ?? ?? ?? 48 89 44 24 
            ?? FF 15 ?? ?? ?? ?? 85 C0 75 ?? FF 15 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? E9 ?? ?? ?? 
            ?? B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B F8 48 85 C0 75 ?? 41 B8 ?? ?? ?? ?? 48 8D 15 
            ?? ?? ?? ?? E9 ?? ?? ?? ?? 32 DB 90 4C 8D 4C 24 ?? 41 B8 ?? ?? ?? ?? 48 8B D7 49 8B 
            CC 4C 89 7C 24 ?? FF 15 ?? ?? ?? ?? 85 C0 0F 84 ?? ?? ?? ?? 81 7C 24 ?? ?? ?? ?? ?? 
            48 8B 4C 24 ?? B8 ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? 0F B6 DB 0F 42 D8 48 8D 44 24 
            ?? 45 33 C9 48 89 44 24 ?? 44 0F B6 C3 33 D2 48 89 7C 24 ?? FF 15 ?? ?? ?? ?? 85 C0
      }

      $encrypt_files_p3 = {
            74 ?? 44 8B 44 24 ?? 4C 8D 4C 24 ?? 48 8B D7 48 8B CD 4C 89 7C 24 ?? FF 15 ?? ?? ?? 
            ?? 85 C0 74 ?? 84 DB 0F 84 ?? ?? ?? ?? 41 B5 ?? EB ?? FF 15 ?? ?? ?? ?? 48 8D 15 ?? 
            ?? ?? ?? EB ?? FF 15 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? EB ?? FF 15 ?? ?? ?? ?? 48 8D 
            15 ?? ?? ?? ?? 44 8B C0 48 8B CE E8 ?? ?? ?? ?? 4D 85 E4 74 ?? 49 8B CC FF 15 ?? ?? 
            ?? ?? 48 85 ED 74 ?? 48 8B CD FF 15 ?? ?? ?? ?? 48 85 FF 74 ?? 48 8B CF E8 ?? ?? ?? 
            ?? 48 8B 4C 24 ?? 48 85 C9 74 ?? FF 15 ?? ?? ?? ?? 85 C0 75 ?? FF 15 ?? ?? ?? ?? 8B 
            D8 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 48 ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 4C 
            8D 05 ?? ?? ?? ?? 48 8D 48 ?? 48 8D 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 
            8D 15 ?? ?? ?? ?? 48 83 C0 ?? 44 8B C3 48 8B C8 E8 ?? ?? ?? ?? 4C 89 7C 24 ?? 48 8B 
            4C 24 ?? 48 85 C9 74 ?? FF 15 ?? ?? ?? ?? 85 C0 75 ?? FF 15 ?? ?? ?? ?? 8B D8 E8 ?? 
            ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 48 ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 4C 8D 05 ?? 
            ?? ?? ?? 48 8D 48 ?? 48 8D 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8D 15 ?? 
            ?? ?? ?? 48 83 C0 ?? 44 8B C3 48 8B C8 E8 ?? ?? ?? ?? 48 8B 4C 24
        }

      $find_files = {
            E8 ?? ?? ?? ?? 48 8D 8C 24 ?? ?? ?? ?? 33 F6 33 D2 41 B8 ?? ?? ?? ?? 66 89 B4 24 ?? 
            ?? 00 00 E8 ?? ?? ?? ?? 4C 8D 05 ?? ?? ?? ?? 48 8D 8C 24 ?? ?? ?? ?? 48 8B D7 FF 15 
            ?? ?? ?? ?? 48 8D 54 24 ?? 48 8D 8C 24 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 8B D8 48 83 
            F8 ?? 0F 84 ?? ?? ?? ?? 0F 1F 40 ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 ?? 41 B8 ?? ?? 
            ?? ?? E8 ?? ?? ?? ?? 85 C0 0F 84 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 ?? 41 
            B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 0F 84 ?? ?? ?? ?? F6 44 24 ?? ?? 74 ?? 4C 8D 44 
            24 ?? 48 8D 8C 24 ?? ?? ?? ?? 48 8B D7 FF 15 ?? ?? ?? ?? 48 8D 8C 24 ?? ?? ?? ?? E8 
            ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 ?? FF 15 ?? ?? ?? ?? 85 C0 0F 85 ?? ?? 
            ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 ?? FF 15 ?? ?? ?? ?? 85 C0 0F 85 ?? ?? ?? ?? 
            48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 ?? FF 15 ?? ?? ?? ?? 85 C0 0F 85 ?? ?? ?? ?? 48 8D 
            15 ?? ?? ?? ?? 48 8D 4C 24 ?? FF 15 ?? ?? ?? ?? 85 C0 0F 85 ?? ?? ?? ?? 48 8D 15 ?? 
            ?? ?? ?? 48 8D 4C 24 ?? FF 15 ?? ?? ?? ?? 85 C0 0F 85 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? 
            ?? 48 8D 4C 24 ?? FF 15 ?? ?? ?? ?? 85 C0 0F 85 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 
            8D 4C 24 ?? FF 15 ?? ?? ?? ?? 85 C0 0F 85 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 
            24 ?? FF 15 ?? ?? ?? ?? 85 C0 0F 85 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 ?? 
            FF 15 ?? ?? ?? ?? 85 C0 0F 85 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 ?? FF 15 
            ?? ?? ?? ?? 85 C0 0F 85 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 ?? FF 15 ?? ?? 
            ?? ?? 85 C0 0F 85 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 ?? FF 15 ?? ?? ?? ?? 
            85 C0 0F 85 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 ?? FF 15 ?? ?? ?? ?? 85 C0 
            0F 85 ?? ?? ?? ?? 8B 44 24 ?? A8 ?? 0F 85 ?? ?? ?? ?? A8 ?? 0F 85 ?? ?? ?? ?? 48 8D 
            8C 24 ?? ?? ?? ?? 33 D2 41 B8 ?? ?? ?? ?? 66 89 B4 24 ?? ?? 00 00 E8 ?? ?? ?? ?? 48 
            8D 8C 24 ?? ?? ?? ?? 33 D2 41 B8 ?? ?? ?? ?? 66 89 B4 24 ?? ?? 00 00 E8 ?? ?? ?? ?? 
            4C 8D 44 24 ?? 48 8D 8C 24 ?? ?? ?? ?? 48 8B D7 FF 15 ?? ?? ?? ?? 4C 8D 84 24 ?? ?? 
            ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 8C 24 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 39 74 24 ?? 76 
            ?? 4C 8D 0D ?? ?? ?? ?? 4C 8D 84 24 ?? ?? ?? ?? 48 8D 94 24 ?? ?? ?? ?? 48 8D 4C 24 
            ?? E8 ?? ?? ?? ?? 48 8D 54 24 ?? 48 8B CB FF 15 ?? ?? ?? ?? 85 C0 0F 85 ?? ?? ?? ?? 
            48 8B CB FF 15
      }

    condition:
      uint16(0) == 0x5A4D and $find_files and (all of ($encrypt_files_p*))
}