rule Win64_Ransomware_RedRoman : tc_detection malicious
{
    meta:

        author              = "ReversingLabs"

        source              = "ReversingLabs"
        status              = "RELEASED"
        sharing             = "TLP:WHITE"
        category            = "MALWARE"
        malware             = "REDROMAN"
        description         = "Yara rule that detects RedRoman ransomware."

        tc_detection_type   = "Ransomware"
        tc_detection_name   = "RedRoman"
        tc_detection_factor = 5

    strings:

        $encrypt_files_p1 = {
            48 8B 8C 24 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 48 8D 84 24 ?? ?? ?? ?? 48 89 84 24 ?? ??
            ?? ?? C7 84 24 ?? ?? ?? ?? ?? ?? ?? ?? 48 C7 44 24 ?? ?? ?? ?? ?? 48 C7 44 24 ?? ??
            ?? ?? ?? 48 8D 84 24 ?? ?? ?? ?? 48 89 44 24 ?? 4C 8D 8C 24 ?? ?? ?? ?? 41 B8 ?? ??
            ?? ?? BA ?? ?? ?? ?? 48 8B 8C 24 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 85 C0 75 ?? 48 C7 84
            24 ?? ?? ?? ?? ?? ?? ?? ?? 33 C0 85 C0 75 ?? 33 D2 48 8B 8C 24 ?? ?? ?? ?? FF 15 ??
            ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? 48 C7 44 24 ?? ?? ?? ?? ?? 48 8D 84 24 ?? ??
            ?? ?? 48 89 44 24 ?? 41 B9 ?? ?? ?? ?? 45 33 C0 BA ?? ?? ?? ?? 48 8B 8C 24 ?? ?? ??
            ?? FF 15 ?? ?? ?? ?? B9 ?? ?? ?? ?? 48 6B C9 ?? 48 89 84 0C ?? ?? ?? ?? 48 C7 84 24
            ?? ?? ?? ?? ?? ?? ?? ?? 33 C0 85 C0 75 ?? B8 ?? ?? ?? ?? 48 6B C0 ?? 48 83 BC 04 ??
            ?? ?? ?? ?? 74 ?? C7 84 24 ?? ?? ?? ?? ?? ?? ?? ?? 48 8D 84 24 ?? ?? ?? ?? 48 89 84
            24 ?? ?? ?? ?? EB ?? 33 D2 48 8B 8C 24 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? B8 ?? ?? ?? ??
            E9 ?? ?? ?? ?? 33 D2 48 8B 8C 24 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? BA ?? ?? ?? ?? B9 ??
            ?? ?? ?? FF 15 ?? ?? ?? ?? 48 8B 4C 24 ?? 48 8B 49 ?? 48 89 01 48 8B 44 24 ?? 48 8B
            40 ?? 48 83 38 ?? 75 ?? 48 8D 15 ?? ?? ?? ?? 48 8B 4C 24 ?? E8 ?? ?? ?? ?? B8 ?? ??
            ?? ?? 48 6B C0 ?? 48 83 BC 04 ?? ?? ?? ?? ?? 74 ?? B8 ?? ?? ?? ?? 48 6B C0 ?? 48 8B
            8C 04 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? B8
        }

        $encrypt_files_p2 = {
            4C 8D 05 ?? ?? ?? ?? 41 B9 ?? ?? ?? ?? 48 8B 4D ?? 48 8B 55 ?? E8 ?? ?? ?? ?? 48 89
            55 ?? 48 89 45 ?? EB ?? 31 C0 41 89 C0 48 8B 4D ?? 48 8B 55 ?? E8 ?? ?? ?? ?? 48 89
            45 ?? EB ?? 48 8B 45 ?? 48 83 F8 ?? 74 ?? 48 8B 55 ?? 48 8D 8D ?? ?? ?? ?? E8 ?? ??
            ?? ?? EB ?? EB ?? 48 81 C4 ?? ?? ?? ?? 5D C3 48 8D 4D ?? E8 ?? ?? ?? ?? EB ?? 48 8B
            85 ?? ?? ?? ?? 48 85 C0 74 ?? EB ?? EB ?? 0F 0B 48 8B 85 ?? ?? ?? ?? 48 89 85 ?? ??
            ?? ?? 48 8B 85 ?? ?? ?? ?? 48 89 85 ?? ?? ?? ?? 48 8B 85 ?? ?? ?? ?? 48 89 85 ?? ??
            ?? ?? C6 85 ?? ?? ?? ?? ?? 48 8B 85 ?? ?? ?? ?? 48 89 85 ?? ?? ?? ?? 48 8B 85 ?? ??
            ?? ?? 48 89 85 ?? ?? ?? ?? 48 8B 85 ?? ?? ?? ?? 48 89 85 ?? ?? ?? ?? 48 83 BD ?? ??
            ?? ?? ?? 0F 84 ?? ?? ?? ?? E9 ?? ?? ?? ?? 48 8B 85 ?? ?? ?? ?? 48 8B 8D ?? ?? ?? ??
            48 89 85 ?? ?? ?? ?? 48 89 8D ?? ?? ?? ?? 48 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? EB ??
            48 83 BD ?? ?? ?? ?? ?? 0F 84 ?? ?? ?? ?? E9 ?? ?? ?? ?? 48 8B 85 ?? ?? ?? ?? 48 85
            C0 74 ?? EB ?? EB ?? 0F 0B 48 8B 85 ?? ?? ?? ?? 48 89 85 ?? ?? ?? ?? 48 8B 85 ?? ??
            ?? ?? 48 89 85 ?? ?? ?? ?? 48 8B 85 ?? ?? ?? ?? 48 89 85 ?? ?? ?? ?? 48 8B 85 ?? ??
            ?? ?? 48 89 85 ?? ?? ?? ?? 48 8B 85 ?? ?? ?? ?? 48 89 85 ?? ?? ?? ?? 48 8B 85 ?? ??
            ?? ?? 48 89 85 ?? ?? ?? ?? 48 83 BD ?? ?? ?? ?? ?? 0F 84 ?? ?? ?? ?? E9 ?? ?? ?? ??
            48 8B 85 ?? ?? ?? ?? 48 8B 8D ?? ?? ?? ?? 48 89 85 ?? ?? ?? ?? 48 89 8D
        }

        $find_files = {
            48 8D 9C 24 ?? ?? ?? ?? 41 B8 ?? ?? ?? ?? 48 89 D9 31 D2 E8 ?? ?? ?? ?? 48 8B 0F 48
            89 DA E8 ?? ?? ?? ?? 85 C0 0F 84 ?? ?? ?? ?? 4C 8D B4 24 ?? ?? ?? ?? 48 8D 9C 24 ??
            ?? ?? ?? 66 83 BC 24 ?? ?? 00 00 ?? 74 ?? EB ?? 0F 1F 84 00 ?? ?? ?? ?? 48 8B 0F 48
            89 DA E8 ?? ?? ?? ?? 85 C0 74 ?? 66 83 BC 24 ?? ?? 00 00 ?? 75 ?? 0F B7 84 24 ?? ??
            ?? ?? 66 85 C0 74 ?? 66 83 F8 ?? 75 ?? 66 83 BC 24 ?? ?? 00 00 ?? 74 ?? 48 8B 47 ??
            F0 48 83 00 ?? 0F 8E ?? ?? ?? ?? 48 89 84 24 ?? ?? ?? ?? 48 8D 94 24 ?? ?? ?? ?? 41
            B8 ?? ?? ?? ?? 4C 89 F1 E8 ?? ?? ?? ?? 48 C7 06 ?? ?? ?? ?? 48 8D 4E ?? 48 8D 94 24
            ?? ?? ?? ?? 41 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB ?? E8 ?? ?? ?? ?? 83 F8 ?? 75 ?? 48
            C7 06 ?? ?? ?? ?? EB ?? E8 ?? ?? ?? ?? 48 C7 06 ?? ?? ?? ?? C6 46 ?? ?? 89 46 ?? 48
            89 F0 0F 28 B5 ?? ?? ?? ?? 0F 28 BD ?? ?? ?? ?? 44 0F 28 85 ?? ?? ?? ?? 44 0F 28 8D
            ?? ?? ?? ?? 44 0F 28 95 ?? ?? ?? ?? 44 0F 28 9D ?? ?? ?? ?? 44 0F 28 A5 ?? ?? ?? ??
            44 0F 28 AD ?? ?? ?? ?? 44 0F 28 B5 ?? ?? ?? ?? 44 0F 28 BD ?? ?? ?? ?? 48 8D A5 ??
            ?? ?? ?? 5B 5F 5E 41 5E 5D C3 0F 0B
        }

    condition:
        uint16(0) == 0x5A4D and
        (
            $find_files
        ) and
        (
            all of ($encrypt_files_p*)
        )
}