rule Win64_Ransomware_Seth : tc_detection malicious
{
    meta:

        author              = "ReversingLabs"

        source              = "ReversingLabs"
        status              = "RELEASED"
        sharing             = "TLP:WHITE"
        category            = "MALWARE"
        malware             = "SETH"
        description         = "Yara rule that detects Seth ransomware."

        tc_detection_type   = "Ransomware"
        tc_detection_name   = "Seth"
        tc_detection_factor = 5

    strings:

        $encrypt_files_p1 = {
            55 53 48 81 EC ?? ?? ?? ?? 48 8D AC 24 ?? ?? ?? ?? 48 89 8D ?? ?? ?? ?? 48 8D 85 ??
            ?? ?? ?? 4C 8D 05 ?? ?? ?? ?? 48 8B 95 ?? ?? ?? ?? 48 89 C1 E8 ?? ?? ?? ?? BA ?? ??
            ?? ?? 48 8B 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 89 85 ?? ?? ?? ?? 48 8D 85 ?? ?? ?? ??
            BA ?? ?? ?? ?? 48 89 C1 E8 ?? ?? ?? ?? 48 89 85 ?? ?? ?? ?? 48 8D 85 ?? ?? ?? ?? 48
            89 C1 E8 ?? ?? ?? ?? BA ?? ?? ?? ?? B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 C1 48 8B 95 ??
            ?? ?? ?? 48 8D 85 ?? ?? ?? ?? 41 89 C8 48 89 C1 E8 ?? ?? ?? ?? 48 8D 85 ?? ?? ?? ??
            48 05 ?? ?? ?? ?? 48 89 C1 E8 ?? ?? ?? ?? 84 C0 74 ?? 48 8D 15 ?? ?? ?? ?? 48 8B 0D
            ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 89 C1 48 8B 85 ?? ?? ?? ?? 48 89 C2 E8 ?? ?? ?? ?? 48
            8B 15 ?? ?? ?? ?? 48 89 C1 E8 ?? ?? ?? ?? 48 8D 85 ?? ?? ?? ?? 41 B8 ?? ?? ?? ?? BA
            ?? ?? ?? ?? 48 89 C1 E8 ?? ?? ?? ?? 48 8D 85 ?? ?? ?? ?? 48 8D 95 ?? ?? ?? ?? 48 89
            C1 E8 ?? ?? ?? ?? 48 8D 85 ?? ?? ?? ?? 48 89 C1 E8 ?? ?? ?? ?? 89 85 ?? ?? ?? ?? 48
            8D 15 ?? ?? ?? ?? 48 8B 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 89 C1 48 8B 85
        }

        $encrypt_files_p2 = {
            48 89 C2 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 89 C1 E8 ?? ?? ?? ?? 48 89 C1 8B 85
            ?? ?? ?? ?? 89 C2 E8 ?? ?? ?? ?? 48 8B 15 ?? ?? ?? ?? 48 89 C1 E8 ?? ?? ?? ?? 8B 85
            ?? ?? ?? ?? 48 98 48 89 C1 E8 ?? ?? ?? ?? 48 89 85 ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? 48
            63 C8 48 8B 95 ?? ?? ?? ?? 48 8D 85 ?? ?? ?? ?? 49 89 C8 48 89 C1 E8 ?? ?? ?? ?? 48
            8B 95 ?? ?? ?? ?? 48 8D 45 ?? 41 B8 ?? ?? ?? ?? 48 89 C1 E8 ?? ?? ?? ?? 8B 85 ?? ??
            ?? ?? 48 63 C8 48 8B 95 ?? ?? ?? ?? 48 8D 45 ?? 49 89 C8 48 89 C1 E8 ?? ?? ?? ?? 48
            8D 85 ?? ?? ?? ?? 48 89 C1 E8 ?? ?? ?? ?? 48 8D 45 ?? 48 89 C1 E8 ?? ?? ?? ?? 48 83
            BD ?? ?? ?? ?? ?? 74 ?? 48 8B 85 ?? ?? ?? ?? 48 89 C1 E8 ?? ?? ?? ?? 48 8D 45 ?? 48
            89 C1 E8 ?? ?? ?? ?? 48 8D 85 ?? ?? ?? ?? 48 89 C1 E8 ?? ?? ?? ?? 48 8D 85 ?? ?? ??
            ?? 48 89 C1 E8 ?? ?? ?? ?? EB ?? 48 89 C3 48 8D 45 ?? 48 89 C1 E8 ?? ?? ?? ?? EB ??
            48 89 C3 48 8D 85 ?? ?? ?? ?? 48 89 C1 E8 ?? ?? ?? ?? EB ?? 48 89 C3 48 8D 85 ?? ??
            ?? ?? 48 89 C1 E8 ?? ?? ?? ?? 48 89 D8 48 89 C1 E8 ?? ?? ?? ?? 90 48 81 C4 ?? ?? ??
            ?? 5B 5D C3
        }

        $remote_connection_p1 = {
            55 48 81 EC ?? ?? ?? ?? 48 8D AC 24 ?? ?? ?? ?? 48 89 8D ?? ?? ?? ?? 48 8B 05 ?? ??
            ?? ?? FF D0 89 C1 E8 ?? ?? ?? ?? C6 85 ?? ?? ?? ?? ?? BA ?? ?? ?? ?? 48 8D 85 ?? ??
            ?? ?? 41 89 D0 48 89 C2 48 8D 0D ?? ?? ?? ?? 48 8B 05 ?? ?? ?? ?? FF D0 48 8B 05 ??
            ?? ?? ?? FF D0 89 C1 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 C1 BA ?? ?? ?? ?? 89 C8 F7 EA
            C1 FA ?? 89 C8 C1 F8 ?? 29 C2 89 D0 69 C0 ?? ?? ?? ?? 29 C1 89 C8 8D 88 ?? ?? ?? ??
            48 8D 95 ?? ?? ?? ?? 48 8D 45 ?? 41 89 C9 49 89 D0 48 8D 15 ?? ?? ?? ?? 48 89 C1 48
            8B 05 ?? ?? ?? ?? FF D0 C7 44 24 ?? ?? ?? ?? ?? 41 B9 ?? ?? ?? ?? 41 B8 ?? ?? ?? ??
            BA ?? ?? ?? ?? 48 8D 0D ?? ?? ?? ?? 48 8B 05 ?? ?? ?? ?? FF D0 48 89 85 ?? ?? ?? ??
            48 83 BD ?? ?? ?? ?? ?? 0F 84 ?? ?? ?? ?? 48 8B 85 ?? ?? ?? ?? 48 C7 44 24 ?? ?? ??
            ?? ?? C7 44 24 ?? ?? ?? ?? ?? 41 B9 ?? ?? ?? ?? 41 B8 ?? ?? ?? ?? 48 8B 95 ?? ?? ??
            ?? 48 89 C1 48 8B 05 ?? ?? ?? ?? FF D0 48 89 85 ?? ?? ?? ?? 48 83 BD ?? ?? ?? ?? ??
            0F 84 ?? ?? ?? ?? 48 8D 45 ?? 48 C7 44 24 ?? ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? C7
            44 24 ?? ?? ?? ?? ?? 41 B9 ?? ?? ?? ?? 41 B8 ?? ?? ?? ?? BA ?? ?? ?? ?? 48 89 C1 48
            8B 05 ?? ?? ?? ?? FF D0 48 89 85 ?? ?? ?? ?? 48 83 BD ?? ?? ?? ?? ?? 0F 84 ?? ?? ??
            ?? 48 8D 85 ?? ?? ?? ?? 41 B8 ?? ?? ?? ?? BA ?? ?? ?? ?? 48 89 C1 E8 ?? ?? ?? ?? EB
            ?? 8B 8D ?? ?? ?? ?? 4C 8D 85 ?? ?? ?? ?? 48 8D 95 ?? ?? ?? ?? 48 8B 85 ?? ?? ?? ??
            48 C7 44 24 ?? ?? ?? ?? ?? 4D 89 C1 41 89 C8 48 89 C1 48 8B 05 ?? ?? ?? ?? FF D0 B8
            ?? ?? ?? ?? 44 8D 40 ?? 48 8D 8D ?? ?? ?? ?? 48 8D 95 ?? ?? ?? ?? 48 8B 85 ?? ?? ??
            ?? 49 89 C9 48 89 C1 48 8B 05 ?? ?? ?? ?? FF D0 85 C0 74 ?? 8B 85 ?? ?? ?? ?? 85 C0
        }

        $remote_connection_p2 = {
            74 ?? B8 ?? ?? ?? ?? EB ?? B8 ?? ?? ?? ?? 84 C0 0F 85 ?? ?? ?? ?? 48 8B 85 ?? ?? ??
            ?? 48 89 C1 48 8B 05 ?? ?? ?? ?? FF D0 48 8D 55 ?? 48 8D 85 ?? ?? ?? ?? 49 89 D0 48
            8D 15 ?? ?? ?? ?? 48 89 C1 48 8B 05 ?? ?? ?? ?? FF D0 48 8D 85 ?? ?? ?? ?? 48 89 C1
            48 8B 05 ?? ?? ?? ?? FF D0 B9 ?? ?? ?? ?? 48 8B 05 ?? ?? ?? ?? FF D0 48 8D 45 ?? 48
            89 C1 E8 ?? ?? ?? ?? 84 C0 74 ?? C6 85 ?? ?? ?? ?? ?? 48 8B 85 ?? ?? ?? ?? 48 89 C1
            48 8B 05 ?? ?? ?? ?? FF D0 48 8B 85 ?? ?? ?? ?? 48 89 C1 48 8B 05 ?? ?? ?? ?? FF D0
            48 8B 85 ?? ?? ?? ?? 48 89 C1 48 8B 05 ?? ?? ?? ?? FF D0 B9 ?? ?? ?? ?? 48 8B 05 ??
            ?? ?? ?? FF D0 0F B6 85 ?? ?? ?? ?? 83 F0 ?? 84 C0 0F 84 ?? ?? ?? ?? E8 ?? ?? ?? ??
            89 C1 BA ?? ?? ?? ?? 89 C8 F7 EA C1 FA ?? 89 C8 C1 F8 ?? 29 C2 89 D0 69 C0 ?? ?? ??
            ?? 29 C1 89 C8 8D 88 ?? ?? ?? ?? 48 8D 95 ?? ?? ?? ?? 48 8D 45 ?? 41 89 C9 49 89 D0
            48 8D 15 ?? ?? ?? ?? 48 89 C1 48 8B 05 ?? ?? ?? ?? FF D0 48 8D 45 ?? 48 C7 44 24 ??
            ?? ?? ?? ?? 41 B9 ?? ?? ?? ?? 49 89 C0 48 8B 95 ?? ?? ?? ?? B9 ?? ?? ?? ?? E8 ?? ??
            ?? ?? 85 C0 0F 94 C0 84 C0 74 ?? 48 8D 55 ?? 48 8D 85 ?? ?? ?? ?? 49 89 D0 48 8D 15
            ?? ?? ?? ?? 48 89 C1 48 8B 05 ?? ?? ?? ?? FF D0 48 8D 85 ?? ?? ?? ?? 48 89 C1 48 8B
            05 ?? ?? ?? ?? FF D0 B9 ?? ?? ?? ?? 48 8B 05 ?? ?? ?? ?? FF D0 48 8D 45 ?? 48 89 C1
            E8 ?? ?? ?? ?? 90 48 81 C4 ?? ?? ?? ?? 5D C3
        }

        $find_files = {
            48 8D 15 ?? ?? ?? ?? 48 89 C1 E8 ?? ?? ?? ?? 48 83 F8 ?? 0F 95 C0 84 C0 74 ?? BB ??
            ?? ?? ?? E9 ?? ?? ?? ?? 48 8D 85 ?? ?? ?? ?? 48 8D 8D ?? ?? ?? ?? 48 8D 95 ?? ?? ??
            ?? 49 89 C8 48 89 C1 E8 ?? ?? ?? ?? 48 8D 85 ?? ?? ?? ?? 48 89 C2 48 8B 0D ?? ?? ??
            ?? E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 89 C1 E8 ?? ?? ?? ?? 48 8D 95 ?? ?? ?? ??
            48 8D 85 ?? ?? ?? ?? 48 89 C1 E8 ?? ?? ?? ?? 48 8D 85 ?? ?? ?? ?? 48 89 C1 E8 ?? ??
            ?? ?? 48 8D 85 ?? ?? ?? ?? 48 89 C1 E8 ?? ?? ?? ?? 48 8D 85 ?? ?? ?? ?? 48 89 C1 E8
            ?? ?? ?? ?? 48 89 C1 E8 ?? ?? ?? ?? 48 8D 85 ?? ?? ?? ?? 48 89 C1 E8 ?? ?? ?? ?? 48
            8D 95 ?? ?? ?? ?? 48 8D 45 ?? 48 89 C1 E8 ?? ?? ?? ?? 48 8B 10 48 83 EA ?? 48 8B 12
            48 01 D0 48 89 C1 E8 ?? ?? ?? ?? 48 85 C0 0F 95 C0 84 C0 0F 85 ?? ?? ?? ?? 48 8B 8D
            ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 89 C1 E8 ?? ?? ?? ?? BB ?? ?? ?? ?? 48 8D 85 ?? ?? ??
            ?? 48 89 C1 E8 ?? ?? ?? ?? 83 FB ?? 74 ?? BB ?? ?? ?? ?? EB ?? 90 BB ?? ?? ?? ?? 48
            8D 85 ?? ?? ?? ?? 48 89 C1 E8 ?? ?? ?? ?? 83 FB ?? 74 ?? BB ?? ?? ?? ?? EB ?? 90 BB
            ?? ?? ?? ?? 48 8D 45 ?? 48 89 C1 E8 ?? ?? ?? ?? 83 FB ?? 74 ?? E9 ?? ?? ?? ?? 90 E9
            ?? ?? ?? ?? 48 89 C3 48 8D 85 ?? ?? ?? ?? 48 89 C1 E8 ?? ?? ?? ?? E9 ?? ?? ?? ?? 48
            89 C3 48 8D 85 ?? ?? ?? ?? 48 89 C1 E8 ?? ?? ?? ?? EB ?? 48 89 C3 48 8D 85 ?? ?? ??
            ?? 48 89 C1 E8 ?? ?? ?? ?? E9 
        }

    condition:
        uint16(0) == 0x5A4D and
        (
            $find_files
        ) and
        (
            all of ($encrypt_files_p*)
        ) and
        (
            all of ($remote_connection_p*)
        )
}