rule ByteCode_MSIL_Ransomware_WormLocker : tc_detection malicious
{
    meta:

        author              = "ReversingLabs"

        source              = "ReversingLabs"
        status              = "RELEASED"
        sharing             = "TLP:WHITE"
        category            = "MALWARE"
        malware             = "WORMLOCKER"
        description         = "Yara rule that detects WormLocker ransomware."

        tc_detection_type   = "Ransomware"
        tc_detection_name   = "WormLocker"
        tc_detection_factor = 5

    strings:

        $set_environment = {
            73 ?? ?? ?? ?? 0A 06 02 7D ?? ?? ?? ?? 00 16 28 ?? ?? ?? ?? 0B 72 ?? ?? ?? ?? 28 ?? ??
            ?? ?? 0C 08 72 ?? ?? ?? ?? 28 ?? ?? ?? ?? 0D 02 20 ?? ?? ?? ?? 20 ?? ?? ?? ?? 73 ?? ??
            ?? ?? 28 ?? ?? ?? ?? 00 7E ?? ?? ?? ?? 72 ?? ?? ?? ?? 6F ?? ?? ?? ?? 13 ?? 11 ?? 72 ??
            ?? ?? ?? 72 ?? ?? ?? ?? 17 6F ?? ?? ?? ?? 00 07 72 ?? ?? ?? ?? 28 ?? ?? ?? ?? 72 ?? ??
            ?? ?? 28 ?? ?? ?? ?? 00 09 72 ?? ?? ?? ?? 28 ?? ?? ?? ?? 72 ?? ?? ?? ?? 28 ?? ?? ?? ??
            00 02 7B ?? ?? ?? ?? 6F ?? ?? ?? ?? 00 02 7B ?? ?? ?? ?? 6F ?? ?? ?? ?? 00 02 7B ?? ??
            ?? ?? 6F ?? ?? ?? ?? 00 06 28 ?? ?? ?? ?? 7D ?? ?? ?? ?? 73 ?? ?? ?? ?? 25 20 ?? ?? ??
            ?? 6F ?? ?? ?? ?? 00 13 ?? 11 ?? 06 FE 06 ?? ?? ?? ?? 73 ?? ?? ?? ?? 6F ?? ?? ?? ?? 00
            11 ?? 17 6F ?? ?? ?? ?? 00 02 7B ?? ?? ?? ?? 6F ?? ?? ?? ?? 00 2A
        }

        $find_files = {
            00 28 ?? ?? ?? ?? 00 16 28 ?? ?? ?? ?? 0A 72 ?? ?? ?? ?? 28 ?? ?? ?? ?? 0B 07 72 ?? ??
            ?? ?? 28 ?? ?? ?? ?? 0C 06 72 ?? ?? ?? ?? 28 ?? ?? ?? ?? 72 ?? ?? ?? ?? 17 28 ?? ?? ??
            ?? 0D 08 72 ?? ?? ?? ?? 28 ?? ?? ?? ?? 72 ?? ?? ?? ?? 17 28 ?? ?? ?? ?? 13 ?? 73 ?? ??
            ?? ?? 13 ?? 72 ?? ?? ?? ?? 13 ?? 16 13 ?? 2B ?? 00 11 ?? 09 11 ?? 9A 11 ?? 6F ?? ?? ??
            ?? 00 00 11 ?? 17 58 13 ?? 11 ?? 09 8E 69 FE 04 13 ?? 11 ?? 2D ?? 16 13 ?? 2B ?? 00 11
            ?? 11 ?? 11 ?? 9A 11 ?? 6F ?? ?? ?? ?? 00 00 11 ?? 17 58 13 ?? 11 ?? 11 ?? 8E 69 FE 04
            13 ?? 11 ?? 2D ?? 2A
        }

        $encrypt_files_p1 = {
            00 14 0A 1E 8D ?? ?? ?? ?? 25 D0 ?? ?? ?? ?? 28 ?? ?? ?? ?? 0B 73 ?? ?? ?? ?? 0C 00 73
            ?? ?? ?? ?? 0D 00 09 20 ?? ?? ?? ?? 6F ?? ?? ?? ?? 00 09 20 ?? ?? ?? ?? 6F ?? ?? ?? ??
            00 03 07 20 ?? ?? ?? ?? 73 ?? ?? ?? ?? 13 ?? 09 11 ?? 09 6F ?? ?? ?? ?? 1E 5B 6F ?? ??
            ?? ?? 6F ?? ?? ?? ?? 00 09 11 ?? 09 6F ?? ?? ?? ?? 1E 5B 6F ?? ?? ?? ?? 6F ?? ?? ?? ??
            00 09 17 6F ?? ?? ?? ?? 00 08 09 6F ?? ?? ?? ?? 17 73 ?? ?? ?? ?? 13 ?? 00 11 ?? 02 16
            02 8E 69 6F ?? ?? ?? ?? 00 11 ?? 6F ?? ?? ?? ?? 00 00 DE ?? 11 ?? 2C ?? 11 ?? 6F ?? ??
            ?? ?? 00 DC 08 6F ?? ?? ?? ?? 0A 00 DE ?? 09 2C ?? 09 6F ?? ?? ?? ?? 00 DC 00 DE ?? 08
            2C ?? 08 6F ?? ?? ?? ?? 00 DC 06 13 ?? 2B ?? 11 ?? 2A
        }

        $encrypt_files_p2 = {
            00 03 28 ?? ?? ?? ?? 0A 28 ?? ?? ?? ?? 04 6F ?? ?? ?? ?? 0B 28 ?? ?? ?? ?? 07 6F ?? ??
            ?? ?? 0B 06 07 28 ?? ?? ?? ?? 0C 03 0D 09 08 28 ?? ?? ?? ?? 00 2A
        }

    condition:
        uint16(0) == 0x5A4D and
        (
            $set_environment
        ) and
        (
            $find_files
        ) and
        (
            all of ($encrypt_files_p*)
        )
}