rule Win32_Ransomware_Badbeeteam : tc_detection malicious
{
    meta:

        author              = "ReversingLabs"

        source              = "ReversingLabs"
        status              = "RELEASED"
        sharing             = "TLP:WHITE"
        category            = "MALWARE"
        malware             = "BADBEETEAM"
        description         = "Yara rule that detects Badbeeteam ransomware."

        tc_detection_type   = "Ransomware"
        tc_detection_name   = "Badbeeteam"
        tc_detection_factor = 5

    strings:

        $find_files_p1 = {
            8B FF 55 8B EC 51 8B 4D ?? 8D 51 ?? 8A 01 41 84 C0 75 ?? 57 8B 7D ?? 2B CA 8B C7 41 
            F7 D0 89 4D ?? 3B C8 76 ?? 6A ?? 58 5F C9 C3 53 56 8D 5F ?? 03 D9 6A ?? 53 E8 ?? ?? 
            ?? ?? 8B F0 59 59 85 FF 74 ?? 57 FF 75 ?? 53 56 E8 ?? ?? ?? ?? 83 C4 ?? 85 C0 75 ?? 
            FF 75 ?? 2B DF 8D 04 3E FF 75 ?? 53 50 E8 ?? ?? ?? ?? 83 C4 ?? 85 C0 75 ?? 8B 5D ?? 
            8B CB E8 ?? ?? ?? ?? 33 FF 89 45 ?? 85 C0 74 ?? 56 E8 ?? ?? ?? ?? 8B 75 ?? 59 EB ?? 
            8B 43 ?? 89 30 8B F7 83 43 ?? ?? 57 E8 ?? ?? ?? ?? 59 8B C6 5E 5B EB ?? 33 FF 57 57 
            57 57 57 E8 ?? ?? ?? ?? CC 8B FF 55 8B EC 81 EC ?? ?? ?? ?? A1 ?? ?? ?? ?? 33 C5 89 
            45 ?? 8B 4D ?? 8B 55 ?? 53 57 8B 7D ?? 89 95 ?? ?? ?? ?? 3B CF 74 ?? 8A 01 3C ?? 74 
            ?? 3C ?? 74 ?? 3C ?? 74 ?? 51 57 E8 ?? ?? ?? ?? 59 59 8B C8 3B CF 75 ?? 8B 95 ?? ?? 
            ?? ?? 8A 01 88 85 ?? ?? ?? ?? 3C ?? 75 ?? 8D 47 ?? 3B C8 74 ?? 52 33 DB 53 53 57 E8 
            ?? ?? ?? ?? 83 C4 ?? E9 ?? ?? ?? ?? 8A 85 ?? ?? ?? ?? 33 DB 3C ?? 74 ?? 3C ?? 74 ?? 
            3C ?? 8A C3 75 ?? B0 ?? 2B CF 0F B6 C0 41 89 9D ?? ?? ?? ?? F7 D8 89 9D
        }

        $find_files_p2 = {
            56 1B C0 89 9D ?? ?? ?? ?? 23 C1 89 9D ?? ?? ?? ?? 89 85 ?? ?? ?? ?? 89 9D ?? ?? ?? 
            ?? 88 9D ?? ?? ?? ?? E8 ?? ?? ?? ?? 50 8D 85 ?? ?? ?? ?? 50 57 E8 ?? ?? ?? ?? 83 C4 
            ?? 8D 8D ?? ?? ?? ?? F7 D8 1B C0 53 53 53 51 F7 D0 23 85 ?? ?? ?? ?? 53 50 FF 15 ?? 
            ?? ?? ?? 8B F0 83 FE ?? 75 ?? FF B5 ?? ?? ?? ?? 53 53 57 E8 ?? ?? ?? ?? 83 C4 ?? 8B 
            D8 E9 ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? 8B 48 ?? 2B 08 C1 F9 ?? 89 8D ?? ?? ?? ?? 89 9D 
            ?? ?? ?? ?? 89 9D ?? ?? ?? ?? 89 9D ?? ?? ?? ?? 89 9D ?? ?? ?? ?? 89 9D ?? ?? ?? ?? 
            88 9D ?? ?? ?? ?? E8 ?? ?? ?? ?? 50 8D 85 ?? ?? ?? ?? 50 8D 85 ?? ?? ?? ?? 50 8D 85 
            ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? F7 D8 1B C0 F7 D0 23 85 ?? ?? ?? ?? 80 38 ?? 
            75 ?? 8A 48 ?? 84 C9 74 ?? 80 F9 ?? 75 ?? 38 58 ?? 74 ?? FF B5 ?? ?? ?? ?? FF B5 ?? 
            ?? ?? ?? 57 50 E8 ?? ?? ?? ?? 83 C4 ?? 89 85 ?? ?? ?? ?? 85 C0 75 ?? 38 9D ?? ?? ?? 
            ?? 74 ?? FF B5 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 8D 85 ?? ?? ?? ?? 50 56 FF 15 ?? ?? ?? 
            ?? 85 C0 0F 85 ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? 8B 8D ?? ?? ?? ?? 8B 10 8B 40 ?? 2B C2 
            C1 F8 ?? 3B C8 74 ?? 68 ?? ?? ?? ?? 2B C1 6A ?? 50 8D 04 8A 50 E8 ?? ?? ?? ?? 83 C4 
            ?? EB ?? 38 9D ?? ?? ?? ?? 74 ?? FF B5 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? 
            59 8B D8 56 FF 15 ?? ?? ?? ?? 80 BD ?? ?? ?? ?? ?? 5E 74 ?? FF B5 ?? ?? ?? ?? E8 ?? 
            ?? ?? ?? 59 8B C3 8B 4D ?? 5F 33 CD 5B E8 ?? ?? ?? ?? C9 C3 
        }

        $encrypt_files_p1 = {
            59 6A ?? 68 ?? ?? ?? ?? 52 50 E8 ?? ?? ?? ?? 89 F1 83 C4 ?? 84 C0 0F 85 ?? ?? ?? ?? 
            51 E8 ?? ?? ?? ?? 59 B9 ?? ?? ?? ?? 89 D6 6A ?? 5A 56 50 E8 ?? ?? ?? ?? 8D 8C 24 ?? 
            ?? ?? ?? 83 C4 ?? 84 C0 0F 85 ?? ?? ?? ?? FF 04 24 51 57 E8 ?? ?? ?? ?? 58 59 8D 8C 
            24 ?? ?? ?? ?? 8D 54 24 ?? 57 E8 ?? ?? ?? ?? 58 83 BC 24 ?? ?? ?? ?? ?? 0F 84 ?? ?? 
            ?? ?? 8B 84 24 ?? ?? ?? ?? F2 0F 10 84 24 ?? ?? ?? ?? 89 84 24 ?? ?? ?? ?? A1 ?? ?? 
            ?? ?? F2 0F 11 84 24 ?? ?? ?? ?? 8B 00 83 F8 ?? 72 ?? 8D 84 24 ?? ?? ?? ?? C7 84 24 
            ?? ?? ?? ?? ?? ?? ?? ?? 8D 4C 24 ?? 89 44 24 ?? 31 C0 C7 44 24 ?? ?? ?? ?? ?? 40 89 
            84 24 ?? ?? ?? ?? 83 A4 24 ?? ?? ?? ?? ?? 89 8C 24 ?? ?? ?? ?? 89 84 24 ?? ?? ?? ?? 
            68 ?? ?? ?? ?? 6A ?? 57 E8 ?? ?? ?? ?? 83 C4 ?? 8D 8C 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 
            8D 8C 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 4C 24 ?? E8 ?? ?? ?? ?? E9 ?? ?? ?? ?? 57 E8 
            ?? ?? ?? ?? 59 89 D6 B9 ?? ?? ?? ?? 6A ?? 5A 56 50 E8 ?? ?? ?? ?? 59 5A 89 F9 89 C3 
            E8 ?? ?? ?? ?? 84 DB 0F 85 ?? ?? ?? ?? 6A ?? 59 8D 7C 24 ?? 8D B4 24 ?? ?? ?? ?? F3 
            A5 6A ?? 59 8D BC 24 ?? ?? ?? ?? 8D 74 24 ?? 31 C0 F3 A5 E9 ?? ?? ?? ?? 8B 84 24 ?? 
            ?? ?? ?? 85 C0 74 ?? 8B 8C 24 ?? ?? ?? ?? 50 FF 11 83 C4 ?? 8B 84 24 ?? ?? ?? ?? 8B 
            70 ?? 8B 78 ?? FF B4 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 89 C1 89 F2 57 E8 ?? ?? ?? ?? 
            58 8D 8C 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 9C 24 ?? ?? ?? ?? 53 E8 ?? ?? ?? ?? 59 69
        }

        $encrypt_files_p2 = {
            7B ?? ?? ?? ?? ?? 89 C6 83 C6 ?? 85 FF 74 ?? 83 7E ?? ?? 74 ?? 8D 46 ?? 50 E8 ?? ?? 
            ?? ?? 58 81 C6 ?? ?? ?? ?? 81 C7 ?? ?? ?? ?? EB ?? 83 7E ?? ?? 74 ?? 83 3E ?? 74 ?? 
            8D 4E ?? E8 ?? ?? ?? ?? EB ?? 8D 46 ?? 50 E8 ?? ?? ?? ?? 58 8B 06 F0 FF 08 75 ?? 56 
            E8 ?? ?? ?? ?? EB ?? 53 8D 44 24 ?? 50 E8 ?? ?? ?? ?? 58 59 8B 4C 24 ?? 85 C9 74 ?? 
            8B 54 24 ?? FF 74 24 ?? E8 ?? ?? ?? ?? 58 8D 9C 24 ?? ?? ?? ?? 53 E8 ?? ?? ?? ?? 59 
            6B 5B ?? ?? 89 C7 89 C6 83 C7 ?? 85 DB 74 ?? 8D 4E ?? E8 ?? ?? ?? ?? 83 7E ?? ?? 74 
            ?? 57 E8 ?? ?? ?? ?? 58 83 3F ?? 74 ?? 8D 47 ?? EB ?? 8D 46 ?? 50 E8 ?? ?? ?? ?? 58 
            83 C6 ?? 83 C7 ?? 83 C3 ?? EB ?? 8D 84 24 ?? ?? ?? ?? 50 8D 5C 24 ?? 53 E8 ?? ?? ?? 
            ?? 58 59 8B 4C 24 ?? 85 C9 74 ?? 8B 54 24 ?? FF 74 24 ?? E8 ?? ?? ?? ?? 58 8D B4 24 
            ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 59 6B 7E ?? ?? 89 C1 85 FF 74 ?? 8D 59 ?? 83 C1 ?? E8 
            ?? ?? ?? ?? 89 D9 83 C7 ?? 8D 5C 24 ?? EB ?? 56 53 E8 ?? ?? ?? ?? 58 59 8B 4C 24 ?? 
            85 C9 74 ?? 8B 54 24 ?? FF 74 24 ?? E8 ?? ?? ?? ?? 58 A1 ?? ?? ?? ?? 8B 00 83 F8 ?? 
            72 ?? 89 E0 68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 59 89 C6 89 D7 68 ?? ?? ?? ?? 8D 44 
            24 ?? 50 E8 ?? ?? ?? ?? 59 59 89 B4 24 ?? ?? ?? ?? 89 BC 24 ?? ?? ?? ?? 89 84 24 ?? 
            ?? ?? ?? 89 94 24 ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? 6A ?? 58 89 44 24 ?? 83 64 24 
            ?? ?? 8D 8C 24 ?? ?? ?? ?? 89 4C 24 ?? 89 44 24 ?? 68 ?? ?? ?? ?? 6A ?? 53 E8 ?? ?? 
            ?? ?? 83 C4 ?? 8D 4C 24 ?? E8 ?? ?? ?? ?? 8B 7D ?? 8B 77 ?? 83 C7 ?? 8D 4E ?? E8 ?? 
            ?? ?? ?? C7 46 ?? ?? ?? ?? ?? 83 66 ?? ?? 89 F9 E8 ?? ?? ?? ?? 8D 65 ?? 5E 5F 5B 5D 
            C3 
        }

        $drop_hta_file_p1 = {
            6A ?? 68 ?? ?? ?? ?? 57 E8 ?? ?? ?? ?? 83 C4 ?? 56 E8 ?? ?? ?? ?? 59 89 D3 89 F9 89 
            C2 53 E8 ?? ?? ?? ?? 58 8D B4 24 ?? ?? ?? ?? 89 F1 E8 ?? ?? ?? ?? 6A ?? 68 ?? ?? ?? 
            ?? 56 E8 ?? ?? ?? ?? 83 C4 ?? 57 E8 ?? ?? ?? ?? 58 31 DB 43 53 57 E8 ?? ?? ?? ?? 59 
            5A 53 89 DF 50 E8 ?? ?? ?? ?? 59 5A 8D 5C 24 ?? 89 C2 89 D9 56 E8 ?? ?? ?? ?? 58 39 
            3B 0F 85 ?? ?? ?? ?? F2 0F 10 44 24 ?? A1 ?? ?? ?? ?? 8D 74 24 ?? 8D BC 24 ?? ?? ?? 
            ?? F2 0F 11 44 24 ?? 8B 00 83 F8 ?? 72 ?? 68 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 59 59 89 
            84 24 ?? ?? ?? ?? 31 C0 C7 84 24 ?? ?? ?? ?? ?? ?? ?? ?? 89 94 24 ?? ?? ?? ?? 40 89 
            84 24 ?? ?? ?? ?? 83 A4 24 ?? ?? ?? ?? ?? 89 BC 24 ?? ?? ?? ?? 89 84 24 ?? ?? ?? ?? 
            68 ?? ?? ?? ?? 6A ?? 8D 84 24 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 56 E8 ?? ?? ?? 
            ?? EB ?? 8B 44 24 ?? 89 84 24 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A ?? 6A ?? 
            8D BC 24 ?? ?? ?? ?? 57 8D B4 24 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 83 C4 ?? 89 F1 E8 ?? 
            ?? ?? ?? 57 E8 ?? ?? ?? ?? 58 6A ?? 68 ?? ?? ?? ?? 57 E8 ?? ?? ?? ?? 83 C4 ?? 6A
        }

        $drop_hta_file_p2 = {
            68 ?? ?? ?? ?? 57 E8 ?? ?? ?? ?? 83 C4 ?? 8D B4 24 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 58 
            31 DB 43 53 56 E8 ?? ?? ?? ?? 59 5A 53 50 E8 ?? ?? ?? ?? 59 5A 8D 74 24 ?? 89 C2 89 
            F1 57 E8 ?? ?? ?? ?? 58 39 1E 0F 85 ?? ?? ?? ?? F2 0F 10 44 24 ?? A1 ?? ?? ?? ?? 8D 
            74 24 ?? F2 0F 11 84 24 ?? ?? ?? ?? 8B 00 83 F8 ?? 72 ?? 68 ?? ?? ?? ?? 8D 84 24 ?? 
            ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 59 89 44 24 ?? 31 C0 C7 84 24 ?? ?? ?? ?? ?? ?? ?? ?? 
            89 54 24 ?? 40 89 84 24 ?? ?? ?? ?? 83 A4 24 ?? ?? ?? ?? ?? 89 B4 24 ?? ?? ?? ?? 89 
            84 24 ?? ?? ?? ?? 68 ?? ?? ?? ?? 6A ?? 8D 84 24 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 
            ?? 8D 84 24 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? EB ?? 8B 44 24 ?? 89 44 24 ?? 68 ?? ?? ?? 
            ?? 68 ?? ?? ?? ?? 6A ?? 6A ?? 8D 74 24 ?? 56 8D 9C 24 ?? ?? ?? ?? 53 E8 ?? ?? ?? ?? 
            83 C4 ?? 89 D9 E8 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 58 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 
            8D BC 24 ?? ?? ?? ?? 89 C3 89 84 24 ?? ?? ?? ?? BA ?? ?? ?? ?? 89 F9 6A ?? E8 ?? ?? 
            ?? ?? 58 83 64 24 ?? ?? 83 64 24 ?? ?? 57 E8 ?? ?? ?? ?? 59 8D 4C 24 ?? 51 56 6A ?? 
            68 ?? ?? ?? ?? 6A ?? 6A ?? 6A ?? 50 53 E8
        }

    condition:
        uint16(0) == 0x5A4D and
        (
            all of ($find_files_p*)
        ) and
        (
            all of ($encrypt_files_p*)
        ) and
        (
            all of ($drop_hta_file_p*)
        )
}