rule Win32_Ransomware_Koxic : tc_detection malicious
{
    meta:

        author              = "ReversingLabs"

        source              = "ReversingLabs"
        status              = "RELEASED"
        sharing             = "TLP:WHITE"
        category            = "MALWARE"
        malware             = "KOXIC"
        description         = "Yara rule that detects Koxic ransomware."

        tc_detection_type   = "Ransomware"
        tc_detection_name   = "Koxic"
        tc_detection_factor = 5

    strings:

        $enum_shares_p1 = {
            8B 45 ?? 50 6A ?? 8B 4D ?? 51 E8 ?? ?? ?? ?? 83 C4 ?? 8D 55 ?? 52 8B 45 ?? 50 8D 4D
            ?? 51 8B 55 ?? 52 FF 15 ?? ?? ?? ?? 89 45 ?? 83 7D ?? ?? 0F 85 ?? ?? ?? ?? C7 45 ??
            ?? ?? ?? ?? EB ?? 8B 45 ?? 83 C0 ?? 89 45 ?? 8B 4D ?? 3B 4D ?? 0F 83 ?? ?? ?? ?? 8B
            55 ?? C1 E2 ?? 8B 45 ?? 83 7C 10 ?? ?? 0F 85 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 4D ?? C1
            E1 ?? 8B 55 ?? 8B 44 0A ?? 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 ?? ?? ?? ?? 68 ?? ?? ??
            ?? 8B 4D ?? C1 E1 ?? 8B 55 ?? 8B 44 0A ?? 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 ?? ?? ??
            ?? 8B 4D ?? C1 E1 ?? 8B 55 ?? 8B 44 0A ?? 50 8D 8D ?? ?? ?? ?? 51 FF 15 ?? ?? ?? ??
            68 ?? ?? ?? ?? 8D 95 ?? ?? ?? ?? 52 FF 15 ?? ?? ?? ?? 8B 45 ?? C1 E0 ?? 8B 4D ?? 8B
        }

        $enum_shares_p2 = {
            54 01 ?? 52 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 ?? C6 45 ?? ?? C7 45 ?? ?? ?? ?? ??
            0F B6 45 ?? 85 C0 0F 84 ?? ?? ?? ?? 83 7D ?? ?? 0F 84 ?? ?? ?? ?? 8D 8D ?? ?? ?? ??
            51 FF 15 ?? ?? ?? ?? 83 E8 ?? 89 45 ?? EB ?? 8B 55 ?? 83 EA ?? 89 55 ?? 83 7D ?? ??
            0F 8C ?? ?? ?? ?? 8B 45 ?? 0F B7 8C 45 ?? ?? ?? ?? 83 F9 ?? 0F 85 ?? ?? ?? ?? 8B 55
            ?? 0F B7 84 55 ?? ?? ?? ?? 83 F8 ?? 75 ?? C6 45 ?? ?? EB ?? 8B 4D ?? 8D 94 4D ?? ??
            ?? ?? 52 8D 85 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 33 C9 8B 55 ?? 66 89 8C 55 ?? ?? FF
            FF 8D 85 ?? ?? ?? ?? 50 8D 8D ?? ?? ?? ?? 51 FF 15 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 95
            ?? ?? ?? ?? 52 FF 15 ?? ?? ?? ?? 8B 45 ?? 50 8B 4D ?? 51 8D 95 ?? ?? ?? ?? 52 8D 85
            ?? ?? ?? ?? 50 8B 4D ?? 51 E8 ?? ?? ?? ?? EB ?? E9 ?? ?? ?? ?? 8B 55 ?? 83 EA ?? 89
            55 ?? E9 ?? ?? ?? ?? EB ?? 8B 45 ?? C1 E0 ?? 8B 4D ?? 8B 54 01 ?? 83 E2 ?? 74 ?? 8B
            45 ?? C1 E0 ?? 8B 4D ?? 8B 54 01 ?? 52 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 ?? 8B 45
            ?? C1 E0 ?? 03 45 ?? B9 ?? ?? ?? ?? 6B D1 ?? 89 44 15 ?? B8 ?? ?? ?? ?? C1 E0 ?? 8B
            4D ?? 89 4C 05 ?? BA ?? ?? ?? ?? D1 E2 8B 45 ?? 89 44 15 ?? 8D 4D ?? 51 E8 ?? ?? ??
            ?? 83 C4 ?? E9 ?? ?? ?? ?? EB ?? 81 7D ?? ?? ?? ?? ?? 74 ?? EB ?? 81 7D ?? ?? ?? ??
            ?? 0F 85 ?? ?? ?? ?? 8B 55 ?? 52 FF 15 ?? ?? ?? ?? 8B 45 ?? 50 FF 15 ?? ?? ?? ?? 85
            C0 75 ?? B8 ?? ?? ?? ?? EB ?? 33 C0
        }

        $find_files = {
            8D 85 ?? ?? ?? ?? 50 8B 4D ?? 51 FF 15 ?? ?? ?? ?? 89 45 ?? 33 D2 8B 45 ?? 66 89 10
            8B 4D ?? 51 FF 15 ?? ?? ?? ?? 89 45 ?? 83 7D ?? ?? 75 ?? 33 C0 E9 ?? ?? ?? ?? 68 ??
            ?? ?? ?? 8D 95 ?? ?? ?? ?? 52 E8 ?? ?? ?? ?? 83 C4 ?? 0F B6 C0 83 F8 ?? 75 ?? E9 ??
            ?? ?? ?? 8D 8D ?? ?? ?? ?? 51 FF 15 ?? ?? ?? ?? 8B 55 ?? 8D 44 02 ?? 3D ?? ?? ?? ??
            72 ?? E9 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? 51 8B 55 ?? 52 FF 15 ?? ?? ?? ?? 8B 45 ?? 8B
            48 ?? 81 79 ?? ?? ?? ?? ?? 76 ?? 6A ?? FF 15 ?? ?? ?? ?? EB ?? 8B 95 ?? ?? ?? ?? 83
            E2 ?? 74 ?? 68 ?? ?? ?? ?? 8B 45 ?? 50 FF 15 ?? ?? ?? ?? 6A ?? 8B 0D ?? ?? ?? ?? 51
            FF 15 ?? ?? ?? ?? 85 C0 75 ?? 8B 55 ?? 52 8B 45 ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 8B 0D
            ?? ?? ?? ?? 51 FF 15 ?? ?? ?? ?? BA ?? ?? ?? ?? C1 E2 ?? 8B 45 ?? 89 44 15 ?? 8D 4D
            ?? 51 E8 ?? ?? ?? ?? E9 ?? ?? ?? ?? 8D 95 ?? ?? ?? ?? 52 E8 ?? ?? ?? ?? 83 C4 ?? 85
            C0 75 ?? 6A ?? A1
        }

        $encrypt_files = {
            8D 4D ?? 51 8B 55 ?? 52 FF 15 ?? ?? ?? ?? 83 7D ?? ?? 7F ?? 7C ?? 83 7D ?? ?? 73 ??
            E9 ?? ?? ?? ?? 6A ?? 6A ?? 8B 45 ?? 50 8B 4D ?? 51 E8 ?? ?? ?? ?? 8B 4D ?? 2B C8 8B
            45 ?? 1B C2 89 4D ?? 89 45 ?? 6A ?? 8B 4D ?? 51 8B 55 ?? 52 6A ?? 6A ?? 8B 45 ?? 50
            FF 15 ?? ?? ?? ?? 89 45 ?? 83 7D ?? ?? 75 ?? E9 ?? ?? ?? ?? 83 7D ?? ?? 77 ?? 72 ??
            81 7D ?? ?? ?? ?? ?? 73 ?? 8B 4D ?? 51 8B 55 ?? 52 8B 45 ?? 50 6A ?? 8B 4D ?? 51 FF
            15 ?? ?? ?? ?? 89 45 ?? 83 7D ?? ?? 74 ?? 8B 55 ?? 52 8B 45 ?? 50 8B 4D ?? 51 E8 ??
            ?? ?? ?? 83 C4 ?? 8B 55 ?? 52 FF 15 ?? ?? ?? ?? EB ?? E9 ?? ?? ?? ?? E9 ?? ?? ?? ??
            EB ?? 68 ?? ?? ?? ?? 8B 45 ?? 50 8B 4D ?? 51 6A ?? 8B 55 ?? 52 FF 15 ?? ?? ?? ?? 89
            45
        }

    condition:
        uint16(0) == 0x5A4D and
        (
            $find_files
        ) and
        (
            $encrypt_files
        ) and
        (
            all of ($enum_shares_p*)
        )
}