rule Win64_Ransomware_Ako : tc_detection malicious
{
    meta:

        author              = "ReversingLabs"

        source              = "ReversingLabs"
        status              = "RELEASED"
        sharing             = "TLP:WHITE"
        category            = "MALWARE"
        malware             = "AKO"
        description         = "Yara rule that detects Ako ransomware."

        tc_detection_type   = "Ransomware"
        tc_detection_name   = "Ako"
        tc_detection_factor = 5

    strings:

        $encrypt_files_win64_p1 = {
            44 89 4C 24 ?? 4C 89 44 24 ?? 48 89 54 24 ?? 48 89 4C 24 ?? 56 57 48 81 EC ?? ?? ?? 
            ?? 48 C7 44 24 ?? ?? ?? ?? ?? 48 8B 05 ?? ?? ?? ?? 48 33 C4 48 89 84 24 ?? ?? ?? ?? 
            48 83 BC 24 ?? ?? ?? ?? ?? 74 ?? 48 83 BC 24 ?? ?? ?? ?? ?? 75 ?? 32 C0 E9 ?? ?? ?? 
            ?? 41 B9 ?? ?? ?? ?? 45 33 C0 48 8B 94 24 ?? ?? ?? ?? 48 8B 8C 24 ?? ?? ?? ?? E8 ?? 
            ?? ?? ?? 90 89 44 24 ?? 81 7C 24 ?? ?? ?? ?? ?? 73 ?? 32 C0 E9 ?? ?? ?? ?? C7 84 24 
            ?? ?? ?? ?? ?? ?? ?? ?? 48 8D 84 24 ?? ?? ?? ?? 48 8B F8 33 C0 B9 ?? ?? ?? ?? F3 AA 
            48 8D 94 24 ?? ?? ?? ?? 48 8B 8C 24 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 90 85 C0 75 ?? 32 
            C0 E9 ?? ?? ?? ?? C7 84 24 ?? ?? ?? ?? ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? 8B 44 24 
            ?? 45 33 C0 8B D0 48 8D 8C 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 90 45 33 C0 BA ?? ?? ?? ?? 
            48 8D 8C 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 90 C7 84 24 ?? ?? ?? ?? ?? ?? ?? ?? 48 8D 84 
            24 ?? ?? ?? ?? 48 8B F8 33 C0 B9 ?? ?? ?? ?? F3 AA C7 84 24 ?? ?? ?? ?? ?? ?? ?? ?? 
            48 8D 84 24 ?? ?? ?? ?? 48 8B F8 33 C0 B9 ?? ?? ?? ?? F3 AA 48 C7 44 24 ?? ?? ?? ?? 
            ?? EB ?? 48 8B 44 24 ?? 48 05 ?? ?? ?? ?? 48 89 44 24 ?? 48 8B 84 24 ?? ?? ?? ?? 48 
            39 44 24 ?? 0F 8D ?? ?? ?? ?? 48 C7 84 24 ?? ?? ?? ?? ?? ?? ?? ?? 41 B9 ?? ?? ?? ?? 
            4C 8D 84 24 ?? ?? ?? ?? 48 8B 94 24 ?? ?? ?? ?? 48 8B 8C 24 ?? ?? ?? ?? FF 15 ?? ?? 
            ?? ?? 90 85 C0 75 ?? C6 44 24 ?? ?? 48 8D 8C 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 90 48 8D 
            8C 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 90 0F B6 44 24 ?? E9 ?? ?? ?? ?? 33 D2 48 8D 8C 24 
            ?? ?? ?? ?? E8 ?? ?? ?? ?? 90 48 C7 44 24 ?? ?? ?? ?? ?? 4C 8D 8C 24 ?? ?? ?? ?? 41 
            B8 ?? ?? ?? ?? 48 8B D0 48 8B 8C 24 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 90 85 C0 75 ?? C6
        }

        $encrypt_files_win64_p2 = {
            44 24 ?? ?? 48 8D 8C 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 90 48 8D 8C 24 ?? ?? ?? ?? E8 ?? 
            ?? ?? ?? 90 0F B6 44 24 ?? E9 ?? ?? ?? ?? 45 33 C9 4C 8D 84 24 ?? ?? ?? ?? 48 8B 94 
            24 ?? ?? ?? ?? 48 8B 8C 24 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 90 85 C0 75 ?? C6 44 24 ?? 
            ?? 48 8D 8C 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 90 48 8D 8C 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 
            90 0F B6 44 24 ?? E9 ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? EB ?? 8B 44 24 ?? 05 ?? ?? 
            ?? ?? 89 44 24 ?? 8B 84 24 ?? ?? ?? ?? 39 44 24 ?? 0F 83 ?? ?? ?? ?? 48 8D 8C 24 ?? 
            ?? ?? ?? E8 ?? ?? ?? ?? 90 8B 4C 24 ?? 48 03 C1 48 89 44 24 ?? 33 D2 48 8D 8C 24 ?? 
            ?? ?? ?? E8 ?? ?? ?? ?? 90 48 8B F8 48 8B 44 24 ?? 48 8B F0 B9 ?? ?? ?? ?? F3 A4 48 
            8D 8C 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 90 8B 4C 24 ?? 89 4C 24 ?? C7 44 24 ?? ?? ?? ?? 
            ?? 4C 8B C8 45 33 C0 48 8B 94 24 ?? ?? ?? ?? 48 8B 8C 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 
            90 0F B6 C0 85 C0 75 ?? C6 44 24 ?? ?? 48 8D 8C 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 90 48 
            8D 8C 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 90 0F B6 44 24 ?? E9 ?? ?? ?? ?? 48 8D 8C 24 ?? 
            ?? ?? ?? E8 ?? ?? ?? ?? 90 48 C7 44 24 ?? ?? ?? ?? ?? 4C 8D 4C 24 ?? 44 8B 44 24 ?? 
            48 8B D0 48 8B 8C 24 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 90 85 C0 75 ?? C6 44 24 ?? ?? 48 
            8D 8C 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 90 48 8D 8C 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 90 0F 
            B6 44 24 ?? E9 ?? ?? ?? ?? E9 ?? ?? ?? ?? 83 BC 24 ?? ?? ?? ?? ?? 75 ?? EB ?? E9 ?? 
            ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? 48 8D 44 24 ?? 48 8B F8 33 C0 B9 ?? ?? ?? ?? F3 AA
        }

        $encrypt_files_win64_p3 = {
            48 8B 44 24 ?? 48 89 84 24 ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? 48 8D 44 24 ?? 48 8B 
            F8 33 C0 B9 ?? ?? ?? ?? F3 AA 48 8B 44 24 ?? 48 89 84 24 ?? ?? ?? ?? 41 B9 ?? ?? ?? 
            ?? 4C 8D 84 24 ?? ?? ?? ?? 48 8B 94 24 ?? ?? ?? ?? 48 8B 8C 24 ?? ?? ?? ?? FF 15 ?? 
            ?? ?? ?? 90 85 C0 0F 84 ?? ?? ?? ?? 48 8B 84 24 ?? ?? ?? ?? 48 83 C0 ?? 48 8B C8 E8 
            ?? ?? ?? ?? 90 48 89 44 24 ?? 48 8B 8C 24 ?? ?? ?? ?? 48 83 C1 ?? E8 ?? ?? ?? ?? 90 
            48 C7 44 24 ?? ?? ?? ?? ?? 4C 8D 4C 24 ?? 48 8B 4C 24 ?? 44 8B C1 48 8B D0 48 8B 8C 
            24 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 90 85 C0 0F 84 ?? ?? ?? ?? 8B 44 24 ?? 48 89 44 24 
            ?? 48 8B 8C 24 ?? ?? ?? ?? 48 83 C1 ?? E8 ?? ?? ?? ?? 90 48 8B 4C 24 ?? 48 3B C8 0F 
            85 ?? ?? ?? ?? 48 C7 84 24 ?? ?? ?? ?? ?? ?? ?? ?? C7 84 24 ?? ?? ?? ?? ?? ?? ?? ?? 
            C7 84 24 ?? ?? ?? ?? ?? ?? ?? ?? 48 8B 84 24 ?? ?? ?? ?? 48 89 84 24 ?? ?? ?? ?? 8B 
            84 24 ?? ?? ?? ?? 89 84 24 ?? ?? ?? ?? 48 C7 44 24 ?? ?? ?? ?? ?? 4C 8D 4C 24 ?? 41 
            B8 ?? ?? ?? ?? 48 8D 94 24 ?? ?? ?? ?? 48 8B 8C 24 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 90 
            85 C0 74 ?? 8B 44 24 ?? 48 83 F8 ?? 75 ?? C6 44 24 ?? ?? 48 8D 8C 24 ?? ?? ?? ?? E8 
            ?? ?? ?? ?? 90 48 8D 8C 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 90 0F B6 44 24 ?? EB ?? C6 44 
            24 ?? ?? 48 8D 8C 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 90 48 8D 8C 24 ?? ?? ?? ?? E8 ?? ?? 
            ?? ?? 90 0F B6 44 24 ?? 48 8B 8C 24 ?? ?? ?? ?? 48 33 CC E8 ?? ?? ?? ?? 90 48 81 C4 
            ?? ?? ?? ?? 5F 5E C3 
        }

        $encrypt_network_shares_win64_p1 = {
            48 89 54 24 ?? 48 89 4C 24 ?? 48 81 EC ?? ?? ?? ?? 48 C7 44 24 ?? ?? ?? ?? ?? 48 8B 
            05 ?? ?? ?? ?? 48 33 C4 48 89 84 24 ?? ?? ?? ?? 48 8B 94 24 ?? ?? ?? ?? 48 8D 8C 24 
            ?? ?? ?? ?? E8 ?? ?? ?? ?? 90 48 8B 84 24 ?? ?? ?? ?? 48 05 ?? ?? ?? ?? 48 8B C8 E8 
            ?? ?? ?? ?? 90 0F B6 C0 85 C0 0F 85 ?? ?? ?? ?? 48 8B 8C 24 ?? ?? ?? ?? E8 ?? ?? ?? 
            ?? 90 0F B6 C0 85 C0 0F 85 ?? ?? ?? ?? 48 8D 8C 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 90 48 
            8D 94 24 ?? ?? ?? ?? 48 8B 8C 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 90 48 8D 8C 24 ?? ?? ?? 
            ?? E8 ?? ?? ?? ?? 90 0F B6 C0 85 C0 0F 85 ?? ?? ?? ?? 48 8B 84 24 ?? ?? ?? ?? 48 83 
            C0 ?? 48 8D 94 24 ?? ?? ?? ?? 48 8B C8 E8 ?? ?? ?? ?? 90 48 8D 15 ?? ?? ?? ?? 48 8D 
            8C 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 90 48 8D 94 24 ?? ?? ?? ?? 48 8B 8C 24 ?? ?? ?? ?? 
            E8 ?? ?? ?? ?? 90 4C 8B C0 48 8D 94 24 ?? ?? ?? ?? 48 8B 8C 24 ?? ?? ?? ?? E8 ?? ?? 
            ?? ?? 90 4C 8B C0 48 8D 15 ?? ?? ?? ?? 48 8D 8C 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 90 4C 
            8D 05 ?? ?? ?? ?? 48 8B D0 48 8D 8C 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 90 48 8B D0 48 8D 
            8C 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 90 48 8D 8C 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 90 48 8D 
            8C 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 90 48 8D 8C 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 90 48 8D 
            8C 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 90 4C 8D 84 24 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 
            8D 8C 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 90 4C 8D 05 ?? ?? ?? ?? 48 8B D0 48 8D 8C 24 ?? 
            ?? ?? ?? E8 ?? ?? ?? ?? 90 48 8B D0 48 8D 8C 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 90 48 8D 
            8C 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 90 48 8D 8C 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 90 48 8B
        }

        $encrypt_network_shares_win64_p2 = {
            8C 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 90 4C 8B C0 48 8D 94 24 ?? ?? ?? ?? 48 8B 8C 24 ?? 
            ?? ?? ?? E8 ?? ?? ?? ?? 90 4C 8B C0 48 8D 15 ?? ?? ?? ?? 48 8D 8C 24 ?? ?? ?? ?? E8 
            ?? ?? ?? ?? 90 4C 8D 05 ?? ?? ?? ?? 48 8B D0 48 8D 8C 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 
            90 48 8B D0 48 8D 8C 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 90 48 8D 8C 24 ?? ?? ?? ?? E8 ?? 
            ?? ?? ?? 90 48 8D 8C 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 90 48 8D 8C 24 ?? ?? ?? ?? E8 ?? 
            ?? ?? ?? 90 48 8B 8C 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 90 4C 8B C0 48 8D 94 24 ?? ?? ?? 
            ?? 48 8B 8C 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 90 4C 8B C0 48 8D 15 ?? ?? ?? ?? 48 8D 8C 
            24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 90 4C 8D 05 ?? ?? ?? ?? 48 8B D0 48 8D 8C 24 ?? ?? ?? 
            ?? E8 ?? ?? ?? ?? 90 48 8B D0 48 8D 8C 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 90 48 8D 8C 24 
            ?? ?? ?? ?? E8 ?? ?? ?? ?? 90 48 8D 8C 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 90 48 8D 8C 24 
            ?? ?? ?? ?? E8 ?? ?? ?? ?? 90 48 8D 15 ?? ?? ?? ?? 48 8D 8C 24 ?? ?? ?? ?? E8 ?? ?? 
            ?? ?? 90 48 8D 15 ?? ?? ?? ?? 48 8D 8C 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 90 48 8D 8C 24 
            ?? ?? ?? ?? E8 ?? ?? ?? ?? 90 48 8D 94 24 ?? ?? ?? ?? 48 8D 8C 24 ?? ?? ?? ?? E8 ?? 
            ?? ?? ?? 90 48 8D 8C 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 90 0F B6 C0 85 C0 0F 85 ?? ?? ?? 
            ?? 48 C7 44 24 ?? ?? ?? ?? ?? EB ?? 48 8B 44 24 ?? 48 FF C0 48 89 44 24 ?? 48 8D 8C 
            24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 90 48 39 44 24 ?? 73 ?? 48 83 7C 24 ?? ?? 76 ?? 33 D2 
            48 8B 44 24 ?? B9 ?? ?? ?? ?? 48 F7 F1 48 8B C2 48 85 C0 75 ?? 41 B9 ?? ?? ?? ?? 4C
        }

        $encrypt_network_shares_win64_p3 = {
            8D 05 ?? ?? ?? ?? 48 8B 54 24 ?? 48 8D 8C 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 90 48 8B 44 
            24 ?? 48 FF C0 48 89 44 24 ?? EB ?? 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 ?? E8 ?? ?? ?? 
            ?? 90 48 8D 8C 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 90 4C 8B C0 48 8D 54 24 ?? 48 8D 8C 24 
            ?? ?? ?? ?? E8 ?? ?? ?? ?? 90 48 8D 4C 24 ?? E8 ?? ?? ?? ?? 90 48 8D 15 ?? ?? ?? ?? 
            48 8D 4C 24 ?? E8 ?? ?? ?? ?? 90 48 8D 94 24 ?? ?? ?? ?? 48 8B 8C 24 ?? ?? ?? ?? E8 
            ?? ?? ?? ?? 90 4C 8B C0 48 8D 94 24 ?? ?? ?? ?? 48 8B 8C 24 ?? ?? ?? ?? E8 ?? ?? ?? 
            ?? 90 48 8B C8 E8 ?? ?? ?? ?? 90 4C 8B C0 48 8D 54 24 ?? 48 8D 8C 24 ?? ?? ?? ?? E8 
            ?? ?? ?? ?? 90 48 8D 8C 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 90 48 8D 8C 24 ?? ?? ?? ?? E8 
            ?? ?? ?? ?? 90 48 8D 4C 24 ?? E8 ?? ?? ?? ?? 90 48 8D 15 ?? ?? ?? ?? 48 8D 4C 24 ?? 
            E8 ?? ?? ?? ?? 90 48 8B 8C 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 90 4C 8B C0 48 8D 94 24 ?? 
            ?? ?? ?? 48 8B 8C 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 90 48 8B C8 E8 ?? ?? ?? ?? 90 4C 8B 
            C0 48 8D 54 24 ?? 48 8D 8C 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 90 48 8D 8C 24 ?? ?? ?? ?? 
            E8 ?? ?? ?? ?? 90 48 8D 4C 24 ?? E8 ?? ?? ?? ?? 90 C6 44 24 ?? ?? 48 8D 8C 24 ?? ?? 
            ?? ?? E8 ?? ?? ?? ?? 90 48 8D 8C 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 90 48 8D 8C 24 ?? ?? 
            ?? ?? E8 ?? ?? ?? ?? 90 0F B6 44 24 ?? EB ?? 48 8D 8C 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 
            90 48 8D 8C 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 90 48 8D 8C 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 
            90 32 C0 48 8B 8C 24 ?? ?? ?? ?? 48 33 CC E8 ?? ?? ?? ?? 90 48 81 C4 ?? ?? ?? ?? C3 
        }

        $find_files_win64 = {
            48 89 5C 24 ?? 55 56 57 41 56 41 57 48 81 EC ?? ?? ?? ?? 48 8B 05 ?? ?? ?? ?? 48 33 
            C4 48 89 84 24 ?? ?? ?? ?? 4D 8B F0 49 B8 ?? ?? ?? ?? ?? ?? ?? ?? 48 8B E9 48 3B D1 
            74 ?? 0F B7 02 66 83 E8 ?? 66 83 F8 ?? 77 ?? 0F B7 C0 49 0F A3 C0 72 ?? 48 83 EA ?? 
            48 3B D5 75 ?? 0F B7 0A 66 83 F9 ?? 75 ?? 48 8D 45 ?? 48 3B D0 74 ?? 4D 8B CE 45 33 
            C0 33 D2 48 8B CD E8 ?? ?? ?? ?? E9 ?? ?? ?? ?? 66 83 E9 ?? 33 FF 66 83 F9 ?? 77 ?? 
            0F B7 C1 49 0F A3 C0 B0 ?? 72 ?? 40 8A C7 48 2B D5 48 8D 4C 24 ?? 48 D1 FA 41 B8 ?? 
            ?? ?? ?? 48 FF C2 F6 D8 4D 1B FF 4C 23 FA 33 D2 E8 ?? ?? ?? ?? 45 33 C9 89 7C 24 ?? 
            4C 8D 44 24 ?? 48 89 7C 24 ?? 33 D2 48 8B CD FF 15 ?? ?? ?? ?? 48 8B D8 48 83 F8 ?? 
            75 ?? 4D 8B CE 45 33 C0 33 D2 48 8B CD E8 ?? ?? ?? ?? 8B F8 48 83 FB ?? 74 ?? 48 8B 
            CB FF 15 ?? ?? ?? ?? 8B C7 48 8B 8C 24 ?? ?? ?? ?? 48 33 CC E8 ?? ?? ?? ?? 48 8B 9C 
            24 ?? ?? ?? ?? 48 81 C4 ?? ?? ?? ?? 41 5F 41 5E 5F 5E 5D C3 49 8B 76 ?? 49 2B 36 48 
            C1 FE ?? 66 83 7C 24 ?? ?? 75 ?? 66 39 7C 24 ?? 74 ?? 66 83 7C 24 ?? ?? 75 ?? 66 39 
            7C 24 ?? 74 ?? 4D 8B CE 48 8D 4C 24 ?? 4D 8B C7 48 8B D5 E8 ?? ?? ?? ?? 85 C0 75 ?? 
            48 8D 54 24 ?? 48 8B CB FF 15 ?? ?? ?? ?? 85 C0 75 ?? 49 8B 06 49 8B 56 ?? 48 2B D0 
            48 C1 FA ?? 48 3B F2 0F 84 ?? ?? ?? ?? 48 2B D6 48 8D 0C F0 4C 8D 0D ?? ?? ?? ?? 41 
            B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E9
        }

    condition:
        uint16(0) == 0x5A4D and
        (
            $find_files_win64
        ) and
        (
            all of ($encrypt_files_win64_p*)
        ) and
        (
            all of ($encrypt_network_shares_win64_p*)
        )
}