rule ByteCode_MSIL_Ransomware_Venom : tc_detection malicious
{
    meta:

        author              = "ReversingLabs"

        source              = "ReversingLabs"
        status              = "RELEASED"
        sharing             = "TLP:WHITE"
        category            = "MALWARE"
        malware             = "VENOM"
        description         = "Yara rule that detects Venom ransomware."

        tc_detection_type   = "Ransomware"
        tc_detection_name   = "Venom"
        tc_detection_factor = 5

    strings:

        $setup_env = {
            00 28 ?? ?? ?? ?? 0A 73 ?? ?? ?? ?? 0B 07 1F ?? 28 ?? ?? ?? ?? 6F ?? ?? ?? ?? 00 07 1B
            28 ?? ?? ?? ?? 6F ?? ?? ?? ?? 00 07 1F ?? 28 ?? ?? ?? ?? 6F ?? ?? ?? ?? 00 07 1F ?? 28
            ?? ?? ?? ?? 6F ?? ?? ?? ?? 00 07 1F ?? 28 ?? ?? ?? ?? 6F ?? ?? ?? ?? 00 00 07 6F ?? ??
            ?? ?? 13 ?? 2B ?? 12 ?? 28 ?? ?? ?? ?? 13 ?? 00 06 11 ?? 28 ?? ?? ?? ?? 00 00 12 ?? 28
            ?? ?? ?? ?? 2D ?? DE ?? 12 ?? FE 16 ?? ?? ?? ?? 6F ?? ?? ?? ?? 00 DC 72 ?? ?? ?? ?? 1F
            ?? 28 ?? ?? ?? ?? 72 ?? ?? ?? ?? 72 ?? ?? ?? ?? 28 ?? ?? ?? ?? 00 72 ?? ?? ?? ?? 1F ??
            28 ?? ?? ?? ?? 72 ?? ?? ?? ?? 72 ?? ?? ?? ?? 28 ?? ?? ?? ?? 00 1F ?? 28 ?? ?? ?? ?? 72
            ?? ?? ?? ?? 28 ?? ?? ?? ?? 28 ?? ?? ?? ?? 00 72 ?? ?? ?? ?? 1F ?? 28 ?? ?? ?? ?? 72 ??
            ?? ?? ?? 28 ?? ?? ?? ?? 28 ?? ?? ?? ?? 26 20 ?? ?? ?? ?? 8D ?? ?? ?? ?? 25 D0 ?? ?? ??
            ?? 28 ?? ?? ?? ?? 0C 72 ?? ?? ?? ?? 20 ?? ?? ?? ?? 19 7E ?? ?? ?? ?? 19 16 7E ?? ?? ??
            ?? 28 ?? ?? ?? ?? 0D 09 08 20 ?? ?? ?? ?? 12 ?? 7E ?? ?? ?? ?? 28 ?? ?? ?? ?? 26 17 28
            ?? ?? ?? ?? 00 2A
        }

        $find_files = {
            00 00 00 03 28 ?? ?? ?? ?? 0A 16 0B 2B ?? 06 07 9A 0C 00 00 08 72 ?? ?? ?? ?? 6F ?? ??
            ?? ?? 16 FE 01 0D 09 2C ?? 00 08 02 28 ?? ?? ?? ?? 00 00 00 DE ?? 26 00 00 DE ?? 00 07
            17 58 0B 07 06 8E 69 32 ?? 00 03 28 ?? ?? ?? ?? 13 ?? 16 13 ?? 2B ?? 11 ?? 11 ?? 9A 13
            ?? 00 11 ?? 02 28 ?? ?? ?? ?? 00 00 11 ?? 17 58 13 ?? 11 ?? 11 ?? 8E 69 32 ?? 00 DE ??
            26 00 00 DE ?? 2A
        }

        $encrypt_files = {
            00 28 ?? ?? ?? ?? 0A 28 ?? ?? ?? ?? 03 6F ?? ?? ?? ?? 0B 02 72 ?? ?? ?? ?? 28 ?? ?? ??
            ?? 18 73 ?? ?? ?? ?? 0C 73 ?? ?? ?? ?? 0D 09 20 ?? ?? ?? ?? 6F ?? ?? ?? ?? 00 09 20 ??
            ?? ?? ?? 6F ?? ?? ?? ?? 00 09 18 6F ?? ?? ?? ?? 00 07 06 20 ?? ?? ?? ?? 73 ?? ?? ?? ??
            13 ?? 09 11 ?? 09 6F ?? ?? ?? ?? 1E 5B 6F ?? ?? ?? ?? 6F ?? ?? ?? ?? 00 09 11 ?? 09 6F
            ?? ?? ?? ?? 1E 5B 6F ?? ?? ?? ?? 6F ?? ?? ?? ?? 00 09 17 6F ?? ?? ?? ?? 00 08 06 16 06
            8E 69 6F ?? ?? ?? ?? 00 08 09 6F ?? ?? ?? ?? 17 73 ?? ?? ?? ?? 13 ?? 02 19 73 ?? ?? ??
            ?? 13 ?? 20 ?? ?? ?? ?? 8D ?? ?? ?? ?? 13 ?? 00 2B ?? 00 11 ?? 11 ?? 16 11 ?? 6F ?? ??
            ?? ?? 00 00 11 ?? 11 ?? 16 11 ?? 8E 69 6F ?? ?? ?? ?? 25 13 ?? 16 FE 02 13 ?? 11 ?? 2D
            ?? 11 ?? 6F ?? ?? ?? ?? 00 00 DE ?? 13 ?? 00 11 ?? 6F ?? ?? ?? ?? 28 ?? ?? ?? ?? 00 00
            DE ?? DE ?? 00 11 ?? 6F ?? ?? ?? ?? 00 08 6F ?? ?? ?? ?? 00 00 02 28 ?? ?? ?? ?? 00 00
            DE ?? 26 00 00 DE ?? 00 DC 2A
        }

    condition:
        uint16(0) == 0x5A4D and
        (
            $setup_env
        ) and
        (
            $find_files
        ) and
        (
            $encrypt_files
        )
}