rule Win32_Ransomware_Balaclava : tc_detection malicious
{
    meta:

        author              = "ReversingLabs"

        source              = "ReversingLabs"
        status              = "RELEASED"
        sharing             = "TLP:WHITE"
        category            = "MALWARE"
        malware             = "BALACLAVA"
        description         = "Yara rule that detects Balaclava ransomware."

        tc_detection_type   = "Ransomware"
        tc_detection_name   = "Balaclava"
        tc_detection_factor = 5

    strings:

        $find_files_p1 = {
            55 8B EC 83 EC ?? 53 56 8B 75 ?? 33 D2 57 6A ?? 5B 8B 7E ?? 89 55 ?? 8D 4F ?? 66 8B 
            07 03 FB 66 3B C2 75 ?? 2B F9 B9 ?? ?? ?? ?? D1 FF E8 ?? ?? ?? ?? 50 FF 76 ?? 89 45 
            ?? FF 15 ?? ?? ?? ?? 89 45 ?? 83 F8 ?? 75 ?? 50 FF 15 ?? ?? ?? ?? E9 ?? ?? ?? ?? 8B 
            45 ?? 83 C0 ?? 89 45 ?? 8B D8 33 D2 8D 4B ?? 66 8B 03 83 C3 ?? 66 3B C2 75 ?? 2B D9 
            D1 FB 8D 04 3B 3D ?? ?? ?? ?? 7C ?? 8D 04 45 ?? ?? ?? ?? 50 39 56 ?? 74 ?? FF 76 ?? 
            52 FF 15 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? EB ?? 52 FF 15 ?? ?? ?? ?? 50 FF 15 ?? ?? 
            ?? ?? 39 46 ?? 74 ?? 89 46 ?? 8B 46 ?? 33 C9 66 89 0C 78 8B 55 ?? F7 02 ?? ?? ?? ?? 
            0F 85 ?? ?? ?? ?? 33 D2 8B C2 6A ?? 89 45 ?? 59 89 4D ?? 3B C1 7F ?? 03 C1 8B 4D ?? 
            99 2B C2 D1 F8 89 45 ?? 8B 14 85 ?? ?? ?? ?? 66 8B 01 66 3B 02 75 ?? 66 85 C0 74 ?? 
            66 8B 41 ?? 66 3B 42 ?? 75 ?? 83 C1 ?? 83 C2 ?? 66 85 C0 75 ?? 33 D2 8B C2 EB ?? 1B 
            C0 83 C8 ?? 33 D2 85 C0 0F 84 ?? ?? ?? ?? 79 ?? 8B 4D ?? 8B 45 ?? 49 EB ?? 8B 45 ?? 
            8B 4D ?? 40 89 45 ?? EB ?? 8B 45 ?? F6 00 ?? 0F 84 ?? ?? ?? ?? 8D 04 5D ?? ?? ?? ?? 
            50 8B 46 ?? FF 75 ?? 8D 04 78 83 C0 ?? 50 E8 ?? ?? ?? ?? 8B 4E ?? 83 C4 ?? 8B 46 ?? 
            66 8B 10 66 3B 11 75 ?? 66 85 D2 74 ?? 66 8B 50 ?? 66 3B 51 ?? 75 ?? 83 C0 ?? 83 C1 
            ?? 66 85 D2 75 ?? 33 C0 EB ?? 1B C0 83 C8 ?? 85 C0 0F 84 ?? ?? ?? ?? 83 7E ?? ?? 74 
            ?? 83 7E ?? ?? 7E ?? FF 76 ?? 8B 4E ?? FF 76 ?? E8 ?? ?? ?? ?? 59 59 8B 4E ?? 8D 14
        }

        $find_files_p2 = { 
            3B A1 ?? ?? ?? ?? 56 89 44 51 ?? 66 A1 ?? ?? ?? ?? 66 89 44 51 ?? FF 46 ?? E8 ?? ?? 
            ?? ?? FF 4E ?? E9 ?? ?? ?? ?? 39 56 ?? 0F 85 ?? ?? ?? ?? 8D 04 5D ?? ?? ?? ?? 50 8B 
            46 ?? FF 75 ?? 8D 04 78 83 C0 ?? 50 E8 ?? ?? ?? ?? 8B 5E ?? 83 C4 ?? 8B CB B8 ?? ?? 
            ?? ?? 66 8B 10 66 3B 11 75 ?? 66 85 D2 74 ?? 66 8B 50 ?? 66 3B 51 ?? 75 ?? 83 C0 ?? 
            83 C1 ?? 66 85 D2 75 ?? 33 C0 EB ?? 1B C0 83 C8 ?? 85 C0 0F 84 ?? ?? ?? ?? 8B CB 8D 
            51 ?? 66 8B 01 83 C1 ?? 66 3B 45 ?? 75 ?? 2B CA D1 F9 83 F9 ?? 72 ?? 8B CB 8D 51 ?? 
            66 8B 01 83 C1 ?? 66 3B 45 ?? 75 ?? 2B CA D1 F9 83 C1 ?? 68 ?? ?? ?? ?? 8D 04 4B 50 
            FF 15 ?? ?? ?? ?? 59 59 85 C0 0F 84 ?? ?? ?? ?? 8B 45 ?? 8B 00 A8 ?? 74 ?? 83 E0 ?? 
            50 FF 76 ?? FF 15 ?? ?? ?? ?? 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? BB ?? ?? ?? ?? 53 FF 
            15 ?? ?? ?? ?? EB ?? 85 C0 75 ?? 6A ?? 53 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 8B 0D ?? 
            ?? ?? ?? 6A ?? 58 3B C8 A1 ?? ?? ?? ?? 74 ?? 83 F8 ?? 74 ?? FF 76 ?? A1 ?? ?? ?? ?? 
            33 D2 6A ?? 03 C1 59 F7 F1 FF 34 95 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? FF 05 ?? ?? ?? ?? 
            FF 05 ?? ?? ?? ?? 53 FF 15 ?? ?? ?? ?? 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 8B 46 ?? 6A 
            ?? 59 66 89 4C 78 ?? 33 C9 8B 46 ?? 66 89 0C 78 FF 75 ?? 8B 5D ?? 53 FF 15 ?? ?? ?? 
            ?? 85 C0 74 ?? 8B 45 ?? E9 ?? ?? ?? ?? 53 FF 15 ?? ?? ?? ?? 8B 5D ?? 33 FF 39 7E ?? 
            75 ?? 89 3E 53 FF 15 ?? ?? ?? ?? 8B DF 8B 4D ?? E8 ?? ?? ?? ?? 5F 5E 8B C3 5B 8B E5 
            5D C2
        }

        $encrypt_files_p1 = {
            68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 55 ?? 8B C1 89 45 ?? C7 45 ?? ?? ?? 
            ?? ?? 33 F6 89 75 ?? 83 4D ?? ?? 89 75 ?? 89 75 ?? 89 75 ?? 89 75 ?? 89 75 ?? 89 75 
            ?? 56 68 ?? ?? ?? ?? 6A ?? 56 56 68 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 8B D8 89 5D ?? 
            83 FB ?? 74 ?? 8D 45 ?? 50 53 FF 15 ?? ?? ?? ?? 85 C0 74 ?? 8B 45 ?? 0B 45 ?? 74 ?? 
            8B FE EB ?? 33 FF 47 89 7D ?? 85 FF 0F 85 ?? ?? ?? ?? 8B 45 ?? 89 45 ?? 8B 45 ?? 89 
            45 ?? A1 ?? ?? ?? ?? 85 C0 74 ?? 6A ?? FF 75 ?? FF D0 8B C8 A1 ?? ?? ?? ?? EB ?? 8B 
            CE 85 C9 0F 84 ?? ?? ?? ?? 85 C0 74 ?? 6A ?? FF 75 ?? FF D0 EB ?? 8B C6 85 C0 0F 84 
            ?? ?? ?? ?? 56 8D 45 ?? 50 68 ?? ?? ?? ?? 8B 7D ?? 57 53 FF 15 ?? ?? ?? ?? 85 C0 75 
            ?? 83 CF ?? 89 7D ?? E9 ?? ?? ?? ?? 8B 45 ?? 3B C6 7C ?? 8B 4D ?? 7F ?? 81 F9 ?? ?? 
            ?? ?? 76 ?? 81 E9 ?? ?? ?? ?? 1B C6 50 51 33 D2 8B CB E8 ?? ?? ?? ?? 59 59 23 C2 89
        }

        $encrypt_files_p2 = {
            75 ?? 85 F6 75 ?? 56 8D 45 ?? 50 68 ?? ?? ?? ?? 8B 45 ?? 03 C7 50 53 FF 15 ?? ?? ?? 
            ?? 8B FE 89 7D ?? EB ?? 56 56 6A ?? 5A 8B CB E8 ?? ?? ?? ?? 59 59 23 C2 8B FE 89 7D 
            ?? 85 FF 75 ?? 56 8D 45 ?? 50 6A ?? FF 75 ?? 53 FF 15 ?? ?? ?? ?? 85 C0 0F 84 ?? ?? 
            ?? ?? 8B 4D ?? FF 71 ?? FF 71 ?? 8D 41 ?? 50 FF 71 ?? 6A ?? 5A 8B 4D ?? E8 ?? ?? ?? 
            ?? 83 C4 ?? 0F B6 C0 23 F8 89 7D ?? 0F 85 ?? ?? ?? ?? 56 8D 45 ?? 50 8B 45 ?? FF 70 
            ?? FF 70 ?? 53 FF 15 ?? ?? ?? ?? 56 8D 45 ?? 50 8B 45 ?? FF 70 ?? FF 70 ?? 53 FF 15 
            ?? ?? ?? ?? 51 8B 55 ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 51 8D 45 ?? 50 8B 55 ?? 52 
            8B 4D ?? 8B 45 ?? 03 C1 50 52 51 51 8B 55 ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 
            ?? 85 C0 75 ?? 56 8D 45 ?? 50 6A ?? 8D 45 ?? 50 53 FF 15 ?? ?? ?? ?? 53 FF 15 ?? ?? 
            ?? ?? 56 56 33 D2 8B CB E8 ?? ?? ?? ?? 59 59 56 8D 45 ?? 50 FF 75 ?? FF 75 ?? 53 FF 
            15 ?? ?? ?? ?? 83 7D ?? ?? 76 ?? 8B 45 ?? 2D ?? ?? ?? ?? 8B 4D ?? 1B CE 51 50 33 D2 
            8B CB E8 ?? ?? ?? ?? 59 59 56 8D 45 ?? 50 FF 75 ?? 8B 45 ?? 03 45 ?? 50 53 FF 15 ?? 
            ?? ?? ?? C7 45 ?? ?? ?? ?? ?? 83 4D ?? ?? E8 ?? ?? ?? ?? 8B C7 E8 ?? ?? ?? ?? C3 
        }

        $find_volumes = {
            68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? BE ?? ?? ?? ?? 56 33 DB 53 8D 85 ?? ?? 
            ?? ?? 50 E8 ?? ?? ?? ?? 56 53 8D 85 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 68 ?? ?? 
            ?? ?? 8D 85 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 8B F8 89 7D ?? 83 FF ?? 0F 84 ?? ?? ?? 
            ?? 89 5D ?? 6A ?? 5B 8D B5 ?? ?? ?? ?? 8D 4E ?? 33 D2 66 8B 06 83 C6 ?? 66 3B C2 75 
            ?? 2B F1 D1 FE 66 39 9D ?? ?? ?? ?? 0F 85 ?? ?? ?? ?? 66 39 9D ?? ?? ?? ?? 75 ?? 66 
            83 BD ?? ?? ?? ?? ?? 75 ?? 66 39 9D ?? ?? ?? ?? 75 ?? 66 39 9C 75 ?? ?? ?? ?? 75 ?? 
            33 C0 66 89 84 75 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 50 8D 85 ?? ?? ?? ?? 
            50 FF 15 ?? ?? ?? ?? 66 89 9C 75 ?? ?? ?? ?? 85 C0 74 ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? 
            ?? ?? 68 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 50 57 FF 15 ?? ?? ?? ?? 85 C0 0F 85 ?? ?? ?? 
            ?? FF 15 ?? ?? ?? ?? 89 45 ?? 83 4D ?? ?? E8 ?? ?? ?? ?? EB ?? 8B 7D ?? 57 FF 15 ?? 
            ?? ?? ?? 8B 65 ?? E8 ?? ?? ?? ?? C3 
        }
        
    condition:
        uint16(0) == 0x5A4D and
        (
            $find_volumes
        ) and
        (
            all of ($find_files_p*)
        ) and
        (
            all of ($encrypt_files_p*)
        )
}