rule Win32_Ransomware_GPGQwerty : tc_detection malicious
{
    meta:

        author              = "ReversingLabs"

        source              = "ReversingLabs"
        status              = "RELEASED"
        sharing             = "TLP:WHITE"
        category            = "MALWARE"
        malware             = "GPGQWERTY"
        description         = "Yara rule that detects GPGQwerty ransomware."

        tc_detection_type   = "Ransomware"
        tc_detection_name   = "GPGQwerty"
        tc_detection_factor = 5

    strings:

        $find_files_p1 = {                        
            56 53 89 D3 81 EC ?? ?? ?? ?? 8D 54 24 ?? 89 04 24 89 54 24 ?? E8 ?? ?? ?? ?? 83 EC 
            ?? 83 F8 ?? 89 C6 74 ?? 31 C0 8D 4B ?? 66 89 43 ?? 31 C0 EB ?? 0F B7 43 ?? 83 C0 ?? 
            66 3D ?? ?? 66 89 43 ?? 83 D1 ?? 0F B7 C0 0F B6 44 04 ?? 84 C0 88 01 75 ?? 8B 44 24 
            ?? 24 ?? 83 F8 ?? 76 ?? C7 43 ?? ?? ?? ?? ?? 81 C4 ?? ?? ?? ?? 89 F0 5B 5E C3 66 90 
            89 43 ?? 81 C4 ?? ?? ?? ?? 89 F0 5B 5E C3 E8 ?? ?? ?? ?? 89 C3 E8 ?? ?? ?? ?? 83 F8 
            ?? 89 03 74 ?? E8 ?? ?? ?? ?? 81 38 ?? ?? ?? ?? 74 ?? E8 ?? ?? ?? ?? 83 38 ?? 74 ?? 
            E8 ?? ?? ?? ?? C7 00 ?? ?? ?? ?? EB ?? E8 ?? ?? ?? ?? C7 00 ?? ?? ?? ?? EB ?? E8 ?? 
            ?? ?? ?? C7 00 ?? ?? ?? ?? EB ?? 90 56 53 89 D3 81 EC ?? ?? ?? ?? 8D 54 24 ?? 89 04 
            24 89 54 24 ?? E8 ?? ?? ?? ?? 83 EC ?? 85 C0 89 C6 74 ?? 31 C0 8D 4B ?? 66 89 43 ?? 
            31 C0 EB ?? 0F B7 43 ?? 83 C0 ?? 66 3D ?? ?? 66 89 43 ?? 83 D1 ?? 0F B7 C0 0F B6 44 
            04 ?? 84 C0 88 01 75 ?? 8B 44 24 ?? 24 ?? 83 F8 ?? 77 ?? 89 43 ?? 81 C4 ?? ?? ?? ?? 
            89 F0 5B 5E C3 8D B4 26 ?? ?? ?? ?? C7 43 ?? ?? ?? ?? ?? 81 C4 ?? ?? ?? ?? 89 F0 5B 
            5E C3 E8 ?? ?? ?? ?? 83 F8 ?? 74 ?? E8 ?? ?? ?? ?? C7 00 ?? ?? ?? ?? 81 C4 ?? ?? ?? 
            ?? 89 F0 5B 5E C3 
        }

        $find_files_p2 = {                        
            8B 45 ?? 89 45 ?? 8B 45 ?? 89 04 24 E8 ?? ?? ?? ?? 89 45 ?? 83 7D ?? ?? 0F 95 C0 84 
            C0 0F 84 ?? ?? ?? ?? 8B 45 ?? 83 C0 ?? C7 44 24 ?? ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? 
            ?? 85 C0 74 ?? 8B 45 ?? 83 C0 ?? C7 44 24 ?? ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? 85 
            C0 74 ?? C6 85 ?? ?? ?? ?? ?? 8B 45 ?? 89 44 24 ?? 8D 85 ?? ?? ?? ?? 89 04 24 E8 ?? 
            ?? ?? ?? 8B 45 ?? 83 C0 ?? 89 44 24 ?? 8D 85 ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? 8D 
            85 ?? ?? ?? ?? 89 45 ?? 8B 45 ?? 89 04 24 E8 ?? ?? ?? ?? 85 C0 0F 94 C0 84 C0 0F 84 
            ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? 8B 45 ?? 89 04 24 E8 ?? ?? ?? ?? 85 C0 0F 85 ?? 
            ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? 8B 45 ?? 89 04 24 E8 ?? ?? ?? ?? 85 C0 0F 85 ?? ?? 
            ?? ?? C7 44 24 ?? ?? ?? ?? ?? 8B 45 ?? 89 04 24 E8 ?? ?? ?? ?? 85 C0 0F 85 ?? ?? ?? 
            ?? C7 44 24 ?? ?? ?? ?? ?? 8B 45 ?? 89 04 24 E8 ?? ?? ?? ?? 85 C0 0F 85 ?? ?? ?? ?? 
            C7 44 24 ?? ?? ?? ?? ?? 8B 45 ?? 89 04 24 E8 ?? ?? ?? ?? 85 C0 0F 85 ?? ?? ?? ?? C7 
            44 24 ?? ?? ?? ?? ?? 8B 45 ?? 89 04 24 E8 ?? ?? ?? ?? 85 C0 0F 85 ?? ?? ?? ?? C7 44 
            24 ?? ?? ?? ?? ?? 8B 45 ?? 89 04 24 E8 ?? ?? ?? ?? 85 C0 0F 85 ?? ?? ?? ?? C7 44 24 
            ?? ?? ?? ?? ?? 8B 45 ?? 89 04 24 E8 ?? ?? ?? ?? 85 C0 0F 85 ?? ?? ?? ?? 8B 45 ?? 83 
            C0 ?? C7 44 24 ?? ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? 85 C0 0F 85 ?? ?? ?? ?? 8B 45 
            ?? 83 C0 ?? C7 44 24 ?? ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? 85 C0 0F 85 ?? ?? ?? ?? 
            8B 45 ?? 83 C0 ?? C7 44 24 ?? ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? 85 C0 0F 85 ?? ?? 
            ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? E8
        }

        $encrypt_files = {                        
            C7 44 24 ?? ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? 
            C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 ?? 83 
            C0 ?? 89 44 24 ?? 8B 45 ?? 89 44 24 ?? C7 44 24 ?? ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? 
            E8 ?? ?? ?? ?? C7 44 24 ?? ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 04 24 
            ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 ?? 89 44 24 ?? 8D 85 ?? ?? ?? ?? 89 44 24 ?? C7 44 
            24 ?? ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? 
            ?? ?? 8B 45 ?? 89 44 24 ?? 8D 85 ?? ?? ?? ?? 89 44 24 ?? C7 44 24 ?? ?? ?? ?? ?? C7 
            04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 ?? 89 44 
            24 ?? 8D 85 ?? ?? ?? ?? 89 44 24 ?? C7 44 24 ?? ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 
            ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 ?? 89 44 24 ?? 8D 85 ?? ?? ?? 
            ?? 89 44 24 ?? C7 44 24 ?? ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 04 24 
            ?? ?? ?? ?? E8 ?? ?? ?? ?? E9 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? B9 ?? ?? ?? ?? 89 C2 B8 
            ?? ?? ?? ?? 89 D7 F2 AE 89 C8 F7 D0 8D 50 ?? 8D 85 ?? ?? ?? ?? 01 D0 66 C7 00 ?? ?? 
            8B 45 ?? 83 E8 ?? 89 44 24 ?? 8D 85 ?? ?? ?? ?? 89 04 24 E8 ?? ?? ?? ?? E9
        }

    condition:
        uint16(0) == 0x5A4D and 
        (
            all of ($find_files_p*)
        ) and 
        (
            $encrypt_files
        )
}