rule Win32_Ransomware_MountLocker : tc_detection malicious
{
    meta:

        author              = "ReversingLabs"

        source              = "ReversingLabs"
        status              = "RELEASED"
        sharing             = "TLP:WHITE"
        category            = "MALWARE"
        malware             = "MOUNTLOCKER"
        description         = "Yara rule that detects MountLocker ransomware."

        tc_detection_type   = "Ransomware"
        tc_detection_name   = "MountLocker"
        tc_detection_factor = 5

    strings:

        $encrypt_files_p1 = {
            55 8B EC 83 E4 ?? 83 EC ?? 53 56 57 8B 3D ?? ?? ?? ?? 8B DA 8B F1 FF D7 89 44 24 ??
            33 C0 50 68 ?? ?? ?? ?? 6A ?? 50 50 68 ?? ?? ?? ?? 56 89 54 24 ?? 89 44 24 ?? FF 15
            ?? ?? ?? ?? 89 44 24 ?? 83 F8 ?? 0F 84 ?? ?? ?? ?? 8D 4C 24 ?? 51 50 FF 15 ?? ?? ??
            ?? 85 C0 0F 84 ?? ?? ?? ?? 6A ?? FF 74 24 ?? FF 74 24 ?? 6A ?? 6A ?? FF 74 24 ?? FF
            15 ?? ?? ?? ?? 89 44 24 ?? 85 C0 0F 84 ?? ?? ?? ?? 33 C9 0F 31 89 44 8C ?? 41 83 F9
            ?? 72 ?? FF 75 ?? 8B D3 8D 4C 24 ?? E8 ?? ?? ?? ?? 89 44 24 ?? 59 85 C0 74 ?? 8D 4C
            24 ?? E8 ?? ?? ?? ?? 89 44 24 ?? 8B 7C 24 ?? 8B 44 24 ?? 89 7C 24 ?? 89 44 24 ?? 8B
            35 ?? ?? ?? ?? 8B DE 8B 15 ?? ?? ?? ?? 03 DF 8B CA 89 54 24 ?? 13 C8 BF ?? ?? ?? ??
            8B C6 F0 0F C7 0F 8B 7C 24 ?? 3B C6 8B 44 24 ?? 75 ?? 3B 54 24 ?? 75 ?? FF 74 24 ??
            8B 35 ?? ?? ?? ?? FF D6 FF 74 24 ?? FF D6 8B 3D ?? ?? ?? ?? FF D7 8B F8 8B C2 2B 7C
            24 ?? 89 7C 24 ?? 1B 44 24 ?? 89 44 24 ?? 75 ?? 85 FF 0F 84 ?? ?? ?? ?? 8B 35 ?? ??
            ?? ?? 8B DE 8B 15 ?? ?? ?? ?? 03 DF 8B CA 89 54 24 ?? 13 C8 BF ?? ?? ?? ?? 8B C6 F0
            0F C7 0F 8B 7C 24 ?? 3B C6 8B 44 24 ?? 75 ?? 3B 54 24 ?? 75 ?? 50 57 FF 74 24 ?? FF
            74 24 ?? E8 ?? ?? ?? ?? 89 44 24 ?? 8B C2 81 E2 ?? ?? ?? ?? 25 ?? ?? ?? ?? 89 54 24
            ?? DF 6C 24 ?? 83 64 24 ?? ?? 89 44 24 ?? DF 6C 24 ?? D9 E0 DE C1 D9 5C 24 ?? D9 44
            24 ?? D9 05 ?? ?? ?? ?? D8 D9 DF E0 F6 C4 ?? 7A ?? D9 1D ?? ?? ?? ?? EB ?? DD D8 8B
            44 24 ?? EB ?? 8B 44 24 ?? 85 C0 8B 35 ?? ?? ?? ?? 74 ?? 50 FF D6 FF 74 24 ?? FF D6
            33 C0 5F 5E 5B 8B E5 5D C3
        }

        $encrypt_files_p2 = {
            55 8B EC 83 EC ?? 53 56 57 33 FF 6A ?? 8B F7 5B 0F 31 6A ?? 89 86 ?? ?? ?? ?? FF 15
            ?? ?? ?? ?? 83 C6 ?? 3B F3 72 ?? 8B D3 B9 ?? ?? ?? ?? 8A 01 88 41 ?? 41 83 EA ?? 75
            ?? 68 ?? ?? ?? ?? 6A ?? 68 ?? ?? ?? ?? 57 8D 45 ?? 89 5D ?? 50 89 7D ?? 89 7D ?? FF
            15 ?? ?? ?? ?? 85 C0 0F 84 ?? ?? ?? ?? 8D 45 ?? 50 57 57 68 ?? ?? ?? ?? 68 ?? ?? ??
            ?? FF 75 ?? FF 15 ?? ?? ?? ?? 8B F0 85 F6 74 ?? 68 ?? ?? ?? ?? 8D 45 ?? 50 68 ?? ??
            ?? ?? 57 6A ?? 57 FF 75 ?? FF 15 ?? ?? ?? ?? FF 75 ?? 8B F0 FF 15 ?? ?? ?? ?? 57 FF
            75 ?? FF 15 ?? ?? ?? ?? 85 F6 74 ?? E8 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? 68 ?? ?? ?? ??
            68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 83 C4 ?? E8 ?? ?? ?? ?? 33 C0 40
            EB ?? FF 15 ?? ?? ?? ?? 50 68 ?? ?? ?? ?? 6A ?? E8 ?? ?? ?? ?? 83 C4 ?? 33 C0 5F 5E
            5B 8B E5 5D C3
        }

        $find_files_p1 = {
            53 55 56 8B 74 24 ?? 8B EA 57 8B F9 6A ?? 83 26 ?? 58 66 89 44 6F ?? 8D 5F ?? 33 C0
            66 89 44 6F ?? 8D 87 ?? ?? ?? ?? 50 A1 ?? ?? ?? ?? 53 89 44 24 ?? FF D0 33 C9 66 89
            4C 6F ?? 83 F8 ?? 0F 85 ?? ?? ?? ?? 39 4F ?? 0F 84 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 83
            F8 ?? 0F 85 ?? ?? ?? ?? 8D 46 ?? 50 6A ?? 8D 4E ?? 51 8D 56 ?? 52 8D 46 ?? 50 6A ??
            6A ?? 8D 5F ?? 53 FF 15 ?? ?? ?? ?? F7 D8 1B C0 83 C0 ?? 89 06 74 ?? 8B CB E8 ?? ??
            ?? ?? 85 C0 74 ?? 6A ?? 58 66 89 44 6F ?? 33 C0 66 89 44 6F ?? 8D 87 ?? ?? ?? ?? 50
            53 FF 54 24 ?? 33 C9 66 89 4C 6F ?? 83 F8 ?? 75 ?? 39 0E 74 ?? 51 FF 76 ?? FF 76 ??
            FF 76 ?? 6A ?? 6A ?? 53 FF 15 ?? ?? ?? ?? 83 3E ?? 74 ?? FF 76 ?? FF 15 ?? ?? ?? ??
            83 26 ?? 83 C8 ?? 5F 5E 5D 5B C3
        }

        $find_files_p2 = {
            55 8B EC 83 E4 ?? 83 EC ?? 53 55 56 8B F1 57 FF 46 ?? 8D 7E ?? 8B 07 8D 5E ?? 89 44
            24 ?? 8B 46 ?? 53 89 07 FF 15 ?? ?? ?? ?? 8D 4C 24 ?? 89 44 24 ?? 51 8B D0 8B CE E8
            ?? ?? ?? ?? 8B E8 59 83 FD ?? 75 ?? 33 C0 E9 ?? ?? ?? ?? 53 8D 86 ?? ?? ?? ?? 50 FF
            15 ?? ?? ?? ?? 8D 9E ?? ?? ?? ?? F6 03 ?? 74 ?? 8B 54 24 ?? 8B CE E8 ?? ?? ?? ?? EB
            ?? 8D 86 ?? ?? ?? ?? 50 8B 44 24 ?? 05 ?? ?? ?? ?? 8D 04 46 50 FF 15 ?? ?? ?? ?? FF
            76 ?? 57 6A ?? FF 16 83 C4 ?? 85 C0 74 ?? 53 55 FF 15 ?? ?? ?? ?? 85 C0 75 ?? 55 FF
            15 ?? ?? ?? ?? 83 7E ?? ?? 8D 5E ?? 74 ?? 83 7C 24 ?? ?? 74 ?? 6A ?? FF 74 24 ?? FF
            74 24 ?? FF 74 24 ?? 6A ?? 6A ?? 53 FF 15 ?? ?? ?? ?? 83 7C 24 ?? ?? 74 ?? FF 74 24
            ?? FF 15 ?? ?? ?? ?? 8B 4C 24 ?? 33 C0 89 0F 40 5F 5E 5D 5B 8B E5 5D C3
        }

    condition:
        uint16(0) == 0x5A4D and
        (
            all of ($find_files_p*)
        ) and
        (
            all of ($encrypt_files_p*)
        )
}