rule Win64_Ransomware_Albabat : tc_detection malicious
{
    meta:

        author              = "ReversingLabs"

        source              = "ReversingLabs"
        status              = "RELEASED"
        sharing             = "TLP:WHITE"
        category            = "MALWARE"
        malware             = "ALBABAT"
        description         = "Yara rule that detects Albabat ransomware."

        tc_detection_type   = "Ransomware"
        tc_detection_name   = "Albabat"
        tc_detection_factor = 5

    strings:

        $encrypt_files_p1 = {
            48 8D 05 ?? ?? ?? ?? 48 89 83 ?? ?? ?? ?? 48 C7 83 ?? ?? ?? ?? ?? ?? ?? ?? C7 83 ??
            ?? ?? ?? ?? ?? ?? ?? 66 C7 83 ?? ?? 00 00 ?? ?? C7 83 ?? ?? ?? ?? ?? ?? ?? ?? 0F 57
            F6 0F 11 B3 ?? ?? ?? ?? 48 C7 83 ?? ?? ?? ?? ?? ?? ?? ?? C6 83 ?? ?? ?? ?? ?? 4C 8D
            83 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 89 D7 48 85 C0 74 ?? 0F B6 05 ?? ?? ?? ?? 48 8B 0D
            ?? ?? ?? ?? 48 85 C9 75 ?? FF 15 ?? ?? ?? ?? 48 85 C0 0F 84 ?? ?? ?? ?? 48 89 C1 48
            89 05 ?? ?? ?? ?? 41 B8 ?? ?? ?? ?? 31 D2 FF 15 ?? ?? ?? ?? 48 85 C0 0F 84 ?? ?? ??
            ?? 48 89 C6 48 89 38 4C 8D 35 ?? ?? ?? ?? E9 ?? ?? ?? ?? 48 89 BB ?? ?? ?? ?? 48 C7
            83 ?? ?? ?? ?? ?? ?? ?? ?? 0F 11 B3 ?? ?? ?? ?? 48 89 F9 E8 ?? ?? ?? ?? 48 89 C6 48
            89 D7 48 85 C0 74 ?? 48 85 FF 0F 85 ?? ?? ?? ?? 48 89 7C 24 ?? 48 8D 8B ?? ?? ?? ??
            48 8D 93 ?? ?? ?? ?? 4C 8D 83 ?? ?? ?? ?? 49 89 F1 E8 ?? ?? ?? ?? 48 83 BB ?? ?? ??
            ?? ?? 0F 84 ?? ?? ?? ?? 48 8B BB ?? ?? ?? ?? 0F B6 05 ?? ?? ?? ?? 48 8B 0D ?? ?? ??
            ?? 48 85 C9 75 ?? FF 15 ?? ?? ?? ?? 48 85 C0 0F 84 ?? ?? ?? ?? 48 89 C1 48 89 05 ??
            ?? ?? ?? 41 B8 ?? ?? ?? ?? 31 D2 FF 15 ?? ?? ?? ?? 48 85 C0 0F 84 ?? ?? ?? ?? 48 89
        }

        $encrypt_files_p2 = {
            C6 48 89 38 4C 8D 35 ?? ?? ?? ?? 48 83 BB ?? ?? ?? ?? ?? 74 ?? 4C 8B 83 ?? ?? ?? ??
            48 8B 0D ?? ?? ?? ?? 31 D2 FF 15 ?? ?? ?? ?? 48 8B 8B ?? ?? ?? ?? FF 15 ?? ?? ?? ??
            48 85 F6 0F 84 ?? ?? ?? ?? 48 89 B3 ?? ?? ?? ?? 4C 89 B3 ?? ?? ?? ?? 4C 8D B3 ?? ??
            ?? ?? 4C 89 B3 ?? ?? ?? ?? 4C 8D 3D ?? ?? ?? ?? 4C 89 BB ?? ?? ?? ?? 48 8D 05 ?? ??
            ?? ?? 48 89 83 ?? ?? ?? ?? 48 C7 83 ?? ?? ?? ?? ?? ?? ?? ?? 48 C7 83 ?? ?? ?? ?? ??
            ?? ?? ?? 48 8D BB ?? ?? ?? ?? 48 89 BB ?? ?? ?? ?? 48 C7 83 ?? ?? ?? ?? ?? ?? ?? ??
            48 8D 8B ?? ?? ?? ?? 48 8D 93 ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 8B B3 ?? ?? ?? ?? 48 8B
            93 ?? ?? ?? ?? 4C 8B A3 ?? ?? ?? ?? 48 89 F1 E8 ?? ?? ?? ?? 4D 85 E4 74 ?? 48 8B 0D
            ?? ?? ?? ?? 31 D2 49 89 F0 FF 15 ?? ?? ?? ?? 4C 89 B3 ?? ?? ?? ?? 4C 89 BB ?? ?? ??
            ?? 48 8D 05 ?? ?? ?? ?? 48 89 83 ?? ?? ?? ?? 48 C7 83 ?? ?? ?? ?? ?? ?? ?? ?? 48 8D
            35 ?? ?? ?? ?? 48 89 B3 ?? ?? ?? ?? 48 C7 83 ?? ?? ?? ?? ?? ?? ?? ?? 4C 8D B3 ?? ??
            ?? ?? 4C 89 B3 ?? ?? ?? ?? 48 C7 83 ?? ?? ?? ?? ?? ?? ?? ?? 48 C7 83 ?? ?? ?? ?? ??
            ?? ?? ?? 48 8D 8B ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 0F 85 ?? ?? ?? ?? 48 8B 05 ?? ??
            ?? ?? 48 83 F8 ?? 0F 85 ?? ?? ?? ?? 48 8B 05 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 65 48 8B
            14 25 ?? ?? ?? ?? 48 8B 0C CA 48 8D 89 ?? ?? ?? ?? 48 39 C8 75 ?? 8B 05 ?? ?? ?? ??
            FF C0 75 ?? 48 8D 0D ?? ?? ?? ?? 4C 8D 05 ?? ?? ?? ?? BA ?? ?? ?? ?? E8
        }

        $drop_ransom_note = {
            48 8D 05 ?? ?? ?? ?? 48 89 84 24 ?? ?? ?? ?? 48 C7 84 24 ?? ?? ?? ?? ?? ?? ?? ?? 48
            89 B4 24 ?? ?? ?? ?? 48 C7 84 24 ?? ?? ?? ?? ?? ?? ?? ?? 4C 89 B4 24 ?? ?? ?? ?? 48
            C7 84 24 ?? ?? ?? ?? ?? ?? ?? ?? 48 8D 8C 24 ?? ?? ?? ?? 48 8D 94 24 ?? ?? ?? ?? E8
            ?? ?? ?? ?? 48 83 BC 24 ?? ?? ?? ?? ?? 74 ?? 4C 8B 84 24 ?? ?? ?? ?? 48 8B 0D ?? ??
            ?? ?? 31 D2 FF 15 ?? ?? ?? ?? 48 8D B4 24 ?? ?? ?? ?? 48 8D 94 24 ?? ?? ?? ?? 48 89
            F1 E8 ?? ?? ?? ?? 48 85 C0 4C 8B 74 24 ?? 74 ?? 48 89 C5 4C 8B 6C 24 ?? E9 ?? ?? ??
            ?? 4D 8D 0C D1 49 83 C1 ?? 48 C1 E2 ?? 48 F7 DA 4F 8D 14 C2 49 83 C2 ?? 49 C1 E0 ??
            49 F7 D8 45 31 DB 4C 39 DA 0F 84 ?? ?? ?? ?? 4D 39 D8 0F 84 ?? ?? ?? ?? 4B 8B 34 19
            4F 8B 34 1A 4C 39 F6 0F 82 ?? ?? ?? ?? 49 83 C3 ?? 4C 39 F6 76 ?? E9 ?? ?? ?? ?? 48
            8D 15 ?? ?? ?? ?? 48 8D 8C 24 ?? ?? ?? ?? 41 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 80 BC 24
            ?? ?? ?? ?? ?? 0F 85 ?? ?? ?? ?? 48 8B 9C 24 ?? ?? ?? ?? 48 8B AC 24 ?? ?? ?? ?? 4C
            8B 84 24 ?? ?? ?? ?? 48 C7 44 24 ?? ?? ?? ?? ?? 4C 8D 0D ?? ?? ?? ?? 48 8D 8C 24 ??
            ?? ?? ?? 48 89 DA E8 ?? ?? ?? ?? 4C 8B B4 24 ?? ?? ?? ?? 4C 8B 84 24 ?? ?? ?? ?? 48
            C7 44 24 ?? ?? ?? ?? ?? 4C 8D 0D ?? ?? ?? ?? 48 8D 8C 24 ?? ?? ?? ?? 4C 89 F2 E8 ??
            ?? ?? ?? 48 83 BC 24 ?? ?? ?? ?? ?? 74 ?? 48 8B 0D ?? ?? ?? ?? 31 D2 4D 89 F0 FF 15
            ?? ?? ?? ?? 48 85 ED 74 ?? 48 8B 0D ?? ?? ?? ?? 31 D2 49 89 D8 FF 15 ?? ?? ?? ?? 48
            8D 9C 24 ?? ?? ?? ?? 48 89 D9 E8 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 4C 8D 0D ?? ?? ??
            ?? 41 B8 ?? ?? ?? ?? 48 89 D9 E8 ?? ?? ?? ?? 0F 10 00 0F 11 84 24 ?? ?? ?? ?? 48 8B
            8C 24 ?? ?? ?? ?? 48 85 C9 74
        }

        $change_desktop_wallpaper = {
            4C 8D 0D ?? ?? ?? ?? 48 8D 8C 24 ?? ?? ?? ?? 48 89 DA E8 ?? ?? ?? ?? 48 83 BC 24 ??
            ?? ?? ?? ?? 74 ?? 48 8B 0D ?? ?? ?? ?? 31 D2 49 89 D8 FF 15 ?? ?? ?? ?? 4D 85 F6 74
            ?? 48 8B 0D ?? ?? ?? ?? 31 D2 49 89 F0 FF 15 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D
            8C 24 ?? ?? ?? ?? 41 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 4C 8D 25 ?? ?? ?? ?? 48 85 C0 4C
            8B 74 24 ?? 0F 85 ?? ?? ?? ?? 48 8D 15 ?? ?? ?? ?? 48 8D 8C 24 ?? ?? ?? ?? 41 B8 ??
            ?? ?? ?? E8 ?? ?? ?? ?? 80 BC 24 ?? ?? ?? ?? ?? 0F 85 ?? ?? ?? ?? 48 8B B4 24 ?? ??
            ?? ?? 4C 8B AC 24 ?? ?? ?? ?? 4C 8B 84 24 ?? ?? ?? ?? 48 C7 44 24 ?? ?? ?? ?? ?? 4C
            8D 0D ?? ?? ?? ?? 48 8D 8C 24 ?? ?? ?? ?? 48 89 F2 E8 ?? ?? ?? ?? 48 8B 9C 24 ?? ??
            ?? ?? 4C 8B 84 24 ?? ?? ?? ?? 48 C7 44 24 ?? ?? ?? ?? ?? 4C 8D 0D ?? ?? ?? ?? 48 8D
            8C 24 ?? ?? ?? ?? 48 89 DA E8 ?? ?? ?? ?? 48 83 BC 24 ?? ?? ?? ?? ?? 74 ?? 48 8B 0D
            ?? ?? ?? ?? 31 D2 49 89 D8 FF 15 ?? ?? ?? ?? 48 8B 9C 24 ?? ?? ?? ?? 4C 8B B4 24 ??
            ?? ?? ?? 48 8D 8C 24 ?? ?? ?? ?? 48 89 DA 4D 89 F0 E8 ?? ?? ?? ?? 83 BC 24 ?? ?? ??
            ?? ?? 0F 85 ?? ?? ?? ?? 48 8B 84 24 ?? ?? ?? ?? 89 C1 83 E1 ?? 83 F9 ?? 0F 85 ?? ??
            ?? ?? 48 8D 58 ?? 4C 8B 70 ?? 48 8B 68 ?? 4C 89 F1 FF 55
        }

        $find_files_p1 = {
            4C 8D 0D ?? ?? ?? ?? 48 8D 8C 24 ?? ?? ?? ?? 48 89 DA E8 ?? ?? ?? ?? 48 83 BC 24 ??
            ?? ?? ?? ?? 74 ?? 48 8B 0D ?? ?? ?? ?? 31 D2 49 89 D8 FF 15 ?? ?? ?? ?? 4D 85 FF 74
            ?? 48 8B 0D ?? ?? ?? ?? 31 D2 49 89 F0 FF 15 ?? ?? ?? ?? 48 C7 84 24 ?? ?? ?? ?? ??
            ?? ?? ?? 66 0F EF C0 F3 0F 7F 84 24 ?? ?? ?? ?? 48 8D 8C 24 ?? ?? ?? ?? 48 8D 94 24
            ?? ?? ?? ?? E8 ?? ?? ?? ?? 48 85 C0 0F 84 ?? ?? ?? ?? 48 89 C5 4C 8B 6C 24 ?? 4C 8B
            74 24 ?? E9 ?? ?? ?? ?? 48 8D 8C 24 ?? ?? ?? ?? 31 D2 49 89 F0 E8 ?? ?? ?? ?? 48 8B
            84 24 ?? ?? ?? ?? 48 8B AC 24 ?? ?? ?? ?? 48 29 E8 48 39 F0 72 ?? 48 8B 8C 24 ?? ??
            ?? ?? 48 01 E9 31 D2 49 89 F0 E8 ?? ?? ?? ?? 48 01 F5 48 89 AC 24 ?? ?? ?? ?? E9 ??
            ?? ?? ?? 48 C1 ED ?? 74 ?? 41 BD ?? ?? ?? ?? E9 ?? ?? ?? ?? 49 83 FF ?? 72 ?? 48 85
            DB 74 ?? 48 8B 84 24 ?? ?? ?? ?? EB ?? 48 8D 8C 24 ?? ?? ?? ?? 48 89 EA 49 89 F0 E8
            ?? ?? ?? ?? 48 8B AC 24 ?? ?? ?? ?? EB ?? 4C 89 FB 4C 89 F0 4D 85 FF 74 ?? 49 89 DC
            48 8B 44 D8 ?? 48 85 C0 74 ?? 48 0F BD C0 48 83 F0 ?? EB ?? 45 31 E4 EB ?? B8 ?? ??
            ?? ?? 49 C1 E4 ?? 49 83 CC ?? 49 29 C4 49 C1 EC ?? 48 8B B4 24 ?? ?? ?? ?? BA ?? ??
            ?? ?? 48 89 F1 45 31 C0 E8 ?? ?? ?? ?? 48 89 F1 E8 ?? ?? ?? ?? 49 89 C7 49 83 FC
        }

        $find_files_p2 = {
            73 ?? 48 8B 0D ?? ?? ?? ?? 31 D2 4D 89 F8 FF 15 ?? ?? ?? ?? 41 BD ?? ?? ?? ?? E9 ??
            ?? ?? ?? BA ?? ?? ?? ?? 4C 89 E1 E8 ?? ?? ?? ?? 48 85 C0 0F 84 ?? ?? ?? ?? 48 8D 68
            ?? 49 8D 5C 24 ?? 48 8B 8C 24 ?? ?? ?? ?? 48 89 EA 48 89 44 24 ?? E8 ?? ?? ?? ?? 48
            8B 44 24 ?? F3 41 0F 6F 07 41 0F 10 4F ?? 0F 11 48 ?? F3 0F 7F 40 ?? 49 8D 4C 24 ??
            48 39 D9 0F 83 ?? ?? ?? ?? 4D 89 E5 4C 8D 60 ?? 49 8D 4D ?? 43 C6 44 2C ?? ?? 48 39
            CB 0F 82 ?? ?? ?? ?? 43 0F 11 74 2C ?? 43 0F 11 7C 2C ?? 48 C7 44 24 ?? ?? ?? ?? ??
            4C 89 E1 48 89 DA 48 8B B4 24 ?? ?? ?? ?? 49 89 F0 49 89 E9 E8 ?? ?? ?? ?? 48 89 5C
            24 ?? BA ?? ?? ?? ?? 48 89 E9 49 89 F0 4D 89 E1 E8 ?? ?? ?? ?? 48 8B 0D ?? ?? ?? ??
            31 D2 4D 89 F8 FF 15 ?? ?? ?? ?? 0F B6 05 ?? ?? ?? ?? BA ?? ?? ?? ?? 4C 89 E9 E8 ??
            ?? ?? ?? 48 85 C0 0F 84 ?? ?? ?? ?? 48 89 C3 48 8D B4 24 ?? ?? ?? ?? 48 89 C1 48 8B
            54 24 ?? 4D 89 E8 E8
        }

    condition:
        uint16(0) == 0x5A4D and
        (
            all of ($find_files_p*)
        ) and
        (
            all of ($encrypt_files_p*)
        ) and
        (
            $drop_ransom_note
        ) and
        (
            $change_desktop_wallpaper
        )
}